/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteConfigurationSetResponse extends PinpointSmsVoiceV2Response implements
        ToCopyableBuilder<DeleteConfigurationSetResponse.Builder, DeleteConfigurationSetResponse> {
    private static final SdkField<String> CONFIGURATION_SET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationSetArn").getter(getter(DeleteConfigurationSetResponse::configurationSetArn))
            .setter(setter(Builder::configurationSetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSetArn").build())
            .build();

    private static final SdkField<String> CONFIGURATION_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationSetName").getter(getter(DeleteConfigurationSetResponse::configurationSetName))
            .setter(setter(Builder::configurationSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSetName").build())
            .build();

    private static final SdkField<List<EventDestination>> EVENT_DESTINATIONS_FIELD = SdkField
            .<List<EventDestination>> builder(MarshallingType.LIST)
            .memberName("EventDestinations")
            .getter(getter(DeleteConfigurationSetResponse::eventDestinations))
            .setter(setter(Builder::eventDestinations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventDestinations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EventDestination> builder(MarshallingType.SDK_POJO)
                                            .constructor(EventDestination::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DEFAULT_MESSAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultMessageType").getter(getter(DeleteConfigurationSetResponse::defaultMessageTypeAsString))
            .setter(setter(Builder::defaultMessageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultMessageType").build())
            .build();

    private static final SdkField<String> DEFAULT_SENDER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultSenderId").getter(getter(DeleteConfigurationSetResponse::defaultSenderId))
            .setter(setter(Builder::defaultSenderId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultSenderId").build()).build();

    private static final SdkField<Boolean> DEFAULT_MESSAGE_FEEDBACK_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DefaultMessageFeedbackEnabled")
            .getter(getter(DeleteConfigurationSetResponse::defaultMessageFeedbackEnabled))
            .setter(setter(Builder::defaultMessageFeedbackEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultMessageFeedbackEnabled")
                    .build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp").getter(getter(DeleteConfigurationSetResponse::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_SET_ARN_FIELD,
            CONFIGURATION_SET_NAME_FIELD, EVENT_DESTINATIONS_FIELD, DEFAULT_MESSAGE_TYPE_FIELD, DEFAULT_SENDER_ID_FIELD,
            DEFAULT_MESSAGE_FEEDBACK_ENABLED_FIELD, CREATED_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String configurationSetArn;

    private final String configurationSetName;

    private final List<EventDestination> eventDestinations;

    private final String defaultMessageType;

    private final String defaultSenderId;

    private final Boolean defaultMessageFeedbackEnabled;

    private final Instant createdTimestamp;

    private DeleteConfigurationSetResponse(BuilderImpl builder) {
        super(builder);
        this.configurationSetArn = builder.configurationSetArn;
        this.configurationSetName = builder.configurationSetName;
        this.eventDestinations = builder.eventDestinations;
        this.defaultMessageType = builder.defaultMessageType;
        this.defaultSenderId = builder.defaultSenderId;
        this.defaultMessageFeedbackEnabled = builder.defaultMessageFeedbackEnabled;
        this.createdTimestamp = builder.createdTimestamp;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the deleted configuration set.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the deleted configuration set.
     */
    public final String configurationSetArn() {
        return configurationSetArn;
    }

    /**
     * <p>
     * The name of the deleted configuration set.
     * </p>
     * 
     * @return The name of the deleted configuration set.
     */
    public final String configurationSetName() {
        return configurationSetName;
    }

    /**
     * For responses, this returns true if the service returned a value for the EventDestinations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEventDestinations() {
        return eventDestinations != null && !(eventDestinations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of any EventDestination objects that were associated with the deleted configuration set.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventDestinations} method.
     * </p>
     * 
     * @return An array of any EventDestination objects that were associated with the deleted configuration set.
     */
    public final List<EventDestination> eventDestinations() {
        return eventDestinations;
    }

    /**
     * <p>
     * The default message type of the configuration set that was deleted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultMessageType} will return {@link MessageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #defaultMessageTypeAsString}.
     * </p>
     * 
     * @return The default message type of the configuration set that was deleted.
     * @see MessageType
     */
    public final MessageType defaultMessageType() {
        return MessageType.fromValue(defaultMessageType);
    }

    /**
     * <p>
     * The default message type of the configuration set that was deleted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultMessageType} will return {@link MessageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #defaultMessageTypeAsString}.
     * </p>
     * 
     * @return The default message type of the configuration set that was deleted.
     * @see MessageType
     */
    public final String defaultMessageTypeAsString() {
        return defaultMessageType;
    }

    /**
     * <p>
     * The default Sender ID of the configuration set that was deleted.
     * </p>
     * 
     * @return The default Sender ID of the configuration set that was deleted.
     */
    public final String defaultSenderId() {
        return defaultSenderId;
    }

    /**
     * <p>
     * True if the configuration set has message feedback enabled. By default this is set to false.
     * </p>
     * 
     * @return True if the configuration set has message feedback enabled. By default this is set to false.
     */
    public final Boolean defaultMessageFeedbackEnabled() {
        return defaultMessageFeedbackEnabled;
    }

    /**
     * <p>
     * The time that the deleted configuration set was created in <a href="https://www.epochconverter.com/">UNIX epoch
     * time</a> format.
     * </p>
     * 
     * @return The time that the deleted configuration set was created in <a href="https://www.epochconverter.com/">UNIX
     *         epoch time</a> format.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configurationSetArn());
        hashCode = 31 * hashCode + Objects.hashCode(configurationSetName());
        hashCode = 31 * hashCode + Objects.hashCode(hasEventDestinations() ? eventDestinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(defaultMessageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(defaultSenderId());
        hashCode = 31 * hashCode + Objects.hashCode(defaultMessageFeedbackEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteConfigurationSetResponse)) {
            return false;
        }
        DeleteConfigurationSetResponse other = (DeleteConfigurationSetResponse) obj;
        return Objects.equals(configurationSetArn(), other.configurationSetArn())
                && Objects.equals(configurationSetName(), other.configurationSetName())
                && hasEventDestinations() == other.hasEventDestinations()
                && Objects.equals(eventDestinations(), other.eventDestinations())
                && Objects.equals(defaultMessageTypeAsString(), other.defaultMessageTypeAsString())
                && Objects.equals(defaultSenderId(), other.defaultSenderId())
                && Objects.equals(defaultMessageFeedbackEnabled(), other.defaultMessageFeedbackEnabled())
                && Objects.equals(createdTimestamp(), other.createdTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteConfigurationSetResponse").add("ConfigurationSetArn", configurationSetArn())
                .add("ConfigurationSetName", configurationSetName())
                .add("EventDestinations", hasEventDestinations() ? eventDestinations() : null)
                .add("DefaultMessageType", defaultMessageTypeAsString()).add("DefaultSenderId", defaultSenderId())
                .add("DefaultMessageFeedbackEnabled", defaultMessageFeedbackEnabled())
                .add("CreatedTimestamp", createdTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationSetArn":
            return Optional.ofNullable(clazz.cast(configurationSetArn()));
        case "ConfigurationSetName":
            return Optional.ofNullable(clazz.cast(configurationSetName()));
        case "EventDestinations":
            return Optional.ofNullable(clazz.cast(eventDestinations()));
        case "DefaultMessageType":
            return Optional.ofNullable(clazz.cast(defaultMessageTypeAsString()));
        case "DefaultSenderId":
            return Optional.ofNullable(clazz.cast(defaultSenderId()));
        case "DefaultMessageFeedbackEnabled":
            return Optional.ofNullable(clazz.cast(defaultMessageFeedbackEnabled()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConfigurationSetArn", CONFIGURATION_SET_ARN_FIELD);
        map.put("ConfigurationSetName", CONFIGURATION_SET_NAME_FIELD);
        map.put("EventDestinations", EVENT_DESTINATIONS_FIELD);
        map.put("DefaultMessageType", DEFAULT_MESSAGE_TYPE_FIELD);
        map.put("DefaultSenderId", DEFAULT_SENDER_ID_FIELD);
        map.put("DefaultMessageFeedbackEnabled", DEFAULT_MESSAGE_FEEDBACK_ENABLED_FIELD);
        map.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteConfigurationSetResponse, T> g) {
        return obj -> g.apply((DeleteConfigurationSetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PinpointSmsVoiceV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteConfigurationSetResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the deleted configuration set.
         * </p>
         * 
         * @param configurationSetArn
         *        The Amazon Resource Name (ARN) of the deleted configuration set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSetArn(String configurationSetArn);

        /**
         * <p>
         * The name of the deleted configuration set.
         * </p>
         * 
         * @param configurationSetName
         *        The name of the deleted configuration set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSetName(String configurationSetName);

        /**
         * <p>
         * An array of any EventDestination objects that were associated with the deleted configuration set.
         * </p>
         * 
         * @param eventDestinations
         *        An array of any EventDestination objects that were associated with the deleted configuration set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventDestinations(Collection<EventDestination> eventDestinations);

        /**
         * <p>
         * An array of any EventDestination objects that were associated with the deleted configuration set.
         * </p>
         * 
         * @param eventDestinations
         *        An array of any EventDestination objects that were associated with the deleted configuration set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventDestinations(EventDestination... eventDestinations);

        /**
         * <p>
         * An array of any EventDestination objects that were associated with the deleted configuration set.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.EventDestination.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.EventDestination#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.EventDestination.Builder#build()} is called
         * immediately and its result is passed to {@link #eventDestinations(List<EventDestination>)}.
         * 
         * @param eventDestinations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.EventDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventDestinations(java.util.Collection<EventDestination>)
         */
        Builder eventDestinations(Consumer<EventDestination.Builder>... eventDestinations);

        /**
         * <p>
         * The default message type of the configuration set that was deleted.
         * </p>
         * 
         * @param defaultMessageType
         *        The default message type of the configuration set that was deleted.
         * @see MessageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageType
         */
        Builder defaultMessageType(String defaultMessageType);

        /**
         * <p>
         * The default message type of the configuration set that was deleted.
         * </p>
         * 
         * @param defaultMessageType
         *        The default message type of the configuration set that was deleted.
         * @see MessageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageType
         */
        Builder defaultMessageType(MessageType defaultMessageType);

        /**
         * <p>
         * The default Sender ID of the configuration set that was deleted.
         * </p>
         * 
         * @param defaultSenderId
         *        The default Sender ID of the configuration set that was deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultSenderId(String defaultSenderId);

        /**
         * <p>
         * True if the configuration set has message feedback enabled. By default this is set to false.
         * </p>
         * 
         * @param defaultMessageFeedbackEnabled
         *        True if the configuration set has message feedback enabled. By default this is set to false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultMessageFeedbackEnabled(Boolean defaultMessageFeedbackEnabled);

        /**
         * <p>
         * The time that the deleted configuration set was created in <a href="https://www.epochconverter.com/">UNIX
         * epoch time</a> format.
         * </p>
         * 
         * @param createdTimestamp
         *        The time that the deleted configuration set was created in <a
         *        href="https://www.epochconverter.com/">UNIX epoch time</a> format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Response.BuilderImpl implements Builder {
        private String configurationSetArn;

        private String configurationSetName;

        private List<EventDestination> eventDestinations = DefaultSdkAutoConstructList.getInstance();

        private String defaultMessageType;

        private String defaultSenderId;

        private Boolean defaultMessageFeedbackEnabled;

        private Instant createdTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteConfigurationSetResponse model) {
            super(model);
            configurationSetArn(model.configurationSetArn);
            configurationSetName(model.configurationSetName);
            eventDestinations(model.eventDestinations);
            defaultMessageType(model.defaultMessageType);
            defaultSenderId(model.defaultSenderId);
            defaultMessageFeedbackEnabled(model.defaultMessageFeedbackEnabled);
            createdTimestamp(model.createdTimestamp);
        }

        public final String getConfigurationSetArn() {
            return configurationSetArn;
        }

        public final void setConfigurationSetArn(String configurationSetArn) {
            this.configurationSetArn = configurationSetArn;
        }

        @Override
        public final Builder configurationSetArn(String configurationSetArn) {
            this.configurationSetArn = configurationSetArn;
            return this;
        }

        public final String getConfigurationSetName() {
            return configurationSetName;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final List<EventDestination.Builder> getEventDestinations() {
            List<EventDestination.Builder> result = EventDestinationListCopier.copyToBuilder(this.eventDestinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventDestinations(Collection<EventDestination.BuilderImpl> eventDestinations) {
            this.eventDestinations = EventDestinationListCopier.copyFromBuilder(eventDestinations);
        }

        @Override
        public final Builder eventDestinations(Collection<EventDestination> eventDestinations) {
            this.eventDestinations = EventDestinationListCopier.copy(eventDestinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventDestinations(EventDestination... eventDestinations) {
            eventDestinations(Arrays.asList(eventDestinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventDestinations(Consumer<EventDestination.Builder>... eventDestinations) {
            eventDestinations(Stream.of(eventDestinations).map(c -> EventDestination.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getDefaultMessageType() {
            return defaultMessageType;
        }

        public final void setDefaultMessageType(String defaultMessageType) {
            this.defaultMessageType = defaultMessageType;
        }

        @Override
        public final Builder defaultMessageType(String defaultMessageType) {
            this.defaultMessageType = defaultMessageType;
            return this;
        }

        @Override
        public final Builder defaultMessageType(MessageType defaultMessageType) {
            this.defaultMessageType(defaultMessageType == null ? null : defaultMessageType.toString());
            return this;
        }

        public final String getDefaultSenderId() {
            return defaultSenderId;
        }

        public final void setDefaultSenderId(String defaultSenderId) {
            this.defaultSenderId = defaultSenderId;
        }

        @Override
        public final Builder defaultSenderId(String defaultSenderId) {
            this.defaultSenderId = defaultSenderId;
            return this;
        }

        public final Boolean getDefaultMessageFeedbackEnabled() {
            return defaultMessageFeedbackEnabled;
        }

        public final void setDefaultMessageFeedbackEnabled(Boolean defaultMessageFeedbackEnabled) {
            this.defaultMessageFeedbackEnabled = defaultMessageFeedbackEnabled;
        }

        @Override
        public final Builder defaultMessageFeedbackEnabled(Boolean defaultMessageFeedbackEnabled) {
            this.defaultMessageFeedbackEnabled = defaultMessageFeedbackEnabled;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        @Override
        public DeleteConfigurationSetResponse build() {
            return new DeleteConfigurationSetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
