/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeConfigurationSetsResponse extends PinpointSmsVoiceV2Response implements
        ToCopyableBuilder<DescribeConfigurationSetsResponse.Builder, DescribeConfigurationSetsResponse> {
    private static final SdkField<List<ConfigurationSetInformation>> CONFIGURATION_SETS_FIELD = SdkField
            .<List<ConfigurationSetInformation>> builder(MarshallingType.LIST)
            .memberName("ConfigurationSets")
            .getter(getter(DescribeConfigurationSetsResponse::configurationSets))
            .setter(setter(Builder::configurationSets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConfigurationSetInformation> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConfigurationSetInformation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeConfigurationSetsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_SETS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ConfigurationSetInformation> configurationSets;

    private final String nextToken;

    private DescribeConfigurationSetsResponse(BuilderImpl builder) {
        super(builder);
        this.configurationSets = builder.configurationSets;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConfigurationSets property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasConfigurationSets() {
        return configurationSets != null && !(configurationSets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of ConfigurationSets objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConfigurationSets} method.
     * </p>
     * 
     * @return An array of ConfigurationSets objects.
     */
    public final List<ConfigurationSetInformation> configurationSets() {
        return configurationSets;
    }

    /**
     * <p>
     * The token to be used for the next set of paginated results. If this field is empty then there are no more
     * results.
     * </p>
     * 
     * @return The token to be used for the next set of paginated results. If this field is empty then there are no more
     *         results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasConfigurationSets() ? configurationSets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationSetsResponse)) {
            return false;
        }
        DescribeConfigurationSetsResponse other = (DescribeConfigurationSetsResponse) obj;
        return hasConfigurationSets() == other.hasConfigurationSets()
                && Objects.equals(configurationSets(), other.configurationSets())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeConfigurationSetsResponse")
                .add("ConfigurationSets", hasConfigurationSets() ? configurationSets() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationSets":
            return Optional.ofNullable(clazz.cast(configurationSets()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConfigurationSets", CONFIGURATION_SETS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeConfigurationSetsResponse, T> g) {
        return obj -> g.apply((DescribeConfigurationSetsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PinpointSmsVoiceV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeConfigurationSetsResponse> {
        /**
         * <p>
         * An array of ConfigurationSets objects.
         * </p>
         * 
         * @param configurationSets
         *        An array of ConfigurationSets objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSets(Collection<ConfigurationSetInformation> configurationSets);

        /**
         * <p>
         * An array of ConfigurationSets objects.
         * </p>
         * 
         * @param configurationSets
         *        An array of ConfigurationSets objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSets(ConfigurationSetInformation... configurationSets);

        /**
         * <p>
         * An array of ConfigurationSets objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.ConfigurationSetInformation.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.ConfigurationSetInformation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.ConfigurationSetInformation.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #configurationSets(List<ConfigurationSetInformation>)}.
         * 
         * @param configurationSets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.ConfigurationSetInformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurationSets(java.util.Collection<ConfigurationSetInformation>)
         */
        Builder configurationSets(Consumer<ConfigurationSetInformation.Builder>... configurationSets);

        /**
         * <p>
         * The token to be used for the next set of paginated results. If this field is empty then there are no more
         * results.
         * </p>
         * 
         * @param nextToken
         *        The token to be used for the next set of paginated results. If this field is empty then there are no
         *        more results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Response.BuilderImpl implements Builder {
        private List<ConfigurationSetInformation> configurationSets = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationSetsResponse model) {
            super(model);
            configurationSets(model.configurationSets);
            nextToken(model.nextToken);
        }

        public final List<ConfigurationSetInformation.Builder> getConfigurationSets() {
            List<ConfigurationSetInformation.Builder> result = ConfigurationSetInformationListCopier
                    .copyToBuilder(this.configurationSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfigurationSets(Collection<ConfigurationSetInformation.BuilderImpl> configurationSets) {
            this.configurationSets = ConfigurationSetInformationListCopier.copyFromBuilder(configurationSets);
        }

        @Override
        public final Builder configurationSets(Collection<ConfigurationSetInformation> configurationSets) {
            this.configurationSets = ConfigurationSetInformationListCopier.copy(configurationSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationSets(ConfigurationSetInformation... configurationSets) {
            configurationSets(Arrays.asList(configurationSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationSets(Consumer<ConfigurationSetInformation.Builder>... configurationSets) {
            configurationSets(Stream.of(configurationSets)
                    .map(c -> ConfigurationSetInformation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeConfigurationSetsResponse build() {
            return new DescribeConfigurationSetsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
