/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeOptedOutNumbersResponse extends PinpointSmsVoiceV2Response implements
        ToCopyableBuilder<DescribeOptedOutNumbersResponse.Builder, DescribeOptedOutNumbersResponse> {
    private static final SdkField<String> OPT_OUT_LIST_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptOutListArn").getter(getter(DescribeOptedOutNumbersResponse::optOutListArn))
            .setter(setter(Builder::optOutListArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptOutListArn").build()).build();

    private static final SdkField<String> OPT_OUT_LIST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptOutListName").getter(getter(DescribeOptedOutNumbersResponse::optOutListName))
            .setter(setter(Builder::optOutListName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptOutListName").build()).build();

    private static final SdkField<List<OptedOutNumberInformation>> OPTED_OUT_NUMBERS_FIELD = SdkField
            .<List<OptedOutNumberInformation>> builder(MarshallingType.LIST)
            .memberName("OptedOutNumbers")
            .getter(getter(DescribeOptedOutNumbersResponse::optedOutNumbers))
            .setter(setter(Builder::optedOutNumbers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptedOutNumbers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OptedOutNumberInformation> builder(MarshallingType.SDK_POJO)
                                            .constructor(OptedOutNumberInformation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeOptedOutNumbersResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPT_OUT_LIST_ARN_FIELD,
            OPT_OUT_LIST_NAME_FIELD, OPTED_OUT_NUMBERS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String optOutListArn;

    private final String optOutListName;

    private final List<OptedOutNumberInformation> optedOutNumbers;

    private final String nextToken;

    private DescribeOptedOutNumbersResponse(BuilderImpl builder) {
        super(builder);
        this.optOutListArn = builder.optOutListArn;
        this.optOutListName = builder.optOutListName;
        this.optedOutNumbers = builder.optedOutNumbers;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the OptOutList.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the OptOutList.
     */
    public final String optOutListArn() {
        return optOutListArn;
    }

    /**
     * <p>
     * The name of the OptOutList.
     * </p>
     * 
     * @return The name of the OptOutList.
     */
    public final String optOutListName() {
        return optOutListName;
    }

    /**
     * For responses, this returns true if the service returned a value for the OptedOutNumbers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOptedOutNumbers() {
        return optedOutNumbers != null && !(optedOutNumbers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of OptedOutNumbersInformation objects that provide information about the requested OptedOutNumbers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOptedOutNumbers} method.
     * </p>
     * 
     * @return An array of OptedOutNumbersInformation objects that provide information about the requested
     *         OptedOutNumbers.
     */
    public final List<OptedOutNumberInformation> optedOutNumbers() {
        return optedOutNumbers;
    }

    /**
     * <p>
     * The token to be used for the next set of paginated results. If this field is empty then there are no more
     * results.
     * </p>
     * 
     * @return The token to be used for the next set of paginated results. If this field is empty then there are no more
     *         results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(optOutListArn());
        hashCode = 31 * hashCode + Objects.hashCode(optOutListName());
        hashCode = 31 * hashCode + Objects.hashCode(hasOptedOutNumbers() ? optedOutNumbers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOptedOutNumbersResponse)) {
            return false;
        }
        DescribeOptedOutNumbersResponse other = (DescribeOptedOutNumbersResponse) obj;
        return Objects.equals(optOutListArn(), other.optOutListArn()) && Objects.equals(optOutListName(), other.optOutListName())
                && hasOptedOutNumbers() == other.hasOptedOutNumbers()
                && Objects.equals(optedOutNumbers(), other.optedOutNumbers()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeOptedOutNumbersResponse").add("OptOutListArn", optOutListArn())
                .add("OptOutListName", optOutListName()).add("OptedOutNumbers", hasOptedOutNumbers() ? optedOutNumbers() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OptOutListArn":
            return Optional.ofNullable(clazz.cast(optOutListArn()));
        case "OptOutListName":
            return Optional.ofNullable(clazz.cast(optOutListName()));
        case "OptedOutNumbers":
            return Optional.ofNullable(clazz.cast(optedOutNumbers()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OptOutListArn", OPT_OUT_LIST_ARN_FIELD);
        map.put("OptOutListName", OPT_OUT_LIST_NAME_FIELD);
        map.put("OptedOutNumbers", OPTED_OUT_NUMBERS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeOptedOutNumbersResponse, T> g) {
        return obj -> g.apply((DescribeOptedOutNumbersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PinpointSmsVoiceV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeOptedOutNumbersResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the OptOutList.
         * </p>
         * 
         * @param optOutListArn
         *        The Amazon Resource Name (ARN) of the OptOutList.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optOutListArn(String optOutListArn);

        /**
         * <p>
         * The name of the OptOutList.
         * </p>
         * 
         * @param optOutListName
         *        The name of the OptOutList.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optOutListName(String optOutListName);

        /**
         * <p>
         * An array of OptedOutNumbersInformation objects that provide information about the requested OptedOutNumbers.
         * </p>
         * 
         * @param optedOutNumbers
         *        An array of OptedOutNumbersInformation objects that provide information about the requested
         *        OptedOutNumbers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optedOutNumbers(Collection<OptedOutNumberInformation> optedOutNumbers);

        /**
         * <p>
         * An array of OptedOutNumbersInformation objects that provide information about the requested OptedOutNumbers.
         * </p>
         * 
         * @param optedOutNumbers
         *        An array of OptedOutNumbersInformation objects that provide information about the requested
         *        OptedOutNumbers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optedOutNumbers(OptedOutNumberInformation... optedOutNumbers);

        /**
         * <p>
         * An array of OptedOutNumbersInformation objects that provide information about the requested OptedOutNumbers.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.OptedOutNumberInformation.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.OptedOutNumberInformation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.OptedOutNumberInformation.Builder#build()} is
         * called immediately and its result is passed to {@link #optedOutNumbers(List<OptedOutNumberInformation>)}.
         * 
         * @param optedOutNumbers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.OptedOutNumberInformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #optedOutNumbers(java.util.Collection<OptedOutNumberInformation>)
         */
        Builder optedOutNumbers(Consumer<OptedOutNumberInformation.Builder>... optedOutNumbers);

        /**
         * <p>
         * The token to be used for the next set of paginated results. If this field is empty then there are no more
         * results.
         * </p>
         * 
         * @param nextToken
         *        The token to be used for the next set of paginated results. If this field is empty then there are no
         *        more results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Response.BuilderImpl implements Builder {
        private String optOutListArn;

        private String optOutListName;

        private List<OptedOutNumberInformation> optedOutNumbers = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOptedOutNumbersResponse model) {
            super(model);
            optOutListArn(model.optOutListArn);
            optOutListName(model.optOutListName);
            optedOutNumbers(model.optedOutNumbers);
            nextToken(model.nextToken);
        }

        public final String getOptOutListArn() {
            return optOutListArn;
        }

        public final void setOptOutListArn(String optOutListArn) {
            this.optOutListArn = optOutListArn;
        }

        @Override
        public final Builder optOutListArn(String optOutListArn) {
            this.optOutListArn = optOutListArn;
            return this;
        }

        public final String getOptOutListName() {
            return optOutListName;
        }

        public final void setOptOutListName(String optOutListName) {
            this.optOutListName = optOutListName;
        }

        @Override
        public final Builder optOutListName(String optOutListName) {
            this.optOutListName = optOutListName;
            return this;
        }

        public final List<OptedOutNumberInformation.Builder> getOptedOutNumbers() {
            List<OptedOutNumberInformation.Builder> result = OptedOutNumberInformationListCopier
                    .copyToBuilder(this.optedOutNumbers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOptedOutNumbers(Collection<OptedOutNumberInformation.BuilderImpl> optedOutNumbers) {
            this.optedOutNumbers = OptedOutNumberInformationListCopier.copyFromBuilder(optedOutNumbers);
        }

        @Override
        public final Builder optedOutNumbers(Collection<OptedOutNumberInformation> optedOutNumbers) {
            this.optedOutNumbers = OptedOutNumberInformationListCopier.copy(optedOutNumbers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optedOutNumbers(OptedOutNumberInformation... optedOutNumbers) {
            optedOutNumbers(Arrays.asList(optedOutNumbers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optedOutNumbers(Consumer<OptedOutNumberInformation.Builder>... optedOutNumbers) {
            optedOutNumbers(Stream.of(optedOutNumbers).map(c -> OptedOutNumberInformation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeOptedOutNumbersResponse build() {
            return new DescribeOptedOutNumbersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
