/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeRegistrationAttachmentsResponse extends PinpointSmsVoiceV2Response implements
        ToCopyableBuilder<DescribeRegistrationAttachmentsResponse.Builder, DescribeRegistrationAttachmentsResponse> {
    private static final SdkField<List<RegistrationAttachmentsInformation>> REGISTRATION_ATTACHMENTS_FIELD = SdkField
            .<List<RegistrationAttachmentsInformation>> builder(MarshallingType.LIST)
            .memberName("RegistrationAttachments")
            .getter(getter(DescribeRegistrationAttachmentsResponse::registrationAttachments))
            .setter(setter(Builder::registrationAttachments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationAttachments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RegistrationAttachmentsInformation> builder(MarshallingType.SDK_POJO)
                                            .constructor(RegistrationAttachmentsInformation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeRegistrationAttachmentsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            REGISTRATION_ATTACHMENTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<RegistrationAttachmentsInformation> registrationAttachments;

    private final String nextToken;

    private DescribeRegistrationAttachmentsResponse(BuilderImpl builder) {
        super(builder);
        this.registrationAttachments = builder.registrationAttachments;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the RegistrationAttachments property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRegistrationAttachments() {
        return registrationAttachments != null && !(registrationAttachments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <b>RegistrationAttachments</b> objects that contain the details for the requested registration
     * attachments.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegistrationAttachments} method.
     * </p>
     * 
     * @return An array of <b>RegistrationAttachments</b> objects that contain the details for the requested
     *         registration attachments.
     */
    public final List<RegistrationAttachmentsInformation> registrationAttachments() {
        return registrationAttachments;
    }

    /**
     * <p>
     * The token to be used for the next set of paginated results. You don't need to supply a value for this field in
     * the initial request.
     * </p>
     * 
     * @return The token to be used for the next set of paginated results. You don't need to supply a value for this
     *         field in the initial request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRegistrationAttachments() ? registrationAttachments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRegistrationAttachmentsResponse)) {
            return false;
        }
        DescribeRegistrationAttachmentsResponse other = (DescribeRegistrationAttachmentsResponse) obj;
        return hasRegistrationAttachments() == other.hasRegistrationAttachments()
                && Objects.equals(registrationAttachments(), other.registrationAttachments())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeRegistrationAttachmentsResponse")
                .add("RegistrationAttachments", hasRegistrationAttachments() ? registrationAttachments() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RegistrationAttachments":
            return Optional.ofNullable(clazz.cast(registrationAttachments()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RegistrationAttachments", REGISTRATION_ATTACHMENTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeRegistrationAttachmentsResponse, T> g) {
        return obj -> g.apply((DescribeRegistrationAttachmentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PinpointSmsVoiceV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeRegistrationAttachmentsResponse> {
        /**
         * <p>
         * An array of <b>RegistrationAttachments</b> objects that contain the details for the requested registration
         * attachments.
         * </p>
         * 
         * @param registrationAttachments
         *        An array of <b>RegistrationAttachments</b> objects that contain the details for the requested
         *        registration attachments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationAttachments(Collection<RegistrationAttachmentsInformation> registrationAttachments);

        /**
         * <p>
         * An array of <b>RegistrationAttachments</b> objects that contain the details for the requested registration
         * attachments.
         * </p>
         * 
         * @param registrationAttachments
         *        An array of <b>RegistrationAttachments</b> objects that contain the details for the requested
         *        registration attachments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationAttachments(RegistrationAttachmentsInformation... registrationAttachments);

        /**
         * <p>
         * An array of <b>RegistrationAttachments</b> objects that contain the details for the requested registration
         * attachments.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationAttachmentsInformation.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationAttachmentsInformation#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationAttachmentsInformation.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #registrationAttachments(List<RegistrationAttachmentsInformation>)}.
         * 
         * @param registrationAttachments
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationAttachmentsInformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #registrationAttachments(java.util.Collection<RegistrationAttachmentsInformation>)
         */
        Builder registrationAttachments(Consumer<RegistrationAttachmentsInformation.Builder>... registrationAttachments);

        /**
         * <p>
         * The token to be used for the next set of paginated results. You don't need to supply a value for this field
         * in the initial request.
         * </p>
         * 
         * @param nextToken
         *        The token to be used for the next set of paginated results. You don't need to supply a value for this
         *        field in the initial request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Response.BuilderImpl implements Builder {
        private List<RegistrationAttachmentsInformation> registrationAttachments = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRegistrationAttachmentsResponse model) {
            super(model);
            registrationAttachments(model.registrationAttachments);
            nextToken(model.nextToken);
        }

        public final List<RegistrationAttachmentsInformation.Builder> getRegistrationAttachments() {
            List<RegistrationAttachmentsInformation.Builder> result = RegistrationAttachmentsInformationListCopier
                    .copyToBuilder(this.registrationAttachments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRegistrationAttachments(
                Collection<RegistrationAttachmentsInformation.BuilderImpl> registrationAttachments) {
            this.registrationAttachments = RegistrationAttachmentsInformationListCopier.copyFromBuilder(registrationAttachments);
        }

        @Override
        public final Builder registrationAttachments(Collection<RegistrationAttachmentsInformation> registrationAttachments) {
            this.registrationAttachments = RegistrationAttachmentsInformationListCopier.copy(registrationAttachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder registrationAttachments(RegistrationAttachmentsInformation... registrationAttachments) {
            registrationAttachments(Arrays.asList(registrationAttachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder registrationAttachments(
                Consumer<RegistrationAttachmentsInformation.Builder>... registrationAttachments) {
            registrationAttachments(Stream.of(registrationAttachments)
                    .map(c -> RegistrationAttachmentsInformation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeRegistrationAttachmentsResponse build() {
            return new DescribeRegistrationAttachmentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
