/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DiscardRegistrationVersionResponse extends PinpointSmsVoiceV2Response implements
        ToCopyableBuilder<DiscardRegistrationVersionResponse.Builder, DiscardRegistrationVersionResponse> {
    private static final SdkField<String> REGISTRATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegistrationArn").getter(getter(DiscardRegistrationVersionResponse::registrationArn))
            .setter(setter(Builder::registrationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationArn").build()).build();

    private static final SdkField<String> REGISTRATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegistrationId").getter(getter(DiscardRegistrationVersionResponse::registrationId))
            .setter(setter(Builder::registrationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationId").build()).build();

    private static final SdkField<Long> VERSION_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("VersionNumber").getter(getter(DiscardRegistrationVersionResponse::versionNumber))
            .setter(setter(Builder::versionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionNumber").build()).build();

    private static final SdkField<String> REGISTRATION_VERSION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegistrationVersionStatus")
            .getter(getter(DiscardRegistrationVersionResponse::registrationVersionStatusAsString))
            .setter(setter(Builder::registrationVersionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationVersionStatus").build())
            .build();

    private static final SdkField<RegistrationVersionStatusHistory> REGISTRATION_VERSION_STATUS_HISTORY_FIELD = SdkField
            .<RegistrationVersionStatusHistory> builder(MarshallingType.SDK_POJO)
            .memberName("RegistrationVersionStatusHistory")
            .getter(getter(DiscardRegistrationVersionResponse::registrationVersionStatusHistory))
            .setter(setter(Builder::registrationVersionStatusHistory))
            .constructor(RegistrationVersionStatusHistory::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationVersionStatusHistory")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRATION_ARN_FIELD,
            REGISTRATION_ID_FIELD, VERSION_NUMBER_FIELD, REGISTRATION_VERSION_STATUS_FIELD,
            REGISTRATION_VERSION_STATUS_HISTORY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String registrationArn;

    private final String registrationId;

    private final Long versionNumber;

    private final String registrationVersionStatus;

    private final RegistrationVersionStatusHistory registrationVersionStatusHistory;

    private DiscardRegistrationVersionResponse(BuilderImpl builder) {
        super(builder);
        this.registrationArn = builder.registrationArn;
        this.registrationId = builder.registrationId;
        this.versionNumber = builder.versionNumber;
        this.registrationVersionStatus = builder.registrationVersionStatus;
        this.registrationVersionStatusHistory = builder.registrationVersionStatusHistory;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the registration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the registration.
     */
    public final String registrationArn() {
        return registrationArn;
    }

    /**
     * <p>
     * The unique identifier for the registration.
     * </p>
     * 
     * @return The unique identifier for the registration.
     */
    public final String registrationId() {
        return registrationId;
    }

    /**
     * <p>
     * The version number of the registration.
     * </p>
     * 
     * @return The version number of the registration.
     */
    public final Long versionNumber() {
        return versionNumber;
    }

    /**
     * <p>
     * The status of the registration version.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>APPROVED</code>: Your registration has been approved.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ARCHIVED</code>: Your previously approved registration version moves into this status when a more recently
     * submitted version is approved.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DENIED</code>: You must fix your registration and resubmit it.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISCARDED</code>: You've abandon this version of their registration to start over with a new version.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DRAFT</code>: The initial status of a registration version after it’s created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REQUIRES_AUTHENTICATION</code>: You need to complete email authentication.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REVIEWING</code>: Your registration has been accepted and is being reviewed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REVOKED</code>: Your previously approved registration has been revoked.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUBMITTED</code>: Your registration has been submitted.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #registrationVersionStatus} will return {@link RegistrationVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #registrationVersionStatusAsString}.
     * </p>
     * 
     * @return The status of the registration version.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>APPROVED</code>: Your registration has been approved.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ARCHIVED</code>: Your previously approved registration version moves into this status when a more
     *         recently submitted version is approved.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DENIED</code>: You must fix your registration and resubmit it.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISCARDED</code>: You've abandon this version of their registration to start over with a new
     *         version.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DRAFT</code>: The initial status of a registration version after it’s created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REQUIRES_AUTHENTICATION</code>: You need to complete email authentication.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REVIEWING</code>: Your registration has been accepted and is being reviewed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REVOKED</code>: Your previously approved registration has been revoked.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUBMITTED</code>: Your registration has been submitted.
     *         </p>
     *         </li>
     * @see RegistrationVersionStatus
     */
    public final RegistrationVersionStatus registrationVersionStatus() {
        return RegistrationVersionStatus.fromValue(registrationVersionStatus);
    }

    /**
     * <p>
     * The status of the registration version.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>APPROVED</code>: Your registration has been approved.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ARCHIVED</code>: Your previously approved registration version moves into this status when a more recently
     * submitted version is approved.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DENIED</code>: You must fix your registration and resubmit it.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISCARDED</code>: You've abandon this version of their registration to start over with a new version.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DRAFT</code>: The initial status of a registration version after it’s created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REQUIRES_AUTHENTICATION</code>: You need to complete email authentication.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REVIEWING</code>: Your registration has been accepted and is being reviewed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REVOKED</code>: Your previously approved registration has been revoked.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUBMITTED</code>: Your registration has been submitted.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #registrationVersionStatus} will return {@link RegistrationVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #registrationVersionStatusAsString}.
     * </p>
     * 
     * @return The status of the registration version.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>APPROVED</code>: Your registration has been approved.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ARCHIVED</code>: Your previously approved registration version moves into this status when a more
     *         recently submitted version is approved.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DENIED</code>: You must fix your registration and resubmit it.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISCARDED</code>: You've abandon this version of their registration to start over with a new
     *         version.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DRAFT</code>: The initial status of a registration version after it’s created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REQUIRES_AUTHENTICATION</code>: You need to complete email authentication.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REVIEWING</code>: Your registration has been accepted and is being reviewed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REVOKED</code>: Your previously approved registration has been revoked.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUBMITTED</code>: Your registration has been submitted.
     *         </p>
     *         </li>
     * @see RegistrationVersionStatus
     */
    public final String registrationVersionStatusAsString() {
        return registrationVersionStatus;
    }

    /**
     * <p>
     * The <b>RegistrationVersionStatusHistory</b> object contains the time stamps for when the reservations status
     * changes.
     * </p>
     * 
     * @return The <b>RegistrationVersionStatusHistory</b> object contains the time stamps for when the reservations
     *         status changes.
     */
    public final RegistrationVersionStatusHistory registrationVersionStatusHistory() {
        return registrationVersionStatusHistory;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(registrationArn());
        hashCode = 31 * hashCode + Objects.hashCode(registrationId());
        hashCode = 31 * hashCode + Objects.hashCode(versionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(registrationVersionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(registrationVersionStatusHistory());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiscardRegistrationVersionResponse)) {
            return false;
        }
        DiscardRegistrationVersionResponse other = (DiscardRegistrationVersionResponse) obj;
        return Objects.equals(registrationArn(), other.registrationArn())
                && Objects.equals(registrationId(), other.registrationId())
                && Objects.equals(versionNumber(), other.versionNumber())
                && Objects.equals(registrationVersionStatusAsString(), other.registrationVersionStatusAsString())
                && Objects.equals(registrationVersionStatusHistory(), other.registrationVersionStatusHistory());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DiscardRegistrationVersionResponse").add("RegistrationArn", registrationArn())
                .add("RegistrationId", registrationId()).add("VersionNumber", versionNumber())
                .add("RegistrationVersionStatus", registrationVersionStatusAsString())
                .add("RegistrationVersionStatusHistory", registrationVersionStatusHistory()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RegistrationArn":
            return Optional.ofNullable(clazz.cast(registrationArn()));
        case "RegistrationId":
            return Optional.ofNullable(clazz.cast(registrationId()));
        case "VersionNumber":
            return Optional.ofNullable(clazz.cast(versionNumber()));
        case "RegistrationVersionStatus":
            return Optional.ofNullable(clazz.cast(registrationVersionStatusAsString()));
        case "RegistrationVersionStatusHistory":
            return Optional.ofNullable(clazz.cast(registrationVersionStatusHistory()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RegistrationArn", REGISTRATION_ARN_FIELD);
        map.put("RegistrationId", REGISTRATION_ID_FIELD);
        map.put("VersionNumber", VERSION_NUMBER_FIELD);
        map.put("RegistrationVersionStatus", REGISTRATION_VERSION_STATUS_FIELD);
        map.put("RegistrationVersionStatusHistory", REGISTRATION_VERSION_STATUS_HISTORY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DiscardRegistrationVersionResponse, T> g) {
        return obj -> g.apply((DiscardRegistrationVersionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PinpointSmsVoiceV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DiscardRegistrationVersionResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the registration.
         * </p>
         * 
         * @param registrationArn
         *        The Amazon Resource Name (ARN) for the registration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationArn(String registrationArn);

        /**
         * <p>
         * The unique identifier for the registration.
         * </p>
         * 
         * @param registrationId
         *        The unique identifier for the registration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationId(String registrationId);

        /**
         * <p>
         * The version number of the registration.
         * </p>
         * 
         * @param versionNumber
         *        The version number of the registration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionNumber(Long versionNumber);

        /**
         * <p>
         * The status of the registration version.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>APPROVED</code>: Your registration has been approved.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ARCHIVED</code>: Your previously approved registration version moves into this status when a more
         * recently submitted version is approved.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DENIED</code>: You must fix your registration and resubmit it.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISCARDED</code>: You've abandon this version of their registration to start over with a new version.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DRAFT</code>: The initial status of a registration version after it’s created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REQUIRES_AUTHENTICATION</code>: You need to complete email authentication.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REVIEWING</code>: Your registration has been accepted and is being reviewed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REVOKED</code>: Your previously approved registration has been revoked.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUBMITTED</code>: Your registration has been submitted.
         * </p>
         * </li>
         * </ul>
         * 
         * @param registrationVersionStatus
         *        The status of the registration version.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>APPROVED</code>: Your registration has been approved.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ARCHIVED</code>: Your previously approved registration version moves into this status when a
         *        more recently submitted version is approved.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DENIED</code>: You must fix your registration and resubmit it.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISCARDED</code>: You've abandon this version of their registration to start over with a new
         *        version.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DRAFT</code>: The initial status of a registration version after it’s created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REQUIRES_AUTHENTICATION</code>: You need to complete email authentication.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REVIEWING</code>: Your registration has been accepted and is being reviewed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REVOKED</code>: Your previously approved registration has been revoked.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUBMITTED</code>: Your registration has been submitted.
         *        </p>
         *        </li>
         * @see RegistrationVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistrationVersionStatus
         */
        Builder registrationVersionStatus(String registrationVersionStatus);

        /**
         * <p>
         * The status of the registration version.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>APPROVED</code>: Your registration has been approved.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ARCHIVED</code>: Your previously approved registration version moves into this status when a more
         * recently submitted version is approved.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DENIED</code>: You must fix your registration and resubmit it.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISCARDED</code>: You've abandon this version of their registration to start over with a new version.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DRAFT</code>: The initial status of a registration version after it’s created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REQUIRES_AUTHENTICATION</code>: You need to complete email authentication.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REVIEWING</code>: Your registration has been accepted and is being reviewed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REVOKED</code>: Your previously approved registration has been revoked.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUBMITTED</code>: Your registration has been submitted.
         * </p>
         * </li>
         * </ul>
         * 
         * @param registrationVersionStatus
         *        The status of the registration version.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>APPROVED</code>: Your registration has been approved.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ARCHIVED</code>: Your previously approved registration version moves into this status when a
         *        more recently submitted version is approved.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DENIED</code>: You must fix your registration and resubmit it.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISCARDED</code>: You've abandon this version of their registration to start over with a new
         *        version.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DRAFT</code>: The initial status of a registration version after it’s created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REQUIRES_AUTHENTICATION</code>: You need to complete email authentication.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REVIEWING</code>: Your registration has been accepted and is being reviewed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REVOKED</code>: Your previously approved registration has been revoked.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUBMITTED</code>: Your registration has been submitted.
         *        </p>
         *        </li>
         * @see RegistrationVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistrationVersionStatus
         */
        Builder registrationVersionStatus(RegistrationVersionStatus registrationVersionStatus);

        /**
         * <p>
         * The <b>RegistrationVersionStatusHistory</b> object contains the time stamps for when the reservations status
         * changes.
         * </p>
         * 
         * @param registrationVersionStatusHistory
         *        The <b>RegistrationVersionStatusHistory</b> object contains the time stamps for when the reservations
         *        status changes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationVersionStatusHistory(RegistrationVersionStatusHistory registrationVersionStatusHistory);

        /**
         * <p>
         * The <b>RegistrationVersionStatusHistory</b> object contains the time stamps for when the reservations status
         * changes.
         * </p>
         * This is a convenience method that creates an instance of the {@link RegistrationVersionStatusHistory.Builder}
         * avoiding the need to create one manually via {@link RegistrationVersionStatusHistory#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RegistrationVersionStatusHistory.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #registrationVersionStatusHistory(RegistrationVersionStatusHistory)}.
         * 
         * @param registrationVersionStatusHistory
         *        a consumer that will call methods on {@link RegistrationVersionStatusHistory.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #registrationVersionStatusHistory(RegistrationVersionStatusHistory)
         */
        default Builder registrationVersionStatusHistory(
                Consumer<RegistrationVersionStatusHistory.Builder> registrationVersionStatusHistory) {
            return registrationVersionStatusHistory(RegistrationVersionStatusHistory.builder()
                    .applyMutation(registrationVersionStatusHistory).build());
        }
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Response.BuilderImpl implements Builder {
        private String registrationArn;

        private String registrationId;

        private Long versionNumber;

        private String registrationVersionStatus;

        private RegistrationVersionStatusHistory registrationVersionStatusHistory;

        private BuilderImpl() {
        }

        private BuilderImpl(DiscardRegistrationVersionResponse model) {
            super(model);
            registrationArn(model.registrationArn);
            registrationId(model.registrationId);
            versionNumber(model.versionNumber);
            registrationVersionStatus(model.registrationVersionStatus);
            registrationVersionStatusHistory(model.registrationVersionStatusHistory);
        }

        public final String getRegistrationArn() {
            return registrationArn;
        }

        public final void setRegistrationArn(String registrationArn) {
            this.registrationArn = registrationArn;
        }

        @Override
        public final Builder registrationArn(String registrationArn) {
            this.registrationArn = registrationArn;
            return this;
        }

        public final String getRegistrationId() {
            return registrationId;
        }

        public final void setRegistrationId(String registrationId) {
            this.registrationId = registrationId;
        }

        @Override
        public final Builder registrationId(String registrationId) {
            this.registrationId = registrationId;
            return this;
        }

        public final Long getVersionNumber() {
            return versionNumber;
        }

        public final void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        @Override
        public final Builder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        public final String getRegistrationVersionStatus() {
            return registrationVersionStatus;
        }

        public final void setRegistrationVersionStatus(String registrationVersionStatus) {
            this.registrationVersionStatus = registrationVersionStatus;
        }

        @Override
        public final Builder registrationVersionStatus(String registrationVersionStatus) {
            this.registrationVersionStatus = registrationVersionStatus;
            return this;
        }

        @Override
        public final Builder registrationVersionStatus(RegistrationVersionStatus registrationVersionStatus) {
            this.registrationVersionStatus(registrationVersionStatus == null ? null : registrationVersionStatus.toString());
            return this;
        }

        public final RegistrationVersionStatusHistory.Builder getRegistrationVersionStatusHistory() {
            return registrationVersionStatusHistory != null ? registrationVersionStatusHistory.toBuilder() : null;
        }

        public final void setRegistrationVersionStatusHistory(
                RegistrationVersionStatusHistory.BuilderImpl registrationVersionStatusHistory) {
            this.registrationVersionStatusHistory = registrationVersionStatusHistory != null ? registrationVersionStatusHistory
                    .build() : null;
        }

        @Override
        public final Builder registrationVersionStatusHistory(RegistrationVersionStatusHistory registrationVersionStatusHistory) {
            this.registrationVersionStatusHistory = registrationVersionStatusHistory;
            return this;
        }

        @Override
        public DiscardRegistrationVersionResponse build() {
            return new DiscardRegistrationVersionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
