/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The information for all keywords in a pool.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KeywordInformation implements SdkPojo, Serializable,
        ToCopyableBuilder<KeywordInformation.Builder, KeywordInformation> {
    private static final SdkField<String> KEYWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Keyword")
            .getter(getter(KeywordInformation::keyword)).setter(setter(Builder::keyword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Keyword").build()).build();

    private static final SdkField<String> KEYWORD_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeywordMessage").getter(getter(KeywordInformation::keywordMessage))
            .setter(setter(Builder::keywordMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeywordMessage").build()).build();

    private static final SdkField<String> KEYWORD_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeywordAction").getter(getter(KeywordInformation::keywordActionAsString))
            .setter(setter(Builder::keywordAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeywordAction").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEYWORD_FIELD,
            KEYWORD_MESSAGE_FIELD, KEYWORD_ACTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String keyword;

    private final String keywordMessage;

    private final String keywordAction;

    private KeywordInformation(BuilderImpl builder) {
        this.keyword = builder.keyword;
        this.keywordMessage = builder.keywordMessage;
        this.keywordAction = builder.keywordAction;
    }

    /**
     * <p>
     * The keyword as a string.
     * </p>
     * 
     * @return The keyword as a string.
     */
    public final String keyword() {
        return keyword;
    }

    /**
     * <p>
     * A custom message that can be used with the keyword.
     * </p>
     * 
     * @return A custom message that can be used with the keyword.
     */
    public final String keywordMessage() {
        return keywordMessage;
    }

    /**
     * <p>
     * The action to perform for the keyword.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #keywordAction}
     * will return {@link KeywordAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keywordActionAsString}.
     * </p>
     * 
     * @return The action to perform for the keyword.
     * @see KeywordAction
     */
    public final KeywordAction keywordAction() {
        return KeywordAction.fromValue(keywordAction);
    }

    /**
     * <p>
     * The action to perform for the keyword.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #keywordAction}
     * will return {@link KeywordAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keywordActionAsString}.
     * </p>
     * 
     * @return The action to perform for the keyword.
     * @see KeywordAction
     */
    public final String keywordActionAsString() {
        return keywordAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(keyword());
        hashCode = 31 * hashCode + Objects.hashCode(keywordMessage());
        hashCode = 31 * hashCode + Objects.hashCode(keywordActionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeywordInformation)) {
            return false;
        }
        KeywordInformation other = (KeywordInformation) obj;
        return Objects.equals(keyword(), other.keyword()) && Objects.equals(keywordMessage(), other.keywordMessage())
                && Objects.equals(keywordActionAsString(), other.keywordActionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KeywordInformation").add("Keyword", keyword()).add("KeywordMessage", keywordMessage())
                .add("KeywordAction", keywordActionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Keyword":
            return Optional.ofNullable(clazz.cast(keyword()));
        case "KeywordMessage":
            return Optional.ofNullable(clazz.cast(keywordMessage()));
        case "KeywordAction":
            return Optional.ofNullable(clazz.cast(keywordActionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Keyword", KEYWORD_FIELD);
        map.put("KeywordMessage", KEYWORD_MESSAGE_FIELD);
        map.put("KeywordAction", KEYWORD_ACTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KeywordInformation, T> g) {
        return obj -> g.apply((KeywordInformation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KeywordInformation> {
        /**
         * <p>
         * The keyword as a string.
         * </p>
         * 
         * @param keyword
         *        The keyword as a string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyword(String keyword);

        /**
         * <p>
         * A custom message that can be used with the keyword.
         * </p>
         * 
         * @param keywordMessage
         *        A custom message that can be used with the keyword.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keywordMessage(String keywordMessage);

        /**
         * <p>
         * The action to perform for the keyword.
         * </p>
         * 
         * @param keywordAction
         *        The action to perform for the keyword.
         * @see KeywordAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeywordAction
         */
        Builder keywordAction(String keywordAction);

        /**
         * <p>
         * The action to perform for the keyword.
         * </p>
         * 
         * @param keywordAction
         *        The action to perform for the keyword.
         * @see KeywordAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeywordAction
         */
        Builder keywordAction(KeywordAction keywordAction);
    }

    static final class BuilderImpl implements Builder {
        private String keyword;

        private String keywordMessage;

        private String keywordAction;

        private BuilderImpl() {
        }

        private BuilderImpl(KeywordInformation model) {
            keyword(model.keyword);
            keywordMessage(model.keywordMessage);
            keywordAction(model.keywordAction);
        }

        public final String getKeyword() {
            return keyword;
        }

        public final void setKeyword(String keyword) {
            this.keyword = keyword;
        }

        @Override
        public final Builder keyword(String keyword) {
            this.keyword = keyword;
            return this;
        }

        public final String getKeywordMessage() {
            return keywordMessage;
        }

        public final void setKeywordMessage(String keywordMessage) {
            this.keywordMessage = keywordMessage;
        }

        @Override
        public final Builder keywordMessage(String keywordMessage) {
            this.keywordMessage = keywordMessage;
            return this;
        }

        public final String getKeywordAction() {
            return keywordAction;
        }

        public final void setKeywordAction(String keywordAction) {
            this.keywordAction = keywordAction;
        }

        @Override
        public final Builder keywordAction(String keywordAction) {
            this.keywordAction = keywordAction;
            return this;
        }

        @Override
        public final Builder keywordAction(KeywordAction keywordAction) {
            this.keywordAction(keywordAction == null ? null : keywordAction.toString());
            return this;
        }

        @Override
        public KeywordInformation build() {
            return new KeywordInformation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
