/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The information for an opted out number in an Amazon Web Services account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OptedOutNumberInformation implements SdkPojo, Serializable,
        ToCopyableBuilder<OptedOutNumberInformation.Builder, OptedOutNumberInformation> {
    private static final SdkField<String> OPTED_OUT_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptedOutNumber").getter(getter(OptedOutNumberInformation::optedOutNumber))
            .setter(setter(Builder::optedOutNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptedOutNumber").build()).build();

    private static final SdkField<Instant> OPTED_OUT_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("OptedOutTimestamp").getter(getter(OptedOutNumberInformation::optedOutTimestamp))
            .setter(setter(Builder::optedOutTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptedOutTimestamp").build()).build();

    private static final SdkField<Boolean> END_USER_OPTED_OUT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EndUserOptedOut").getter(getter(OptedOutNumberInformation::endUserOptedOut))
            .setter(setter(Builder::endUserOptedOut))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndUserOptedOut").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPTED_OUT_NUMBER_FIELD,
            OPTED_OUT_TIMESTAMP_FIELD, END_USER_OPTED_OUT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String optedOutNumber;

    private final Instant optedOutTimestamp;

    private final Boolean endUserOptedOut;

    private OptedOutNumberInformation(BuilderImpl builder) {
        this.optedOutNumber = builder.optedOutNumber;
        this.optedOutTimestamp = builder.optedOutTimestamp;
        this.endUserOptedOut = builder.endUserOptedOut;
    }

    /**
     * <p>
     * The phone number that is opted out.
     * </p>
     * 
     * @return The phone number that is opted out.
     */
    public final String optedOutNumber() {
        return optedOutNumber;
    }

    /**
     * <p>
     * The time that the op tout occurred, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.
     * </p>
     * 
     * @return The time that the op tout occurred, in <a href="https://www.epochconverter.com/">UNIX epoch time</a>
     *         format.
     */
    public final Instant optedOutTimestamp() {
        return optedOutTimestamp;
    }

    /**
     * <p>
     * This is set to true if it was the end recipient that opted out.
     * </p>
     * 
     * @return This is set to true if it was the end recipient that opted out.
     */
    public final Boolean endUserOptedOut() {
        return endUserOptedOut;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(optedOutNumber());
        hashCode = 31 * hashCode + Objects.hashCode(optedOutTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(endUserOptedOut());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OptedOutNumberInformation)) {
            return false;
        }
        OptedOutNumberInformation other = (OptedOutNumberInformation) obj;
        return Objects.equals(optedOutNumber(), other.optedOutNumber())
                && Objects.equals(optedOutTimestamp(), other.optedOutTimestamp())
                && Objects.equals(endUserOptedOut(), other.endUserOptedOut());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OptedOutNumberInformation").add("OptedOutNumber", optedOutNumber())
                .add("OptedOutTimestamp", optedOutTimestamp()).add("EndUserOptedOut", endUserOptedOut()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OptedOutNumber":
            return Optional.ofNullable(clazz.cast(optedOutNumber()));
        case "OptedOutTimestamp":
            return Optional.ofNullable(clazz.cast(optedOutTimestamp()));
        case "EndUserOptedOut":
            return Optional.ofNullable(clazz.cast(endUserOptedOut()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OptedOutNumber", OPTED_OUT_NUMBER_FIELD);
        map.put("OptedOutTimestamp", OPTED_OUT_TIMESTAMP_FIELD);
        map.put("EndUserOptedOut", END_USER_OPTED_OUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OptedOutNumberInformation, T> g) {
        return obj -> g.apply((OptedOutNumberInformation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OptedOutNumberInformation> {
        /**
         * <p>
         * The phone number that is opted out.
         * </p>
         * 
         * @param optedOutNumber
         *        The phone number that is opted out.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optedOutNumber(String optedOutNumber);

        /**
         * <p>
         * The time that the op tout occurred, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.
         * </p>
         * 
         * @param optedOutTimestamp
         *        The time that the op tout occurred, in <a href="https://www.epochconverter.com/">UNIX epoch time</a>
         *        format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optedOutTimestamp(Instant optedOutTimestamp);

        /**
         * <p>
         * This is set to true if it was the end recipient that opted out.
         * </p>
         * 
         * @param endUserOptedOut
         *        This is set to true if it was the end recipient that opted out.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endUserOptedOut(Boolean endUserOptedOut);
    }

    static final class BuilderImpl implements Builder {
        private String optedOutNumber;

        private Instant optedOutTimestamp;

        private Boolean endUserOptedOut;

        private BuilderImpl() {
        }

        private BuilderImpl(OptedOutNumberInformation model) {
            optedOutNumber(model.optedOutNumber);
            optedOutTimestamp(model.optedOutTimestamp);
            endUserOptedOut(model.endUserOptedOut);
        }

        public final String getOptedOutNumber() {
            return optedOutNumber;
        }

        public final void setOptedOutNumber(String optedOutNumber) {
            this.optedOutNumber = optedOutNumber;
        }

        @Override
        public final Builder optedOutNumber(String optedOutNumber) {
            this.optedOutNumber = optedOutNumber;
            return this;
        }

        public final Instant getOptedOutTimestamp() {
            return optedOutTimestamp;
        }

        public final void setOptedOutTimestamp(Instant optedOutTimestamp) {
            this.optedOutTimestamp = optedOutTimestamp;
        }

        @Override
        public final Builder optedOutTimestamp(Instant optedOutTimestamp) {
            this.optedOutTimestamp = optedOutTimestamp;
            return this;
        }

        public final Boolean getEndUserOptedOut() {
            return endUserOptedOut;
        }

        public final void setEndUserOptedOut(Boolean endUserOptedOut) {
            this.endUserOptedOut = endUserOptedOut;
        }

        @Override
        public final Builder endUserOptedOut(Boolean endUserOptedOut) {
            this.endUserOptedOut = endUserOptedOut;
            return this;
        }

        @Override
        public OptedOutNumberInformation build() {
            return new OptedOutNumberInformation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
