/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The metadata for an origination identity associated with a pool.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OriginationIdentityMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<OriginationIdentityMetadata.Builder, OriginationIdentityMetadata> {
    private static final SdkField<String> ORIGINATION_IDENTITY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OriginationIdentityArn").getter(getter(OriginationIdentityMetadata::originationIdentityArn))
            .setter(setter(Builder::originationIdentityArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginationIdentityArn").build())
            .build();

    private static final SdkField<String> ORIGINATION_IDENTITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OriginationIdentity").getter(getter(OriginationIdentityMetadata::originationIdentity))
            .setter(setter(Builder::originationIdentity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginationIdentity").build())
            .build();

    private static final SdkField<String> ISO_COUNTRY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IsoCountryCode").getter(getter(OriginationIdentityMetadata::isoCountryCode))
            .setter(setter(Builder::isoCountryCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsoCountryCode").build()).build();

    private static final SdkField<List<String>> NUMBER_CAPABILITIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NumberCapabilities")
            .getter(getter(OriginationIdentityMetadata::numberCapabilitiesAsStrings))
            .setter(setter(Builder::numberCapabilitiesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberCapabilities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PhoneNumber").getter(getter(OriginationIdentityMetadata::phoneNumber))
            .setter(setter(Builder::phoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumber").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ORIGINATION_IDENTITY_ARN_FIELD, ORIGINATION_IDENTITY_FIELD, ISO_COUNTRY_CODE_FIELD, NUMBER_CAPABILITIES_FIELD,
            PHONE_NUMBER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String originationIdentityArn;

    private final String originationIdentity;

    private final String isoCountryCode;

    private final List<String> numberCapabilities;

    private final String phoneNumber;

    private OriginationIdentityMetadata(BuilderImpl builder) {
        this.originationIdentityArn = builder.originationIdentityArn;
        this.originationIdentity = builder.originationIdentity;
        this.isoCountryCode = builder.isoCountryCode;
        this.numberCapabilities = builder.numberCapabilities;
        this.phoneNumber = builder.phoneNumber;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) associated with the origination identity.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) associated with the origination identity.
     */
    public final String originationIdentityArn() {
        return originationIdentityArn;
    }

    /**
     * <p>
     * The unique identifier of the origination identity.
     * </p>
     * 
     * @return The unique identifier of the origination identity.
     */
    public final String originationIdentity() {
        return originationIdentity;
    }

    /**
     * <p>
     * The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.
     * </p>
     * 
     * @return The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.
     */
    public final String isoCountryCode() {
        return isoCountryCode;
    }

    /**
     * <p>
     * Describes if the origination identity can be used for text messages, voice calls or both.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNumberCapabilities} method.
     * </p>
     * 
     * @return Describes if the origination identity can be used for text messages, voice calls or both.
     */
    public final List<NumberCapability> numberCapabilities() {
        return NumberCapabilityListCopier.copyStringToEnum(numberCapabilities);
    }

    /**
     * For responses, this returns true if the service returned a value for the NumberCapabilities property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNumberCapabilities() {
        return numberCapabilities != null && !(numberCapabilities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describes if the origination identity can be used for text messages, voice calls or both.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNumberCapabilities} method.
     * </p>
     * 
     * @return Describes if the origination identity can be used for text messages, voice calls or both.
     */
    public final List<String> numberCapabilitiesAsStrings() {
        return numberCapabilities;
    }

    /**
     * <p>
     * The phone number in E.164 format.
     * </p>
     * 
     * @return The phone number in E.164 format.
     */
    public final String phoneNumber() {
        return phoneNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(originationIdentityArn());
        hashCode = 31 * hashCode + Objects.hashCode(originationIdentity());
        hashCode = 31 * hashCode + Objects.hashCode(isoCountryCode());
        hashCode = 31 * hashCode + Objects.hashCode(hasNumberCapabilities() ? numberCapabilitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OriginationIdentityMetadata)) {
            return false;
        }
        OriginationIdentityMetadata other = (OriginationIdentityMetadata) obj;
        return Objects.equals(originationIdentityArn(), other.originationIdentityArn())
                && Objects.equals(originationIdentity(), other.originationIdentity())
                && Objects.equals(isoCountryCode(), other.isoCountryCode())
                && hasNumberCapabilities() == other.hasNumberCapabilities()
                && Objects.equals(numberCapabilitiesAsStrings(), other.numberCapabilitiesAsStrings())
                && Objects.equals(phoneNumber(), other.phoneNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OriginationIdentityMetadata").add("OriginationIdentityArn", originationIdentityArn())
                .add("OriginationIdentity", originationIdentity()).add("IsoCountryCode", isoCountryCode())
                .add("NumberCapabilities", hasNumberCapabilities() ? numberCapabilitiesAsStrings() : null)
                .add("PhoneNumber", phoneNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OriginationIdentityArn":
            return Optional.ofNullable(clazz.cast(originationIdentityArn()));
        case "OriginationIdentity":
            return Optional.ofNullable(clazz.cast(originationIdentity()));
        case "IsoCountryCode":
            return Optional.ofNullable(clazz.cast(isoCountryCode()));
        case "NumberCapabilities":
            return Optional.ofNullable(clazz.cast(numberCapabilitiesAsStrings()));
        case "PhoneNumber":
            return Optional.ofNullable(clazz.cast(phoneNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OriginationIdentityArn", ORIGINATION_IDENTITY_ARN_FIELD);
        map.put("OriginationIdentity", ORIGINATION_IDENTITY_FIELD);
        map.put("IsoCountryCode", ISO_COUNTRY_CODE_FIELD);
        map.put("NumberCapabilities", NUMBER_CAPABILITIES_FIELD);
        map.put("PhoneNumber", PHONE_NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OriginationIdentityMetadata, T> g) {
        return obj -> g.apply((OriginationIdentityMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OriginationIdentityMetadata> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) associated with the origination identity.
         * </p>
         * 
         * @param originationIdentityArn
         *        The Amazon Resource Name (ARN) associated with the origination identity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originationIdentityArn(String originationIdentityArn);

        /**
         * <p>
         * The unique identifier of the origination identity.
         * </p>
         * 
         * @param originationIdentity
         *        The unique identifier of the origination identity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originationIdentity(String originationIdentity);

        /**
         * <p>
         * The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.
         * </p>
         * 
         * @param isoCountryCode
         *        The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isoCountryCode(String isoCountryCode);

        /**
         * <p>
         * Describes if the origination identity can be used for text messages, voice calls or both.
         * </p>
         * 
         * @param numberCapabilities
         *        Describes if the origination identity can be used for text messages, voice calls or both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberCapabilitiesWithStrings(Collection<String> numberCapabilities);

        /**
         * <p>
         * Describes if the origination identity can be used for text messages, voice calls or both.
         * </p>
         * 
         * @param numberCapabilities
         *        Describes if the origination identity can be used for text messages, voice calls or both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberCapabilitiesWithStrings(String... numberCapabilities);

        /**
         * <p>
         * Describes if the origination identity can be used for text messages, voice calls or both.
         * </p>
         * 
         * @param numberCapabilities
         *        Describes if the origination identity can be used for text messages, voice calls or both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberCapabilities(Collection<NumberCapability> numberCapabilities);

        /**
         * <p>
         * Describes if the origination identity can be used for text messages, voice calls or both.
         * </p>
         * 
         * @param numberCapabilities
         *        Describes if the origination identity can be used for text messages, voice calls or both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberCapabilities(NumberCapability... numberCapabilities);

        /**
         * <p>
         * The phone number in E.164 format.
         * </p>
         * 
         * @param phoneNumber
         *        The phone number in E.164 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumber(String phoneNumber);
    }

    static final class BuilderImpl implements Builder {
        private String originationIdentityArn;

        private String originationIdentity;

        private String isoCountryCode;

        private List<String> numberCapabilities = DefaultSdkAutoConstructList.getInstance();

        private String phoneNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(OriginationIdentityMetadata model) {
            originationIdentityArn(model.originationIdentityArn);
            originationIdentity(model.originationIdentity);
            isoCountryCode(model.isoCountryCode);
            numberCapabilitiesWithStrings(model.numberCapabilities);
            phoneNumber(model.phoneNumber);
        }

        public final String getOriginationIdentityArn() {
            return originationIdentityArn;
        }

        public final void setOriginationIdentityArn(String originationIdentityArn) {
            this.originationIdentityArn = originationIdentityArn;
        }

        @Override
        public final Builder originationIdentityArn(String originationIdentityArn) {
            this.originationIdentityArn = originationIdentityArn;
            return this;
        }

        public final String getOriginationIdentity() {
            return originationIdentity;
        }

        public final void setOriginationIdentity(String originationIdentity) {
            this.originationIdentity = originationIdentity;
        }

        @Override
        public final Builder originationIdentity(String originationIdentity) {
            this.originationIdentity = originationIdentity;
            return this;
        }

        public final String getIsoCountryCode() {
            return isoCountryCode;
        }

        public final void setIsoCountryCode(String isoCountryCode) {
            this.isoCountryCode = isoCountryCode;
        }

        @Override
        public final Builder isoCountryCode(String isoCountryCode) {
            this.isoCountryCode = isoCountryCode;
            return this;
        }

        public final Collection<String> getNumberCapabilities() {
            if (numberCapabilities instanceof SdkAutoConstructList) {
                return null;
            }
            return numberCapabilities;
        }

        public final void setNumberCapabilities(Collection<String> numberCapabilities) {
            this.numberCapabilities = NumberCapabilityListCopier.copy(numberCapabilities);
        }

        @Override
        public final Builder numberCapabilitiesWithStrings(Collection<String> numberCapabilities) {
            this.numberCapabilities = NumberCapabilityListCopier.copy(numberCapabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder numberCapabilitiesWithStrings(String... numberCapabilities) {
            numberCapabilitiesWithStrings(Arrays.asList(numberCapabilities));
            return this;
        }

        @Override
        public final Builder numberCapabilities(Collection<NumberCapability> numberCapabilities) {
            this.numberCapabilities = NumberCapabilityListCopier.copyEnumToString(numberCapabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder numberCapabilities(NumberCapability... numberCapabilities) {
            numberCapabilities(Arrays.asList(numberCapabilities));
            return this;
        }

        public final String getPhoneNumber() {
            return phoneNumber;
        }

        public final void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        @Override
        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        @Override
        public OriginationIdentityMetadata build() {
            return new OriginationIdentityMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
