/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutMessageFeedbackResponse extends PinpointSmsVoiceV2Response implements
        ToCopyableBuilder<PutMessageFeedbackResponse.Builder, PutMessageFeedbackResponse> {
    private static final SdkField<String> MESSAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MessageId").getter(getter(PutMessageFeedbackResponse::messageId)).setter(setter(Builder::messageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageId").build()).build();

    private static final SdkField<String> MESSAGE_FEEDBACK_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MessageFeedbackStatus").getter(getter(PutMessageFeedbackResponse::messageFeedbackStatusAsString))
            .setter(setter(Builder::messageFeedbackStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageFeedbackStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_ID_FIELD,
            MESSAGE_FEEDBACK_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String messageId;

    private final String messageFeedbackStatus;

    private PutMessageFeedbackResponse(BuilderImpl builder) {
        super(builder);
        this.messageId = builder.messageId;
        this.messageFeedbackStatus = builder.messageFeedbackStatus;
    }

    /**
     * <p>
     * The unique identifier for the message.
     * </p>
     * 
     * @return The unique identifier for the message.
     */
    public final String messageId() {
        return messageId;
    }

    /**
     * <p>
     * The current status of the message.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #messageFeedbackStatus} will return {@link MessageFeedbackStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #messageFeedbackStatusAsString}.
     * </p>
     * 
     * @return The current status of the message.
     * @see MessageFeedbackStatus
     */
    public final MessageFeedbackStatus messageFeedbackStatus() {
        return MessageFeedbackStatus.fromValue(messageFeedbackStatus);
    }

    /**
     * <p>
     * The current status of the message.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #messageFeedbackStatus} will return {@link MessageFeedbackStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #messageFeedbackStatusAsString}.
     * </p>
     * 
     * @return The current status of the message.
     * @see MessageFeedbackStatus
     */
    public final String messageFeedbackStatusAsString() {
        return messageFeedbackStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(messageId());
        hashCode = 31 * hashCode + Objects.hashCode(messageFeedbackStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutMessageFeedbackResponse)) {
            return false;
        }
        PutMessageFeedbackResponse other = (PutMessageFeedbackResponse) obj;
        return Objects.equals(messageId(), other.messageId())
                && Objects.equals(messageFeedbackStatusAsString(), other.messageFeedbackStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutMessageFeedbackResponse").add("MessageId", messageId())
                .add("MessageFeedbackStatus", messageFeedbackStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MessageId":
            return Optional.ofNullable(clazz.cast(messageId()));
        case "MessageFeedbackStatus":
            return Optional.ofNullable(clazz.cast(messageFeedbackStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MessageId", MESSAGE_ID_FIELD);
        map.put("MessageFeedbackStatus", MESSAGE_FEEDBACK_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutMessageFeedbackResponse, T> g) {
        return obj -> g.apply((PutMessageFeedbackResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PinpointSmsVoiceV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, PutMessageFeedbackResponse> {
        /**
         * <p>
         * The unique identifier for the message.
         * </p>
         * 
         * @param messageId
         *        The unique identifier for the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageId(String messageId);

        /**
         * <p>
         * The current status of the message.
         * </p>
         * 
         * @param messageFeedbackStatus
         *        The current status of the message.
         * @see MessageFeedbackStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageFeedbackStatus
         */
        Builder messageFeedbackStatus(String messageFeedbackStatus);

        /**
         * <p>
         * The current status of the message.
         * </p>
         * 
         * @param messageFeedbackStatus
         *        The current status of the message.
         * @see MessageFeedbackStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageFeedbackStatus
         */
        Builder messageFeedbackStatus(MessageFeedbackStatus messageFeedbackStatus);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Response.BuilderImpl implements Builder {
        private String messageId;

        private String messageFeedbackStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(PutMessageFeedbackResponse model) {
            super(model);
            messageId(model.messageId);
            messageFeedbackStatus(model.messageFeedbackStatus);
        }

        public final String getMessageId() {
            return messageId;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        @Override
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final String getMessageFeedbackStatus() {
            return messageFeedbackStatus;
        }

        public final void setMessageFeedbackStatus(String messageFeedbackStatus) {
            this.messageFeedbackStatus = messageFeedbackStatus;
        }

        @Override
        public final Builder messageFeedbackStatus(String messageFeedbackStatus) {
            this.messageFeedbackStatus = messageFeedbackStatus;
            return this;
        }

        @Override
        public final Builder messageFeedbackStatus(MessageFeedbackStatus messageFeedbackStatus) {
            this.messageFeedbackStatus(messageFeedbackStatus == null ? null : messageFeedbackStatus.toString());
            return this;
        }

        @Override
        public PutMessageFeedbackResponse build() {
            return new PutMessageFeedbackResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
