/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the specified version of the registration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegistrationVersionInformation implements SdkPojo, Serializable,
        ToCopyableBuilder<RegistrationVersionInformation.Builder, RegistrationVersionInformation> {
    private static final SdkField<Long> VERSION_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("VersionNumber").getter(getter(RegistrationVersionInformation::versionNumber))
            .setter(setter(Builder::versionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionNumber").build()).build();

    private static final SdkField<String> REGISTRATION_VERSION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegistrationVersionStatus")
            .getter(getter(RegistrationVersionInformation::registrationVersionStatusAsString))
            .setter(setter(Builder::registrationVersionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationVersionStatus").build())
            .build();

    private static final SdkField<RegistrationVersionStatusHistory> REGISTRATION_VERSION_STATUS_HISTORY_FIELD = SdkField
            .<RegistrationVersionStatusHistory> builder(MarshallingType.SDK_POJO)
            .memberName("RegistrationVersionStatusHistory")
            .getter(getter(RegistrationVersionInformation::registrationVersionStatusHistory))
            .setter(setter(Builder::registrationVersionStatusHistory))
            .constructor(RegistrationVersionStatusHistory::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationVersionStatusHistory")
                    .build()).build();

    private static final SdkField<List<RegistrationDeniedReasonInformation>> DENIED_REASONS_FIELD = SdkField
            .<List<RegistrationDeniedReasonInformation>> builder(MarshallingType.LIST)
            .memberName("DeniedReasons")
            .getter(getter(RegistrationVersionInformation::deniedReasons))
            .setter(setter(Builder::deniedReasons))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeniedReasons").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RegistrationDeniedReasonInformation> builder(MarshallingType.SDK_POJO)
                                            .constructor(RegistrationDeniedReasonInformation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSION_NUMBER_FIELD,
            REGISTRATION_VERSION_STATUS_FIELD, REGISTRATION_VERSION_STATUS_HISTORY_FIELD, DENIED_REASONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long versionNumber;

    private final String registrationVersionStatus;

    private final RegistrationVersionStatusHistory registrationVersionStatusHistory;

    private final List<RegistrationDeniedReasonInformation> deniedReasons;

    private RegistrationVersionInformation(BuilderImpl builder) {
        this.versionNumber = builder.versionNumber;
        this.registrationVersionStatus = builder.registrationVersionStatus;
        this.registrationVersionStatusHistory = builder.registrationVersionStatusHistory;
        this.deniedReasons = builder.deniedReasons;
    }

    /**
     * <p>
     * The version number of the registration.
     * </p>
     * 
     * @return The version number of the registration.
     */
    public final Long versionNumber() {
        return versionNumber;
    }

    /**
     * <p>
     * The status of the registration.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>APPROVED</code>: Your registration has been approved.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ARCHIVED</code>: Your previously approved registration version moves into this status when a more recently
     * submitted version is approved.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DENIED</code>: You must fix your registration and resubmit it.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISCARDED</code>: You've abandon this version of their registration to start over with a new version.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DRAFT</code>: The initial status of a registration version after it’s created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REQUIRES_AUTHENTICATION</code>: You need to complete email authentication.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REVIEWING</code>: Your registration has been accepted and is being reviewed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REVOKED</code>: Your previously approved registration has been revoked.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUBMITTED</code>: Your registration has been submitted.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #registrationVersionStatus} will return {@link RegistrationVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #registrationVersionStatusAsString}.
     * </p>
     * 
     * @return The status of the registration.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>APPROVED</code>: Your registration has been approved.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ARCHIVED</code>: Your previously approved registration version moves into this status when a more
     *         recently submitted version is approved.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DENIED</code>: You must fix your registration and resubmit it.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISCARDED</code>: You've abandon this version of their registration to start over with a new
     *         version.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DRAFT</code>: The initial status of a registration version after it’s created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REQUIRES_AUTHENTICATION</code>: You need to complete email authentication.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REVIEWING</code>: Your registration has been accepted and is being reviewed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REVOKED</code>: Your previously approved registration has been revoked.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUBMITTED</code>: Your registration has been submitted.
     *         </p>
     *         </li>
     * @see RegistrationVersionStatus
     */
    public final RegistrationVersionStatus registrationVersionStatus() {
        return RegistrationVersionStatus.fromValue(registrationVersionStatus);
    }

    /**
     * <p>
     * The status of the registration.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>APPROVED</code>: Your registration has been approved.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ARCHIVED</code>: Your previously approved registration version moves into this status when a more recently
     * submitted version is approved.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DENIED</code>: You must fix your registration and resubmit it.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISCARDED</code>: You've abandon this version of their registration to start over with a new version.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DRAFT</code>: The initial status of a registration version after it’s created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REQUIRES_AUTHENTICATION</code>: You need to complete email authentication.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REVIEWING</code>: Your registration has been accepted and is being reviewed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REVOKED</code>: Your previously approved registration has been revoked.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUBMITTED</code>: Your registration has been submitted.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #registrationVersionStatus} will return {@link RegistrationVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #registrationVersionStatusAsString}.
     * </p>
     * 
     * @return The status of the registration.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>APPROVED</code>: Your registration has been approved.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ARCHIVED</code>: Your previously approved registration version moves into this status when a more
     *         recently submitted version is approved.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DENIED</code>: You must fix your registration and resubmit it.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISCARDED</code>: You've abandon this version of their registration to start over with a new
     *         version.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DRAFT</code>: The initial status of a registration version after it’s created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REQUIRES_AUTHENTICATION</code>: You need to complete email authentication.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REVIEWING</code>: Your registration has been accepted and is being reviewed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REVOKED</code>: Your previously approved registration has been revoked.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUBMITTED</code>: Your registration has been submitted.
     *         </p>
     *         </li>
     * @see RegistrationVersionStatus
     */
    public final String registrationVersionStatusAsString() {
        return registrationVersionStatus;
    }

    /**
     * <p>
     * The <b>RegistrationVersionStatusHistory</b> object contains the time stamps for when the reservations status
     * changes.
     * </p>
     * 
     * @return The <b>RegistrationVersionStatusHistory</b> object contains the time stamps for when the reservations
     *         status changes.
     */
    public final RegistrationVersionStatusHistory registrationVersionStatusHistory() {
        return registrationVersionStatusHistory;
    }

    /**
     * For responses, this returns true if the service returned a value for the DeniedReasons property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDeniedReasons() {
        return deniedReasons != null && !(deniedReasons instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of RegistrationDeniedReasonInformation objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeniedReasons} method.
     * </p>
     * 
     * @return An array of RegistrationDeniedReasonInformation objects.
     */
    public final List<RegistrationDeniedReasonInformation> deniedReasons() {
        return deniedReasons;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(versionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(registrationVersionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(registrationVersionStatusHistory());
        hashCode = 31 * hashCode + Objects.hashCode(hasDeniedReasons() ? deniedReasons() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegistrationVersionInformation)) {
            return false;
        }
        RegistrationVersionInformation other = (RegistrationVersionInformation) obj;
        return Objects.equals(versionNumber(), other.versionNumber())
                && Objects.equals(registrationVersionStatusAsString(), other.registrationVersionStatusAsString())
                && Objects.equals(registrationVersionStatusHistory(), other.registrationVersionStatusHistory())
                && hasDeniedReasons() == other.hasDeniedReasons() && Objects.equals(deniedReasons(), other.deniedReasons());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegistrationVersionInformation").add("VersionNumber", versionNumber())
                .add("RegistrationVersionStatus", registrationVersionStatusAsString())
                .add("RegistrationVersionStatusHistory", registrationVersionStatusHistory())
                .add("DeniedReasons", hasDeniedReasons() ? deniedReasons() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VersionNumber":
            return Optional.ofNullable(clazz.cast(versionNumber()));
        case "RegistrationVersionStatus":
            return Optional.ofNullable(clazz.cast(registrationVersionStatusAsString()));
        case "RegistrationVersionStatusHistory":
            return Optional.ofNullable(clazz.cast(registrationVersionStatusHistory()));
        case "DeniedReasons":
            return Optional.ofNullable(clazz.cast(deniedReasons()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VersionNumber", VERSION_NUMBER_FIELD);
        map.put("RegistrationVersionStatus", REGISTRATION_VERSION_STATUS_FIELD);
        map.put("RegistrationVersionStatusHistory", REGISTRATION_VERSION_STATUS_HISTORY_FIELD);
        map.put("DeniedReasons", DENIED_REASONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegistrationVersionInformation, T> g) {
        return obj -> g.apply((RegistrationVersionInformation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RegistrationVersionInformation> {
        /**
         * <p>
         * The version number of the registration.
         * </p>
         * 
         * @param versionNumber
         *        The version number of the registration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionNumber(Long versionNumber);

        /**
         * <p>
         * The status of the registration.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>APPROVED</code>: Your registration has been approved.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ARCHIVED</code>: Your previously approved registration version moves into this status when a more
         * recently submitted version is approved.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DENIED</code>: You must fix your registration and resubmit it.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISCARDED</code>: You've abandon this version of their registration to start over with a new version.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DRAFT</code>: The initial status of a registration version after it’s created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REQUIRES_AUTHENTICATION</code>: You need to complete email authentication.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REVIEWING</code>: Your registration has been accepted and is being reviewed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REVOKED</code>: Your previously approved registration has been revoked.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUBMITTED</code>: Your registration has been submitted.
         * </p>
         * </li>
         * </ul>
         * 
         * @param registrationVersionStatus
         *        The status of the registration.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>APPROVED</code>: Your registration has been approved.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ARCHIVED</code>: Your previously approved registration version moves into this status when a
         *        more recently submitted version is approved.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DENIED</code>: You must fix your registration and resubmit it.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISCARDED</code>: You've abandon this version of their registration to start over with a new
         *        version.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DRAFT</code>: The initial status of a registration version after it’s created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REQUIRES_AUTHENTICATION</code>: You need to complete email authentication.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REVIEWING</code>: Your registration has been accepted and is being reviewed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REVOKED</code>: Your previously approved registration has been revoked.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUBMITTED</code>: Your registration has been submitted.
         *        </p>
         *        </li>
         * @see RegistrationVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistrationVersionStatus
         */
        Builder registrationVersionStatus(String registrationVersionStatus);

        /**
         * <p>
         * The status of the registration.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>APPROVED</code>: Your registration has been approved.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ARCHIVED</code>: Your previously approved registration version moves into this status when a more
         * recently submitted version is approved.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DENIED</code>: You must fix your registration and resubmit it.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISCARDED</code>: You've abandon this version of their registration to start over with a new version.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DRAFT</code>: The initial status of a registration version after it’s created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REQUIRES_AUTHENTICATION</code>: You need to complete email authentication.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REVIEWING</code>: Your registration has been accepted and is being reviewed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REVOKED</code>: Your previously approved registration has been revoked.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUBMITTED</code>: Your registration has been submitted.
         * </p>
         * </li>
         * </ul>
         * 
         * @param registrationVersionStatus
         *        The status of the registration.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>APPROVED</code>: Your registration has been approved.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ARCHIVED</code>: Your previously approved registration version moves into this status when a
         *        more recently submitted version is approved.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DENIED</code>: You must fix your registration and resubmit it.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISCARDED</code>: You've abandon this version of their registration to start over with a new
         *        version.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DRAFT</code>: The initial status of a registration version after it’s created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REQUIRES_AUTHENTICATION</code>: You need to complete email authentication.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REVIEWING</code>: Your registration has been accepted and is being reviewed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REVOKED</code>: Your previously approved registration has been revoked.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUBMITTED</code>: Your registration has been submitted.
         *        </p>
         *        </li>
         * @see RegistrationVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistrationVersionStatus
         */
        Builder registrationVersionStatus(RegistrationVersionStatus registrationVersionStatus);

        /**
         * <p>
         * The <b>RegistrationVersionStatusHistory</b> object contains the time stamps for when the reservations status
         * changes.
         * </p>
         * 
         * @param registrationVersionStatusHistory
         *        The <b>RegistrationVersionStatusHistory</b> object contains the time stamps for when the reservations
         *        status changes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationVersionStatusHistory(RegistrationVersionStatusHistory registrationVersionStatusHistory);

        /**
         * <p>
         * The <b>RegistrationVersionStatusHistory</b> object contains the time stamps for when the reservations status
         * changes.
         * </p>
         * This is a convenience method that creates an instance of the {@link RegistrationVersionStatusHistory.Builder}
         * avoiding the need to create one manually via {@link RegistrationVersionStatusHistory#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RegistrationVersionStatusHistory.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #registrationVersionStatusHistory(RegistrationVersionStatusHistory)}.
         * 
         * @param registrationVersionStatusHistory
         *        a consumer that will call methods on {@link RegistrationVersionStatusHistory.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #registrationVersionStatusHistory(RegistrationVersionStatusHistory)
         */
        default Builder registrationVersionStatusHistory(
                Consumer<RegistrationVersionStatusHistory.Builder> registrationVersionStatusHistory) {
            return registrationVersionStatusHistory(RegistrationVersionStatusHistory.builder()
                    .applyMutation(registrationVersionStatusHistory).build());
        }

        /**
         * <p>
         * An array of RegistrationDeniedReasonInformation objects.
         * </p>
         * 
         * @param deniedReasons
         *        An array of RegistrationDeniedReasonInformation objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deniedReasons(Collection<RegistrationDeniedReasonInformation> deniedReasons);

        /**
         * <p>
         * An array of RegistrationDeniedReasonInformation objects.
         * </p>
         * 
         * @param deniedReasons
         *        An array of RegistrationDeniedReasonInformation objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deniedReasons(RegistrationDeniedReasonInformation... deniedReasons);

        /**
         * <p>
         * An array of RegistrationDeniedReasonInformation objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationDeniedReasonInformation.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationDeniedReasonInformation#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationDeniedReasonInformation.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #deniedReasons(List<RegistrationDeniedReasonInformation>)}.
         * 
         * @param deniedReasons
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationDeniedReasonInformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deniedReasons(java.util.Collection<RegistrationDeniedReasonInformation>)
         */
        Builder deniedReasons(Consumer<RegistrationDeniedReasonInformation.Builder>... deniedReasons);
    }

    static final class BuilderImpl implements Builder {
        private Long versionNumber;

        private String registrationVersionStatus;

        private RegistrationVersionStatusHistory registrationVersionStatusHistory;

        private List<RegistrationDeniedReasonInformation> deniedReasons = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RegistrationVersionInformation model) {
            versionNumber(model.versionNumber);
            registrationVersionStatus(model.registrationVersionStatus);
            registrationVersionStatusHistory(model.registrationVersionStatusHistory);
            deniedReasons(model.deniedReasons);
        }

        public final Long getVersionNumber() {
            return versionNumber;
        }

        public final void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        @Override
        public final Builder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        public final String getRegistrationVersionStatus() {
            return registrationVersionStatus;
        }

        public final void setRegistrationVersionStatus(String registrationVersionStatus) {
            this.registrationVersionStatus = registrationVersionStatus;
        }

        @Override
        public final Builder registrationVersionStatus(String registrationVersionStatus) {
            this.registrationVersionStatus = registrationVersionStatus;
            return this;
        }

        @Override
        public final Builder registrationVersionStatus(RegistrationVersionStatus registrationVersionStatus) {
            this.registrationVersionStatus(registrationVersionStatus == null ? null : registrationVersionStatus.toString());
            return this;
        }

        public final RegistrationVersionStatusHistory.Builder getRegistrationVersionStatusHistory() {
            return registrationVersionStatusHistory != null ? registrationVersionStatusHistory.toBuilder() : null;
        }

        public final void setRegistrationVersionStatusHistory(
                RegistrationVersionStatusHistory.BuilderImpl registrationVersionStatusHistory) {
            this.registrationVersionStatusHistory = registrationVersionStatusHistory != null ? registrationVersionStatusHistory
                    .build() : null;
        }

        @Override
        public final Builder registrationVersionStatusHistory(RegistrationVersionStatusHistory registrationVersionStatusHistory) {
            this.registrationVersionStatusHistory = registrationVersionStatusHistory;
            return this;
        }

        public final List<RegistrationDeniedReasonInformation.Builder> getDeniedReasons() {
            List<RegistrationDeniedReasonInformation.Builder> result = RegistrationDeniedReasonInformationListCopier
                    .copyToBuilder(this.deniedReasons);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeniedReasons(Collection<RegistrationDeniedReasonInformation.BuilderImpl> deniedReasons) {
            this.deniedReasons = RegistrationDeniedReasonInformationListCopier.copyFromBuilder(deniedReasons);
        }

        @Override
        public final Builder deniedReasons(Collection<RegistrationDeniedReasonInformation> deniedReasons) {
            this.deniedReasons = RegistrationDeniedReasonInformationListCopier.copy(deniedReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deniedReasons(RegistrationDeniedReasonInformation... deniedReasons) {
            deniedReasons(Arrays.asList(deniedReasons));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deniedReasons(Consumer<RegistrationDeniedReasonInformation.Builder>... deniedReasons) {
            deniedReasons(Stream.of(deniedReasons)
                    .map(c -> RegistrationDeniedReasonInformation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public RegistrationVersionInformation build() {
            return new RegistrationVersionInformation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
