/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The <b>RegistrationVersionStatusHistory</b> object contains the time stamps for when the reservations status changes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegistrationVersionStatusHistory implements SdkPojo, Serializable,
        ToCopyableBuilder<RegistrationVersionStatusHistory.Builder, RegistrationVersionStatusHistory> {
    private static final SdkField<Instant> DRAFT_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DraftTimestamp").getter(getter(RegistrationVersionStatusHistory::draftTimestamp))
            .setter(setter(Builder::draftTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DraftTimestamp").build()).build();

    private static final SdkField<Instant> SUBMITTED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("SubmittedTimestamp").getter(getter(RegistrationVersionStatusHistory::submittedTimestamp))
            .setter(setter(Builder::submittedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubmittedTimestamp").build())
            .build();

    private static final SdkField<Instant> REVIEWING_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ReviewingTimestamp").getter(getter(RegistrationVersionStatusHistory::reviewingTimestamp))
            .setter(setter(Builder::reviewingTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReviewingTimestamp").build())
            .build();

    private static final SdkField<Instant> REQUIRES_AUTHENTICATION_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("RequiresAuthenticationTimestamp")
            .getter(getter(RegistrationVersionStatusHistory::requiresAuthenticationTimestamp))
            .setter(setter(Builder::requiresAuthenticationTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequiresAuthenticationTimestamp")
                    .build()).build();

    private static final SdkField<Instant> APPROVED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ApprovedTimestamp").getter(getter(RegistrationVersionStatusHistory::approvedTimestamp))
            .setter(setter(Builder::approvedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovedTimestamp").build()).build();

    private static final SdkField<Instant> DISCARDED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DiscardedTimestamp").getter(getter(RegistrationVersionStatusHistory::discardedTimestamp))
            .setter(setter(Builder::discardedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiscardedTimestamp").build())
            .build();

    private static final SdkField<Instant> DENIED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DeniedTimestamp").getter(getter(RegistrationVersionStatusHistory::deniedTimestamp))
            .setter(setter(Builder::deniedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeniedTimestamp").build()).build();

    private static final SdkField<Instant> REVOKED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("RevokedTimestamp").getter(getter(RegistrationVersionStatusHistory::revokedTimestamp))
            .setter(setter(Builder::revokedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevokedTimestamp").build()).build();

    private static final SdkField<Instant> ARCHIVED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ArchivedTimestamp").getter(getter(RegistrationVersionStatusHistory::archivedTimestamp))
            .setter(setter(Builder::archivedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchivedTimestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRAFT_TIMESTAMP_FIELD,
            SUBMITTED_TIMESTAMP_FIELD, REVIEWING_TIMESTAMP_FIELD, REQUIRES_AUTHENTICATION_TIMESTAMP_FIELD,
            APPROVED_TIMESTAMP_FIELD, DISCARDED_TIMESTAMP_FIELD, DENIED_TIMESTAMP_FIELD, REVOKED_TIMESTAMP_FIELD,
            ARCHIVED_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant draftTimestamp;

    private final Instant submittedTimestamp;

    private final Instant reviewingTimestamp;

    private final Instant requiresAuthenticationTimestamp;

    private final Instant approvedTimestamp;

    private final Instant discardedTimestamp;

    private final Instant deniedTimestamp;

    private final Instant revokedTimestamp;

    private final Instant archivedTimestamp;

    private RegistrationVersionStatusHistory(BuilderImpl builder) {
        this.draftTimestamp = builder.draftTimestamp;
        this.submittedTimestamp = builder.submittedTimestamp;
        this.reviewingTimestamp = builder.reviewingTimestamp;
        this.requiresAuthenticationTimestamp = builder.requiresAuthenticationTimestamp;
        this.approvedTimestamp = builder.approvedTimestamp;
        this.discardedTimestamp = builder.discardedTimestamp;
        this.deniedTimestamp = builder.deniedTimestamp;
        this.revokedTimestamp = builder.revokedTimestamp;
        this.archivedTimestamp = builder.archivedTimestamp;
    }

    /**
     * <p>
     * The time when the registration was in the draft state, in <a href="https://www.epochconverter.com/">UNIX epoch
     * time</a> format.
     * </p>
     * 
     * @return The time when the registration was in the draft state, in <a href="https://www.epochconverter.com/">UNIX
     *         epoch time</a> format.
     */
    public final Instant draftTimestamp() {
        return draftTimestamp;
    }

    /**
     * <p>
     * The time when the registration was in the submitted state, in <a href="https://www.epochconverter.com/">UNIX
     * epoch time</a> format.
     * </p>
     * 
     * @return The time when the registration was in the submitted state, in <a
     *         href="https://www.epochconverter.com/">UNIX epoch time</a> format.
     */
    public final Instant submittedTimestamp() {
        return submittedTimestamp;
    }

    /**
     * <p>
     * The time when the registration was in the reviewing state, in <a href="https://www.epochconverter.com/">UNIX
     * epoch time</a> format.
     * </p>
     * 
     * @return The time when the registration was in the reviewing state, in <a
     *         href="https://www.epochconverter.com/">UNIX epoch time</a> format.
     */
    public final Instant reviewingTimestamp() {
        return reviewingTimestamp;
    }

    /**
     * <p>
     * The time when the registration was in the requires authentication state, in <a
     * href="https://www.epochconverter.com/">UNIX epoch time</a> format.
     * </p>
     * 
     * @return The time when the registration was in the requires authentication state, in <a
     *         href="https://www.epochconverter.com/">UNIX epoch time</a> format.
     */
    public final Instant requiresAuthenticationTimestamp() {
        return requiresAuthenticationTimestamp;
    }

    /**
     * <p>
     * The time when the registration was in the approved state, in <a href="https://www.epochconverter.com/">UNIX epoch
     * time</a> format.
     * </p>
     * 
     * @return The time when the registration was in the approved state, in <a
     *         href="https://www.epochconverter.com/">UNIX epoch time</a> format.
     */
    public final Instant approvedTimestamp() {
        return approvedTimestamp;
    }

    /**
     * <p>
     * The time when the registration was in the discarded state, in <a href="https://www.epochconverter.com/">UNIX
     * epoch time</a> format.
     * </p>
     * 
     * @return The time when the registration was in the discarded state, in <a
     *         href="https://www.epochconverter.com/">UNIX epoch time</a> format.
     */
    public final Instant discardedTimestamp() {
        return discardedTimestamp;
    }

    /**
     * <p>
     * The time when the registration was in the denied state, in <a href="https://www.epochconverter.com/">UNIX epoch
     * time</a> format.
     * </p>
     * 
     * @return The time when the registration was in the denied state, in <a href="https://www.epochconverter.com/">UNIX
     *         epoch time</a> format.
     */
    public final Instant deniedTimestamp() {
        return deniedTimestamp;
    }

    /**
     * <p>
     * The time when the registration was in the revoked state, in <a href="https://www.epochconverter.com/">UNIX epoch
     * time</a> format.
     * </p>
     * 
     * @return The time when the registration was in the revoked state, in <a
     *         href="https://www.epochconverter.com/">UNIX epoch time</a> format.
     */
    public final Instant revokedTimestamp() {
        return revokedTimestamp;
    }

    /**
     * <p>
     * The time when the registration was in the archived state, in <a href="https://www.epochconverter.com/">UNIX epoch
     * time</a> format.
     * </p>
     * 
     * @return The time when the registration was in the archived state, in <a
     *         href="https://www.epochconverter.com/">UNIX epoch time</a> format.
     */
    public final Instant archivedTimestamp() {
        return archivedTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(draftTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(submittedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(reviewingTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(requiresAuthenticationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(approvedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(discardedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(deniedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(revokedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(archivedTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegistrationVersionStatusHistory)) {
            return false;
        }
        RegistrationVersionStatusHistory other = (RegistrationVersionStatusHistory) obj;
        return Objects.equals(draftTimestamp(), other.draftTimestamp())
                && Objects.equals(submittedTimestamp(), other.submittedTimestamp())
                && Objects.equals(reviewingTimestamp(), other.reviewingTimestamp())
                && Objects.equals(requiresAuthenticationTimestamp(), other.requiresAuthenticationTimestamp())
                && Objects.equals(approvedTimestamp(), other.approvedTimestamp())
                && Objects.equals(discardedTimestamp(), other.discardedTimestamp())
                && Objects.equals(deniedTimestamp(), other.deniedTimestamp())
                && Objects.equals(revokedTimestamp(), other.revokedTimestamp())
                && Objects.equals(archivedTimestamp(), other.archivedTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegistrationVersionStatusHistory").add("DraftTimestamp", draftTimestamp())
                .add("SubmittedTimestamp", submittedTimestamp()).add("ReviewingTimestamp", reviewingTimestamp())
                .add("RequiresAuthenticationTimestamp", requiresAuthenticationTimestamp())
                .add("ApprovedTimestamp", approvedTimestamp()).add("DiscardedTimestamp", discardedTimestamp())
                .add("DeniedTimestamp", deniedTimestamp()).add("RevokedTimestamp", revokedTimestamp())
                .add("ArchivedTimestamp", archivedTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DraftTimestamp":
            return Optional.ofNullable(clazz.cast(draftTimestamp()));
        case "SubmittedTimestamp":
            return Optional.ofNullable(clazz.cast(submittedTimestamp()));
        case "ReviewingTimestamp":
            return Optional.ofNullable(clazz.cast(reviewingTimestamp()));
        case "RequiresAuthenticationTimestamp":
            return Optional.ofNullable(clazz.cast(requiresAuthenticationTimestamp()));
        case "ApprovedTimestamp":
            return Optional.ofNullable(clazz.cast(approvedTimestamp()));
        case "DiscardedTimestamp":
            return Optional.ofNullable(clazz.cast(discardedTimestamp()));
        case "DeniedTimestamp":
            return Optional.ofNullable(clazz.cast(deniedTimestamp()));
        case "RevokedTimestamp":
            return Optional.ofNullable(clazz.cast(revokedTimestamp()));
        case "ArchivedTimestamp":
            return Optional.ofNullable(clazz.cast(archivedTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DraftTimestamp", DRAFT_TIMESTAMP_FIELD);
        map.put("SubmittedTimestamp", SUBMITTED_TIMESTAMP_FIELD);
        map.put("ReviewingTimestamp", REVIEWING_TIMESTAMP_FIELD);
        map.put("RequiresAuthenticationTimestamp", REQUIRES_AUTHENTICATION_TIMESTAMP_FIELD);
        map.put("ApprovedTimestamp", APPROVED_TIMESTAMP_FIELD);
        map.put("DiscardedTimestamp", DISCARDED_TIMESTAMP_FIELD);
        map.put("DeniedTimestamp", DENIED_TIMESTAMP_FIELD);
        map.put("RevokedTimestamp", REVOKED_TIMESTAMP_FIELD);
        map.put("ArchivedTimestamp", ARCHIVED_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegistrationVersionStatusHistory, T> g) {
        return obj -> g.apply((RegistrationVersionStatusHistory) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RegistrationVersionStatusHistory> {
        /**
         * <p>
         * The time when the registration was in the draft state, in <a href="https://www.epochconverter.com/">UNIX
         * epoch time</a> format.
         * </p>
         * 
         * @param draftTimestamp
         *        The time when the registration was in the draft state, in <a
         *        href="https://www.epochconverter.com/">UNIX epoch time</a> format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder draftTimestamp(Instant draftTimestamp);

        /**
         * <p>
         * The time when the registration was in the submitted state, in <a href="https://www.epochconverter.com/">UNIX
         * epoch time</a> format.
         * </p>
         * 
         * @param submittedTimestamp
         *        The time when the registration was in the submitted state, in <a
         *        href="https://www.epochconverter.com/">UNIX epoch time</a> format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder submittedTimestamp(Instant submittedTimestamp);

        /**
         * <p>
         * The time when the registration was in the reviewing state, in <a href="https://www.epochconverter.com/">UNIX
         * epoch time</a> format.
         * </p>
         * 
         * @param reviewingTimestamp
         *        The time when the registration was in the reviewing state, in <a
         *        href="https://www.epochconverter.com/">UNIX epoch time</a> format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reviewingTimestamp(Instant reviewingTimestamp);

        /**
         * <p>
         * The time when the registration was in the requires authentication state, in <a
         * href="https://www.epochconverter.com/">UNIX epoch time</a> format.
         * </p>
         * 
         * @param requiresAuthenticationTimestamp
         *        The time when the registration was in the requires authentication state, in <a
         *        href="https://www.epochconverter.com/">UNIX epoch time</a> format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requiresAuthenticationTimestamp(Instant requiresAuthenticationTimestamp);

        /**
         * <p>
         * The time when the registration was in the approved state, in <a href="https://www.epochconverter.com/">UNIX
         * epoch time</a> format.
         * </p>
         * 
         * @param approvedTimestamp
         *        The time when the registration was in the approved state, in <a
         *        href="https://www.epochconverter.com/">UNIX epoch time</a> format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvedTimestamp(Instant approvedTimestamp);

        /**
         * <p>
         * The time when the registration was in the discarded state, in <a href="https://www.epochconverter.com/">UNIX
         * epoch time</a> format.
         * </p>
         * 
         * @param discardedTimestamp
         *        The time when the registration was in the discarded state, in <a
         *        href="https://www.epochconverter.com/">UNIX epoch time</a> format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder discardedTimestamp(Instant discardedTimestamp);

        /**
         * <p>
         * The time when the registration was in the denied state, in <a href="https://www.epochconverter.com/">UNIX
         * epoch time</a> format.
         * </p>
         * 
         * @param deniedTimestamp
         *        The time when the registration was in the denied state, in <a
         *        href="https://www.epochconverter.com/">UNIX epoch time</a> format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deniedTimestamp(Instant deniedTimestamp);

        /**
         * <p>
         * The time when the registration was in the revoked state, in <a href="https://www.epochconverter.com/">UNIX
         * epoch time</a> format.
         * </p>
         * 
         * @param revokedTimestamp
         *        The time when the registration was in the revoked state, in <a
         *        href="https://www.epochconverter.com/">UNIX epoch time</a> format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revokedTimestamp(Instant revokedTimestamp);

        /**
         * <p>
         * The time when the registration was in the archived state, in <a href="https://www.epochconverter.com/">UNIX
         * epoch time</a> format.
         * </p>
         * 
         * @param archivedTimestamp
         *        The time when the registration was in the archived state, in <a
         *        href="https://www.epochconverter.com/">UNIX epoch time</a> format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder archivedTimestamp(Instant archivedTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private Instant draftTimestamp;

        private Instant submittedTimestamp;

        private Instant reviewingTimestamp;

        private Instant requiresAuthenticationTimestamp;

        private Instant approvedTimestamp;

        private Instant discardedTimestamp;

        private Instant deniedTimestamp;

        private Instant revokedTimestamp;

        private Instant archivedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(RegistrationVersionStatusHistory model) {
            draftTimestamp(model.draftTimestamp);
            submittedTimestamp(model.submittedTimestamp);
            reviewingTimestamp(model.reviewingTimestamp);
            requiresAuthenticationTimestamp(model.requiresAuthenticationTimestamp);
            approvedTimestamp(model.approvedTimestamp);
            discardedTimestamp(model.discardedTimestamp);
            deniedTimestamp(model.deniedTimestamp);
            revokedTimestamp(model.revokedTimestamp);
            archivedTimestamp(model.archivedTimestamp);
        }

        public final Instant getDraftTimestamp() {
            return draftTimestamp;
        }

        public final void setDraftTimestamp(Instant draftTimestamp) {
            this.draftTimestamp = draftTimestamp;
        }

        @Override
        public final Builder draftTimestamp(Instant draftTimestamp) {
            this.draftTimestamp = draftTimestamp;
            return this;
        }

        public final Instant getSubmittedTimestamp() {
            return submittedTimestamp;
        }

        public final void setSubmittedTimestamp(Instant submittedTimestamp) {
            this.submittedTimestamp = submittedTimestamp;
        }

        @Override
        public final Builder submittedTimestamp(Instant submittedTimestamp) {
            this.submittedTimestamp = submittedTimestamp;
            return this;
        }

        public final Instant getReviewingTimestamp() {
            return reviewingTimestamp;
        }

        public final void setReviewingTimestamp(Instant reviewingTimestamp) {
            this.reviewingTimestamp = reviewingTimestamp;
        }

        @Override
        public final Builder reviewingTimestamp(Instant reviewingTimestamp) {
            this.reviewingTimestamp = reviewingTimestamp;
            return this;
        }

        public final Instant getRequiresAuthenticationTimestamp() {
            return requiresAuthenticationTimestamp;
        }

        public final void setRequiresAuthenticationTimestamp(Instant requiresAuthenticationTimestamp) {
            this.requiresAuthenticationTimestamp = requiresAuthenticationTimestamp;
        }

        @Override
        public final Builder requiresAuthenticationTimestamp(Instant requiresAuthenticationTimestamp) {
            this.requiresAuthenticationTimestamp = requiresAuthenticationTimestamp;
            return this;
        }

        public final Instant getApprovedTimestamp() {
            return approvedTimestamp;
        }

        public final void setApprovedTimestamp(Instant approvedTimestamp) {
            this.approvedTimestamp = approvedTimestamp;
        }

        @Override
        public final Builder approvedTimestamp(Instant approvedTimestamp) {
            this.approvedTimestamp = approvedTimestamp;
            return this;
        }

        public final Instant getDiscardedTimestamp() {
            return discardedTimestamp;
        }

        public final void setDiscardedTimestamp(Instant discardedTimestamp) {
            this.discardedTimestamp = discardedTimestamp;
        }

        @Override
        public final Builder discardedTimestamp(Instant discardedTimestamp) {
            this.discardedTimestamp = discardedTimestamp;
            return this;
        }

        public final Instant getDeniedTimestamp() {
            return deniedTimestamp;
        }

        public final void setDeniedTimestamp(Instant deniedTimestamp) {
            this.deniedTimestamp = deniedTimestamp;
        }

        @Override
        public final Builder deniedTimestamp(Instant deniedTimestamp) {
            this.deniedTimestamp = deniedTimestamp;
            return this;
        }

        public final Instant getRevokedTimestamp() {
            return revokedTimestamp;
        }

        public final void setRevokedTimestamp(Instant revokedTimestamp) {
            this.revokedTimestamp = revokedTimestamp;
        }

        @Override
        public final Builder revokedTimestamp(Instant revokedTimestamp) {
            this.revokedTimestamp = revokedTimestamp;
            return this;
        }

        public final Instant getArchivedTimestamp() {
            return archivedTimestamp;
        }

        public final void setArchivedTimestamp(Instant archivedTimestamp) {
            this.archivedTimestamp = archivedTimestamp;
        }

        @Override
        public final Builder archivedTimestamp(Instant archivedTimestamp) {
            this.archivedTimestamp = archivedTimestamp;
            return this;
        }

        @Override
        public RegistrationVersionStatusHistory build() {
            return new RegistrationVersionStatusHistory(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
