/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SendMediaMessageRequest extends PinpointSmsVoiceV2Request implements
        ToCopyableBuilder<SendMediaMessageRequest.Builder, SendMediaMessageRequest> {
    private static final SdkField<String> DESTINATION_PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationPhoneNumber").getter(getter(SendMediaMessageRequest::destinationPhoneNumber))
            .setter(setter(Builder::destinationPhoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPhoneNumber").build())
            .build();

    private static final SdkField<String> ORIGINATION_IDENTITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OriginationIdentity").getter(getter(SendMediaMessageRequest::originationIdentity))
            .setter(setter(Builder::originationIdentity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginationIdentity").build())
            .build();

    private static final SdkField<String> MESSAGE_BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MessageBody").getter(getter(SendMediaMessageRequest::messageBody)).setter(setter(Builder::messageBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageBody").build()).build();

    private static final SdkField<List<String>> MEDIA_URLS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("MediaUrls")
            .getter(getter(SendMediaMessageRequest::mediaUrls))
            .setter(setter(Builder::mediaUrls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaUrls").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CONFIGURATION_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationSetName").getter(getter(SendMediaMessageRequest::configurationSetName))
            .setter(setter(Builder::configurationSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSetName").build())
            .build();

    private static final SdkField<String> MAX_PRICE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaxPrice").getter(getter(SendMediaMessageRequest::maxPrice)).setter(setter(Builder::maxPrice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxPrice").build()).build();

    private static final SdkField<Integer> TIME_TO_LIVE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TimeToLive").getter(getter(SendMediaMessageRequest::timeToLive)).setter(setter(Builder::timeToLive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeToLive").build()).build();

    private static final SdkField<Map<String, String>> CONTEXT_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Context")
            .getter(getter(SendMediaMessageRequest::context))
            .setter(setter(Builder::context))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Context").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun").getter(getter(SendMediaMessageRequest::dryRun)).setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").build()).build();

    private static final SdkField<String> PROTECT_CONFIGURATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProtectConfigurationId").getter(getter(SendMediaMessageRequest::protectConfigurationId))
            .setter(setter(Builder::protectConfigurationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectConfigurationId").build())
            .build();

    private static final SdkField<Boolean> MESSAGE_FEEDBACK_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("MessageFeedbackEnabled").getter(getter(SendMediaMessageRequest::messageFeedbackEnabled))
            .setter(setter(Builder::messageFeedbackEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageFeedbackEnabled").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DESTINATION_PHONE_NUMBER_FIELD, ORIGINATION_IDENTITY_FIELD, MESSAGE_BODY_FIELD, MEDIA_URLS_FIELD,
            CONFIGURATION_SET_NAME_FIELD, MAX_PRICE_FIELD, TIME_TO_LIVE_FIELD, CONTEXT_FIELD, DRY_RUN_FIELD,
            PROTECT_CONFIGURATION_ID_FIELD, MESSAGE_FEEDBACK_ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String destinationPhoneNumber;

    private final String originationIdentity;

    private final String messageBody;

    private final List<String> mediaUrls;

    private final String configurationSetName;

    private final String maxPrice;

    private final Integer timeToLive;

    private final Map<String, String> context;

    private final Boolean dryRun;

    private final String protectConfigurationId;

    private final Boolean messageFeedbackEnabled;

    private SendMediaMessageRequest(BuilderImpl builder) {
        super(builder);
        this.destinationPhoneNumber = builder.destinationPhoneNumber;
        this.originationIdentity = builder.originationIdentity;
        this.messageBody = builder.messageBody;
        this.mediaUrls = builder.mediaUrls;
        this.configurationSetName = builder.configurationSetName;
        this.maxPrice = builder.maxPrice;
        this.timeToLive = builder.timeToLive;
        this.context = builder.context;
        this.dryRun = builder.dryRun;
        this.protectConfigurationId = builder.protectConfigurationId;
        this.messageFeedbackEnabled = builder.messageFeedbackEnabled;
    }

    /**
     * <p>
     * The destination phone number in E.164 format.
     * </p>
     * 
     * @return The destination phone number in E.164 format.
     */
    public final String destinationPhoneNumber() {
        return destinationPhoneNumber;
    }

    /**
     * <p>
     * The origination identity of the message. This can be either the PhoneNumber, PhoneNumberId, PhoneNumberArn,
     * SenderId, SenderIdArn, PoolId, or PoolArn.
     * </p>
     * <important>
     * <p>
     * If you are using a shared End User MessagingSMS resource then you must use the full Amazon Resource Name(ARN).
     * </p>
     * </important>
     * 
     * @return The origination identity of the message. This can be either the PhoneNumber, PhoneNumberId,
     *         PhoneNumberArn, SenderId, SenderIdArn, PoolId, or PoolArn.</p> <important>
     *         <p>
     *         If you are using a shared End User MessagingSMS resource then you must use the full Amazon Resource
     *         Name(ARN).
     *         </p>
     */
    public final String originationIdentity() {
        return originationIdentity;
    }

    /**
     * <p>
     * The text body of the message.
     * </p>
     * 
     * @return The text body of the message.
     */
    public final String messageBody() {
        return messageBody;
    }

    /**
     * For responses, this returns true if the service returned a value for the MediaUrls property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMediaUrls() {
        return mediaUrls != null && !(mediaUrls instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of URLs to each media file to send.
     * </p>
     * <p>
     * The media files have to be stored in an S3 bucket. Supported media file formats are listed in <a
     * href="https://docs.aws.amazon.com/sms-voice/latest/userguide/mms-limitations-character.html">MMS file types, size
     * and character limits</a>. For more information on creating an S3 bucket and managing objects, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/create-bucket-overview.html">Creating a bucket</a>,
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/upload-objects.html">Uploading objects</a> in the
     * <i>Amazon S3 User Guide</i>, and <a
     * href="https://docs.aws.amazon.com/sms-voice/latest/userguide/send-mms-message.html#send-mms-message-bucket"
     * >Setting up an Amazon S3 bucket for MMS files</a> in the <i>Amazon Web Services End User Messaging SMS User
     * Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMediaUrls} method.
     * </p>
     * 
     * @return An array of URLs to each media file to send. </p>
     *         <p>
     *         The media files have to be stored in an S3 bucket. Supported media file formats are listed in <a
     *         href="https://docs.aws.amazon.com/sms-voice/latest/userguide/mms-limitations-character.html">MMS file
     *         types, size and character limits</a>. For more information on creating an S3 bucket and managing objects,
     *         see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/create-bucket-overview.html">Creating
     *         a bucket</a>, <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/upload-objects.html">Uploading objects</a> in
     *         the <i>Amazon S3 User Guide</i>, and <a href=
     *         "https://docs.aws.amazon.com/sms-voice/latest/userguide/send-mms-message.html#send-mms-message-bucket"
     *         >Setting up an Amazon S3 bucket for MMS files</a> in the <i>Amazon Web Services End User Messaging SMS
     *         User Guide</i>.
     */
    public final List<String> mediaUrls() {
        return mediaUrls;
    }

    /**
     * <p>
     * The name of the configuration set to use. This can be either the ConfigurationSetName or ConfigurationSetArn.
     * </p>
     * 
     * @return The name of the configuration set to use. This can be either the ConfigurationSetName or
     *         ConfigurationSetArn.
     */
    public final String configurationSetName() {
        return configurationSetName;
    }

    /**
     * <p>
     * The maximum amount that you want to spend, in US dollars, per each MMS message.
     * </p>
     * 
     * @return The maximum amount that you want to spend, in US dollars, per each MMS message.
     */
    public final String maxPrice() {
        return maxPrice;
    }

    /**
     * <p>
     * How long the media message is valid for. By default this is 72 hours.
     * </p>
     * 
     * @return How long the media message is valid for. By default this is 72 hours.
     */
    public final Integer timeToLive() {
        return timeToLive;
    }

    /**
     * For responses, this returns true if the service returned a value for the Context property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasContext() {
        return context != null && !(context instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * You can specify custom data in this field. If you do, that data is logged to the event destination.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContext} method.
     * </p>
     * 
     * @return You can specify custom data in this field. If you do, that data is logged to the event destination.
     */
    public final Map<String, String> context() {
        return context;
    }

    /**
     * <p>
     * When set to true, the message is checked and validated, but isn't sent to the end recipient.
     * </p>
     * 
     * @return When set to true, the message is checked and validated, but isn't sent to the end recipient.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * The unique identifier of the protect configuration to use.
     * </p>
     * 
     * @return The unique identifier of the protect configuration to use.
     */
    public final String protectConfigurationId() {
        return protectConfigurationId;
    }

    /**
     * <p>
     * Set to true to enable message feedback for the message. When a user receives the message you need to update the
     * message status using <a>PutMessageFeedback</a>.
     * </p>
     * 
     * @return Set to true to enable message feedback for the message. When a user receives the message you need to
     *         update the message status using <a>PutMessageFeedback</a>.
     */
    public final Boolean messageFeedbackEnabled() {
        return messageFeedbackEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(destinationPhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(originationIdentity());
        hashCode = 31 * hashCode + Objects.hashCode(messageBody());
        hashCode = 31 * hashCode + Objects.hashCode(hasMediaUrls() ? mediaUrls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(configurationSetName());
        hashCode = 31 * hashCode + Objects.hashCode(maxPrice());
        hashCode = 31 * hashCode + Objects.hashCode(timeToLive());
        hashCode = 31 * hashCode + Objects.hashCode(hasContext() ? context() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(protectConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(messageFeedbackEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendMediaMessageRequest)) {
            return false;
        }
        SendMediaMessageRequest other = (SendMediaMessageRequest) obj;
        return Objects.equals(destinationPhoneNumber(), other.destinationPhoneNumber())
                && Objects.equals(originationIdentity(), other.originationIdentity())
                && Objects.equals(messageBody(), other.messageBody()) && hasMediaUrls() == other.hasMediaUrls()
                && Objects.equals(mediaUrls(), other.mediaUrls())
                && Objects.equals(configurationSetName(), other.configurationSetName())
                && Objects.equals(maxPrice(), other.maxPrice()) && Objects.equals(timeToLive(), other.timeToLive())
                && hasContext() == other.hasContext() && Objects.equals(context(), other.context())
                && Objects.equals(dryRun(), other.dryRun())
                && Objects.equals(protectConfigurationId(), other.protectConfigurationId())
                && Objects.equals(messageFeedbackEnabled(), other.messageFeedbackEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SendMediaMessageRequest").add("DestinationPhoneNumber", destinationPhoneNumber())
                .add("OriginationIdentity", originationIdentity()).add("MessageBody", messageBody())
                .add("MediaUrls", hasMediaUrls() ? mediaUrls() : null).add("ConfigurationSetName", configurationSetName())
                .add("MaxPrice", maxPrice()).add("TimeToLive", timeToLive()).add("Context", hasContext() ? context() : null)
                .add("DryRun", dryRun()).add("ProtectConfigurationId", protectConfigurationId())
                .add("MessageFeedbackEnabled", messageFeedbackEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationPhoneNumber":
            return Optional.ofNullable(clazz.cast(destinationPhoneNumber()));
        case "OriginationIdentity":
            return Optional.ofNullable(clazz.cast(originationIdentity()));
        case "MessageBody":
            return Optional.ofNullable(clazz.cast(messageBody()));
        case "MediaUrls":
            return Optional.ofNullable(clazz.cast(mediaUrls()));
        case "ConfigurationSetName":
            return Optional.ofNullable(clazz.cast(configurationSetName()));
        case "MaxPrice":
            return Optional.ofNullable(clazz.cast(maxPrice()));
        case "TimeToLive":
            return Optional.ofNullable(clazz.cast(timeToLive()));
        case "Context":
            return Optional.ofNullable(clazz.cast(context()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "ProtectConfigurationId":
            return Optional.ofNullable(clazz.cast(protectConfigurationId()));
        case "MessageFeedbackEnabled":
            return Optional.ofNullable(clazz.cast(messageFeedbackEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DestinationPhoneNumber", DESTINATION_PHONE_NUMBER_FIELD);
        map.put("OriginationIdentity", ORIGINATION_IDENTITY_FIELD);
        map.put("MessageBody", MESSAGE_BODY_FIELD);
        map.put("MediaUrls", MEDIA_URLS_FIELD);
        map.put("ConfigurationSetName", CONFIGURATION_SET_NAME_FIELD);
        map.put("MaxPrice", MAX_PRICE_FIELD);
        map.put("TimeToLive", TIME_TO_LIVE_FIELD);
        map.put("Context", CONTEXT_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("ProtectConfigurationId", PROTECT_CONFIGURATION_ID_FIELD);
        map.put("MessageFeedbackEnabled", MESSAGE_FEEDBACK_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SendMediaMessageRequest, T> g) {
        return obj -> g.apply((SendMediaMessageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PinpointSmsVoiceV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, SendMediaMessageRequest> {
        /**
         * <p>
         * The destination phone number in E.164 format.
         * </p>
         * 
         * @param destinationPhoneNumber
         *        The destination phone number in E.164 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPhoneNumber(String destinationPhoneNumber);

        /**
         * <p>
         * The origination identity of the message. This can be either the PhoneNumber, PhoneNumberId, PhoneNumberArn,
         * SenderId, SenderIdArn, PoolId, or PoolArn.
         * </p>
         * <important>
         * <p>
         * If you are using a shared End User MessagingSMS resource then you must use the full Amazon Resource
         * Name(ARN).
         * </p>
         * </important>
         * 
         * @param originationIdentity
         *        The origination identity of the message. This can be either the PhoneNumber, PhoneNumberId,
         *        PhoneNumberArn, SenderId, SenderIdArn, PoolId, or PoolArn.</p> <important>
         *        <p>
         *        If you are using a shared End User MessagingSMS resource then you must use the full Amazon Resource
         *        Name(ARN).
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originationIdentity(String originationIdentity);

        /**
         * <p>
         * The text body of the message.
         * </p>
         * 
         * @param messageBody
         *        The text body of the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageBody(String messageBody);

        /**
         * <p>
         * An array of URLs to each media file to send.
         * </p>
         * <p>
         * The media files have to be stored in an S3 bucket. Supported media file formats are listed in <a
         * href="https://docs.aws.amazon.com/sms-voice/latest/userguide/mms-limitations-character.html">MMS file types,
         * size and character limits</a>. For more information on creating an S3 bucket and managing objects, see <a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/create-bucket-overview.html">Creating a
         * bucket</a>, <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/upload-objects.html">Uploading
         * objects</a> in the <i>Amazon S3 User Guide</i>, and <a
         * href="https://docs.aws.amazon.com/sms-voice/latest/userguide/send-mms-message.html#send-mms-message-bucket"
         * >Setting up an Amazon S3 bucket for MMS files</a> in the <i>Amazon Web Services End User Messaging SMS User
         * Guide</i>.
         * </p>
         * 
         * @param mediaUrls
         *        An array of URLs to each media file to send. </p>
         *        <p>
         *        The media files have to be stored in an S3 bucket. Supported media file formats are listed in <a
         *        href="https://docs.aws.amazon.com/sms-voice/latest/userguide/mms-limitations-character.html">MMS file
         *        types, size and character limits</a>. For more information on creating an S3 bucket and managing
         *        objects, see <a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/create-bucket-overview.html">Creating a
         *        bucket</a>, <a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/upload-objects.html">Uploading objects</a>
         *        in the <i>Amazon S3 User Guide</i>, and <a href=
         *        "https://docs.aws.amazon.com/sms-voice/latest/userguide/send-mms-message.html#send-mms-message-bucket"
         *        >Setting up an Amazon S3 bucket for MMS files</a> in the <i>Amazon Web Services End User Messaging SMS
         *        User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaUrls(Collection<String> mediaUrls);

        /**
         * <p>
         * An array of URLs to each media file to send.
         * </p>
         * <p>
         * The media files have to be stored in an S3 bucket. Supported media file formats are listed in <a
         * href="https://docs.aws.amazon.com/sms-voice/latest/userguide/mms-limitations-character.html">MMS file types,
         * size and character limits</a>. For more information on creating an S3 bucket and managing objects, see <a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/create-bucket-overview.html">Creating a
         * bucket</a>, <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/upload-objects.html">Uploading
         * objects</a> in the <i>Amazon S3 User Guide</i>, and <a
         * href="https://docs.aws.amazon.com/sms-voice/latest/userguide/send-mms-message.html#send-mms-message-bucket"
         * >Setting up an Amazon S3 bucket for MMS files</a> in the <i>Amazon Web Services End User Messaging SMS User
         * Guide</i>.
         * </p>
         * 
         * @param mediaUrls
         *        An array of URLs to each media file to send. </p>
         *        <p>
         *        The media files have to be stored in an S3 bucket. Supported media file formats are listed in <a
         *        href="https://docs.aws.amazon.com/sms-voice/latest/userguide/mms-limitations-character.html">MMS file
         *        types, size and character limits</a>. For more information on creating an S3 bucket and managing
         *        objects, see <a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/create-bucket-overview.html">Creating a
         *        bucket</a>, <a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/upload-objects.html">Uploading objects</a>
         *        in the <i>Amazon S3 User Guide</i>, and <a href=
         *        "https://docs.aws.amazon.com/sms-voice/latest/userguide/send-mms-message.html#send-mms-message-bucket"
         *        >Setting up an Amazon S3 bucket for MMS files</a> in the <i>Amazon Web Services End User Messaging SMS
         *        User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaUrls(String... mediaUrls);

        /**
         * <p>
         * The name of the configuration set to use. This can be either the ConfigurationSetName or ConfigurationSetArn.
         * </p>
         * 
         * @param configurationSetName
         *        The name of the configuration set to use. This can be either the ConfigurationSetName or
         *        ConfigurationSetArn.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSetName(String configurationSetName);

        /**
         * <p>
         * The maximum amount that you want to spend, in US dollars, per each MMS message.
         * </p>
         * 
         * @param maxPrice
         *        The maximum amount that you want to spend, in US dollars, per each MMS message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxPrice(String maxPrice);

        /**
         * <p>
         * How long the media message is valid for. By default this is 72 hours.
         * </p>
         * 
         * @param timeToLive
         *        How long the media message is valid for. By default this is 72 hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeToLive(Integer timeToLive);

        /**
         * <p>
         * You can specify custom data in this field. If you do, that data is logged to the event destination.
         * </p>
         * 
         * @param context
         *        You can specify custom data in this field. If you do, that data is logged to the event destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder context(Map<String, String> context);

        /**
         * <p>
         * When set to true, the message is checked and validated, but isn't sent to the end recipient.
         * </p>
         * 
         * @param dryRun
         *        When set to true, the message is checked and validated, but isn't sent to the end recipient.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The unique identifier of the protect configuration to use.
         * </p>
         * 
         * @param protectConfigurationId
         *        The unique identifier of the protect configuration to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectConfigurationId(String protectConfigurationId);

        /**
         * <p>
         * Set to true to enable message feedback for the message. When a user receives the message you need to update
         * the message status using <a>PutMessageFeedback</a>.
         * </p>
         * 
         * @param messageFeedbackEnabled
         *        Set to true to enable message feedback for the message. When a user receives the message you need to
         *        update the message status using <a>PutMessageFeedback</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageFeedbackEnabled(Boolean messageFeedbackEnabled);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Request.BuilderImpl implements Builder {
        private String destinationPhoneNumber;

        private String originationIdentity;

        private String messageBody;

        private List<String> mediaUrls = DefaultSdkAutoConstructList.getInstance();

        private String configurationSetName;

        private String maxPrice;

        private Integer timeToLive;

        private Map<String, String> context = DefaultSdkAutoConstructMap.getInstance();

        private Boolean dryRun;

        private String protectConfigurationId;

        private Boolean messageFeedbackEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(SendMediaMessageRequest model) {
            super(model);
            destinationPhoneNumber(model.destinationPhoneNumber);
            originationIdentity(model.originationIdentity);
            messageBody(model.messageBody);
            mediaUrls(model.mediaUrls);
            configurationSetName(model.configurationSetName);
            maxPrice(model.maxPrice);
            timeToLive(model.timeToLive);
            context(model.context);
            dryRun(model.dryRun);
            protectConfigurationId(model.protectConfigurationId);
            messageFeedbackEnabled(model.messageFeedbackEnabled);
        }

        public final String getDestinationPhoneNumber() {
            return destinationPhoneNumber;
        }

        public final void setDestinationPhoneNumber(String destinationPhoneNumber) {
            this.destinationPhoneNumber = destinationPhoneNumber;
        }

        @Override
        public final Builder destinationPhoneNumber(String destinationPhoneNumber) {
            this.destinationPhoneNumber = destinationPhoneNumber;
            return this;
        }

        public final String getOriginationIdentity() {
            return originationIdentity;
        }

        public final void setOriginationIdentity(String originationIdentity) {
            this.originationIdentity = originationIdentity;
        }

        @Override
        public final Builder originationIdentity(String originationIdentity) {
            this.originationIdentity = originationIdentity;
            return this;
        }

        public final String getMessageBody() {
            return messageBody;
        }

        public final void setMessageBody(String messageBody) {
            this.messageBody = messageBody;
        }

        @Override
        public final Builder messageBody(String messageBody) {
            this.messageBody = messageBody;
            return this;
        }

        public final Collection<String> getMediaUrls() {
            if (mediaUrls instanceof SdkAutoConstructList) {
                return null;
            }
            return mediaUrls;
        }

        public final void setMediaUrls(Collection<String> mediaUrls) {
            this.mediaUrls = MediaUrlListCopier.copy(mediaUrls);
        }

        @Override
        public final Builder mediaUrls(Collection<String> mediaUrls) {
            this.mediaUrls = MediaUrlListCopier.copy(mediaUrls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaUrls(String... mediaUrls) {
            mediaUrls(Arrays.asList(mediaUrls));
            return this;
        }

        public final String getConfigurationSetName() {
            return configurationSetName;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final String getMaxPrice() {
            return maxPrice;
        }

        public final void setMaxPrice(String maxPrice) {
            this.maxPrice = maxPrice;
        }

        @Override
        public final Builder maxPrice(String maxPrice) {
            this.maxPrice = maxPrice;
            return this;
        }

        public final Integer getTimeToLive() {
            return timeToLive;
        }

        public final void setTimeToLive(Integer timeToLive) {
            this.timeToLive = timeToLive;
        }

        @Override
        public final Builder timeToLive(Integer timeToLive) {
            this.timeToLive = timeToLive;
            return this;
        }

        public final Map<String, String> getContext() {
            if (context instanceof SdkAutoConstructMap) {
                return null;
            }
            return context;
        }

        public final void setContext(Map<String, String> context) {
            this.context = ContextMapCopier.copy(context);
        }

        @Override
        public final Builder context(Map<String, String> context) {
            this.context = ContextMapCopier.copy(context);
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getProtectConfigurationId() {
            return protectConfigurationId;
        }

        public final void setProtectConfigurationId(String protectConfigurationId) {
            this.protectConfigurationId = protectConfigurationId;
        }

        @Override
        public final Builder protectConfigurationId(String protectConfigurationId) {
            this.protectConfigurationId = protectConfigurationId;
            return this;
        }

        public final Boolean getMessageFeedbackEnabled() {
            return messageFeedbackEnabled;
        }

        public final void setMessageFeedbackEnabled(Boolean messageFeedbackEnabled) {
            this.messageFeedbackEnabled = messageFeedbackEnabled;
        }

        @Override
        public final Builder messageFeedbackEnabled(Boolean messageFeedbackEnabled) {
            this.messageFeedbackEnabled = messageFeedbackEnabled;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendMediaMessageRequest build() {
            return new SendMediaMessageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
