/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SetDefaultMessageFeedbackEnabledRequest extends PinpointSmsVoiceV2Request implements
        ToCopyableBuilder<SetDefaultMessageFeedbackEnabledRequest.Builder, SetDefaultMessageFeedbackEnabledRequest> {
    private static final SdkField<String> CONFIGURATION_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationSetName").getter(getter(SetDefaultMessageFeedbackEnabledRequest::configurationSetName))
            .setter(setter(Builder::configurationSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSetName").build())
            .build();

    private static final SdkField<Boolean> MESSAGE_FEEDBACK_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("MessageFeedbackEnabled").getter(getter(SetDefaultMessageFeedbackEnabledRequest::messageFeedbackEnabled))
            .setter(setter(Builder::messageFeedbackEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageFeedbackEnabled").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_SET_NAME_FIELD,
            MESSAGE_FEEDBACK_ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String configurationSetName;

    private final Boolean messageFeedbackEnabled;

    private SetDefaultMessageFeedbackEnabledRequest(BuilderImpl builder) {
        super(builder);
        this.configurationSetName = builder.configurationSetName;
        this.messageFeedbackEnabled = builder.messageFeedbackEnabled;
    }

    /**
     * <p>
     * The name of the configuration set to use. This can be either the ConfigurationSetName or ConfigurationSetArn.
     * </p>
     * 
     * @return The name of the configuration set to use. This can be either the ConfigurationSetName or
     *         ConfigurationSetArn.
     */
    public final String configurationSetName() {
        return configurationSetName;
    }

    /**
     * <p>
     * Set to true to enable message feedback.
     * </p>
     * 
     * @return Set to true to enable message feedback.
     */
    public final Boolean messageFeedbackEnabled() {
        return messageFeedbackEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configurationSetName());
        hashCode = 31 * hashCode + Objects.hashCode(messageFeedbackEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetDefaultMessageFeedbackEnabledRequest)) {
            return false;
        }
        SetDefaultMessageFeedbackEnabledRequest other = (SetDefaultMessageFeedbackEnabledRequest) obj;
        return Objects.equals(configurationSetName(), other.configurationSetName())
                && Objects.equals(messageFeedbackEnabled(), other.messageFeedbackEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SetDefaultMessageFeedbackEnabledRequest").add("ConfigurationSetName", configurationSetName())
                .add("MessageFeedbackEnabled", messageFeedbackEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationSetName":
            return Optional.ofNullable(clazz.cast(configurationSetName()));
        case "MessageFeedbackEnabled":
            return Optional.ofNullable(clazz.cast(messageFeedbackEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConfigurationSetName", CONFIGURATION_SET_NAME_FIELD);
        map.put("MessageFeedbackEnabled", MESSAGE_FEEDBACK_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SetDefaultMessageFeedbackEnabledRequest, T> g) {
        return obj -> g.apply((SetDefaultMessageFeedbackEnabledRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PinpointSmsVoiceV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, SetDefaultMessageFeedbackEnabledRequest> {
        /**
         * <p>
         * The name of the configuration set to use. This can be either the ConfigurationSetName or ConfigurationSetArn.
         * </p>
         * 
         * @param configurationSetName
         *        The name of the configuration set to use. This can be either the ConfigurationSetName or
         *        ConfigurationSetArn.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSetName(String configurationSetName);

        /**
         * <p>
         * Set to true to enable message feedback.
         * </p>
         * 
         * @param messageFeedbackEnabled
         *        Set to true to enable message feedback.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageFeedbackEnabled(Boolean messageFeedbackEnabled);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Request.BuilderImpl implements Builder {
        private String configurationSetName;

        private Boolean messageFeedbackEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(SetDefaultMessageFeedbackEnabledRequest model) {
            super(model);
            configurationSetName(model.configurationSetName);
            messageFeedbackEnabled(model.messageFeedbackEnabled);
        }

        public final String getConfigurationSetName() {
            return configurationSetName;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final Boolean getMessageFeedbackEnabled() {
            return messageFeedbackEnabled;
        }

        public final void setMessageFeedbackEnabled(Boolean messageFeedbackEnabled) {
            this.messageFeedbackEnabled = messageFeedbackEnabled;
        }

        @Override
        public final Builder messageFeedbackEnabled(Boolean messageFeedbackEnabled) {
            this.messageFeedbackEnabled = messageFeedbackEnabled;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetDefaultMessageFeedbackEnabledRequest build() {
            return new SetDefaultMessageFeedbackEnabledRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
