/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SetMediaMessageSpendLimitOverrideResponse extends PinpointSmsVoiceV2Response implements
        ToCopyableBuilder<SetMediaMessageSpendLimitOverrideResponse.Builder, SetMediaMessageSpendLimitOverrideResponse> {
    private static final SdkField<Long> MONTHLY_LIMIT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("MonthlyLimit").getter(getter(SetMediaMessageSpendLimitOverrideResponse::monthlyLimit))
            .setter(setter(Builder::monthlyLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonthlyLimit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONTHLY_LIMIT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Long monthlyLimit;

    private SetMediaMessageSpendLimitOverrideResponse(BuilderImpl builder) {
        super(builder);
        this.monthlyLimit = builder.monthlyLimit;
    }

    /**
     * <p>
     * The current monthly limit to enforce on sending text messages.
     * </p>
     * 
     * @return The current monthly limit to enforce on sending text messages.
     */
    public final Long monthlyLimit() {
        return monthlyLimit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(monthlyLimit());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetMediaMessageSpendLimitOverrideResponse)) {
            return false;
        }
        SetMediaMessageSpendLimitOverrideResponse other = (SetMediaMessageSpendLimitOverrideResponse) obj;
        return Objects.equals(monthlyLimit(), other.monthlyLimit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SetMediaMessageSpendLimitOverrideResponse").add("MonthlyLimit", monthlyLimit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MonthlyLimit":
            return Optional.ofNullable(clazz.cast(monthlyLimit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MonthlyLimit", MONTHLY_LIMIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SetMediaMessageSpendLimitOverrideResponse, T> g) {
        return obj -> g.apply((SetMediaMessageSpendLimitOverrideResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PinpointSmsVoiceV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, SetMediaMessageSpendLimitOverrideResponse> {
        /**
         * <p>
         * The current monthly limit to enforce on sending text messages.
         * </p>
         * 
         * @param monthlyLimit
         *        The current monthly limit to enforce on sending text messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monthlyLimit(Long monthlyLimit);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Response.BuilderImpl implements Builder {
        private Long monthlyLimit;

        private BuilderImpl() {
        }

        private BuilderImpl(SetMediaMessageSpendLimitOverrideResponse model) {
            super(model);
            monthlyLimit(model.monthlyLimit);
        }

        public final Long getMonthlyLimit() {
            return monthlyLimit;
        }

        public final void setMonthlyLimit(Long monthlyLimit) {
            this.monthlyLimit = monthlyLimit;
        }

        @Override
        public final Builder monthlyLimit(Long monthlyLimit) {
            this.monthlyLimit = monthlyLimit;
            return this;
        }

        @Override
        public SetMediaMessageSpendLimitOverrideResponse build() {
            return new SetMediaMessageSpendLimitOverrideResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
