/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the requested verified destintion phone number.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VerifiedDestinationNumberInformation implements SdkPojo, Serializable,
        ToCopyableBuilder<VerifiedDestinationNumberInformation.Builder, VerifiedDestinationNumberInformation> {
    private static final SdkField<String> VERIFIED_DESTINATION_NUMBER_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VerifiedDestinationNumberArn")
            .getter(getter(VerifiedDestinationNumberInformation::verifiedDestinationNumberArn))
            .setter(setter(Builder::verifiedDestinationNumberArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedDestinationNumberArn")
                    .build()).build();

    private static final SdkField<String> VERIFIED_DESTINATION_NUMBER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VerifiedDestinationNumberId")
            .getter(getter(VerifiedDestinationNumberInformation::verifiedDestinationNumberId))
            .setter(setter(Builder::verifiedDestinationNumberId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedDestinationNumberId")
                    .build()).build();

    private static final SdkField<String> DESTINATION_PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationPhoneNumber").getter(getter(VerifiedDestinationNumberInformation::destinationPhoneNumber))
            .setter(setter(Builder::destinationPhoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPhoneNumber").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(VerifiedDestinationNumberInformation::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp").getter(getter(VerifiedDestinationNumberInformation::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            VERIFIED_DESTINATION_NUMBER_ARN_FIELD, VERIFIED_DESTINATION_NUMBER_ID_FIELD, DESTINATION_PHONE_NUMBER_FIELD,
            STATUS_FIELD, CREATED_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String verifiedDestinationNumberArn;

    private final String verifiedDestinationNumberId;

    private final String destinationPhoneNumber;

    private final String status;

    private final Instant createdTimestamp;

    private VerifiedDestinationNumberInformation(BuilderImpl builder) {
        this.verifiedDestinationNumberArn = builder.verifiedDestinationNumberArn;
        this.verifiedDestinationNumberId = builder.verifiedDestinationNumberId;
        this.destinationPhoneNumber = builder.destinationPhoneNumber;
        this.status = builder.status;
        this.createdTimestamp = builder.createdTimestamp;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the verified destination phone number.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the verified destination phone number.
     */
    public final String verifiedDestinationNumberArn() {
        return verifiedDestinationNumberArn;
    }

    /**
     * <p>
     * The unique identifier for the verified destination phone number.
     * </p>
     * 
     * @return The unique identifier for the verified destination phone number.
     */
    public final String verifiedDestinationNumberId() {
        return verifiedDestinationNumberId;
    }

    /**
     * <p>
     * The verified destination phone number, in E.164 format.
     * </p>
     * 
     * @return The verified destination phone number, in E.164 format.
     */
    public final String destinationPhoneNumber() {
        return destinationPhoneNumber;
    }

    /**
     * <p>
     * The status of the verified destination phone number.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code>: The phone number hasn't been verified yet.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VERIFIED</code>: The phone number is verified and can receive messages.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link VerificationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the verified destination phone number.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PENDING</code>: The phone number hasn't been verified yet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VERIFIED</code>: The phone number is verified and can receive messages.
     *         </p>
     *         </li>
     * @see VerificationStatus
     */
    public final VerificationStatus status() {
        return VerificationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the verified destination phone number.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code>: The phone number hasn't been verified yet.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VERIFIED</code>: The phone number is verified and can receive messages.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link VerificationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the verified destination phone number.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PENDING</code>: The phone number hasn't been verified yet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VERIFIED</code>: The phone number is verified and can receive messages.
     *         </p>
     *         </li>
     * @see VerificationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The time when the destination phone number was created, in <a href="https://www.epochconverter.com/">UNIX epoch
     * time</a> format.
     * </p>
     * 
     * @return The time when the destination phone number was created, in <a href="https://www.epochconverter.com/">UNIX
     *         epoch time</a> format.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(verifiedDestinationNumberArn());
        hashCode = 31 * hashCode + Objects.hashCode(verifiedDestinationNumberId());
        hashCode = 31 * hashCode + Objects.hashCode(destinationPhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifiedDestinationNumberInformation)) {
            return false;
        }
        VerifiedDestinationNumberInformation other = (VerifiedDestinationNumberInformation) obj;
        return Objects.equals(verifiedDestinationNumberArn(), other.verifiedDestinationNumberArn())
                && Objects.equals(verifiedDestinationNumberId(), other.verifiedDestinationNumberId())
                && Objects.equals(destinationPhoneNumber(), other.destinationPhoneNumber())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(createdTimestamp(), other.createdTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VerifiedDestinationNumberInformation")
                .add("VerifiedDestinationNumberArn", verifiedDestinationNumberArn())
                .add("VerifiedDestinationNumberId", verifiedDestinationNumberId())
                .add("DestinationPhoneNumber", destinationPhoneNumber()).add("Status", statusAsString())
                .add("CreatedTimestamp", createdTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VerifiedDestinationNumberArn":
            return Optional.ofNullable(clazz.cast(verifiedDestinationNumberArn()));
        case "VerifiedDestinationNumberId":
            return Optional.ofNullable(clazz.cast(verifiedDestinationNumberId()));
        case "DestinationPhoneNumber":
            return Optional.ofNullable(clazz.cast(destinationPhoneNumber()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VerifiedDestinationNumberArn", VERIFIED_DESTINATION_NUMBER_ARN_FIELD);
        map.put("VerifiedDestinationNumberId", VERIFIED_DESTINATION_NUMBER_ID_FIELD);
        map.put("DestinationPhoneNumber", DESTINATION_PHONE_NUMBER_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VerifiedDestinationNumberInformation, T> g) {
        return obj -> g.apply((VerifiedDestinationNumberInformation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VerifiedDestinationNumberInformation> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the verified destination phone number.
         * </p>
         * 
         * @param verifiedDestinationNumberArn
         *        The Amazon Resource Name (ARN) for the verified destination phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verifiedDestinationNumberArn(String verifiedDestinationNumberArn);

        /**
         * <p>
         * The unique identifier for the verified destination phone number.
         * </p>
         * 
         * @param verifiedDestinationNumberId
         *        The unique identifier for the verified destination phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verifiedDestinationNumberId(String verifiedDestinationNumberId);

        /**
         * <p>
         * The verified destination phone number, in E.164 format.
         * </p>
         * 
         * @param destinationPhoneNumber
         *        The verified destination phone number, in E.164 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPhoneNumber(String destinationPhoneNumber);

        /**
         * <p>
         * The status of the verified destination phone number.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PENDING</code>: The phone number hasn't been verified yet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VERIFIED</code>: The phone number is verified and can receive messages.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the verified destination phone number.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PENDING</code>: The phone number hasn't been verified yet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VERIFIED</code>: The phone number is verified and can receive messages.
         *        </p>
         *        </li>
         * @see VerificationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VerificationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the verified destination phone number.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PENDING</code>: The phone number hasn't been verified yet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VERIFIED</code>: The phone number is verified and can receive messages.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the verified destination phone number.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PENDING</code>: The phone number hasn't been verified yet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VERIFIED</code>: The phone number is verified and can receive messages.
         *        </p>
         *        </li>
         * @see VerificationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VerificationStatus
         */
        Builder status(VerificationStatus status);

        /**
         * <p>
         * The time when the destination phone number was created, in <a href="https://www.epochconverter.com/">UNIX
         * epoch time</a> format.
         * </p>
         * 
         * @param createdTimestamp
         *        The time when the destination phone number was created, in <a
         *        href="https://www.epochconverter.com/">UNIX epoch time</a> format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String verifiedDestinationNumberArn;

        private String verifiedDestinationNumberId;

        private String destinationPhoneNumber;

        private String status;

        private Instant createdTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(VerifiedDestinationNumberInformation model) {
            verifiedDestinationNumberArn(model.verifiedDestinationNumberArn);
            verifiedDestinationNumberId(model.verifiedDestinationNumberId);
            destinationPhoneNumber(model.destinationPhoneNumber);
            status(model.status);
            createdTimestamp(model.createdTimestamp);
        }

        public final String getVerifiedDestinationNumberArn() {
            return verifiedDestinationNumberArn;
        }

        public final void setVerifiedDestinationNumberArn(String verifiedDestinationNumberArn) {
            this.verifiedDestinationNumberArn = verifiedDestinationNumberArn;
        }

        @Override
        public final Builder verifiedDestinationNumberArn(String verifiedDestinationNumberArn) {
            this.verifiedDestinationNumberArn = verifiedDestinationNumberArn;
            return this;
        }

        public final String getVerifiedDestinationNumberId() {
            return verifiedDestinationNumberId;
        }

        public final void setVerifiedDestinationNumberId(String verifiedDestinationNumberId) {
            this.verifiedDestinationNumberId = verifiedDestinationNumberId;
        }

        @Override
        public final Builder verifiedDestinationNumberId(String verifiedDestinationNumberId) {
            this.verifiedDestinationNumberId = verifiedDestinationNumberId;
            return this;
        }

        public final String getDestinationPhoneNumber() {
            return destinationPhoneNumber;
        }

        public final void setDestinationPhoneNumber(String destinationPhoneNumber) {
            this.destinationPhoneNumber = destinationPhoneNumber;
        }

        @Override
        public final Builder destinationPhoneNumber(String destinationPhoneNumber) {
            this.destinationPhoneNumber = destinationPhoneNumber;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(VerificationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        @Override
        public VerifiedDestinationNumberInformation build() {
            return new VerifiedDestinationNumberInformation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
