/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateProtectConfigurationResponse extends PinpointSmsVoiceV2Response implements
        ToCopyableBuilder<AssociateProtectConfigurationResponse.Builder, AssociateProtectConfigurationResponse> {
    private static final SdkField<String> CONFIGURATION_SET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationSetArn").getter(getter(AssociateProtectConfigurationResponse::configurationSetArn))
            .setter(setter(Builder::configurationSetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSetArn").build())
            .build();

    private static final SdkField<String> CONFIGURATION_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationSetName").getter(getter(AssociateProtectConfigurationResponse::configurationSetName))
            .setter(setter(Builder::configurationSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSetName").build())
            .build();

    private static final SdkField<String> PROTECT_CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProtectConfigurationArn").getter(getter(AssociateProtectConfigurationResponse::protectConfigurationArn))
            .setter(setter(Builder::protectConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectConfigurationArn").build())
            .build();

    private static final SdkField<String> PROTECT_CONFIGURATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProtectConfigurationId").getter(getter(AssociateProtectConfigurationResponse::protectConfigurationId))
            .setter(setter(Builder::protectConfigurationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectConfigurationId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_SET_ARN_FIELD,
            CONFIGURATION_SET_NAME_FIELD, PROTECT_CONFIGURATION_ARN_FIELD, PROTECT_CONFIGURATION_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String configurationSetArn;

    private final String configurationSetName;

    private final String protectConfigurationArn;

    private final String protectConfigurationId;

    private AssociateProtectConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.configurationSetArn = builder.configurationSetArn;
        this.configurationSetName = builder.configurationSetName;
        this.protectConfigurationArn = builder.protectConfigurationArn;
        this.protectConfigurationId = builder.protectConfigurationId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the configuration set.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the configuration set.
     */
    public final String configurationSetArn() {
        return configurationSetArn;
    }

    /**
     * <p>
     * The name of the ConfigurationSet.
     * </p>
     * 
     * @return The name of the ConfigurationSet.
     */
    public final String configurationSetName() {
        return configurationSetName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the protect configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the protect configuration.
     */
    public final String protectConfigurationArn() {
        return protectConfigurationArn;
    }

    /**
     * <p>
     * The unique identifier for the protect configuration.
     * </p>
     * 
     * @return The unique identifier for the protect configuration.
     */
    public final String protectConfigurationId() {
        return protectConfigurationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configurationSetArn());
        hashCode = 31 * hashCode + Objects.hashCode(configurationSetName());
        hashCode = 31 * hashCode + Objects.hashCode(protectConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(protectConfigurationId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateProtectConfigurationResponse)) {
            return false;
        }
        AssociateProtectConfigurationResponse other = (AssociateProtectConfigurationResponse) obj;
        return Objects.equals(configurationSetArn(), other.configurationSetArn())
                && Objects.equals(configurationSetName(), other.configurationSetName())
                && Objects.equals(protectConfigurationArn(), other.protectConfigurationArn())
                && Objects.equals(protectConfigurationId(), other.protectConfigurationId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateProtectConfigurationResponse").add("ConfigurationSetArn", configurationSetArn())
                .add("ConfigurationSetName", configurationSetName()).add("ProtectConfigurationArn", protectConfigurationArn())
                .add("ProtectConfigurationId", protectConfigurationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationSetArn":
            return Optional.ofNullable(clazz.cast(configurationSetArn()));
        case "ConfigurationSetName":
            return Optional.ofNullable(clazz.cast(configurationSetName()));
        case "ProtectConfigurationArn":
            return Optional.ofNullable(clazz.cast(protectConfigurationArn()));
        case "ProtectConfigurationId":
            return Optional.ofNullable(clazz.cast(protectConfigurationId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConfigurationSetArn", CONFIGURATION_SET_ARN_FIELD);
        map.put("ConfigurationSetName", CONFIGURATION_SET_NAME_FIELD);
        map.put("ProtectConfigurationArn", PROTECT_CONFIGURATION_ARN_FIELD);
        map.put("ProtectConfigurationId", PROTECT_CONFIGURATION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateProtectConfigurationResponse, T> g) {
        return obj -> g.apply((AssociateProtectConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PinpointSmsVoiceV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateProtectConfigurationResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the configuration set.
         * </p>
         * 
         * @param configurationSetArn
         *        The Amazon Resource Name (ARN) of the configuration set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSetArn(String configurationSetArn);

        /**
         * <p>
         * The name of the ConfigurationSet.
         * </p>
         * 
         * @param configurationSetName
         *        The name of the ConfigurationSet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSetName(String configurationSetName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the protect configuration.
         * </p>
         * 
         * @param protectConfigurationArn
         *        The Amazon Resource Name (ARN) of the protect configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectConfigurationArn(String protectConfigurationArn);

        /**
         * <p>
         * The unique identifier for the protect configuration.
         * </p>
         * 
         * @param protectConfigurationId
         *        The unique identifier for the protect configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectConfigurationId(String protectConfigurationId);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Response.BuilderImpl implements Builder {
        private String configurationSetArn;

        private String configurationSetName;

        private String protectConfigurationArn;

        private String protectConfigurationId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateProtectConfigurationResponse model) {
            super(model);
            configurationSetArn(model.configurationSetArn);
            configurationSetName(model.configurationSetName);
            protectConfigurationArn(model.protectConfigurationArn);
            protectConfigurationId(model.protectConfigurationId);
        }

        public final String getConfigurationSetArn() {
            return configurationSetArn;
        }

        public final void setConfigurationSetArn(String configurationSetArn) {
            this.configurationSetArn = configurationSetArn;
        }

        @Override
        public final Builder configurationSetArn(String configurationSetArn) {
            this.configurationSetArn = configurationSetArn;
            return this;
        }

        public final String getConfigurationSetName() {
            return configurationSetName;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final String getProtectConfigurationArn() {
            return protectConfigurationArn;
        }

        public final void setProtectConfigurationArn(String protectConfigurationArn) {
            this.protectConfigurationArn = protectConfigurationArn;
        }

        @Override
        public final Builder protectConfigurationArn(String protectConfigurationArn) {
            this.protectConfigurationArn = protectConfigurationArn;
            return this;
        }

        public final String getProtectConfigurationId() {
            return protectConfigurationId;
        }

        public final void setProtectConfigurationId(String protectConfigurationId) {
            this.protectConfigurationId = protectConfigurationId;
        }

        @Override
        public final Builder protectConfigurationId(String protectConfigurationId) {
            this.protectConfigurationId = protectConfigurationId;
            return this;
        }

        @Override
        public AssociateProtectConfigurationResponse build() {
            return new AssociateProtectConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
