/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRegistrationResponse extends PinpointSmsVoiceV2Response implements
        ToCopyableBuilder<CreateRegistrationResponse.Builder, CreateRegistrationResponse> {
    private static final SdkField<String> REGISTRATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegistrationArn").getter(getter(CreateRegistrationResponse::registrationArn))
            .setter(setter(Builder::registrationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationArn").build()).build();

    private static final SdkField<String> REGISTRATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegistrationId").getter(getter(CreateRegistrationResponse::registrationId))
            .setter(setter(Builder::registrationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationId").build()).build();

    private static final SdkField<String> REGISTRATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegistrationType").getter(getter(CreateRegistrationResponse::registrationType))
            .setter(setter(Builder::registrationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationType").build()).build();

    private static final SdkField<String> REGISTRATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegistrationStatus").getter(getter(CreateRegistrationResponse::registrationStatusAsString))
            .setter(setter(Builder::registrationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationStatus").build())
            .build();

    private static final SdkField<Long> CURRENT_VERSION_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("CurrentVersionNumber").getter(getter(CreateRegistrationResponse::currentVersionNumber))
            .setter(setter(Builder::currentVersionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentVersionNumber").build())
            .build();

    private static final SdkField<Map<String, String>> ADDITIONAL_ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("AdditionalAttributes")
            .getter(getter(CreateRegistrationResponse::additionalAttributes))
            .setter(setter(Builder::additionalAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalAttributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateRegistrationResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp").getter(getter(CreateRegistrationResponse::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRATION_ARN_FIELD,
            REGISTRATION_ID_FIELD, REGISTRATION_TYPE_FIELD, REGISTRATION_STATUS_FIELD, CURRENT_VERSION_NUMBER_FIELD,
            ADDITIONAL_ATTRIBUTES_FIELD, TAGS_FIELD, CREATED_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String registrationArn;

    private final String registrationId;

    private final String registrationType;

    private final String registrationStatus;

    private final Long currentVersionNumber;

    private final Map<String, String> additionalAttributes;

    private final List<Tag> tags;

    private final Instant createdTimestamp;

    private CreateRegistrationResponse(BuilderImpl builder) {
        super(builder);
        this.registrationArn = builder.registrationArn;
        this.registrationId = builder.registrationId;
        this.registrationType = builder.registrationType;
        this.registrationStatus = builder.registrationStatus;
        this.currentVersionNumber = builder.currentVersionNumber;
        this.additionalAttributes = builder.additionalAttributes;
        this.tags = builder.tags;
        this.createdTimestamp = builder.createdTimestamp;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the registration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the registration.
     */
    public final String registrationArn() {
        return registrationArn;
    }

    /**
     * <p>
     * The unique identifier for the registration.
     * </p>
     * 
     * @return The unique identifier for the registration.
     */
    public final String registrationId() {
        return registrationId;
    }

    /**
     * <p>
     * The type of registration form to create. The list of <b>RegistrationTypes</b> can be found using the
     * <a>DescribeRegistrationTypeDefinitions</a> action.
     * </p>
     * 
     * @return The type of registration form to create. The list of <b>RegistrationTypes</b> can be found using the
     *         <a>DescribeRegistrationTypeDefinitions</a> action.
     */
    public final String registrationType() {
        return registrationType;
    }

    /**
     * <p>
     * The status of the registration.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CLOSED</code>: The phone number or sender ID has been deleted and you must also delete the registration for
     * the number.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATED</code>: Your registration is created but not submitted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETE</code>: Your registration has been approved and your origination identity has been created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETED</code>: The registration has been deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PROVISIONING</code>: Your registration has been approved and your origination identity is being created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REQUIRES_AUTHENTICATION</code>: You need to complete email authentication.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REQUIRES_UPDATES</code>: You must fix your registration and resubmit it.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REVIEWING</code>: Your registration has been accepted and is being reviewed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUBMITTED</code>: Your registration has been submitted and is awaiting review.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #registrationStatus} will return {@link RegistrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #registrationStatusAsString}.
     * </p>
     * 
     * @return The status of the registration.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CLOSED</code>: The phone number or sender ID has been deleted and you must also delete the
     *         registration for the number.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATED</code>: Your registration is created but not submitted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMPLETE</code>: Your registration has been approved and your origination identity has been
     *         created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETED</code>: The registration has been deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PROVISIONING</code>: Your registration has been approved and your origination identity is being
     *         created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REQUIRES_AUTHENTICATION</code>: You need to complete email authentication.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REQUIRES_UPDATES</code>: You must fix your registration and resubmit it.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REVIEWING</code>: Your registration has been accepted and is being reviewed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUBMITTED</code>: Your registration has been submitted and is awaiting review.
     *         </p>
     *         </li>
     * @see RegistrationStatus
     */
    public final RegistrationStatus registrationStatus() {
        return RegistrationStatus.fromValue(registrationStatus);
    }

    /**
     * <p>
     * The status of the registration.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CLOSED</code>: The phone number or sender ID has been deleted and you must also delete the registration for
     * the number.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATED</code>: Your registration is created but not submitted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETE</code>: Your registration has been approved and your origination identity has been created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETED</code>: The registration has been deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PROVISIONING</code>: Your registration has been approved and your origination identity is being created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REQUIRES_AUTHENTICATION</code>: You need to complete email authentication.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REQUIRES_UPDATES</code>: You must fix your registration and resubmit it.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REVIEWING</code>: Your registration has been accepted and is being reviewed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUBMITTED</code>: Your registration has been submitted and is awaiting review.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #registrationStatus} will return {@link RegistrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #registrationStatusAsString}.
     * </p>
     * 
     * @return The status of the registration.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CLOSED</code>: The phone number or sender ID has been deleted and you must also delete the
     *         registration for the number.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATED</code>: Your registration is created but not submitted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMPLETE</code>: Your registration has been approved and your origination identity has been
     *         created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETED</code>: The registration has been deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PROVISIONING</code>: Your registration has been approved and your origination identity is being
     *         created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REQUIRES_AUTHENTICATION</code>: You need to complete email authentication.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REQUIRES_UPDATES</code>: You must fix your registration and resubmit it.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REVIEWING</code>: Your registration has been accepted and is being reviewed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUBMITTED</code>: Your registration has been submitted and is awaiting review.
     *         </p>
     *         </li>
     * @see RegistrationStatus
     */
    public final String registrationStatusAsString() {
        return registrationStatus;
    }

    /**
     * <p>
     * The current version number of the registration.
     * </p>
     * 
     * @return The current version number of the registration.
     */
    public final Long currentVersionNumber() {
        return currentVersionNumber;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalAttributes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAdditionalAttributes() {
        return additionalAttributes != null && !(additionalAttributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Metadata about a given registration which is specific to that registration type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalAttributes} method.
     * </p>
     * 
     * @return Metadata about a given registration which is specific to that registration type.
     */
    public final Map<String, String> additionalAttributes() {
        return additionalAttributes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of tags (key and value pairs) to associate with the registration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return An array of tags (key and value pairs) to associate with the registration.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The time when the registration was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a>
     * format.
     * </p>
     * 
     * @return The time when the registration was created, in <a href="https://www.epochconverter.com/">UNIX epoch
     *         time</a> format.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(registrationArn());
        hashCode = 31 * hashCode + Objects.hashCode(registrationId());
        hashCode = 31 * hashCode + Objects.hashCode(registrationType());
        hashCode = 31 * hashCode + Objects.hashCode(registrationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(currentVersionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalAttributes() ? additionalAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRegistrationResponse)) {
            return false;
        }
        CreateRegistrationResponse other = (CreateRegistrationResponse) obj;
        return Objects.equals(registrationArn(), other.registrationArn())
                && Objects.equals(registrationId(), other.registrationId())
                && Objects.equals(registrationType(), other.registrationType())
                && Objects.equals(registrationStatusAsString(), other.registrationStatusAsString())
                && Objects.equals(currentVersionNumber(), other.currentVersionNumber())
                && hasAdditionalAttributes() == other.hasAdditionalAttributes()
                && Objects.equals(additionalAttributes(), other.additionalAttributes()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(createdTimestamp(), other.createdTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRegistrationResponse").add("RegistrationArn", registrationArn())
                .add("RegistrationId", registrationId()).add("RegistrationType", registrationType())
                .add("RegistrationStatus", registrationStatusAsString()).add("CurrentVersionNumber", currentVersionNumber())
                .add("AdditionalAttributes", hasAdditionalAttributes() ? additionalAttributes() : null)
                .add("Tags", hasTags() ? tags() : null).add("CreatedTimestamp", createdTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RegistrationArn":
            return Optional.ofNullable(clazz.cast(registrationArn()));
        case "RegistrationId":
            return Optional.ofNullable(clazz.cast(registrationId()));
        case "RegistrationType":
            return Optional.ofNullable(clazz.cast(registrationType()));
        case "RegistrationStatus":
            return Optional.ofNullable(clazz.cast(registrationStatusAsString()));
        case "CurrentVersionNumber":
            return Optional.ofNullable(clazz.cast(currentVersionNumber()));
        case "AdditionalAttributes":
            return Optional.ofNullable(clazz.cast(additionalAttributes()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RegistrationArn", REGISTRATION_ARN_FIELD);
        map.put("RegistrationId", REGISTRATION_ID_FIELD);
        map.put("RegistrationType", REGISTRATION_TYPE_FIELD);
        map.put("RegistrationStatus", REGISTRATION_STATUS_FIELD);
        map.put("CurrentVersionNumber", CURRENT_VERSION_NUMBER_FIELD);
        map.put("AdditionalAttributes", ADDITIONAL_ATTRIBUTES_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateRegistrationResponse, T> g) {
        return obj -> g.apply((CreateRegistrationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PinpointSmsVoiceV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateRegistrationResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the registration.
         * </p>
         * 
         * @param registrationArn
         *        The Amazon Resource Name (ARN) for the registration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationArn(String registrationArn);

        /**
         * <p>
         * The unique identifier for the registration.
         * </p>
         * 
         * @param registrationId
         *        The unique identifier for the registration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationId(String registrationId);

        /**
         * <p>
         * The type of registration form to create. The list of <b>RegistrationTypes</b> can be found using the
         * <a>DescribeRegistrationTypeDefinitions</a> action.
         * </p>
         * 
         * @param registrationType
         *        The type of registration form to create. The list of <b>RegistrationTypes</b> can be found using the
         *        <a>DescribeRegistrationTypeDefinitions</a> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationType(String registrationType);

        /**
         * <p>
         * The status of the registration.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CLOSED</code>: The phone number or sender ID has been deleted and you must also delete the registration
         * for the number.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATED</code>: Your registration is created but not submitted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COMPLETE</code>: Your registration has been approved and your origination identity has been created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETED</code>: The registration has been deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PROVISIONING</code>: Your registration has been approved and your origination identity is being
         * created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REQUIRES_AUTHENTICATION</code>: You need to complete email authentication.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REQUIRES_UPDATES</code>: You must fix your registration and resubmit it.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REVIEWING</code>: Your registration has been accepted and is being reviewed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUBMITTED</code>: Your registration has been submitted and is awaiting review.
         * </p>
         * </li>
         * </ul>
         * 
         * @param registrationStatus
         *        The status of the registration.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CLOSED</code>: The phone number or sender ID has been deleted and you must also delete the
         *        registration for the number.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATED</code>: Your registration is created but not submitted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COMPLETE</code>: Your registration has been approved and your origination identity has been
         *        created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETED</code>: The registration has been deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PROVISIONING</code>: Your registration has been approved and your origination identity is being
         *        created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REQUIRES_AUTHENTICATION</code>: You need to complete email authentication.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REQUIRES_UPDATES</code>: You must fix your registration and resubmit it.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REVIEWING</code>: Your registration has been accepted and is being reviewed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUBMITTED</code>: Your registration has been submitted and is awaiting review.
         *        </p>
         *        </li>
         * @see RegistrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistrationStatus
         */
        Builder registrationStatus(String registrationStatus);

        /**
         * <p>
         * The status of the registration.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CLOSED</code>: The phone number or sender ID has been deleted and you must also delete the registration
         * for the number.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATED</code>: Your registration is created but not submitted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COMPLETE</code>: Your registration has been approved and your origination identity has been created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETED</code>: The registration has been deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PROVISIONING</code>: Your registration has been approved and your origination identity is being
         * created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REQUIRES_AUTHENTICATION</code>: You need to complete email authentication.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REQUIRES_UPDATES</code>: You must fix your registration and resubmit it.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REVIEWING</code>: Your registration has been accepted and is being reviewed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUBMITTED</code>: Your registration has been submitted and is awaiting review.
         * </p>
         * </li>
         * </ul>
         * 
         * @param registrationStatus
         *        The status of the registration.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CLOSED</code>: The phone number or sender ID has been deleted and you must also delete the
         *        registration for the number.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATED</code>: Your registration is created but not submitted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COMPLETE</code>: Your registration has been approved and your origination identity has been
         *        created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETED</code>: The registration has been deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PROVISIONING</code>: Your registration has been approved and your origination identity is being
         *        created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REQUIRES_AUTHENTICATION</code>: You need to complete email authentication.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REQUIRES_UPDATES</code>: You must fix your registration and resubmit it.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REVIEWING</code>: Your registration has been accepted and is being reviewed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUBMITTED</code>: Your registration has been submitted and is awaiting review.
         *        </p>
         *        </li>
         * @see RegistrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistrationStatus
         */
        Builder registrationStatus(RegistrationStatus registrationStatus);

        /**
         * <p>
         * The current version number of the registration.
         * </p>
         * 
         * @param currentVersionNumber
         *        The current version number of the registration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentVersionNumber(Long currentVersionNumber);

        /**
         * <p>
         * Metadata about a given registration which is specific to that registration type.
         * </p>
         * 
         * @param additionalAttributes
         *        Metadata about a given registration which is specific to that registration type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalAttributes(Map<String, String> additionalAttributes);

        /**
         * <p>
         * An array of tags (key and value pairs) to associate with the registration.
         * </p>
         * 
         * @param tags
         *        An array of tags (key and value pairs) to associate with the registration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * An array of tags (key and value pairs) to associate with the registration.
         * </p>
         * 
         * @param tags
         *        An array of tags (key and value pairs) to associate with the registration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * An array of tags (key and value pairs) to associate with the registration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.Tag.Builder#build()} is called immediately
         * and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The time when the registration was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a>
         * format.
         * </p>
         * 
         * @param createdTimestamp
         *        The time when the registration was created, in <a href="https://www.epochconverter.com/">UNIX epoch
         *        time</a> format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Response.BuilderImpl implements Builder {
        private String registrationArn;

        private String registrationId;

        private String registrationType;

        private String registrationStatus;

        private Long currentVersionNumber;

        private Map<String, String> additionalAttributes = DefaultSdkAutoConstructMap.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private Instant createdTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRegistrationResponse model) {
            super(model);
            registrationArn(model.registrationArn);
            registrationId(model.registrationId);
            registrationType(model.registrationType);
            registrationStatus(model.registrationStatus);
            currentVersionNumber(model.currentVersionNumber);
            additionalAttributes(model.additionalAttributes);
            tags(model.tags);
            createdTimestamp(model.createdTimestamp);
        }

        public final String getRegistrationArn() {
            return registrationArn;
        }

        public final void setRegistrationArn(String registrationArn) {
            this.registrationArn = registrationArn;
        }

        @Override
        public final Builder registrationArn(String registrationArn) {
            this.registrationArn = registrationArn;
            return this;
        }

        public final String getRegistrationId() {
            return registrationId;
        }

        public final void setRegistrationId(String registrationId) {
            this.registrationId = registrationId;
        }

        @Override
        public final Builder registrationId(String registrationId) {
            this.registrationId = registrationId;
            return this;
        }

        public final String getRegistrationType() {
            return registrationType;
        }

        public final void setRegistrationType(String registrationType) {
            this.registrationType = registrationType;
        }

        @Override
        public final Builder registrationType(String registrationType) {
            this.registrationType = registrationType;
            return this;
        }

        public final String getRegistrationStatus() {
            return registrationStatus;
        }

        public final void setRegistrationStatus(String registrationStatus) {
            this.registrationStatus = registrationStatus;
        }

        @Override
        public final Builder registrationStatus(String registrationStatus) {
            this.registrationStatus = registrationStatus;
            return this;
        }

        @Override
        public final Builder registrationStatus(RegistrationStatus registrationStatus) {
            this.registrationStatus(registrationStatus == null ? null : registrationStatus.toString());
            return this;
        }

        public final Long getCurrentVersionNumber() {
            return currentVersionNumber;
        }

        public final void setCurrentVersionNumber(Long currentVersionNumber) {
            this.currentVersionNumber = currentVersionNumber;
        }

        @Override
        public final Builder currentVersionNumber(Long currentVersionNumber) {
            this.currentVersionNumber = currentVersionNumber;
            return this;
        }

        public final Map<String, String> getAdditionalAttributes() {
            if (additionalAttributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return additionalAttributes;
        }

        public final void setAdditionalAttributes(Map<String, String> additionalAttributes) {
            this.additionalAttributes = StringMapCopier.copy(additionalAttributes);
        }

        @Override
        public final Builder additionalAttributes(Map<String, String> additionalAttributes) {
            this.additionalAttributes = StringMapCopier.copy(additionalAttributes);
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        @Override
        public CreateRegistrationResponse build() {
            return new CreateRegistrationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
