/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeletePoolResponse extends PinpointSmsVoiceV2Response implements
        ToCopyableBuilder<DeletePoolResponse.Builder, DeletePoolResponse> {
    private static final SdkField<String> POOL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PoolArn").getter(getter(DeletePoolResponse::poolArn)).setter(setter(Builder::poolArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolArn").build()).build();

    private static final SdkField<String> POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("PoolId")
            .getter(getter(DeletePoolResponse::poolId)).setter(setter(Builder::poolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DeletePoolResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> MESSAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MessageType").getter(getter(DeletePoolResponse::messageTypeAsString))
            .setter(setter(Builder::messageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageType").build()).build();

    private static final SdkField<Boolean> TWO_WAY_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("TwoWayEnabled").getter(getter(DeletePoolResponse::twoWayEnabled)).setter(setter(Builder::twoWayEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TwoWayEnabled").build()).build();

    private static final SdkField<String> TWO_WAY_CHANNEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TwoWayChannelArn").getter(getter(DeletePoolResponse::twoWayChannelArn))
            .setter(setter(Builder::twoWayChannelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TwoWayChannelArn").build()).build();

    private static final SdkField<String> TWO_WAY_CHANNEL_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TwoWayChannelRole").getter(getter(DeletePoolResponse::twoWayChannelRole))
            .setter(setter(Builder::twoWayChannelRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TwoWayChannelRole").build()).build();

    private static final SdkField<Boolean> SELF_MANAGED_OPT_OUTS_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("SelfManagedOptOutsEnabled")
            .getter(getter(DeletePoolResponse::selfManagedOptOutsEnabled)).setter(setter(Builder::selfManagedOptOutsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelfManagedOptOutsEnabled").build())
            .build();

    private static final SdkField<String> OPT_OUT_LIST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptOutListName").getter(getter(DeletePoolResponse::optOutListName))
            .setter(setter(Builder::optOutListName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptOutListName").build()).build();

    private static final SdkField<Boolean> SHARED_ROUTES_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SharedRoutesEnabled").getter(getter(DeletePoolResponse::sharedRoutesEnabled))
            .setter(setter(Builder::sharedRoutesEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharedRoutesEnabled").build())
            .build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp").getter(getter(DeletePoolResponse::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POOL_ARN_FIELD, POOL_ID_FIELD,
            STATUS_FIELD, MESSAGE_TYPE_FIELD, TWO_WAY_ENABLED_FIELD, TWO_WAY_CHANNEL_ARN_FIELD, TWO_WAY_CHANNEL_ROLE_FIELD,
            SELF_MANAGED_OPT_OUTS_ENABLED_FIELD, OPT_OUT_LIST_NAME_FIELD, SHARED_ROUTES_ENABLED_FIELD, CREATED_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String poolArn;

    private final String poolId;

    private final String status;

    private final String messageType;

    private final Boolean twoWayEnabled;

    private final String twoWayChannelArn;

    private final String twoWayChannelRole;

    private final Boolean selfManagedOptOutsEnabled;

    private final String optOutListName;

    private final Boolean sharedRoutesEnabled;

    private final Instant createdTimestamp;

    private DeletePoolResponse(BuilderImpl builder) {
        super(builder);
        this.poolArn = builder.poolArn;
        this.poolId = builder.poolId;
        this.status = builder.status;
        this.messageType = builder.messageType;
        this.twoWayEnabled = builder.twoWayEnabled;
        this.twoWayChannelArn = builder.twoWayChannelArn;
        this.twoWayChannelRole = builder.twoWayChannelRole;
        this.selfManagedOptOutsEnabled = builder.selfManagedOptOutsEnabled;
        this.optOutListName = builder.optOutListName;
        this.sharedRoutesEnabled = builder.sharedRoutesEnabled;
        this.createdTimestamp = builder.createdTimestamp;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the pool that was deleted.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the pool that was deleted.
     */
    public final String poolArn() {
        return poolArn;
    }

    /**
     * <p>
     * The PoolId of the pool that was deleted.
     * </p>
     * 
     * @return The PoolId of the pool that was deleted.
     */
    public final String poolId() {
        return poolId;
    }

    /**
     * <p>
     * The current status of the pool.
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATING: The pool is currently being created and isn't yet available for use.
     * </p>
     * </li>
     * <li>
     * <p>
     * ACTIVE: The pool is active and available for use.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETING: The pool is being deleted.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PoolStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the pool.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         CREATING: The pool is currently being created and isn't yet available for use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACTIVE: The pool is active and available for use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETING: The pool is being deleted.
     *         </p>
     *         </li>
     * @see PoolStatus
     */
    public final PoolStatus status() {
        return PoolStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the pool.
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATING: The pool is currently being created and isn't yet available for use.
     * </p>
     * </li>
     * <li>
     * <p>
     * ACTIVE: The pool is active and available for use.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETING: The pool is being deleted.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PoolStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the pool.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         CREATING: The pool is currently being created and isn't yet available for use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACTIVE: The pool is active and available for use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETING: The pool is being deleted.
     *         </p>
     *         </li>
     * @see PoolStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The message type that was associated with the deleted pool.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #messageType} will
     * return {@link MessageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #messageTypeAsString}.
     * </p>
     * 
     * @return The message type that was associated with the deleted pool.
     * @see MessageType
     */
    public final MessageType messageType() {
        return MessageType.fromValue(messageType);
    }

    /**
     * <p>
     * The message type that was associated with the deleted pool.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #messageType} will
     * return {@link MessageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #messageTypeAsString}.
     * </p>
     * 
     * @return The message type that was associated with the deleted pool.
     * @see MessageType
     */
    public final String messageTypeAsString() {
        return messageType;
    }

    /**
     * <p>
     * By default this is set to false. When set to true you can receive incoming text messages from your end
     * recipients.
     * </p>
     * 
     * @return By default this is set to false. When set to true you can receive incoming text messages from your end
     *         recipients.
     */
    public final Boolean twoWayEnabled() {
        return twoWayEnabled;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the TwoWayChannel.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the TwoWayChannel.
     */
    public final String twoWayChannelArn() {
        return twoWayChannelArn;
    }

    /**
     * <p>
     * An optional IAM Role Arn for a service to assume, to be able to post inbound SMS messages.
     * </p>
     * 
     * @return An optional IAM Role Arn for a service to assume, to be able to post inbound SMS messages.
     */
    public final String twoWayChannelRole() {
        return twoWayChannelRole;
    }

    /**
     * <p>
     * By default this is set to false. When set to false and an end recipient sends a message that begins with HELP or
     * STOP to one of your dedicated numbers, End User MessagingSMS automatically replies with a customizable message
     * and adds the end recipient to the OptOutList. When set to true you're responsible for responding to HELP and STOP
     * requests. You're also responsible for tracking and honoring opt-out requests.
     * </p>
     * 
     * @return By default this is set to false. When set to false and an end recipient sends a message that begins with
     *         HELP or STOP to one of your dedicated numbers, End User MessagingSMS automatically replies with a
     *         customizable message and adds the end recipient to the OptOutList. When set to true you're responsible
     *         for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out
     *         requests.
     */
    public final Boolean selfManagedOptOutsEnabled() {
        return selfManagedOptOutsEnabled;
    }

    /**
     * <p>
     * The name of the OptOutList that was associated with the deleted pool.
     * </p>
     * 
     * @return The name of the OptOutList that was associated with the deleted pool.
     */
    public final String optOutListName() {
        return optOutListName;
    }

    /**
     * <p>
     * Indicates whether shared routes are enabled for the pool.
     * </p>
     * 
     * @return Indicates whether shared routes are enabled for the pool.
     */
    public final Boolean sharedRoutesEnabled() {
        return sharedRoutesEnabled;
    }

    /**
     * <p>
     * The time when the pool was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.
     * </p>
     * 
     * @return The time when the pool was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a>
     *         format.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(poolArn());
        hashCode = 31 * hashCode + Objects.hashCode(poolId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(messageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(twoWayEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(twoWayChannelArn());
        hashCode = 31 * hashCode + Objects.hashCode(twoWayChannelRole());
        hashCode = 31 * hashCode + Objects.hashCode(selfManagedOptOutsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(optOutListName());
        hashCode = 31 * hashCode + Objects.hashCode(sharedRoutesEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeletePoolResponse)) {
            return false;
        }
        DeletePoolResponse other = (DeletePoolResponse) obj;
        return Objects.equals(poolArn(), other.poolArn()) && Objects.equals(poolId(), other.poolId())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(messageTypeAsString(), other.messageTypeAsString())
                && Objects.equals(twoWayEnabled(), other.twoWayEnabled())
                && Objects.equals(twoWayChannelArn(), other.twoWayChannelArn())
                && Objects.equals(twoWayChannelRole(), other.twoWayChannelRole())
                && Objects.equals(selfManagedOptOutsEnabled(), other.selfManagedOptOutsEnabled())
                && Objects.equals(optOutListName(), other.optOutListName())
                && Objects.equals(sharedRoutesEnabled(), other.sharedRoutesEnabled())
                && Objects.equals(createdTimestamp(), other.createdTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeletePoolResponse").add("PoolArn", poolArn()).add("PoolId", poolId())
                .add("Status", statusAsString()).add("MessageType", messageTypeAsString()).add("TwoWayEnabled", twoWayEnabled())
                .add("TwoWayChannelArn", twoWayChannelArn()).add("TwoWayChannelRole", twoWayChannelRole())
                .add("SelfManagedOptOutsEnabled", selfManagedOptOutsEnabled()).add("OptOutListName", optOutListName())
                .add("SharedRoutesEnabled", sharedRoutesEnabled()).add("CreatedTimestamp", createdTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PoolArn":
            return Optional.ofNullable(clazz.cast(poolArn()));
        case "PoolId":
            return Optional.ofNullable(clazz.cast(poolId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "MessageType":
            return Optional.ofNullable(clazz.cast(messageTypeAsString()));
        case "TwoWayEnabled":
            return Optional.ofNullable(clazz.cast(twoWayEnabled()));
        case "TwoWayChannelArn":
            return Optional.ofNullable(clazz.cast(twoWayChannelArn()));
        case "TwoWayChannelRole":
            return Optional.ofNullable(clazz.cast(twoWayChannelRole()));
        case "SelfManagedOptOutsEnabled":
            return Optional.ofNullable(clazz.cast(selfManagedOptOutsEnabled()));
        case "OptOutListName":
            return Optional.ofNullable(clazz.cast(optOutListName()));
        case "SharedRoutesEnabled":
            return Optional.ofNullable(clazz.cast(sharedRoutesEnabled()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PoolArn", POOL_ARN_FIELD);
        map.put("PoolId", POOL_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("MessageType", MESSAGE_TYPE_FIELD);
        map.put("TwoWayEnabled", TWO_WAY_ENABLED_FIELD);
        map.put("TwoWayChannelArn", TWO_WAY_CHANNEL_ARN_FIELD);
        map.put("TwoWayChannelRole", TWO_WAY_CHANNEL_ROLE_FIELD);
        map.put("SelfManagedOptOutsEnabled", SELF_MANAGED_OPT_OUTS_ENABLED_FIELD);
        map.put("OptOutListName", OPT_OUT_LIST_NAME_FIELD);
        map.put("SharedRoutesEnabled", SHARED_ROUTES_ENABLED_FIELD);
        map.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeletePoolResponse, T> g) {
        return obj -> g.apply((DeletePoolResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PinpointSmsVoiceV2Response.Builder, SdkPojo, CopyableBuilder<Builder, DeletePoolResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the pool that was deleted.
         * </p>
         * 
         * @param poolArn
         *        The Amazon Resource Name (ARN) of the pool that was deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolArn(String poolArn);

        /**
         * <p>
         * The PoolId of the pool that was deleted.
         * </p>
         * 
         * @param poolId
         *        The PoolId of the pool that was deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolId(String poolId);

        /**
         * <p>
         * The current status of the pool.
         * </p>
         * <ul>
         * <li>
         * <p>
         * CREATING: The pool is currently being created and isn't yet available for use.
         * </p>
         * </li>
         * <li>
         * <p>
         * ACTIVE: The pool is active and available for use.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETING: The pool is being deleted.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The current status of the pool.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        CREATING: The pool is currently being created and isn't yet available for use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ACTIVE: The pool is active and available for use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETING: The pool is being deleted.
         *        </p>
         *        </li>
         * @see PoolStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PoolStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the pool.
         * </p>
         * <ul>
         * <li>
         * <p>
         * CREATING: The pool is currently being created and isn't yet available for use.
         * </p>
         * </li>
         * <li>
         * <p>
         * ACTIVE: The pool is active and available for use.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETING: The pool is being deleted.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The current status of the pool.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        CREATING: The pool is currently being created and isn't yet available for use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ACTIVE: The pool is active and available for use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETING: The pool is being deleted.
         *        </p>
         *        </li>
         * @see PoolStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PoolStatus
         */
        Builder status(PoolStatus status);

        /**
         * <p>
         * The message type that was associated with the deleted pool.
         * </p>
         * 
         * @param messageType
         *        The message type that was associated with the deleted pool.
         * @see MessageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageType
         */
        Builder messageType(String messageType);

        /**
         * <p>
         * The message type that was associated with the deleted pool.
         * </p>
         * 
         * @param messageType
         *        The message type that was associated with the deleted pool.
         * @see MessageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageType
         */
        Builder messageType(MessageType messageType);

        /**
         * <p>
         * By default this is set to false. When set to true you can receive incoming text messages from your end
         * recipients.
         * </p>
         * 
         * @param twoWayEnabled
         *        By default this is set to false. When set to true you can receive incoming text messages from your end
         *        recipients.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder twoWayEnabled(Boolean twoWayEnabled);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the TwoWayChannel.
         * </p>
         * 
         * @param twoWayChannelArn
         *        The Amazon Resource Name (ARN) of the TwoWayChannel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder twoWayChannelArn(String twoWayChannelArn);

        /**
         * <p>
         * An optional IAM Role Arn for a service to assume, to be able to post inbound SMS messages.
         * </p>
         * 
         * @param twoWayChannelRole
         *        An optional IAM Role Arn for a service to assume, to be able to post inbound SMS messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder twoWayChannelRole(String twoWayChannelRole);

        /**
         * <p>
         * By default this is set to false. When set to false and an end recipient sends a message that begins with HELP
         * or STOP to one of your dedicated numbers, End User MessagingSMS automatically replies with a customizable
         * message and adds the end recipient to the OptOutList. When set to true you're responsible for responding to
         * HELP and STOP requests. You're also responsible for tracking and honoring opt-out requests.
         * </p>
         * 
         * @param selfManagedOptOutsEnabled
         *        By default this is set to false. When set to false and an end recipient sends a message that begins
         *        with HELP or STOP to one of your dedicated numbers, End User MessagingSMS automatically replies with a
         *        customizable message and adds the end recipient to the OptOutList. When set to true you're responsible
         *        for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out
         *        requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selfManagedOptOutsEnabled(Boolean selfManagedOptOutsEnabled);

        /**
         * <p>
         * The name of the OptOutList that was associated with the deleted pool.
         * </p>
         * 
         * @param optOutListName
         *        The name of the OptOutList that was associated with the deleted pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optOutListName(String optOutListName);

        /**
         * <p>
         * Indicates whether shared routes are enabled for the pool.
         * </p>
         * 
         * @param sharedRoutesEnabled
         *        Indicates whether shared routes are enabled for the pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharedRoutesEnabled(Boolean sharedRoutesEnabled);

        /**
         * <p>
         * The time when the pool was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.
         * </p>
         * 
         * @param createdTimestamp
         *        The time when the pool was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a>
         *        format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Response.BuilderImpl implements Builder {
        private String poolArn;

        private String poolId;

        private String status;

        private String messageType;

        private Boolean twoWayEnabled;

        private String twoWayChannelArn;

        private String twoWayChannelRole;

        private Boolean selfManagedOptOutsEnabled;

        private String optOutListName;

        private Boolean sharedRoutesEnabled;

        private Instant createdTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(DeletePoolResponse model) {
            super(model);
            poolArn(model.poolArn);
            poolId(model.poolId);
            status(model.status);
            messageType(model.messageType);
            twoWayEnabled(model.twoWayEnabled);
            twoWayChannelArn(model.twoWayChannelArn);
            twoWayChannelRole(model.twoWayChannelRole);
            selfManagedOptOutsEnabled(model.selfManagedOptOutsEnabled);
            optOutListName(model.optOutListName);
            sharedRoutesEnabled(model.sharedRoutesEnabled);
            createdTimestamp(model.createdTimestamp);
        }

        public final String getPoolArn() {
            return poolArn;
        }

        public final void setPoolArn(String poolArn) {
            this.poolArn = poolArn;
        }

        @Override
        public final Builder poolArn(String poolArn) {
            this.poolArn = poolArn;
            return this;
        }

        public final String getPoolId() {
            return poolId;
        }

        public final void setPoolId(String poolId) {
            this.poolId = poolId;
        }

        @Override
        public final Builder poolId(String poolId) {
            this.poolId = poolId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PoolStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getMessageType() {
            return messageType;
        }

        public final void setMessageType(String messageType) {
            this.messageType = messageType;
        }

        @Override
        public final Builder messageType(String messageType) {
            this.messageType = messageType;
            return this;
        }

        @Override
        public final Builder messageType(MessageType messageType) {
            this.messageType(messageType == null ? null : messageType.toString());
            return this;
        }

        public final Boolean getTwoWayEnabled() {
            return twoWayEnabled;
        }

        public final void setTwoWayEnabled(Boolean twoWayEnabled) {
            this.twoWayEnabled = twoWayEnabled;
        }

        @Override
        public final Builder twoWayEnabled(Boolean twoWayEnabled) {
            this.twoWayEnabled = twoWayEnabled;
            return this;
        }

        public final String getTwoWayChannelArn() {
            return twoWayChannelArn;
        }

        public final void setTwoWayChannelArn(String twoWayChannelArn) {
            this.twoWayChannelArn = twoWayChannelArn;
        }

        @Override
        public final Builder twoWayChannelArn(String twoWayChannelArn) {
            this.twoWayChannelArn = twoWayChannelArn;
            return this;
        }

        public final String getTwoWayChannelRole() {
            return twoWayChannelRole;
        }

        public final void setTwoWayChannelRole(String twoWayChannelRole) {
            this.twoWayChannelRole = twoWayChannelRole;
        }

        @Override
        public final Builder twoWayChannelRole(String twoWayChannelRole) {
            this.twoWayChannelRole = twoWayChannelRole;
            return this;
        }

        public final Boolean getSelfManagedOptOutsEnabled() {
            return selfManagedOptOutsEnabled;
        }

        public final void setSelfManagedOptOutsEnabled(Boolean selfManagedOptOutsEnabled) {
            this.selfManagedOptOutsEnabled = selfManagedOptOutsEnabled;
        }

        @Override
        public final Builder selfManagedOptOutsEnabled(Boolean selfManagedOptOutsEnabled) {
            this.selfManagedOptOutsEnabled = selfManagedOptOutsEnabled;
            return this;
        }

        public final String getOptOutListName() {
            return optOutListName;
        }

        public final void setOptOutListName(String optOutListName) {
            this.optOutListName = optOutListName;
        }

        @Override
        public final Builder optOutListName(String optOutListName) {
            this.optOutListName = optOutListName;
            return this;
        }

        public final Boolean getSharedRoutesEnabled() {
            return sharedRoutesEnabled;
        }

        public final void setSharedRoutesEnabled(Boolean sharedRoutesEnabled) {
            this.sharedRoutesEnabled = sharedRoutesEnabled;
        }

        @Override
        public final Builder sharedRoutesEnabled(Boolean sharedRoutesEnabled) {
            this.sharedRoutesEnabled = sharedRoutesEnabled;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        @Override
        public DeletePoolResponse build() {
            return new DeletePoolResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
