/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteProtectConfigurationRuleSetNumberOverrideRequest extends PinpointSmsVoiceV2Request
        implements
        ToCopyableBuilder<DeleteProtectConfigurationRuleSetNumberOverrideRequest.Builder, DeleteProtectConfigurationRuleSetNumberOverrideRequest> {
    private static final SdkField<String> PROTECT_CONFIGURATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProtectConfigurationId")
            .getter(getter(DeleteProtectConfigurationRuleSetNumberOverrideRequest::protectConfigurationId))
            .setter(setter(Builder::protectConfigurationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectConfigurationId").build())
            .build();

    private static final SdkField<String> DESTINATION_PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationPhoneNumber")
            .getter(getter(DeleteProtectConfigurationRuleSetNumberOverrideRequest::destinationPhoneNumber))
            .setter(setter(Builder::destinationPhoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPhoneNumber").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PROTECT_CONFIGURATION_ID_FIELD, DESTINATION_PHONE_NUMBER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String protectConfigurationId;

    private final String destinationPhoneNumber;

    private DeleteProtectConfigurationRuleSetNumberOverrideRequest(BuilderImpl builder) {
        super(builder);
        this.protectConfigurationId = builder.protectConfigurationId;
        this.destinationPhoneNumber = builder.destinationPhoneNumber;
    }

    /**
     * <p>
     * The unique identifier for the protect configuration.
     * </p>
     * 
     * @return The unique identifier for the protect configuration.
     */
    public final String protectConfigurationId() {
        return protectConfigurationId;
    }

    /**
     * <p>
     * The destination phone number in E.164 format.
     * </p>
     * 
     * @return The destination phone number in E.164 format.
     */
    public final String destinationPhoneNumber() {
        return destinationPhoneNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(protectConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(destinationPhoneNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteProtectConfigurationRuleSetNumberOverrideRequest)) {
            return false;
        }
        DeleteProtectConfigurationRuleSetNumberOverrideRequest other = (DeleteProtectConfigurationRuleSetNumberOverrideRequest) obj;
        return Objects.equals(protectConfigurationId(), other.protectConfigurationId())
                && Objects.equals(destinationPhoneNumber(), other.destinationPhoneNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteProtectConfigurationRuleSetNumberOverrideRequest")
                .add("ProtectConfigurationId", protectConfigurationId()).add("DestinationPhoneNumber", destinationPhoneNumber())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProtectConfigurationId":
            return Optional.ofNullable(clazz.cast(protectConfigurationId()));
        case "DestinationPhoneNumber":
            return Optional.ofNullable(clazz.cast(destinationPhoneNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProtectConfigurationId", PROTECT_CONFIGURATION_ID_FIELD);
        map.put("DestinationPhoneNumber", DESTINATION_PHONE_NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteProtectConfigurationRuleSetNumberOverrideRequest, T> g) {
        return obj -> g.apply((DeleteProtectConfigurationRuleSetNumberOverrideRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PinpointSmsVoiceV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteProtectConfigurationRuleSetNumberOverrideRequest> {
        /**
         * <p>
         * The unique identifier for the protect configuration.
         * </p>
         * 
         * @param protectConfigurationId
         *        The unique identifier for the protect configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectConfigurationId(String protectConfigurationId);

        /**
         * <p>
         * The destination phone number in E.164 format.
         * </p>
         * 
         * @param destinationPhoneNumber
         *        The destination phone number in E.164 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPhoneNumber(String destinationPhoneNumber);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Request.BuilderImpl implements Builder {
        private String protectConfigurationId;

        private String destinationPhoneNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteProtectConfigurationRuleSetNumberOverrideRequest model) {
            super(model);
            protectConfigurationId(model.protectConfigurationId);
            destinationPhoneNumber(model.destinationPhoneNumber);
        }

        public final String getProtectConfigurationId() {
            return protectConfigurationId;
        }

        public final void setProtectConfigurationId(String protectConfigurationId) {
            this.protectConfigurationId = protectConfigurationId;
        }

        @Override
        public final Builder protectConfigurationId(String protectConfigurationId) {
            this.protectConfigurationId = protectConfigurationId;
            return this;
        }

        public final String getDestinationPhoneNumber() {
            return destinationPhoneNumber;
        }

        public final void setDestinationPhoneNumber(String destinationPhoneNumber) {
            this.destinationPhoneNumber = destinationPhoneNumber;
        }

        @Override
        public final Builder destinationPhoneNumber(String destinationPhoneNumber) {
            this.destinationPhoneNumber = destinationPhoneNumber;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteProtectConfigurationRuleSetNumberOverrideRequest build() {
            return new DeleteProtectConfigurationRuleSetNumberOverrideRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
