/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeProtectConfigurationsResponse extends PinpointSmsVoiceV2Response implements
        ToCopyableBuilder<DescribeProtectConfigurationsResponse.Builder, DescribeProtectConfigurationsResponse> {
    private static final SdkField<List<ProtectConfigurationInformation>> PROTECT_CONFIGURATIONS_FIELD = SdkField
            .<List<ProtectConfigurationInformation>> builder(MarshallingType.LIST)
            .memberName("ProtectConfigurations")
            .getter(getter(DescribeProtectConfigurationsResponse::protectConfigurations))
            .setter(setter(Builder::protectConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProtectConfigurationInformation> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProtectConfigurationInformation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeProtectConfigurationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTECT_CONFIGURATIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ProtectConfigurationInformation> protectConfigurations;

    private final String nextToken;

    private DescribeProtectConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.protectConfigurations = builder.protectConfigurations;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProtectConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasProtectConfigurations() {
        return protectConfigurations != null && !(protectConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of ProtectConfigurationInformation objects that contain the details for the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProtectConfigurations} method.
     * </p>
     * 
     * @return An array of ProtectConfigurationInformation objects that contain the details for the request.
     */
    public final List<ProtectConfigurationInformation> protectConfigurations() {
        return protectConfigurations;
    }

    /**
     * <p>
     * The token to be used for the next set of paginated results. You don't need to supply a value for this field in
     * the initial request.
     * </p>
     * 
     * @return The token to be used for the next set of paginated results. You don't need to supply a value for this
     *         field in the initial request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasProtectConfigurations() ? protectConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProtectConfigurationsResponse)) {
            return false;
        }
        DescribeProtectConfigurationsResponse other = (DescribeProtectConfigurationsResponse) obj;
        return hasProtectConfigurations() == other.hasProtectConfigurations()
                && Objects.equals(protectConfigurations(), other.protectConfigurations())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeProtectConfigurationsResponse")
                .add("ProtectConfigurations", hasProtectConfigurations() ? protectConfigurations() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProtectConfigurations":
            return Optional.ofNullable(clazz.cast(protectConfigurations()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProtectConfigurations", PROTECT_CONFIGURATIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeProtectConfigurationsResponse, T> g) {
        return obj -> g.apply((DescribeProtectConfigurationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PinpointSmsVoiceV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeProtectConfigurationsResponse> {
        /**
         * <p>
         * An array of ProtectConfigurationInformation objects that contain the details for the request.
         * </p>
         * 
         * @param protectConfigurations
         *        An array of ProtectConfigurationInformation objects that contain the details for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectConfigurations(Collection<ProtectConfigurationInformation> protectConfigurations);

        /**
         * <p>
         * An array of ProtectConfigurationInformation objects that contain the details for the request.
         * </p>
         * 
         * @param protectConfigurations
         *        An array of ProtectConfigurationInformation objects that contain the details for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectConfigurations(ProtectConfigurationInformation... protectConfigurations);

        /**
         * <p>
         * An array of ProtectConfigurationInformation objects that contain the details for the request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.ProtectConfigurationInformation.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.ProtectConfigurationInformation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.ProtectConfigurationInformation.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #protectConfigurations(List<ProtectConfigurationInformation>)}.
         * 
         * @param protectConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.ProtectConfigurationInformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #protectConfigurations(java.util.Collection<ProtectConfigurationInformation>)
         */
        Builder protectConfigurations(Consumer<ProtectConfigurationInformation.Builder>... protectConfigurations);

        /**
         * <p>
         * The token to be used for the next set of paginated results. You don't need to supply a value for this field
         * in the initial request.
         * </p>
         * 
         * @param nextToken
         *        The token to be used for the next set of paginated results. You don't need to supply a value for this
         *        field in the initial request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Response.BuilderImpl implements Builder {
        private List<ProtectConfigurationInformation> protectConfigurations = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProtectConfigurationsResponse model) {
            super(model);
            protectConfigurations(model.protectConfigurations);
            nextToken(model.nextToken);
        }

        public final List<ProtectConfigurationInformation.Builder> getProtectConfigurations() {
            List<ProtectConfigurationInformation.Builder> result = ProtectConfigurationInformationListCopier
                    .copyToBuilder(this.protectConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProtectConfigurations(Collection<ProtectConfigurationInformation.BuilderImpl> protectConfigurations) {
            this.protectConfigurations = ProtectConfigurationInformationListCopier.copyFromBuilder(protectConfigurations);
        }

        @Override
        public final Builder protectConfigurations(Collection<ProtectConfigurationInformation> protectConfigurations) {
            this.protectConfigurations = ProtectConfigurationInformationListCopier.copy(protectConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protectConfigurations(ProtectConfigurationInformation... protectConfigurations) {
            protectConfigurations(Arrays.asList(protectConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protectConfigurations(Consumer<ProtectConfigurationInformation.Builder>... protectConfigurations) {
            protectConfigurations(Stream.of(protectConfigurations)
                    .map(c -> ProtectConfigurationInformation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeProtectConfigurationsResponse build() {
            return new DescribeProtectConfigurationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
