/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeRegistrationAttachmentsRequest extends PinpointSmsVoiceV2Request implements
        ToCopyableBuilder<DescribeRegistrationAttachmentsRequest.Builder, DescribeRegistrationAttachmentsRequest> {
    private static final SdkField<List<String>> REGISTRATION_ATTACHMENT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RegistrationAttachmentIds")
            .getter(getter(DescribeRegistrationAttachmentsRequest::registrationAttachmentIds))
            .setter(setter(Builder::registrationAttachmentIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationAttachmentIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<RegistrationAttachmentFilter>> FILTERS_FIELD = SdkField
            .<List<RegistrationAttachmentFilter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(DescribeRegistrationAttachmentsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RegistrationAttachmentFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(RegistrationAttachmentFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeRegistrationAttachmentsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(DescribeRegistrationAttachmentsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            REGISTRATION_ATTACHMENT_IDS_FIELD, FILTERS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> registrationAttachmentIds;

    private final List<RegistrationAttachmentFilter> filters;

    private final String nextToken;

    private final Integer maxResults;

    private DescribeRegistrationAttachmentsRequest(BuilderImpl builder) {
        super(builder);
        this.registrationAttachmentIds = builder.registrationAttachmentIds;
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the RegistrationAttachmentIds property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRegistrationAttachmentIds() {
        return registrationAttachmentIds != null && !(registrationAttachmentIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The unique identifier of registration attachments to find. This is an array of <b>RegistrationAttachmentId</b>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegistrationAttachmentIds} method.
     * </p>
     * 
     * @return The unique identifier of registration attachments to find. This is an array of
     *         <b>RegistrationAttachmentId</b>.
     */
    public final List<String> registrationAttachmentIds() {
        return registrationAttachmentIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of RegistrationAttachmentFilter objects to filter the results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return An array of RegistrationAttachmentFilter objects to filter the results.
     */
    public final List<RegistrationAttachmentFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * The token to be used for the next set of paginated results. You don't need to supply a value for this field in
     * the initial request.
     * </p>
     * 
     * @return The token to be used for the next set of paginated results. You don't need to supply a value for this
     *         field in the initial request.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return per each request.
     * </p>
     * 
     * @return The maximum number of results to return per each request.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRegistrationAttachmentIds() ? registrationAttachmentIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRegistrationAttachmentsRequest)) {
            return false;
        }
        DescribeRegistrationAttachmentsRequest other = (DescribeRegistrationAttachmentsRequest) obj;
        return hasRegistrationAttachmentIds() == other.hasRegistrationAttachmentIds()
                && Objects.equals(registrationAttachmentIds(), other.registrationAttachmentIds())
                && hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeRegistrationAttachmentsRequest")
                .add("RegistrationAttachmentIds", hasRegistrationAttachmentIds() ? registrationAttachmentIds() : null)
                .add("Filters", hasFilters() ? filters() : null).add("NextToken", nextToken()).add("MaxResults", maxResults())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RegistrationAttachmentIds":
            return Optional.ofNullable(clazz.cast(registrationAttachmentIds()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RegistrationAttachmentIds", REGISTRATION_ATTACHMENT_IDS_FIELD);
        map.put("Filters", FILTERS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeRegistrationAttachmentsRequest, T> g) {
        return obj -> g.apply((DescribeRegistrationAttachmentsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PinpointSmsVoiceV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeRegistrationAttachmentsRequest> {
        /**
         * <p>
         * The unique identifier of registration attachments to find. This is an array of
         * <b>RegistrationAttachmentId</b>.
         * </p>
         * 
         * @param registrationAttachmentIds
         *        The unique identifier of registration attachments to find. This is an array of
         *        <b>RegistrationAttachmentId</b>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationAttachmentIds(Collection<String> registrationAttachmentIds);

        /**
         * <p>
         * The unique identifier of registration attachments to find. This is an array of
         * <b>RegistrationAttachmentId</b>.
         * </p>
         * 
         * @param registrationAttachmentIds
         *        The unique identifier of registration attachments to find. This is an array of
         *        <b>RegistrationAttachmentId</b>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationAttachmentIds(String... registrationAttachmentIds);

        /**
         * <p>
         * An array of RegistrationAttachmentFilter objects to filter the results.
         * </p>
         * 
         * @param filters
         *        An array of RegistrationAttachmentFilter objects to filter the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<RegistrationAttachmentFilter> filters);

        /**
         * <p>
         * An array of RegistrationAttachmentFilter objects to filter the results.
         * </p>
         * 
         * @param filters
         *        An array of RegistrationAttachmentFilter objects to filter the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(RegistrationAttachmentFilter... filters);

        /**
         * <p>
         * An array of RegistrationAttachmentFilter objects to filter the results.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationAttachmentFilter.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationAttachmentFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationAttachmentFilter.Builder#build()}
         * is called immediately and its result is passed to {@link #filters(List<RegistrationAttachmentFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationAttachmentFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<RegistrationAttachmentFilter>)
         */
        Builder filters(Consumer<RegistrationAttachmentFilter.Builder>... filters);

        /**
         * <p>
         * The token to be used for the next set of paginated results. You don't need to supply a value for this field
         * in the initial request.
         * </p>
         * 
         * @param nextToken
         *        The token to be used for the next set of paginated results. You don't need to supply a value for this
         *        field in the initial request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return per each request.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return per each request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Request.BuilderImpl implements Builder {
        private List<String> registrationAttachmentIds = DefaultSdkAutoConstructList.getInstance();

        private List<RegistrationAttachmentFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRegistrationAttachmentsRequest model) {
            super(model);
            registrationAttachmentIds(model.registrationAttachmentIds);
            filters(model.filters);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final Collection<String> getRegistrationAttachmentIds() {
            if (registrationAttachmentIds instanceof SdkAutoConstructList) {
                return null;
            }
            return registrationAttachmentIds;
        }

        public final void setRegistrationAttachmentIds(Collection<String> registrationAttachmentIds) {
            this.registrationAttachmentIds = RegistrationAttachmentIdListCopier.copy(registrationAttachmentIds);
        }

        @Override
        public final Builder registrationAttachmentIds(Collection<String> registrationAttachmentIds) {
            this.registrationAttachmentIds = RegistrationAttachmentIdListCopier.copy(registrationAttachmentIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder registrationAttachmentIds(String... registrationAttachmentIds) {
            registrationAttachmentIds(Arrays.asList(registrationAttachmentIds));
            return this;
        }

        public final List<RegistrationAttachmentFilter.Builder> getFilters() {
            List<RegistrationAttachmentFilter.Builder> result = RegistrationAttachmentFilterListCopier
                    .copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<RegistrationAttachmentFilter.BuilderImpl> filters) {
            this.filters = RegistrationAttachmentFilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<RegistrationAttachmentFilter> filters) {
            this.filters = RegistrationAttachmentFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(RegistrationAttachmentFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<RegistrationAttachmentFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> RegistrationAttachmentFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeRegistrationAttachmentsRequest build() {
            return new DescribeRegistrationAttachmentsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
