/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSpendLimitsResponse extends PinpointSmsVoiceV2Response implements
        ToCopyableBuilder<DescribeSpendLimitsResponse.Builder, DescribeSpendLimitsResponse> {
    private static final SdkField<List<SpendLimit>> SPEND_LIMITS_FIELD = SdkField
            .<List<SpendLimit>> builder(MarshallingType.LIST)
            .memberName("SpendLimits")
            .getter(getter(DescribeSpendLimitsResponse::spendLimits))
            .setter(setter(Builder::spendLimits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpendLimits").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SpendLimit> builder(MarshallingType.SDK_POJO)
                                            .constructor(SpendLimit::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeSpendLimitsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPEND_LIMITS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<SpendLimit> spendLimits;

    private final String nextToken;

    private DescribeSpendLimitsResponse(BuilderImpl builder) {
        super(builder);
        this.spendLimits = builder.spendLimits;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the SpendLimits property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSpendLimits() {
        return spendLimits != null && !(spendLimits instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of SpendLimit objects that contain the details for the requested spend limits.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSpendLimits} method.
     * </p>
     * 
     * @return An array of SpendLimit objects that contain the details for the requested spend limits.
     */
    public final List<SpendLimit> spendLimits() {
        return spendLimits;
    }

    /**
     * <p>
     * The token to be used for the next set of paginated results. If this field is empty then there are no more
     * results.
     * </p>
     * 
     * @return The token to be used for the next set of paginated results. If this field is empty then there are no more
     *         results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSpendLimits() ? spendLimits() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSpendLimitsResponse)) {
            return false;
        }
        DescribeSpendLimitsResponse other = (DescribeSpendLimitsResponse) obj;
        return hasSpendLimits() == other.hasSpendLimits() && Objects.equals(spendLimits(), other.spendLimits())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeSpendLimitsResponse").add("SpendLimits", hasSpendLimits() ? spendLimits() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SpendLimits":
            return Optional.ofNullable(clazz.cast(spendLimits()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SpendLimits", SPEND_LIMITS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeSpendLimitsResponse, T> g) {
        return obj -> g.apply((DescribeSpendLimitsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PinpointSmsVoiceV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeSpendLimitsResponse> {
        /**
         * <p>
         * An array of SpendLimit objects that contain the details for the requested spend limits.
         * </p>
         * 
         * @param spendLimits
         *        An array of SpendLimit objects that contain the details for the requested spend limits.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spendLimits(Collection<SpendLimit> spendLimits);

        /**
         * <p>
         * An array of SpendLimit objects that contain the details for the requested spend limits.
         * </p>
         * 
         * @param spendLimits
         *        An array of SpendLimit objects that contain the details for the requested spend limits.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spendLimits(SpendLimit... spendLimits);

        /**
         * <p>
         * An array of SpendLimit objects that contain the details for the requested spend limits.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.SpendLimit.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.SpendLimit#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.SpendLimit.Builder#build()} is called
         * immediately and its result is passed to {@link #spendLimits(List<SpendLimit>)}.
         * 
         * @param spendLimits
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.SpendLimit.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spendLimits(java.util.Collection<SpendLimit>)
         */
        Builder spendLimits(Consumer<SpendLimit.Builder>... spendLimits);

        /**
         * <p>
         * The token to be used for the next set of paginated results. If this field is empty then there are no more
         * results.
         * </p>
         * 
         * @param nextToken
         *        The token to be used for the next set of paginated results. If this field is empty then there are no
         *        more results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Response.BuilderImpl implements Builder {
        private List<SpendLimit> spendLimits = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSpendLimitsResponse model) {
            super(model);
            spendLimits(model.spendLimits);
            nextToken(model.nextToken);
        }

        public final List<SpendLimit.Builder> getSpendLimits() {
            List<SpendLimit.Builder> result = SpendLimitListCopier.copyToBuilder(this.spendLimits);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSpendLimits(Collection<SpendLimit.BuilderImpl> spendLimits) {
            this.spendLimits = SpendLimitListCopier.copyFromBuilder(spendLimits);
        }

        @Override
        public final Builder spendLimits(Collection<SpendLimit> spendLimits) {
            this.spendLimits = SpendLimitListCopier.copy(spendLimits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spendLimits(SpendLimit... spendLimits) {
            spendLimits(Arrays.asList(spendLimits));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spendLimits(Consumer<SpendLimit.Builder>... spendLimits) {
            spendLimits(Stream.of(spendLimits).map(c -> SpendLimit.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeSpendLimitsResponse build() {
            return new DescribeSpendLimitsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
