/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeVerifiedDestinationNumbersRequest extends PinpointSmsVoiceV2Request implements
        ToCopyableBuilder<DescribeVerifiedDestinationNumbersRequest.Builder, DescribeVerifiedDestinationNumbersRequest> {
    private static final SdkField<List<String>> VERIFIED_DESTINATION_NUMBER_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("VerifiedDestinationNumberIds")
            .getter(getter(DescribeVerifiedDestinationNumbersRequest::verifiedDestinationNumberIds))
            .setter(setter(Builder::verifiedDestinationNumberIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedDestinationNumberIds")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> DESTINATION_PHONE_NUMBERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DestinationPhoneNumbers")
            .getter(getter(DescribeVerifiedDestinationNumbersRequest::destinationPhoneNumbers))
            .setter(setter(Builder::destinationPhoneNumbers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPhoneNumbers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<VerifiedDestinationNumberFilter>> FILTERS_FIELD = SdkField
            .<List<VerifiedDestinationNumberFilter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(DescribeVerifiedDestinationNumbersRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VerifiedDestinationNumberFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(VerifiedDestinationNumberFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeVerifiedDestinationNumbersRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(DescribeVerifiedDestinationNumbersRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            VERIFIED_DESTINATION_NUMBER_IDS_FIELD, DESTINATION_PHONE_NUMBERS_FIELD, FILTERS_FIELD, NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> verifiedDestinationNumberIds;

    private final List<String> destinationPhoneNumbers;

    private final List<VerifiedDestinationNumberFilter> filters;

    private final String nextToken;

    private final Integer maxResults;

    private DescribeVerifiedDestinationNumbersRequest(BuilderImpl builder) {
        super(builder);
        this.verifiedDestinationNumberIds = builder.verifiedDestinationNumberIds;
        this.destinationPhoneNumbers = builder.destinationPhoneNumbers;
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the VerifiedDestinationNumberIds property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasVerifiedDestinationNumberIds() {
        return verifiedDestinationNumberIds != null && !(verifiedDestinationNumberIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of VerifiedDestinationNumberid to retrieve.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVerifiedDestinationNumberIds} method.
     * </p>
     * 
     * @return An array of VerifiedDestinationNumberid to retrieve.
     */
    public final List<String> verifiedDestinationNumberIds() {
        return verifiedDestinationNumberIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the DestinationPhoneNumbers property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDestinationPhoneNumbers() {
        return destinationPhoneNumbers != null && !(destinationPhoneNumbers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of verified destination phone number, in E.164 format.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDestinationPhoneNumbers} method.
     * </p>
     * 
     * @return An array of verified destination phone number, in E.164 format.
     */
    public final List<String> destinationPhoneNumbers() {
        return destinationPhoneNumbers;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of VerifiedDestinationNumberFilter objects to filter the results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return An array of VerifiedDestinationNumberFilter objects to filter the results.
     */
    public final List<VerifiedDestinationNumberFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * The token to be used for the next set of paginated results. You don't need to supply a value for this field in
     * the initial request.
     * </p>
     * 
     * @return The token to be used for the next set of paginated results. You don't need to supply a value for this
     *         field in the initial request.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return per each request.
     * </p>
     * 
     * @return The maximum number of results to return per each request.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasVerifiedDestinationNumberIds() ? verifiedDestinationNumberIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDestinationPhoneNumbers() ? destinationPhoneNumbers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVerifiedDestinationNumbersRequest)) {
            return false;
        }
        DescribeVerifiedDestinationNumbersRequest other = (DescribeVerifiedDestinationNumbersRequest) obj;
        return hasVerifiedDestinationNumberIds() == other.hasVerifiedDestinationNumberIds()
                && Objects.equals(verifiedDestinationNumberIds(), other.verifiedDestinationNumberIds())
                && hasDestinationPhoneNumbers() == other.hasDestinationPhoneNumbers()
                && Objects.equals(destinationPhoneNumbers(), other.destinationPhoneNumbers())
                && hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeVerifiedDestinationNumbersRequest")
                .add("VerifiedDestinationNumberIds", hasVerifiedDestinationNumberIds() ? verifiedDestinationNumberIds() : null)
                .add("DestinationPhoneNumbers", hasDestinationPhoneNumbers() ? destinationPhoneNumbers() : null)
                .add("Filters", hasFilters() ? filters() : null).add("NextToken", nextToken()).add("MaxResults", maxResults())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VerifiedDestinationNumberIds":
            return Optional.ofNullable(clazz.cast(verifiedDestinationNumberIds()));
        case "DestinationPhoneNumbers":
            return Optional.ofNullable(clazz.cast(destinationPhoneNumbers()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VerifiedDestinationNumberIds", VERIFIED_DESTINATION_NUMBER_IDS_FIELD);
        map.put("DestinationPhoneNumbers", DESTINATION_PHONE_NUMBERS_FIELD);
        map.put("Filters", FILTERS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeVerifiedDestinationNumbersRequest, T> g) {
        return obj -> g.apply((DescribeVerifiedDestinationNumbersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PinpointSmsVoiceV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeVerifiedDestinationNumbersRequest> {
        /**
         * <p>
         * An array of VerifiedDestinationNumberid to retrieve.
         * </p>
         * 
         * @param verifiedDestinationNumberIds
         *        An array of VerifiedDestinationNumberid to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verifiedDestinationNumberIds(Collection<String> verifiedDestinationNumberIds);

        /**
         * <p>
         * An array of VerifiedDestinationNumberid to retrieve.
         * </p>
         * 
         * @param verifiedDestinationNumberIds
         *        An array of VerifiedDestinationNumberid to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verifiedDestinationNumberIds(String... verifiedDestinationNumberIds);

        /**
         * <p>
         * An array of verified destination phone number, in E.164 format.
         * </p>
         * 
         * @param destinationPhoneNumbers
         *        An array of verified destination phone number, in E.164 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPhoneNumbers(Collection<String> destinationPhoneNumbers);

        /**
         * <p>
         * An array of verified destination phone number, in E.164 format.
         * </p>
         * 
         * @param destinationPhoneNumbers
         *        An array of verified destination phone number, in E.164 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPhoneNumbers(String... destinationPhoneNumbers);

        /**
         * <p>
         * An array of VerifiedDestinationNumberFilter objects to filter the results.
         * </p>
         * 
         * @param filters
         *        An array of VerifiedDestinationNumberFilter objects to filter the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<VerifiedDestinationNumberFilter> filters);

        /**
         * <p>
         * An array of VerifiedDestinationNumberFilter objects to filter the results.
         * </p>
         * 
         * @param filters
         *        An array of VerifiedDestinationNumberFilter objects to filter the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(VerifiedDestinationNumberFilter... filters);

        /**
         * <p>
         * An array of VerifiedDestinationNumberFilter objects to filter the results.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.VerifiedDestinationNumberFilter.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.VerifiedDestinationNumberFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.VerifiedDestinationNumberFilter.Builder#build()}
         * is called immediately and its result is passed to {@link #filters(List<VerifiedDestinationNumberFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.VerifiedDestinationNumberFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<VerifiedDestinationNumberFilter>)
         */
        Builder filters(Consumer<VerifiedDestinationNumberFilter.Builder>... filters);

        /**
         * <p>
         * The token to be used for the next set of paginated results. You don't need to supply a value for this field
         * in the initial request.
         * </p>
         * 
         * @param nextToken
         *        The token to be used for the next set of paginated results. You don't need to supply a value for this
         *        field in the initial request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return per each request.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return per each request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Request.BuilderImpl implements Builder {
        private List<String> verifiedDestinationNumberIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> destinationPhoneNumbers = DefaultSdkAutoConstructList.getInstance();

        private List<VerifiedDestinationNumberFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVerifiedDestinationNumbersRequest model) {
            super(model);
            verifiedDestinationNumberIds(model.verifiedDestinationNumberIds);
            destinationPhoneNumbers(model.destinationPhoneNumbers);
            filters(model.filters);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final Collection<String> getVerifiedDestinationNumberIds() {
            if (verifiedDestinationNumberIds instanceof SdkAutoConstructList) {
                return null;
            }
            return verifiedDestinationNumberIds;
        }

        public final void setVerifiedDestinationNumberIds(Collection<String> verifiedDestinationNumberIds) {
            this.verifiedDestinationNumberIds = VerifiedDestinationNumberIdListCopier.copy(verifiedDestinationNumberIds);
        }

        @Override
        public final Builder verifiedDestinationNumberIds(Collection<String> verifiedDestinationNumberIds) {
            this.verifiedDestinationNumberIds = VerifiedDestinationNumberIdListCopier.copy(verifiedDestinationNumberIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder verifiedDestinationNumberIds(String... verifiedDestinationNumberIds) {
            verifiedDestinationNumberIds(Arrays.asList(verifiedDestinationNumberIds));
            return this;
        }

        public final Collection<String> getDestinationPhoneNumbers() {
            if (destinationPhoneNumbers instanceof SdkAutoConstructList) {
                return null;
            }
            return destinationPhoneNumbers;
        }

        public final void setDestinationPhoneNumbers(Collection<String> destinationPhoneNumbers) {
            this.destinationPhoneNumbers = DestinationPhoneNumberListCopier.copy(destinationPhoneNumbers);
        }

        @Override
        public final Builder destinationPhoneNumbers(Collection<String> destinationPhoneNumbers) {
            this.destinationPhoneNumbers = DestinationPhoneNumberListCopier.copy(destinationPhoneNumbers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationPhoneNumbers(String... destinationPhoneNumbers) {
            destinationPhoneNumbers(Arrays.asList(destinationPhoneNumbers));
            return this;
        }

        public final List<VerifiedDestinationNumberFilter.Builder> getFilters() {
            List<VerifiedDestinationNumberFilter.Builder> result = VerifiedDestinationNumberFilterListCopier
                    .copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<VerifiedDestinationNumberFilter.BuilderImpl> filters) {
            this.filters = VerifiedDestinationNumberFilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<VerifiedDestinationNumberFilter> filters) {
            this.filters = VerifiedDestinationNumberFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(VerifiedDestinationNumberFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<VerifiedDestinationNumberFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> VerifiedDestinationNumberFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeVerifiedDestinationNumbersRequest build() {
            return new DescribeVerifiedDestinationNumbersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
