/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisassociateOriginationIdentityResponse extends PinpointSmsVoiceV2Response implements
        ToCopyableBuilder<DisassociateOriginationIdentityResponse.Builder, DisassociateOriginationIdentityResponse> {
    private static final SdkField<String> POOL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PoolArn").getter(getter(DisassociateOriginationIdentityResponse::poolArn))
            .setter(setter(Builder::poolArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolArn").build()).build();

    private static final SdkField<String> POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("PoolId")
            .getter(getter(DisassociateOriginationIdentityResponse::poolId)).setter(setter(Builder::poolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolId").build()).build();

    private static final SdkField<String> ORIGINATION_IDENTITY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OriginationIdentityArn").getter(getter(DisassociateOriginationIdentityResponse::originationIdentityArn))
            .setter(setter(Builder::originationIdentityArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginationIdentityArn").build())
            .build();

    private static final SdkField<String> ORIGINATION_IDENTITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OriginationIdentity").getter(getter(DisassociateOriginationIdentityResponse::originationIdentity))
            .setter(setter(Builder::originationIdentity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginationIdentity").build())
            .build();

    private static final SdkField<String> ISO_COUNTRY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IsoCountryCode").getter(getter(DisassociateOriginationIdentityResponse::isoCountryCode))
            .setter(setter(Builder::isoCountryCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsoCountryCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POOL_ARN_FIELD, POOL_ID_FIELD,
            ORIGINATION_IDENTITY_ARN_FIELD, ORIGINATION_IDENTITY_FIELD, ISO_COUNTRY_CODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String poolArn;

    private final String poolId;

    private final String originationIdentityArn;

    private final String originationIdentity;

    private final String isoCountryCode;

    private DisassociateOriginationIdentityResponse(BuilderImpl builder) {
        super(builder);
        this.poolArn = builder.poolArn;
        this.poolId = builder.poolId;
        this.originationIdentityArn = builder.originationIdentityArn;
        this.originationIdentity = builder.originationIdentity;
        this.isoCountryCode = builder.isoCountryCode;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the pool.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the pool.
     */
    public final String poolArn() {
        return poolArn;
    }

    /**
     * <p>
     * The PoolId of the pool no longer associated with the origination identity.
     * </p>
     * 
     * @return The PoolId of the pool no longer associated with the origination identity.
     */
    public final String poolId() {
        return poolId;
    }

    /**
     * <p>
     * The PhoneNumberArn or SenderIdArn of the origination identity.
     * </p>
     * 
     * @return The PhoneNumberArn or SenderIdArn of the origination identity.
     */
    public final String originationIdentityArn() {
        return originationIdentityArn;
    }

    /**
     * <p>
     * The PhoneNumberId or SenderId of the origination identity.
     * </p>
     * 
     * @return The PhoneNumberId or SenderId of the origination identity.
     */
    public final String originationIdentity() {
        return originationIdentity;
    }

    /**
     * <p>
     * The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.
     * </p>
     * 
     * @return The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.
     */
    public final String isoCountryCode() {
        return isoCountryCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(poolArn());
        hashCode = 31 * hashCode + Objects.hashCode(poolId());
        hashCode = 31 * hashCode + Objects.hashCode(originationIdentityArn());
        hashCode = 31 * hashCode + Objects.hashCode(originationIdentity());
        hashCode = 31 * hashCode + Objects.hashCode(isoCountryCode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateOriginationIdentityResponse)) {
            return false;
        }
        DisassociateOriginationIdentityResponse other = (DisassociateOriginationIdentityResponse) obj;
        return Objects.equals(poolArn(), other.poolArn()) && Objects.equals(poolId(), other.poolId())
                && Objects.equals(originationIdentityArn(), other.originationIdentityArn())
                && Objects.equals(originationIdentity(), other.originationIdentity())
                && Objects.equals(isoCountryCode(), other.isoCountryCode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisassociateOriginationIdentityResponse").add("PoolArn", poolArn()).add("PoolId", poolId())
                .add("OriginationIdentityArn", originationIdentityArn()).add("OriginationIdentity", originationIdentity())
                .add("IsoCountryCode", isoCountryCode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PoolArn":
            return Optional.ofNullable(clazz.cast(poolArn()));
        case "PoolId":
            return Optional.ofNullable(clazz.cast(poolId()));
        case "OriginationIdentityArn":
            return Optional.ofNullable(clazz.cast(originationIdentityArn()));
        case "OriginationIdentity":
            return Optional.ofNullable(clazz.cast(originationIdentity()));
        case "IsoCountryCode":
            return Optional.ofNullable(clazz.cast(isoCountryCode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PoolArn", POOL_ARN_FIELD);
        map.put("PoolId", POOL_ID_FIELD);
        map.put("OriginationIdentityArn", ORIGINATION_IDENTITY_ARN_FIELD);
        map.put("OriginationIdentity", ORIGINATION_IDENTITY_FIELD);
        map.put("IsoCountryCode", ISO_COUNTRY_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DisassociateOriginationIdentityResponse, T> g) {
        return obj -> g.apply((DisassociateOriginationIdentityResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PinpointSmsVoiceV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DisassociateOriginationIdentityResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the pool.
         * </p>
         * 
         * @param poolArn
         *        The Amazon Resource Name (ARN) of the pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolArn(String poolArn);

        /**
         * <p>
         * The PoolId of the pool no longer associated with the origination identity.
         * </p>
         * 
         * @param poolId
         *        The PoolId of the pool no longer associated with the origination identity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolId(String poolId);

        /**
         * <p>
         * The PhoneNumberArn or SenderIdArn of the origination identity.
         * </p>
         * 
         * @param originationIdentityArn
         *        The PhoneNumberArn or SenderIdArn of the origination identity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originationIdentityArn(String originationIdentityArn);

        /**
         * <p>
         * The PhoneNumberId or SenderId of the origination identity.
         * </p>
         * 
         * @param originationIdentity
         *        The PhoneNumberId or SenderId of the origination identity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originationIdentity(String originationIdentity);

        /**
         * <p>
         * The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.
         * </p>
         * 
         * @param isoCountryCode
         *        The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isoCountryCode(String isoCountryCode);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Response.BuilderImpl implements Builder {
        private String poolArn;

        private String poolId;

        private String originationIdentityArn;

        private String originationIdentity;

        private String isoCountryCode;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateOriginationIdentityResponse model) {
            super(model);
            poolArn(model.poolArn);
            poolId(model.poolId);
            originationIdentityArn(model.originationIdentityArn);
            originationIdentity(model.originationIdentity);
            isoCountryCode(model.isoCountryCode);
        }

        public final String getPoolArn() {
            return poolArn;
        }

        public final void setPoolArn(String poolArn) {
            this.poolArn = poolArn;
        }

        @Override
        public final Builder poolArn(String poolArn) {
            this.poolArn = poolArn;
            return this;
        }

        public final String getPoolId() {
            return poolId;
        }

        public final void setPoolId(String poolId) {
            this.poolId = poolId;
        }

        @Override
        public final Builder poolId(String poolId) {
            this.poolId = poolId;
            return this;
        }

        public final String getOriginationIdentityArn() {
            return originationIdentityArn;
        }

        public final void setOriginationIdentityArn(String originationIdentityArn) {
            this.originationIdentityArn = originationIdentityArn;
        }

        @Override
        public final Builder originationIdentityArn(String originationIdentityArn) {
            this.originationIdentityArn = originationIdentityArn;
            return this;
        }

        public final String getOriginationIdentity() {
            return originationIdentity;
        }

        public final void setOriginationIdentity(String originationIdentity) {
            this.originationIdentity = originationIdentity;
        }

        @Override
        public final Builder originationIdentity(String originationIdentity) {
            this.originationIdentity = originationIdentity;
            return this;
        }

        public final String getIsoCountryCode() {
            return isoCountryCode;
        }

        public final void setIsoCountryCode(String isoCountryCode) {
            this.isoCountryCode = isoCountryCode;
        }

        @Override
        public final Builder isoCountryCode(String isoCountryCode) {
            this.isoCountryCode = isoCountryCode;
            return this;
        }

        @Override
        public DisassociateOriginationIdentityResponse build() {
            return new DisassociateOriginationIdentityResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
