/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutProtectConfigurationRuleSetNumberOverrideRequest extends PinpointSmsVoiceV2Request
        implements
        ToCopyableBuilder<PutProtectConfigurationRuleSetNumberOverrideRequest.Builder, PutProtectConfigurationRuleSetNumberOverrideRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(PutProtectConfigurationRuleSetNumberOverrideRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> PROTECT_CONFIGURATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProtectConfigurationId")
            .getter(getter(PutProtectConfigurationRuleSetNumberOverrideRequest::protectConfigurationId))
            .setter(setter(Builder::protectConfigurationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectConfigurationId").build())
            .build();

    private static final SdkField<String> DESTINATION_PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationPhoneNumber")
            .getter(getter(PutProtectConfigurationRuleSetNumberOverrideRequest::destinationPhoneNumber))
            .setter(setter(Builder::destinationPhoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPhoneNumber").build())
            .build();

    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Action")
            .getter(getter(PutProtectConfigurationRuleSetNumberOverrideRequest::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<Instant> EXPIRATION_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ExpirationTimestamp")
            .getter(getter(PutProtectConfigurationRuleSetNumberOverrideRequest::expirationTimestamp))
            .setter(setter(Builder::expirationTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationTimestamp").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            PROTECT_CONFIGURATION_ID_FIELD, DESTINATION_PHONE_NUMBER_FIELD, ACTION_FIELD, EXPIRATION_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final String protectConfigurationId;

    private final String destinationPhoneNumber;

    private final String action;

    private final Instant expirationTimestamp;

    private PutProtectConfigurationRuleSetNumberOverrideRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.protectConfigurationId = builder.protectConfigurationId;
        this.destinationPhoneNumber = builder.destinationPhoneNumber;
        this.action = builder.action;
        this.expirationTimestamp = builder.expirationTimestamp;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don't specify
     * a client token, a randomly generated token is used for the request to ensure idempotency.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don't
     *         specify a client token, a randomly generated token is used for the request to ensure idempotency.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The unique identifier for the protect configuration.
     * </p>
     * 
     * @return The unique identifier for the protect configuration.
     */
    public final String protectConfigurationId() {
        return protectConfigurationId;
    }

    /**
     * <p>
     * The destination phone number in E.164 format.
     * </p>
     * 
     * @return The destination phone number in E.164 format.
     */
    public final String destinationPhoneNumber() {
        return destinationPhoneNumber;
    }

    /**
     * <p>
     * The action for the rule to either block or allow messages to the destination phone number.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link ProtectConfigurationRuleOverrideAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #actionAsString}.
     * </p>
     * 
     * @return The action for the rule to either block or allow messages to the destination phone number.
     * @see ProtectConfigurationRuleOverrideAction
     */
    public final ProtectConfigurationRuleOverrideAction action() {
        return ProtectConfigurationRuleOverrideAction.fromValue(action);
    }

    /**
     * <p>
     * The action for the rule to either block or allow messages to the destination phone number.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link ProtectConfigurationRuleOverrideAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #actionAsString}.
     * </p>
     * 
     * @return The action for the rule to either block or allow messages to the destination phone number.
     * @see ProtectConfigurationRuleOverrideAction
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * <p>
     * The time the rule will expire at. If <code>ExpirationTimestamp</code> is not set then the rule does not expire.
     * </p>
     * 
     * @return The time the rule will expire at. If <code>ExpirationTimestamp</code> is not set then the rule does not
     *         expire.
     */
    public final Instant expirationTimestamp() {
        return expirationTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(protectConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(destinationPhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(expirationTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutProtectConfigurationRuleSetNumberOverrideRequest)) {
            return false;
        }
        PutProtectConfigurationRuleSetNumberOverrideRequest other = (PutProtectConfigurationRuleSetNumberOverrideRequest) obj;
        return Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(protectConfigurationId(), other.protectConfigurationId())
                && Objects.equals(destinationPhoneNumber(), other.destinationPhoneNumber())
                && Objects.equals(actionAsString(), other.actionAsString())
                && Objects.equals(expirationTimestamp(), other.expirationTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutProtectConfigurationRuleSetNumberOverrideRequest").add("ClientToken", clientToken())
                .add("ProtectConfigurationId", protectConfigurationId()).add("DestinationPhoneNumber", destinationPhoneNumber())
                .add("Action", actionAsString()).add("ExpirationTimestamp", expirationTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "ProtectConfigurationId":
            return Optional.ofNullable(clazz.cast(protectConfigurationId()));
        case "DestinationPhoneNumber":
            return Optional.ofNullable(clazz.cast(destinationPhoneNumber()));
        case "Action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "ExpirationTimestamp":
            return Optional.ofNullable(clazz.cast(expirationTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("ProtectConfigurationId", PROTECT_CONFIGURATION_ID_FIELD);
        map.put("DestinationPhoneNumber", DESTINATION_PHONE_NUMBER_FIELD);
        map.put("Action", ACTION_FIELD);
        map.put("ExpirationTimestamp", EXPIRATION_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutProtectConfigurationRuleSetNumberOverrideRequest, T> g) {
        return obj -> g.apply((PutProtectConfigurationRuleSetNumberOverrideRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PinpointSmsVoiceV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, PutProtectConfigurationRuleSetNumberOverrideRequest> {
        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don't
         * specify a client token, a randomly generated token is used for the request to ensure idempotency.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you
         *        don't specify a client token, a randomly generated token is used for the request to ensure
         *        idempotency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The unique identifier for the protect configuration.
         * </p>
         * 
         * @param protectConfigurationId
         *        The unique identifier for the protect configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectConfigurationId(String protectConfigurationId);

        /**
         * <p>
         * The destination phone number in E.164 format.
         * </p>
         * 
         * @param destinationPhoneNumber
         *        The destination phone number in E.164 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPhoneNumber(String destinationPhoneNumber);

        /**
         * <p>
         * The action for the rule to either block or allow messages to the destination phone number.
         * </p>
         * 
         * @param action
         *        The action for the rule to either block or allow messages to the destination phone number.
         * @see ProtectConfigurationRuleOverrideAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtectConfigurationRuleOverrideAction
         */
        Builder action(String action);

        /**
         * <p>
         * The action for the rule to either block or allow messages to the destination phone number.
         * </p>
         * 
         * @param action
         *        The action for the rule to either block or allow messages to the destination phone number.
         * @see ProtectConfigurationRuleOverrideAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtectConfigurationRuleOverrideAction
         */
        Builder action(ProtectConfigurationRuleOverrideAction action);

        /**
         * <p>
         * The time the rule will expire at. If <code>ExpirationTimestamp</code> is not set then the rule does not
         * expire.
         * </p>
         * 
         * @param expirationTimestamp
         *        The time the rule will expire at. If <code>ExpirationTimestamp</code> is not set then the rule does
         *        not expire.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationTimestamp(Instant expirationTimestamp);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Request.BuilderImpl implements Builder {
        private String clientToken;

        private String protectConfigurationId;

        private String destinationPhoneNumber;

        private String action;

        private Instant expirationTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(PutProtectConfigurationRuleSetNumberOverrideRequest model) {
            super(model);
            clientToken(model.clientToken);
            protectConfigurationId(model.protectConfigurationId);
            destinationPhoneNumber(model.destinationPhoneNumber);
            action(model.action);
            expirationTimestamp(model.expirationTimestamp);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getProtectConfigurationId() {
            return protectConfigurationId;
        }

        public final void setProtectConfigurationId(String protectConfigurationId) {
            this.protectConfigurationId = protectConfigurationId;
        }

        @Override
        public final Builder protectConfigurationId(String protectConfigurationId) {
            this.protectConfigurationId = protectConfigurationId;
            return this;
        }

        public final String getDestinationPhoneNumber() {
            return destinationPhoneNumber;
        }

        public final void setDestinationPhoneNumber(String destinationPhoneNumber) {
            this.destinationPhoneNumber = destinationPhoneNumber;
        }

        @Override
        public final Builder destinationPhoneNumber(String destinationPhoneNumber) {
            this.destinationPhoneNumber = destinationPhoneNumber;
            return this;
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ProtectConfigurationRuleOverrideAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final Instant getExpirationTimestamp() {
            return expirationTimestamp;
        }

        public final void setExpirationTimestamp(Instant expirationTimestamp) {
            this.expirationTimestamp = expirationTimestamp;
        }

        @Override
        public final Builder expirationTimestamp(Instant expirationTimestamp) {
            this.expirationTimestamp = expirationTimestamp;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutProtectConfigurationRuleSetNumberOverrideRequest build() {
            return new PutProtectConfigurationRuleSetNumberOverrideRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
