/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutProtectConfigurationRuleSetNumberOverrideResponse extends PinpointSmsVoiceV2Response
        implements
        ToCopyableBuilder<PutProtectConfigurationRuleSetNumberOverrideResponse.Builder, PutProtectConfigurationRuleSetNumberOverrideResponse> {
    private static final SdkField<String> PROTECT_CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProtectConfigurationArn")
            .getter(getter(PutProtectConfigurationRuleSetNumberOverrideResponse::protectConfigurationArn))
            .setter(setter(Builder::protectConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectConfigurationArn").build())
            .build();

    private static final SdkField<String> PROTECT_CONFIGURATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProtectConfigurationId")
            .getter(getter(PutProtectConfigurationRuleSetNumberOverrideResponse::protectConfigurationId))
            .setter(setter(Builder::protectConfigurationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectConfigurationId").build())
            .build();

    private static final SdkField<String> DESTINATION_PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationPhoneNumber")
            .getter(getter(PutProtectConfigurationRuleSetNumberOverrideResponse::destinationPhoneNumber))
            .setter(setter(Builder::destinationPhoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPhoneNumber").build())
            .build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp")
            .getter(getter(PutProtectConfigurationRuleSetNumberOverrideResponse::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()).build();

    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Action")
            .getter(getter(PutProtectConfigurationRuleSetNumberOverrideResponse::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<String> ISO_COUNTRY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IsoCountryCode").getter(getter(PutProtectConfigurationRuleSetNumberOverrideResponse::isoCountryCode))
            .setter(setter(Builder::isoCountryCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsoCountryCode").build()).build();

    private static final SdkField<Instant> EXPIRATION_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ExpirationTimestamp")
            .getter(getter(PutProtectConfigurationRuleSetNumberOverrideResponse::expirationTimestamp))
            .setter(setter(Builder::expirationTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationTimestamp").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PROTECT_CONFIGURATION_ARN_FIELD, PROTECT_CONFIGURATION_ID_FIELD, DESTINATION_PHONE_NUMBER_FIELD,
            CREATED_TIMESTAMP_FIELD, ACTION_FIELD, ISO_COUNTRY_CODE_FIELD, EXPIRATION_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String protectConfigurationArn;

    private final String protectConfigurationId;

    private final String destinationPhoneNumber;

    private final Instant createdTimestamp;

    private final String action;

    private final String isoCountryCode;

    private final Instant expirationTimestamp;

    private PutProtectConfigurationRuleSetNumberOverrideResponse(BuilderImpl builder) {
        super(builder);
        this.protectConfigurationArn = builder.protectConfigurationArn;
        this.protectConfigurationId = builder.protectConfigurationId;
        this.destinationPhoneNumber = builder.destinationPhoneNumber;
        this.createdTimestamp = builder.createdTimestamp;
        this.action = builder.action;
        this.isoCountryCode = builder.isoCountryCode;
        this.expirationTimestamp = builder.expirationTimestamp;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the protect configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the protect configuration.
     */
    public final String protectConfigurationArn() {
        return protectConfigurationArn;
    }

    /**
     * <p>
     * The unique identifier for the protect configuration.
     * </p>
     * 
     * @return The unique identifier for the protect configuration.
     */
    public final String protectConfigurationId() {
        return protectConfigurationId;
    }

    /**
     * <p>
     * The destination phone number in E.164 format.
     * </p>
     * 
     * @return The destination phone number in E.164 format.
     */
    public final String destinationPhoneNumber() {
        return destinationPhoneNumber;
    }

    /**
     * <p>
     * The time when the rule was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.
     * </p>
     * 
     * @return The time when the rule was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a>
     *         format.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * The action for the rule to take.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link ProtectConfigurationRuleOverrideAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #actionAsString}.
     * </p>
     * 
     * @return The action for the rule to take.
     * @see ProtectConfigurationRuleOverrideAction
     */
    public final ProtectConfigurationRuleOverrideAction action() {
        return ProtectConfigurationRuleOverrideAction.fromValue(action);
    }

    /**
     * <p>
     * The action for the rule to take.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link ProtectConfigurationRuleOverrideAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #actionAsString}.
     * </p>
     * 
     * @return The action for the rule to take.
     * @see ProtectConfigurationRuleOverrideAction
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * <p>
     * The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.
     * </p>
     * 
     * @return The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.
     */
    public final String isoCountryCode() {
        return isoCountryCode;
    }

    /**
     * <p>
     * The time the rule will expire at.
     * </p>
     * 
     * @return The time the rule will expire at.
     */
    public final Instant expirationTimestamp() {
        return expirationTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(protectConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(protectConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(destinationPhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(isoCountryCode());
        hashCode = 31 * hashCode + Objects.hashCode(expirationTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutProtectConfigurationRuleSetNumberOverrideResponse)) {
            return false;
        }
        PutProtectConfigurationRuleSetNumberOverrideResponse other = (PutProtectConfigurationRuleSetNumberOverrideResponse) obj;
        return Objects.equals(protectConfigurationArn(), other.protectConfigurationArn())
                && Objects.equals(protectConfigurationId(), other.protectConfigurationId())
                && Objects.equals(destinationPhoneNumber(), other.destinationPhoneNumber())
                && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(actionAsString(), other.actionAsString())
                && Objects.equals(isoCountryCode(), other.isoCountryCode())
                && Objects.equals(expirationTimestamp(), other.expirationTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutProtectConfigurationRuleSetNumberOverrideResponse")
                .add("ProtectConfigurationArn", protectConfigurationArn())
                .add("ProtectConfigurationId", protectConfigurationId()).add("DestinationPhoneNumber", destinationPhoneNumber())
                .add("CreatedTimestamp", createdTimestamp()).add("Action", actionAsString())
                .add("IsoCountryCode", isoCountryCode()).add("ExpirationTimestamp", expirationTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProtectConfigurationArn":
            return Optional.ofNullable(clazz.cast(protectConfigurationArn()));
        case "ProtectConfigurationId":
            return Optional.ofNullable(clazz.cast(protectConfigurationId()));
        case "DestinationPhoneNumber":
            return Optional.ofNullable(clazz.cast(destinationPhoneNumber()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "Action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "IsoCountryCode":
            return Optional.ofNullable(clazz.cast(isoCountryCode()));
        case "ExpirationTimestamp":
            return Optional.ofNullable(clazz.cast(expirationTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProtectConfigurationArn", PROTECT_CONFIGURATION_ARN_FIELD);
        map.put("ProtectConfigurationId", PROTECT_CONFIGURATION_ID_FIELD);
        map.put("DestinationPhoneNumber", DESTINATION_PHONE_NUMBER_FIELD);
        map.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
        map.put("Action", ACTION_FIELD);
        map.put("IsoCountryCode", ISO_COUNTRY_CODE_FIELD);
        map.put("ExpirationTimestamp", EXPIRATION_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutProtectConfigurationRuleSetNumberOverrideResponse, T> g) {
        return obj -> g.apply((PutProtectConfigurationRuleSetNumberOverrideResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PinpointSmsVoiceV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, PutProtectConfigurationRuleSetNumberOverrideResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the protect configuration.
         * </p>
         * 
         * @param protectConfigurationArn
         *        The Amazon Resource Name (ARN) of the protect configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectConfigurationArn(String protectConfigurationArn);

        /**
         * <p>
         * The unique identifier for the protect configuration.
         * </p>
         * 
         * @param protectConfigurationId
         *        The unique identifier for the protect configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectConfigurationId(String protectConfigurationId);

        /**
         * <p>
         * The destination phone number in E.164 format.
         * </p>
         * 
         * @param destinationPhoneNumber
         *        The destination phone number in E.164 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPhoneNumber(String destinationPhoneNumber);

        /**
         * <p>
         * The time when the rule was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.
         * </p>
         * 
         * @param createdTimestamp
         *        The time when the rule was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a>
         *        format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * The action for the rule to take.
         * </p>
         * 
         * @param action
         *        The action for the rule to take.
         * @see ProtectConfigurationRuleOverrideAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtectConfigurationRuleOverrideAction
         */
        Builder action(String action);

        /**
         * <p>
         * The action for the rule to take.
         * </p>
         * 
         * @param action
         *        The action for the rule to take.
         * @see ProtectConfigurationRuleOverrideAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtectConfigurationRuleOverrideAction
         */
        Builder action(ProtectConfigurationRuleOverrideAction action);

        /**
         * <p>
         * The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.
         * </p>
         * 
         * @param isoCountryCode
         *        The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isoCountryCode(String isoCountryCode);

        /**
         * <p>
         * The time the rule will expire at.
         * </p>
         * 
         * @param expirationTimestamp
         *        The time the rule will expire at.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationTimestamp(Instant expirationTimestamp);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Response.BuilderImpl implements Builder {
        private String protectConfigurationArn;

        private String protectConfigurationId;

        private String destinationPhoneNumber;

        private Instant createdTimestamp;

        private String action;

        private String isoCountryCode;

        private Instant expirationTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(PutProtectConfigurationRuleSetNumberOverrideResponse model) {
            super(model);
            protectConfigurationArn(model.protectConfigurationArn);
            protectConfigurationId(model.protectConfigurationId);
            destinationPhoneNumber(model.destinationPhoneNumber);
            createdTimestamp(model.createdTimestamp);
            action(model.action);
            isoCountryCode(model.isoCountryCode);
            expirationTimestamp(model.expirationTimestamp);
        }

        public final String getProtectConfigurationArn() {
            return protectConfigurationArn;
        }

        public final void setProtectConfigurationArn(String protectConfigurationArn) {
            this.protectConfigurationArn = protectConfigurationArn;
        }

        @Override
        public final Builder protectConfigurationArn(String protectConfigurationArn) {
            this.protectConfigurationArn = protectConfigurationArn;
            return this;
        }

        public final String getProtectConfigurationId() {
            return protectConfigurationId;
        }

        public final void setProtectConfigurationId(String protectConfigurationId) {
            this.protectConfigurationId = protectConfigurationId;
        }

        @Override
        public final Builder protectConfigurationId(String protectConfigurationId) {
            this.protectConfigurationId = protectConfigurationId;
            return this;
        }

        public final String getDestinationPhoneNumber() {
            return destinationPhoneNumber;
        }

        public final void setDestinationPhoneNumber(String destinationPhoneNumber) {
            this.destinationPhoneNumber = destinationPhoneNumber;
        }

        @Override
        public final Builder destinationPhoneNumber(String destinationPhoneNumber) {
            this.destinationPhoneNumber = destinationPhoneNumber;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ProtectConfigurationRuleOverrideAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getIsoCountryCode() {
            return isoCountryCode;
        }

        public final void setIsoCountryCode(String isoCountryCode) {
            this.isoCountryCode = isoCountryCode;
        }

        @Override
        public final Builder isoCountryCode(String isoCountryCode) {
            this.isoCountryCode = isoCountryCode;
            return this;
        }

        public final Instant getExpirationTimestamp() {
            return expirationTimestamp;
        }

        public final void setExpirationTimestamp(Instant expirationTimestamp) {
            this.expirationTimestamp = expirationTimestamp;
        }

        @Override
        public final Builder expirationTimestamp(Instant expirationTimestamp) {
            this.expirationTimestamp = expirationTimestamp;
            return this;
        }

        @Override
        public PutProtectConfigurationRuleSetNumberOverrideResponse build() {
            return new PutProtectConfigurationRuleSetNumberOverrideResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
