/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutRegistrationFieldValueResponse extends PinpointSmsVoiceV2Response implements
        ToCopyableBuilder<PutRegistrationFieldValueResponse.Builder, PutRegistrationFieldValueResponse> {
    private static final SdkField<String> REGISTRATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegistrationArn").getter(getter(PutRegistrationFieldValueResponse::registrationArn))
            .setter(setter(Builder::registrationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationArn").build()).build();

    private static final SdkField<String> REGISTRATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegistrationId").getter(getter(PutRegistrationFieldValueResponse::registrationId))
            .setter(setter(Builder::registrationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationId").build()).build();

    private static final SdkField<Long> VERSION_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("VersionNumber").getter(getter(PutRegistrationFieldValueResponse::versionNumber))
            .setter(setter(Builder::versionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionNumber").build()).build();

    private static final SdkField<String> FIELD_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FieldPath").getter(getter(PutRegistrationFieldValueResponse::fieldPath))
            .setter(setter(Builder::fieldPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldPath").build()).build();

    private static final SdkField<List<String>> SELECT_CHOICES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SelectChoices")
            .getter(getter(PutRegistrationFieldValueResponse::selectChoices))
            .setter(setter(Builder::selectChoices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectChoices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TEXT_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TextValue").getter(getter(PutRegistrationFieldValueResponse::textValue))
            .setter(setter(Builder::textValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextValue").build()).build();

    private static final SdkField<String> REGISTRATION_ATTACHMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegistrationAttachmentId").getter(getter(PutRegistrationFieldValueResponse::registrationAttachmentId))
            .setter(setter(Builder::registrationAttachmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationAttachmentId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRATION_ARN_FIELD,
            REGISTRATION_ID_FIELD, VERSION_NUMBER_FIELD, FIELD_PATH_FIELD, SELECT_CHOICES_FIELD, TEXT_VALUE_FIELD,
            REGISTRATION_ATTACHMENT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String registrationArn;

    private final String registrationId;

    private final Long versionNumber;

    private final String fieldPath;

    private final List<String> selectChoices;

    private final String textValue;

    private final String registrationAttachmentId;

    private PutRegistrationFieldValueResponse(BuilderImpl builder) {
        super(builder);
        this.registrationArn = builder.registrationArn;
        this.registrationId = builder.registrationId;
        this.versionNumber = builder.versionNumber;
        this.fieldPath = builder.fieldPath;
        this.selectChoices = builder.selectChoices;
        this.textValue = builder.textValue;
        this.registrationAttachmentId = builder.registrationAttachmentId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the registration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the registration.
     */
    public final String registrationArn() {
        return registrationArn;
    }

    /**
     * <p>
     * The unique identifier for the registration.
     * </p>
     * 
     * @return The unique identifier for the registration.
     */
    public final String registrationId() {
        return registrationId;
    }

    /**
     * <p>
     * The version number of the registration.
     * </p>
     * 
     * @return The version number of the registration.
     */
    public final Long versionNumber() {
        return versionNumber;
    }

    /**
     * <p>
     * The path to the registration form field. You can use <a>DescribeRegistrationFieldDefinitions</a> for a list of
     * <b>FieldPaths</b>.
     * </p>
     * 
     * @return The path to the registration form field. You can use <a>DescribeRegistrationFieldDefinitions</a> for a
     *         list of <b>FieldPaths</b>.
     */
    public final String fieldPath() {
        return fieldPath;
    }

    /**
     * For responses, this returns true if the service returned a value for the SelectChoices property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSelectChoices() {
        return selectChoices != null && !(selectChoices instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of values for the form field.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSelectChoices} method.
     * </p>
     * 
     * @return An array of values for the form field.
     */
    public final List<String> selectChoices() {
        return selectChoices;
    }

    /**
     * <p>
     * The text data for a free form field.
     * </p>
     * 
     * @return The text data for a free form field.
     */
    public final String textValue() {
        return textValue;
    }

    /**
     * <p>
     * The unique identifier for the registration attachment.
     * </p>
     * 
     * @return The unique identifier for the registration attachment.
     */
    public final String registrationAttachmentId() {
        return registrationAttachmentId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(registrationArn());
        hashCode = 31 * hashCode + Objects.hashCode(registrationId());
        hashCode = 31 * hashCode + Objects.hashCode(versionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(fieldPath());
        hashCode = 31 * hashCode + Objects.hashCode(hasSelectChoices() ? selectChoices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(textValue());
        hashCode = 31 * hashCode + Objects.hashCode(registrationAttachmentId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRegistrationFieldValueResponse)) {
            return false;
        }
        PutRegistrationFieldValueResponse other = (PutRegistrationFieldValueResponse) obj;
        return Objects.equals(registrationArn(), other.registrationArn())
                && Objects.equals(registrationId(), other.registrationId())
                && Objects.equals(versionNumber(), other.versionNumber()) && Objects.equals(fieldPath(), other.fieldPath())
                && hasSelectChoices() == other.hasSelectChoices() && Objects.equals(selectChoices(), other.selectChoices())
                && Objects.equals(textValue(), other.textValue())
                && Objects.equals(registrationAttachmentId(), other.registrationAttachmentId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutRegistrationFieldValueResponse").add("RegistrationArn", registrationArn())
                .add("RegistrationId", registrationId()).add("VersionNumber", versionNumber()).add("FieldPath", fieldPath())
                .add("SelectChoices", hasSelectChoices() ? selectChoices() : null).add("TextValue", textValue())
                .add("RegistrationAttachmentId", registrationAttachmentId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RegistrationArn":
            return Optional.ofNullable(clazz.cast(registrationArn()));
        case "RegistrationId":
            return Optional.ofNullable(clazz.cast(registrationId()));
        case "VersionNumber":
            return Optional.ofNullable(clazz.cast(versionNumber()));
        case "FieldPath":
            return Optional.ofNullable(clazz.cast(fieldPath()));
        case "SelectChoices":
            return Optional.ofNullable(clazz.cast(selectChoices()));
        case "TextValue":
            return Optional.ofNullable(clazz.cast(textValue()));
        case "RegistrationAttachmentId":
            return Optional.ofNullable(clazz.cast(registrationAttachmentId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RegistrationArn", REGISTRATION_ARN_FIELD);
        map.put("RegistrationId", REGISTRATION_ID_FIELD);
        map.put("VersionNumber", VERSION_NUMBER_FIELD);
        map.put("FieldPath", FIELD_PATH_FIELD);
        map.put("SelectChoices", SELECT_CHOICES_FIELD);
        map.put("TextValue", TEXT_VALUE_FIELD);
        map.put("RegistrationAttachmentId", REGISTRATION_ATTACHMENT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutRegistrationFieldValueResponse, T> g) {
        return obj -> g.apply((PutRegistrationFieldValueResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PinpointSmsVoiceV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, PutRegistrationFieldValueResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the registration.
         * </p>
         * 
         * @param registrationArn
         *        The Amazon Resource Name (ARN) for the registration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationArn(String registrationArn);

        /**
         * <p>
         * The unique identifier for the registration.
         * </p>
         * 
         * @param registrationId
         *        The unique identifier for the registration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationId(String registrationId);

        /**
         * <p>
         * The version number of the registration.
         * </p>
         * 
         * @param versionNumber
         *        The version number of the registration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionNumber(Long versionNumber);

        /**
         * <p>
         * The path to the registration form field. You can use <a>DescribeRegistrationFieldDefinitions</a> for a list
         * of <b>FieldPaths</b>.
         * </p>
         * 
         * @param fieldPath
         *        The path to the registration form field. You can use <a>DescribeRegistrationFieldDefinitions</a> for a
         *        list of <b>FieldPaths</b>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldPath(String fieldPath);

        /**
         * <p>
         * An array of values for the form field.
         * </p>
         * 
         * @param selectChoices
         *        An array of values for the form field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectChoices(Collection<String> selectChoices);

        /**
         * <p>
         * An array of values for the form field.
         * </p>
         * 
         * @param selectChoices
         *        An array of values for the form field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectChoices(String... selectChoices);

        /**
         * <p>
         * The text data for a free form field.
         * </p>
         * 
         * @param textValue
         *        The text data for a free form field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textValue(String textValue);

        /**
         * <p>
         * The unique identifier for the registration attachment.
         * </p>
         * 
         * @param registrationAttachmentId
         *        The unique identifier for the registration attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationAttachmentId(String registrationAttachmentId);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Response.BuilderImpl implements Builder {
        private String registrationArn;

        private String registrationId;

        private Long versionNumber;

        private String fieldPath;

        private List<String> selectChoices = DefaultSdkAutoConstructList.getInstance();

        private String textValue;

        private String registrationAttachmentId;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRegistrationFieldValueResponse model) {
            super(model);
            registrationArn(model.registrationArn);
            registrationId(model.registrationId);
            versionNumber(model.versionNumber);
            fieldPath(model.fieldPath);
            selectChoices(model.selectChoices);
            textValue(model.textValue);
            registrationAttachmentId(model.registrationAttachmentId);
        }

        public final String getRegistrationArn() {
            return registrationArn;
        }

        public final void setRegistrationArn(String registrationArn) {
            this.registrationArn = registrationArn;
        }

        @Override
        public final Builder registrationArn(String registrationArn) {
            this.registrationArn = registrationArn;
            return this;
        }

        public final String getRegistrationId() {
            return registrationId;
        }

        public final void setRegistrationId(String registrationId) {
            this.registrationId = registrationId;
        }

        @Override
        public final Builder registrationId(String registrationId) {
            this.registrationId = registrationId;
            return this;
        }

        public final Long getVersionNumber() {
            return versionNumber;
        }

        public final void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        @Override
        public final Builder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        public final String getFieldPath() {
            return fieldPath;
        }

        public final void setFieldPath(String fieldPath) {
            this.fieldPath = fieldPath;
        }

        @Override
        public final Builder fieldPath(String fieldPath) {
            this.fieldPath = fieldPath;
            return this;
        }

        public final Collection<String> getSelectChoices() {
            if (selectChoices instanceof SdkAutoConstructList) {
                return null;
            }
            return selectChoices;
        }

        public final void setSelectChoices(Collection<String> selectChoices) {
            this.selectChoices = SelectChoiceListCopier.copy(selectChoices);
        }

        @Override
        public final Builder selectChoices(Collection<String> selectChoices) {
            this.selectChoices = SelectChoiceListCopier.copy(selectChoices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectChoices(String... selectChoices) {
            selectChoices(Arrays.asList(selectChoices));
            return this;
        }

        public final String getTextValue() {
            return textValue;
        }

        public final void setTextValue(String textValue) {
            this.textValue = textValue;
        }

        @Override
        public final Builder textValue(String textValue) {
            this.textValue = textValue;
            return this;
        }

        public final String getRegistrationAttachmentId() {
            return registrationAttachmentId;
        }

        public final void setRegistrationAttachmentId(String registrationAttachmentId) {
            this.registrationAttachmentId = registrationAttachmentId;
        }

        @Override
        public final Builder registrationAttachmentId(String registrationAttachmentId) {
            this.registrationAttachmentId = registrationAttachmentId;
            return this;
        }

        @Override
        public PutRegistrationFieldValueResponse build() {
            return new PutRegistrationFieldValueResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
