/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides help information on the registration field.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegistrationFieldDisplayHints implements SdkPojo, Serializable,
        ToCopyableBuilder<RegistrationFieldDisplayHints.Builder, RegistrationFieldDisplayHints> {
    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Title")
            .getter(getter(RegistrationFieldDisplayHints::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<String> SHORT_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ShortDescription").getter(getter(RegistrationFieldDisplayHints::shortDescription))
            .setter(setter(Builder::shortDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShortDescription").build()).build();

    private static final SdkField<String> LONG_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LongDescription").getter(getter(RegistrationFieldDisplayHints::longDescription))
            .setter(setter(Builder::longDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LongDescription").build()).build();

    private static final SdkField<String> DOCUMENTATION_TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentationTitle").getter(getter(RegistrationFieldDisplayHints::documentationTitle))
            .setter(setter(Builder::documentationTitle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentationTitle").build())
            .build();

    private static final SdkField<String> DOCUMENTATION_LINK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentationLink").getter(getter(RegistrationFieldDisplayHints::documentationLink))
            .setter(setter(Builder::documentationLink))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentationLink").build()).build();

    private static final SdkField<List<SelectOptionDescription>> SELECT_OPTION_DESCRIPTIONS_FIELD = SdkField
            .<List<SelectOptionDescription>> builder(MarshallingType.LIST)
            .memberName("SelectOptionDescriptions")
            .getter(getter(RegistrationFieldDisplayHints::selectOptionDescriptions))
            .setter(setter(Builder::selectOptionDescriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectOptionDescriptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SelectOptionDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(SelectOptionDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TEXT_VALIDATION_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TextValidationDescription").getter(getter(RegistrationFieldDisplayHints::textValidationDescription))
            .setter(setter(Builder::textValidationDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextValidationDescription").build())
            .build();

    private static final SdkField<String> EXAMPLE_TEXT_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExampleTextValue").getter(getter(RegistrationFieldDisplayHints::exampleTextValue))
            .setter(setter(Builder::exampleTextValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExampleTextValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_FIELD,
            SHORT_DESCRIPTION_FIELD, LONG_DESCRIPTION_FIELD, DOCUMENTATION_TITLE_FIELD, DOCUMENTATION_LINK_FIELD,
            SELECT_OPTION_DESCRIPTIONS_FIELD, TEXT_VALIDATION_DESCRIPTION_FIELD, EXAMPLE_TEXT_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String title;

    private final String shortDescription;

    private final String longDescription;

    private final String documentationTitle;

    private final String documentationLink;

    private final List<SelectOptionDescription> selectOptionDescriptions;

    private final String textValidationDescription;

    private final String exampleTextValue;

    private RegistrationFieldDisplayHints(BuilderImpl builder) {
        this.title = builder.title;
        this.shortDescription = builder.shortDescription;
        this.longDescription = builder.longDescription;
        this.documentationTitle = builder.documentationTitle;
        this.documentationLink = builder.documentationLink;
        this.selectOptionDescriptions = builder.selectOptionDescriptions;
        this.textValidationDescription = builder.textValidationDescription;
        this.exampleTextValue = builder.exampleTextValue;
    }

    /**
     * <p>
     * The title of the display hint.
     * </p>
     * 
     * @return The title of the display hint.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * A short description of the display hint.
     * </p>
     * 
     * @return A short description of the display hint.
     */
    public final String shortDescription() {
        return shortDescription;
    }

    /**
     * <p>
     * A full description of the display hint.
     * </p>
     * 
     * @return A full description of the display hint.
     */
    public final String longDescription() {
        return longDescription;
    }

    /**
     * <p>
     * The title of the document the display hint is associated with.
     * </p>
     * 
     * @return The title of the document the display hint is associated with.
     */
    public final String documentationTitle() {
        return documentationTitle;
    }

    /**
     * <p>
     * The link to the document the display hint is associated with.
     * </p>
     * 
     * @return The link to the document the display hint is associated with.
     */
    public final String documentationLink() {
        return documentationLink;
    }

    /**
     * For responses, this returns true if the service returned a value for the SelectOptionDescriptions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSelectOptionDescriptions() {
        return selectOptionDescriptions != null && !(selectOptionDescriptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of SelectOptionDescription objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSelectOptionDescriptions} method.
     * </p>
     * 
     * @return An array of SelectOptionDescription objects.
     */
    public final List<SelectOptionDescription> selectOptionDescriptions() {
        return selectOptionDescriptions;
    }

    /**
     * <p>
     * The validation rules for the text field.
     * </p>
     * 
     * @return The validation rules for the text field.
     */
    public final String textValidationDescription() {
        return textValidationDescription;
    }

    /**
     * <p>
     * Example text of what the value of a field should contain.
     * </p>
     * 
     * @return Example text of what the value of a field should contain.
     */
    public final String exampleTextValue() {
        return exampleTextValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(shortDescription());
        hashCode = 31 * hashCode + Objects.hashCode(longDescription());
        hashCode = 31 * hashCode + Objects.hashCode(documentationTitle());
        hashCode = 31 * hashCode + Objects.hashCode(documentationLink());
        hashCode = 31 * hashCode + Objects.hashCode(hasSelectOptionDescriptions() ? selectOptionDescriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(textValidationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(exampleTextValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegistrationFieldDisplayHints)) {
            return false;
        }
        RegistrationFieldDisplayHints other = (RegistrationFieldDisplayHints) obj;
        return Objects.equals(title(), other.title()) && Objects.equals(shortDescription(), other.shortDescription())
                && Objects.equals(longDescription(), other.longDescription())
                && Objects.equals(documentationTitle(), other.documentationTitle())
                && Objects.equals(documentationLink(), other.documentationLink())
                && hasSelectOptionDescriptions() == other.hasSelectOptionDescriptions()
                && Objects.equals(selectOptionDescriptions(), other.selectOptionDescriptions())
                && Objects.equals(textValidationDescription(), other.textValidationDescription())
                && Objects.equals(exampleTextValue(), other.exampleTextValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegistrationFieldDisplayHints").add("Title", title())
                .add("ShortDescription", shortDescription()).add("LongDescription", longDescription())
                .add("DocumentationTitle", documentationTitle()).add("DocumentationLink", documentationLink())
                .add("SelectOptionDescriptions", hasSelectOptionDescriptions() ? selectOptionDescriptions() : null)
                .add("TextValidationDescription", textValidationDescription()).add("ExampleTextValue", exampleTextValue())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "ShortDescription":
            return Optional.ofNullable(clazz.cast(shortDescription()));
        case "LongDescription":
            return Optional.ofNullable(clazz.cast(longDescription()));
        case "DocumentationTitle":
            return Optional.ofNullable(clazz.cast(documentationTitle()));
        case "DocumentationLink":
            return Optional.ofNullable(clazz.cast(documentationLink()));
        case "SelectOptionDescriptions":
            return Optional.ofNullable(clazz.cast(selectOptionDescriptions()));
        case "TextValidationDescription":
            return Optional.ofNullable(clazz.cast(textValidationDescription()));
        case "ExampleTextValue":
            return Optional.ofNullable(clazz.cast(exampleTextValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Title", TITLE_FIELD);
        map.put("ShortDescription", SHORT_DESCRIPTION_FIELD);
        map.put("LongDescription", LONG_DESCRIPTION_FIELD);
        map.put("DocumentationTitle", DOCUMENTATION_TITLE_FIELD);
        map.put("DocumentationLink", DOCUMENTATION_LINK_FIELD);
        map.put("SelectOptionDescriptions", SELECT_OPTION_DESCRIPTIONS_FIELD);
        map.put("TextValidationDescription", TEXT_VALIDATION_DESCRIPTION_FIELD);
        map.put("ExampleTextValue", EXAMPLE_TEXT_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegistrationFieldDisplayHints, T> g) {
        return obj -> g.apply((RegistrationFieldDisplayHints) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RegistrationFieldDisplayHints> {
        /**
         * <p>
         * The title of the display hint.
         * </p>
         * 
         * @param title
         *        The title of the display hint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * A short description of the display hint.
         * </p>
         * 
         * @param shortDescription
         *        A short description of the display hint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shortDescription(String shortDescription);

        /**
         * <p>
         * A full description of the display hint.
         * </p>
         * 
         * @param longDescription
         *        A full description of the display hint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder longDescription(String longDescription);

        /**
         * <p>
         * The title of the document the display hint is associated with.
         * </p>
         * 
         * @param documentationTitle
         *        The title of the document the display hint is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentationTitle(String documentationTitle);

        /**
         * <p>
         * The link to the document the display hint is associated with.
         * </p>
         * 
         * @param documentationLink
         *        The link to the document the display hint is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentationLink(String documentationLink);

        /**
         * <p>
         * An array of SelectOptionDescription objects.
         * </p>
         * 
         * @param selectOptionDescriptions
         *        An array of SelectOptionDescription objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectOptionDescriptions(Collection<SelectOptionDescription> selectOptionDescriptions);

        /**
         * <p>
         * An array of SelectOptionDescription objects.
         * </p>
         * 
         * @param selectOptionDescriptions
         *        An array of SelectOptionDescription objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectOptionDescriptions(SelectOptionDescription... selectOptionDescriptions);

        /**
         * <p>
         * An array of SelectOptionDescription objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.SelectOptionDescription.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.SelectOptionDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.SelectOptionDescription.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #selectOptionDescriptions(List<SelectOptionDescription>)}.
         * 
         * @param selectOptionDescriptions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.SelectOptionDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #selectOptionDescriptions(java.util.Collection<SelectOptionDescription>)
         */
        Builder selectOptionDescriptions(Consumer<SelectOptionDescription.Builder>... selectOptionDescriptions);

        /**
         * <p>
         * The validation rules for the text field.
         * </p>
         * 
         * @param textValidationDescription
         *        The validation rules for the text field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textValidationDescription(String textValidationDescription);

        /**
         * <p>
         * Example text of what the value of a field should contain.
         * </p>
         * 
         * @param exampleTextValue
         *        Example text of what the value of a field should contain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exampleTextValue(String exampleTextValue);
    }

    static final class BuilderImpl implements Builder {
        private String title;

        private String shortDescription;

        private String longDescription;

        private String documentationTitle;

        private String documentationLink;

        private List<SelectOptionDescription> selectOptionDescriptions = DefaultSdkAutoConstructList.getInstance();

        private String textValidationDescription;

        private String exampleTextValue;

        private BuilderImpl() {
        }

        private BuilderImpl(RegistrationFieldDisplayHints model) {
            title(model.title);
            shortDescription(model.shortDescription);
            longDescription(model.longDescription);
            documentationTitle(model.documentationTitle);
            documentationLink(model.documentationLink);
            selectOptionDescriptions(model.selectOptionDescriptions);
            textValidationDescription(model.textValidationDescription);
            exampleTextValue(model.exampleTextValue);
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getShortDescription() {
            return shortDescription;
        }

        public final void setShortDescription(String shortDescription) {
            this.shortDescription = shortDescription;
        }

        @Override
        public final Builder shortDescription(String shortDescription) {
            this.shortDescription = shortDescription;
            return this;
        }

        public final String getLongDescription() {
            return longDescription;
        }

        public final void setLongDescription(String longDescription) {
            this.longDescription = longDescription;
        }

        @Override
        public final Builder longDescription(String longDescription) {
            this.longDescription = longDescription;
            return this;
        }

        public final String getDocumentationTitle() {
            return documentationTitle;
        }

        public final void setDocumentationTitle(String documentationTitle) {
            this.documentationTitle = documentationTitle;
        }

        @Override
        public final Builder documentationTitle(String documentationTitle) {
            this.documentationTitle = documentationTitle;
            return this;
        }

        public final String getDocumentationLink() {
            return documentationLink;
        }

        public final void setDocumentationLink(String documentationLink) {
            this.documentationLink = documentationLink;
        }

        @Override
        public final Builder documentationLink(String documentationLink) {
            this.documentationLink = documentationLink;
            return this;
        }

        public final List<SelectOptionDescription.Builder> getSelectOptionDescriptions() {
            List<SelectOptionDescription.Builder> result = SelectOptionDescriptionsListCopier
                    .copyToBuilder(this.selectOptionDescriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSelectOptionDescriptions(Collection<SelectOptionDescription.BuilderImpl> selectOptionDescriptions) {
            this.selectOptionDescriptions = SelectOptionDescriptionsListCopier.copyFromBuilder(selectOptionDescriptions);
        }

        @Override
        public final Builder selectOptionDescriptions(Collection<SelectOptionDescription> selectOptionDescriptions) {
            this.selectOptionDescriptions = SelectOptionDescriptionsListCopier.copy(selectOptionDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectOptionDescriptions(SelectOptionDescription... selectOptionDescriptions) {
            selectOptionDescriptions(Arrays.asList(selectOptionDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectOptionDescriptions(Consumer<SelectOptionDescription.Builder>... selectOptionDescriptions) {
            selectOptionDescriptions(Stream.of(selectOptionDescriptions)
                    .map(c -> SelectOptionDescription.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTextValidationDescription() {
            return textValidationDescription;
        }

        public final void setTextValidationDescription(String textValidationDescription) {
            this.textValidationDescription = textValidationDescription;
        }

        @Override
        public final Builder textValidationDescription(String textValidationDescription) {
            this.textValidationDescription = textValidationDescription;
            return this;
        }

        public final String getExampleTextValue() {
            return exampleTextValue;
        }

        public final void setExampleTextValue(String exampleTextValue) {
            this.exampleTextValue = exampleTextValue;
        }

        @Override
        public final Builder exampleTextValue(String exampleTextValue) {
            this.exampleTextValue = exampleTextValue;
            return this;
        }

        @Override
        public RegistrationFieldDisplayHints build() {
            return new RegistrationFieldDisplayHints(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
