/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides help information on the registration section.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegistrationSectionDisplayHints implements SdkPojo, Serializable,
        ToCopyableBuilder<RegistrationSectionDisplayHints.Builder, RegistrationSectionDisplayHints> {
    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Title")
            .getter(getter(RegistrationSectionDisplayHints::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<String> SHORT_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ShortDescription").getter(getter(RegistrationSectionDisplayHints::shortDescription))
            .setter(setter(Builder::shortDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShortDescription").build()).build();

    private static final SdkField<String> LONG_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LongDescription").getter(getter(RegistrationSectionDisplayHints::longDescription))
            .setter(setter(Builder::longDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LongDescription").build()).build();

    private static final SdkField<String> DOCUMENTATION_TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentationTitle").getter(getter(RegistrationSectionDisplayHints::documentationTitle))
            .setter(setter(Builder::documentationTitle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentationTitle").build())
            .build();

    private static final SdkField<String> DOCUMENTATION_LINK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentationLink").getter(getter(RegistrationSectionDisplayHints::documentationLink))
            .setter(setter(Builder::documentationLink))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentationLink").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_FIELD,
            SHORT_DESCRIPTION_FIELD, LONG_DESCRIPTION_FIELD, DOCUMENTATION_TITLE_FIELD, DOCUMENTATION_LINK_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String title;

    private final String shortDescription;

    private final String longDescription;

    private final String documentationTitle;

    private final String documentationLink;

    private RegistrationSectionDisplayHints(BuilderImpl builder) {
        this.title = builder.title;
        this.shortDescription = builder.shortDescription;
        this.longDescription = builder.longDescription;
        this.documentationTitle = builder.documentationTitle;
        this.documentationLink = builder.documentationLink;
    }

    /**
     * <p>
     * The title of the display hint.
     * </p>
     * 
     * @return The title of the display hint.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * A short description of the display hint.
     * </p>
     * 
     * @return A short description of the display hint.
     */
    public final String shortDescription() {
        return shortDescription;
    }

    /**
     * <p>
     * A full description of the display hint.
     * </p>
     * 
     * @return A full description of the display hint.
     */
    public final String longDescription() {
        return longDescription;
    }

    /**
     * <p>
     * The title of the document the display hint is associated with.
     * </p>
     * 
     * @return The title of the document the display hint is associated with.
     */
    public final String documentationTitle() {
        return documentationTitle;
    }

    /**
     * <p>
     * The link to the document the display hint is associated with.
     * </p>
     * 
     * @return The link to the document the display hint is associated with.
     */
    public final String documentationLink() {
        return documentationLink;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(shortDescription());
        hashCode = 31 * hashCode + Objects.hashCode(longDescription());
        hashCode = 31 * hashCode + Objects.hashCode(documentationTitle());
        hashCode = 31 * hashCode + Objects.hashCode(documentationLink());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegistrationSectionDisplayHints)) {
            return false;
        }
        RegistrationSectionDisplayHints other = (RegistrationSectionDisplayHints) obj;
        return Objects.equals(title(), other.title()) && Objects.equals(shortDescription(), other.shortDescription())
                && Objects.equals(longDescription(), other.longDescription())
                && Objects.equals(documentationTitle(), other.documentationTitle())
                && Objects.equals(documentationLink(), other.documentationLink());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegistrationSectionDisplayHints").add("Title", title())
                .add("ShortDescription", shortDescription()).add("LongDescription", longDescription())
                .add("DocumentationTitle", documentationTitle()).add("DocumentationLink", documentationLink()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "ShortDescription":
            return Optional.ofNullable(clazz.cast(shortDescription()));
        case "LongDescription":
            return Optional.ofNullable(clazz.cast(longDescription()));
        case "DocumentationTitle":
            return Optional.ofNullable(clazz.cast(documentationTitle()));
        case "DocumentationLink":
            return Optional.ofNullable(clazz.cast(documentationLink()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Title", TITLE_FIELD);
        map.put("ShortDescription", SHORT_DESCRIPTION_FIELD);
        map.put("LongDescription", LONG_DESCRIPTION_FIELD);
        map.put("DocumentationTitle", DOCUMENTATION_TITLE_FIELD);
        map.put("DocumentationLink", DOCUMENTATION_LINK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegistrationSectionDisplayHints, T> g) {
        return obj -> g.apply((RegistrationSectionDisplayHints) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RegistrationSectionDisplayHints> {
        /**
         * <p>
         * The title of the display hint.
         * </p>
         * 
         * @param title
         *        The title of the display hint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * A short description of the display hint.
         * </p>
         * 
         * @param shortDescription
         *        A short description of the display hint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shortDescription(String shortDescription);

        /**
         * <p>
         * A full description of the display hint.
         * </p>
         * 
         * @param longDescription
         *        A full description of the display hint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder longDescription(String longDescription);

        /**
         * <p>
         * The title of the document the display hint is associated with.
         * </p>
         * 
         * @param documentationTitle
         *        The title of the document the display hint is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentationTitle(String documentationTitle);

        /**
         * <p>
         * The link to the document the display hint is associated with.
         * </p>
         * 
         * @param documentationLink
         *        The link to the document the display hint is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentationLink(String documentationLink);
    }

    static final class BuilderImpl implements Builder {
        private String title;

        private String shortDescription;

        private String longDescription;

        private String documentationTitle;

        private String documentationLink;

        private BuilderImpl() {
        }

        private BuilderImpl(RegistrationSectionDisplayHints model) {
            title(model.title);
            shortDescription(model.shortDescription);
            longDescription(model.longDescription);
            documentationTitle(model.documentationTitle);
            documentationLink(model.documentationLink);
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getShortDescription() {
            return shortDescription;
        }

        public final void setShortDescription(String shortDescription) {
            this.shortDescription = shortDescription;
        }

        @Override
        public final Builder shortDescription(String shortDescription) {
            this.shortDescription = shortDescription;
            return this;
        }

        public final String getLongDescription() {
            return longDescription;
        }

        public final void setLongDescription(String longDescription) {
            this.longDescription = longDescription;
        }

        @Override
        public final Builder longDescription(String longDescription) {
            this.longDescription = longDescription;
            return this;
        }

        public final String getDocumentationTitle() {
            return documentationTitle;
        }

        public final void setDocumentationTitle(String documentationTitle) {
            this.documentationTitle = documentationTitle;
        }

        @Override
        public final Builder documentationTitle(String documentationTitle) {
            this.documentationTitle = documentationTitle;
            return this;
        }

        public final String getDocumentationLink() {
            return documentationLink;
        }

        public final void setDocumentationLink(String documentationLink) {
            this.documentationLink = documentationLink;
        }

        @Override
        public final Builder documentationLink(String documentationLink) {
            this.documentationLink = documentationLink;
            return this;
        }

        @Override
        public RegistrationSectionDisplayHints build() {
            return new RegistrationSectionDisplayHints(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
