/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SetDefaultSenderIdRequest extends PinpointSmsVoiceV2Request implements
        ToCopyableBuilder<SetDefaultSenderIdRequest.Builder, SetDefaultSenderIdRequest> {
    private static final SdkField<String> CONFIGURATION_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationSetName").getter(getter(SetDefaultSenderIdRequest::configurationSetName))
            .setter(setter(Builder::configurationSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSetName").build())
            .build();

    private static final SdkField<String> SENDER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SenderId").getter(getter(SetDefaultSenderIdRequest::senderId)).setter(setter(Builder::senderId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SenderId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_SET_NAME_FIELD,
            SENDER_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String configurationSetName;

    private final String senderId;

    private SetDefaultSenderIdRequest(BuilderImpl builder) {
        super(builder);
        this.configurationSetName = builder.configurationSetName;
        this.senderId = builder.senderId;
    }

    /**
     * <p>
     * The configuration set to updated with a new default SenderId. This field can be the ConsigurationSetName or
     * ConfigurationSetArn.
     * </p>
     * 
     * @return The configuration set to updated with a new default SenderId. This field can be the ConsigurationSetName
     *         or ConfigurationSetArn.
     */
    public final String configurationSetName() {
        return configurationSetName;
    }

    /**
     * <p>
     * The current sender ID for the configuration set. When sending a text message to a destination country which
     * supports SenderIds, the default sender ID on the configuration set specified on <a>SendTextMessage</a> will be
     * used if no dedicated origination phone numbers or registered SenderIds are available in your account, instead of
     * a generic sender ID, such as 'NOTICE'.
     * </p>
     * 
     * @return The current sender ID for the configuration set. When sending a text message to a destination country
     *         which supports SenderIds, the default sender ID on the configuration set specified on
     *         <a>SendTextMessage</a> will be used if no dedicated origination phone numbers or registered SenderIds are
     *         available in your account, instead of a generic sender ID, such as 'NOTICE'.
     */
    public final String senderId() {
        return senderId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configurationSetName());
        hashCode = 31 * hashCode + Objects.hashCode(senderId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetDefaultSenderIdRequest)) {
            return false;
        }
        SetDefaultSenderIdRequest other = (SetDefaultSenderIdRequest) obj;
        return Objects.equals(configurationSetName(), other.configurationSetName())
                && Objects.equals(senderId(), other.senderId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SetDefaultSenderIdRequest").add("ConfigurationSetName", configurationSetName())
                .add("SenderId", senderId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationSetName":
            return Optional.ofNullable(clazz.cast(configurationSetName()));
        case "SenderId":
            return Optional.ofNullable(clazz.cast(senderId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConfigurationSetName", CONFIGURATION_SET_NAME_FIELD);
        map.put("SenderId", SENDER_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SetDefaultSenderIdRequest, T> g) {
        return obj -> g.apply((SetDefaultSenderIdRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PinpointSmsVoiceV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, SetDefaultSenderIdRequest> {
        /**
         * <p>
         * The configuration set to updated with a new default SenderId. This field can be the ConsigurationSetName or
         * ConfigurationSetArn.
         * </p>
         * 
         * @param configurationSetName
         *        The configuration set to updated with a new default SenderId. This field can be the
         *        ConsigurationSetName or ConfigurationSetArn.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSetName(String configurationSetName);

        /**
         * <p>
         * The current sender ID for the configuration set. When sending a text message to a destination country which
         * supports SenderIds, the default sender ID on the configuration set specified on <a>SendTextMessage</a> will
         * be used if no dedicated origination phone numbers or registered SenderIds are available in your account,
         * instead of a generic sender ID, such as 'NOTICE'.
         * </p>
         * 
         * @param senderId
         *        The current sender ID for the configuration set. When sending a text message to a destination country
         *        which supports SenderIds, the default sender ID on the configuration set specified on
         *        <a>SendTextMessage</a> will be used if no dedicated origination phone numbers or registered SenderIds
         *        are available in your account, instead of a generic sender ID, such as 'NOTICE'.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder senderId(String senderId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Request.BuilderImpl implements Builder {
        private String configurationSetName;

        private String senderId;

        private BuilderImpl() {
        }

        private BuilderImpl(SetDefaultSenderIdRequest model) {
            super(model);
            configurationSetName(model.configurationSetName);
            senderId(model.senderId);
        }

        public final String getConfigurationSetName() {
            return configurationSetName;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final String getSenderId() {
            return senderId;
        }

        public final void setSenderId(String senderId) {
            this.senderId = senderId;
        }

        @Override
        public final Builder senderId(String senderId) {
            this.senderId = senderId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetDefaultSenderIdRequest build() {
            return new SetDefaultSenderIdRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
