/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePhoneNumberRequest extends PinpointSmsVoiceV2Request implements
        ToCopyableBuilder<UpdatePhoneNumberRequest.Builder, UpdatePhoneNumberRequest> {
    private static final SdkField<String> PHONE_NUMBER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PhoneNumberId").getter(getter(UpdatePhoneNumberRequest::phoneNumberId))
            .setter(setter(Builder::phoneNumberId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberId").build()).build();

    private static final SdkField<Boolean> TWO_WAY_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("TwoWayEnabled").getter(getter(UpdatePhoneNumberRequest::twoWayEnabled))
            .setter(setter(Builder::twoWayEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TwoWayEnabled").build()).build();

    private static final SdkField<String> TWO_WAY_CHANNEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TwoWayChannelArn").getter(getter(UpdatePhoneNumberRequest::twoWayChannelArn))
            .setter(setter(Builder::twoWayChannelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TwoWayChannelArn").build()).build();

    private static final SdkField<String> TWO_WAY_CHANNEL_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TwoWayChannelRole").getter(getter(UpdatePhoneNumberRequest::twoWayChannelRole))
            .setter(setter(Builder::twoWayChannelRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TwoWayChannelRole").build()).build();

    private static final SdkField<Boolean> SELF_MANAGED_OPT_OUTS_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("SelfManagedOptOutsEnabled")
            .getter(getter(UpdatePhoneNumberRequest::selfManagedOptOutsEnabled))
            .setter(setter(Builder::selfManagedOptOutsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelfManagedOptOutsEnabled").build())
            .build();

    private static final SdkField<String> OPT_OUT_LIST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptOutListName").getter(getter(UpdatePhoneNumberRequest::optOutListName))
            .setter(setter(Builder::optOutListName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptOutListName").build()).build();

    private static final SdkField<Boolean> INTERNATIONAL_SENDING_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("InternationalSendingEnabled")
            .getter(getter(UpdatePhoneNumberRequest::internationalSendingEnabled))
            .setter(setter(Builder::internationalSendingEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InternationalSendingEnabled")
                    .build()).build();

    private static final SdkField<Boolean> DELETION_PROTECTION_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("DeletionProtectionEnabled")
            .getter(getter(UpdatePhoneNumberRequest::deletionProtectionEnabled))
            .setter(setter(Builder::deletionProtectionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtectionEnabled").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PHONE_NUMBER_ID_FIELD,
            TWO_WAY_ENABLED_FIELD, TWO_WAY_CHANNEL_ARN_FIELD, TWO_WAY_CHANNEL_ROLE_FIELD, SELF_MANAGED_OPT_OUTS_ENABLED_FIELD,
            OPT_OUT_LIST_NAME_FIELD, INTERNATIONAL_SENDING_ENABLED_FIELD, DELETION_PROTECTION_ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String phoneNumberId;

    private final Boolean twoWayEnabled;

    private final String twoWayChannelArn;

    private final String twoWayChannelRole;

    private final Boolean selfManagedOptOutsEnabled;

    private final String optOutListName;

    private final Boolean internationalSendingEnabled;

    private final Boolean deletionProtectionEnabled;

    private UpdatePhoneNumberRequest(BuilderImpl builder) {
        super(builder);
        this.phoneNumberId = builder.phoneNumberId;
        this.twoWayEnabled = builder.twoWayEnabled;
        this.twoWayChannelArn = builder.twoWayChannelArn;
        this.twoWayChannelRole = builder.twoWayChannelRole;
        this.selfManagedOptOutsEnabled = builder.selfManagedOptOutsEnabled;
        this.optOutListName = builder.optOutListName;
        this.internationalSendingEnabled = builder.internationalSendingEnabled;
        this.deletionProtectionEnabled = builder.deletionProtectionEnabled;
    }

    /**
     * <p>
     * The unique identifier of the phone number. Valid values for this field can be either the PhoneNumberId or
     * PhoneNumberArn.
     * </p>
     * <important>
     * <p>
     * If you are using a shared End User MessagingSMS resource then you must use the full Amazon Resource Name(ARN).
     * </p>
     * </important>
     * 
     * @return The unique identifier of the phone number. Valid values for this field can be either the PhoneNumberId or
     *         PhoneNumberArn.</p> <important>
     *         <p>
     *         If you are using a shared End User MessagingSMS resource then you must use the full Amazon Resource
     *         Name(ARN).
     *         </p>
     */
    public final String phoneNumberId() {
        return phoneNumberId;
    }

    /**
     * <p>
     * By default this is set to false. When set to true you can receive incoming text messages from your end
     * recipients.
     * </p>
     * 
     * @return By default this is set to false. When set to true you can receive incoming text messages from your end
     *         recipients.
     */
    public final Boolean twoWayEnabled() {
        return twoWayEnabled;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the two way channel.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the two way channel.
     */
    public final String twoWayChannelArn() {
        return twoWayChannelArn;
    }

    /**
     * <p>
     * An optional IAM Role Arn for a service to assume, to be able to post inbound SMS messages.
     * </p>
     * 
     * @return An optional IAM Role Arn for a service to assume, to be able to post inbound SMS messages.
     */
    public final String twoWayChannelRole() {
        return twoWayChannelRole;
    }

    /**
     * <p>
     * By default this is set to false. When set to false and an end recipient sends a message that begins with HELP or
     * STOP to one of your dedicated numbers, End User MessagingSMS automatically replies with a customizable message
     * and adds the end recipient to the OptOutList. When set to true you're responsible for responding to HELP and STOP
     * requests. You're also responsible for tracking and honoring opt-out requests.
     * </p>
     * 
     * @return By default this is set to false. When set to false and an end recipient sends a message that begins with
     *         HELP or STOP to one of your dedicated numbers, End User MessagingSMS automatically replies with a
     *         customizable message and adds the end recipient to the OptOutList. When set to true you're responsible
     *         for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out
     *         requests.
     */
    public final Boolean selfManagedOptOutsEnabled() {
        return selfManagedOptOutsEnabled;
    }

    /**
     * <p>
     * The OptOutList to add the phone number to. You can use either the opt out list name or the opt out list ARN.
     * </p>
     * 
     * @return The OptOutList to add the phone number to. You can use either the opt out list name or the opt out list
     *         ARN.
     */
    public final String optOutListName() {
        return optOutListName;
    }

    /**
     * <p>
     * By default this is set to false. When set to true the international sending of phone number is Enabled.
     * </p>
     * 
     * @return By default this is set to false. When set to true the international sending of phone number is Enabled.
     */
    public final Boolean internationalSendingEnabled() {
        return internationalSendingEnabled;
    }

    /**
     * <p>
     * By default this is set to false. When set to true the phone number can't be deleted.
     * </p>
     * 
     * @return By default this is set to false. When set to true the phone number can't be deleted.
     */
    public final Boolean deletionProtectionEnabled() {
        return deletionProtectionEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumberId());
        hashCode = 31 * hashCode + Objects.hashCode(twoWayEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(twoWayChannelArn());
        hashCode = 31 * hashCode + Objects.hashCode(twoWayChannelRole());
        hashCode = 31 * hashCode + Objects.hashCode(selfManagedOptOutsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(optOutListName());
        hashCode = 31 * hashCode + Objects.hashCode(internationalSendingEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtectionEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePhoneNumberRequest)) {
            return false;
        }
        UpdatePhoneNumberRequest other = (UpdatePhoneNumberRequest) obj;
        return Objects.equals(phoneNumberId(), other.phoneNumberId()) && Objects.equals(twoWayEnabled(), other.twoWayEnabled())
                && Objects.equals(twoWayChannelArn(), other.twoWayChannelArn())
                && Objects.equals(twoWayChannelRole(), other.twoWayChannelRole())
                && Objects.equals(selfManagedOptOutsEnabled(), other.selfManagedOptOutsEnabled())
                && Objects.equals(optOutListName(), other.optOutListName())
                && Objects.equals(internationalSendingEnabled(), other.internationalSendingEnabled())
                && Objects.equals(deletionProtectionEnabled(), other.deletionProtectionEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePhoneNumberRequest").add("PhoneNumberId", phoneNumberId())
                .add("TwoWayEnabled", twoWayEnabled()).add("TwoWayChannelArn", twoWayChannelArn())
                .add("TwoWayChannelRole", twoWayChannelRole()).add("SelfManagedOptOutsEnabled", selfManagedOptOutsEnabled())
                .add("OptOutListName", optOutListName()).add("InternationalSendingEnabled", internationalSendingEnabled())
                .add("DeletionProtectionEnabled", deletionProtectionEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PhoneNumberId":
            return Optional.ofNullable(clazz.cast(phoneNumberId()));
        case "TwoWayEnabled":
            return Optional.ofNullable(clazz.cast(twoWayEnabled()));
        case "TwoWayChannelArn":
            return Optional.ofNullable(clazz.cast(twoWayChannelArn()));
        case "TwoWayChannelRole":
            return Optional.ofNullable(clazz.cast(twoWayChannelRole()));
        case "SelfManagedOptOutsEnabled":
            return Optional.ofNullable(clazz.cast(selfManagedOptOutsEnabled()));
        case "OptOutListName":
            return Optional.ofNullable(clazz.cast(optOutListName()));
        case "InternationalSendingEnabled":
            return Optional.ofNullable(clazz.cast(internationalSendingEnabled()));
        case "DeletionProtectionEnabled":
            return Optional.ofNullable(clazz.cast(deletionProtectionEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PhoneNumberId", PHONE_NUMBER_ID_FIELD);
        map.put("TwoWayEnabled", TWO_WAY_ENABLED_FIELD);
        map.put("TwoWayChannelArn", TWO_WAY_CHANNEL_ARN_FIELD);
        map.put("TwoWayChannelRole", TWO_WAY_CHANNEL_ROLE_FIELD);
        map.put("SelfManagedOptOutsEnabled", SELF_MANAGED_OPT_OUTS_ENABLED_FIELD);
        map.put("OptOutListName", OPT_OUT_LIST_NAME_FIELD);
        map.put("InternationalSendingEnabled", INTERNATIONAL_SENDING_ENABLED_FIELD);
        map.put("DeletionProtectionEnabled", DELETION_PROTECTION_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePhoneNumberRequest, T> g) {
        return obj -> g.apply((UpdatePhoneNumberRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PinpointSmsVoiceV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdatePhoneNumberRequest> {
        /**
         * <p>
         * The unique identifier of the phone number. Valid values for this field can be either the PhoneNumberId or
         * PhoneNumberArn.
         * </p>
         * <important>
         * <p>
         * If you are using a shared End User MessagingSMS resource then you must use the full Amazon Resource
         * Name(ARN).
         * </p>
         * </important>
         * 
         * @param phoneNumberId
         *        The unique identifier of the phone number. Valid values for this field can be either the PhoneNumberId
         *        or PhoneNumberArn.</p> <important>
         *        <p>
         *        If you are using a shared End User MessagingSMS resource then you must use the full Amazon Resource
         *        Name(ARN).
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumberId(String phoneNumberId);

        /**
         * <p>
         * By default this is set to false. When set to true you can receive incoming text messages from your end
         * recipients.
         * </p>
         * 
         * @param twoWayEnabled
         *        By default this is set to false. When set to true you can receive incoming text messages from your end
         *        recipients.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder twoWayEnabled(Boolean twoWayEnabled);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the two way channel.
         * </p>
         * 
         * @param twoWayChannelArn
         *        The Amazon Resource Name (ARN) of the two way channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder twoWayChannelArn(String twoWayChannelArn);

        /**
         * <p>
         * An optional IAM Role Arn for a service to assume, to be able to post inbound SMS messages.
         * </p>
         * 
         * @param twoWayChannelRole
         *        An optional IAM Role Arn for a service to assume, to be able to post inbound SMS messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder twoWayChannelRole(String twoWayChannelRole);

        /**
         * <p>
         * By default this is set to false. When set to false and an end recipient sends a message that begins with HELP
         * or STOP to one of your dedicated numbers, End User MessagingSMS automatically replies with a customizable
         * message and adds the end recipient to the OptOutList. When set to true you're responsible for responding to
         * HELP and STOP requests. You're also responsible for tracking and honoring opt-out requests.
         * </p>
         * 
         * @param selfManagedOptOutsEnabled
         *        By default this is set to false. When set to false and an end recipient sends a message that begins
         *        with HELP or STOP to one of your dedicated numbers, End User MessagingSMS automatically replies with a
         *        customizable message and adds the end recipient to the OptOutList. When set to true you're responsible
         *        for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out
         *        requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selfManagedOptOutsEnabled(Boolean selfManagedOptOutsEnabled);

        /**
         * <p>
         * The OptOutList to add the phone number to. You can use either the opt out list name or the opt out list ARN.
         * </p>
         * 
         * @param optOutListName
         *        The OptOutList to add the phone number to. You can use either the opt out list name or the opt out
         *        list ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optOutListName(String optOutListName);

        /**
         * <p>
         * By default this is set to false. When set to true the international sending of phone number is Enabled.
         * </p>
         * 
         * @param internationalSendingEnabled
         *        By default this is set to false. When set to true the international sending of phone number is
         *        Enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder internationalSendingEnabled(Boolean internationalSendingEnabled);

        /**
         * <p>
         * By default this is set to false. When set to true the phone number can't be deleted.
         * </p>
         * 
         * @param deletionProtectionEnabled
         *        By default this is set to false. When set to true the phone number can't be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionProtectionEnabled(Boolean deletionProtectionEnabled);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Request.BuilderImpl implements Builder {
        private String phoneNumberId;

        private Boolean twoWayEnabled;

        private String twoWayChannelArn;

        private String twoWayChannelRole;

        private Boolean selfManagedOptOutsEnabled;

        private String optOutListName;

        private Boolean internationalSendingEnabled;

        private Boolean deletionProtectionEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePhoneNumberRequest model) {
            super(model);
            phoneNumberId(model.phoneNumberId);
            twoWayEnabled(model.twoWayEnabled);
            twoWayChannelArn(model.twoWayChannelArn);
            twoWayChannelRole(model.twoWayChannelRole);
            selfManagedOptOutsEnabled(model.selfManagedOptOutsEnabled);
            optOutListName(model.optOutListName);
            internationalSendingEnabled(model.internationalSendingEnabled);
            deletionProtectionEnabled(model.deletionProtectionEnabled);
        }

        public final String getPhoneNumberId() {
            return phoneNumberId;
        }

        public final void setPhoneNumberId(String phoneNumberId) {
            this.phoneNumberId = phoneNumberId;
        }

        @Override
        public final Builder phoneNumberId(String phoneNumberId) {
            this.phoneNumberId = phoneNumberId;
            return this;
        }

        public final Boolean getTwoWayEnabled() {
            return twoWayEnabled;
        }

        public final void setTwoWayEnabled(Boolean twoWayEnabled) {
            this.twoWayEnabled = twoWayEnabled;
        }

        @Override
        public final Builder twoWayEnabled(Boolean twoWayEnabled) {
            this.twoWayEnabled = twoWayEnabled;
            return this;
        }

        public final String getTwoWayChannelArn() {
            return twoWayChannelArn;
        }

        public final void setTwoWayChannelArn(String twoWayChannelArn) {
            this.twoWayChannelArn = twoWayChannelArn;
        }

        @Override
        public final Builder twoWayChannelArn(String twoWayChannelArn) {
            this.twoWayChannelArn = twoWayChannelArn;
            return this;
        }

        public final String getTwoWayChannelRole() {
            return twoWayChannelRole;
        }

        public final void setTwoWayChannelRole(String twoWayChannelRole) {
            this.twoWayChannelRole = twoWayChannelRole;
        }

        @Override
        public final Builder twoWayChannelRole(String twoWayChannelRole) {
            this.twoWayChannelRole = twoWayChannelRole;
            return this;
        }

        public final Boolean getSelfManagedOptOutsEnabled() {
            return selfManagedOptOutsEnabled;
        }

        public final void setSelfManagedOptOutsEnabled(Boolean selfManagedOptOutsEnabled) {
            this.selfManagedOptOutsEnabled = selfManagedOptOutsEnabled;
        }

        @Override
        public final Builder selfManagedOptOutsEnabled(Boolean selfManagedOptOutsEnabled) {
            this.selfManagedOptOutsEnabled = selfManagedOptOutsEnabled;
            return this;
        }

        public final String getOptOutListName() {
            return optOutListName;
        }

        public final void setOptOutListName(String optOutListName) {
            this.optOutListName = optOutListName;
        }

        @Override
        public final Builder optOutListName(String optOutListName) {
            this.optOutListName = optOutListName;
            return this;
        }

        public final Boolean getInternationalSendingEnabled() {
            return internationalSendingEnabled;
        }

        public final void setInternationalSendingEnabled(Boolean internationalSendingEnabled) {
            this.internationalSendingEnabled = internationalSendingEnabled;
        }

        @Override
        public final Builder internationalSendingEnabled(Boolean internationalSendingEnabled) {
            this.internationalSendingEnabled = internationalSendingEnabled;
            return this;
        }

        public final Boolean getDeletionProtectionEnabled() {
            return deletionProtectionEnabled;
        }

        public final void setDeletionProtectionEnabled(Boolean deletionProtectionEnabled) {
            this.deletionProtectionEnabled = deletionProtectionEnabled;
        }

        @Override
        public final Builder deletionProtectionEnabled(Boolean deletionProtectionEnabled) {
            this.deletionProtectionEnabled = deletionProtectionEnabled;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePhoneNumberRequest build() {
            return new UpdatePhoneNumberRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
