/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateProtectConfigurationResponse extends PinpointSmsVoiceV2Response implements
        ToCopyableBuilder<UpdateProtectConfigurationResponse.Builder, UpdateProtectConfigurationResponse> {
    private static final SdkField<String> PROTECT_CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProtectConfigurationArn").getter(getter(UpdateProtectConfigurationResponse::protectConfigurationArn))
            .setter(setter(Builder::protectConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectConfigurationArn").build())
            .build();

    private static final SdkField<String> PROTECT_CONFIGURATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProtectConfigurationId").getter(getter(UpdateProtectConfigurationResponse::protectConfigurationId))
            .setter(setter(Builder::protectConfigurationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectConfigurationId").build())
            .build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp").getter(getter(UpdateProtectConfigurationResponse::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()).build();

    private static final SdkField<Boolean> ACCOUNT_DEFAULT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AccountDefault").getter(getter(UpdateProtectConfigurationResponse::accountDefault))
            .setter(setter(Builder::accountDefault))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountDefault").build()).build();

    private static final SdkField<Boolean> DELETION_PROTECTION_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("DeletionProtectionEnabled")
            .getter(getter(UpdateProtectConfigurationResponse::deletionProtectionEnabled))
            .setter(setter(Builder::deletionProtectionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtectionEnabled").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PROTECT_CONFIGURATION_ARN_FIELD, PROTECT_CONFIGURATION_ID_FIELD, CREATED_TIMESTAMP_FIELD, ACCOUNT_DEFAULT_FIELD,
            DELETION_PROTECTION_ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String protectConfigurationArn;

    private final String protectConfigurationId;

    private final Instant createdTimestamp;

    private final Boolean accountDefault;

    private final Boolean deletionProtectionEnabled;

    private UpdateProtectConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.protectConfigurationArn = builder.protectConfigurationArn;
        this.protectConfigurationId = builder.protectConfigurationId;
        this.createdTimestamp = builder.createdTimestamp;
        this.accountDefault = builder.accountDefault;
        this.deletionProtectionEnabled = builder.deletionProtectionEnabled;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the protect configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the protect configuration.
     */
    public final String protectConfigurationArn() {
        return protectConfigurationArn;
    }

    /**
     * <p>
     * The unique identifier for the protect configuration.
     * </p>
     * 
     * @return The unique identifier for the protect configuration.
     */
    public final String protectConfigurationId() {
        return protectConfigurationId;
    }

    /**
     * <p>
     * The time when the protect configuration was created, in <a href="https://www.epochconverter.com/">UNIX epoch
     * time</a> format.
     * </p>
     * 
     * @return The time when the protect configuration was created, in <a href="https://www.epochconverter.com/">UNIX
     *         epoch time</a> format.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * This is true if the protect configuration is set as your account default protect configuration.
     * </p>
     * 
     * @return This is true if the protect configuration is set as your account default protect configuration.
     */
    public final Boolean accountDefault() {
        return accountDefault;
    }

    /**
     * <p>
     * The status of deletion protection for the protect configuration. When set to true deletion protection is enabled.
     * By default this is set to false.
     * </p>
     * 
     * @return The status of deletion protection for the protect configuration. When set to true deletion protection is
     *         enabled. By default this is set to false.
     */
    public final Boolean deletionProtectionEnabled() {
        return deletionProtectionEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(protectConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(protectConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(accountDefault());
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtectionEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProtectConfigurationResponse)) {
            return false;
        }
        UpdateProtectConfigurationResponse other = (UpdateProtectConfigurationResponse) obj;
        return Objects.equals(protectConfigurationArn(), other.protectConfigurationArn())
                && Objects.equals(protectConfigurationId(), other.protectConfigurationId())
                && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(accountDefault(), other.accountDefault())
                && Objects.equals(deletionProtectionEnabled(), other.deletionProtectionEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateProtectConfigurationResponse").add("ProtectConfigurationArn", protectConfigurationArn())
                .add("ProtectConfigurationId", protectConfigurationId()).add("CreatedTimestamp", createdTimestamp())
                .add("AccountDefault", accountDefault()).add("DeletionProtectionEnabled", deletionProtectionEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProtectConfigurationArn":
            return Optional.ofNullable(clazz.cast(protectConfigurationArn()));
        case "ProtectConfigurationId":
            return Optional.ofNullable(clazz.cast(protectConfigurationId()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "AccountDefault":
            return Optional.ofNullable(clazz.cast(accountDefault()));
        case "DeletionProtectionEnabled":
            return Optional.ofNullable(clazz.cast(deletionProtectionEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProtectConfigurationArn", PROTECT_CONFIGURATION_ARN_FIELD);
        map.put("ProtectConfigurationId", PROTECT_CONFIGURATION_ID_FIELD);
        map.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
        map.put("AccountDefault", ACCOUNT_DEFAULT_FIELD);
        map.put("DeletionProtectionEnabled", DELETION_PROTECTION_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateProtectConfigurationResponse, T> g) {
        return obj -> g.apply((UpdateProtectConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PinpointSmsVoiceV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateProtectConfigurationResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the protect configuration.
         * </p>
         * 
         * @param protectConfigurationArn
         *        The Amazon Resource Name (ARN) of the protect configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectConfigurationArn(String protectConfigurationArn);

        /**
         * <p>
         * The unique identifier for the protect configuration.
         * </p>
         * 
         * @param protectConfigurationId
         *        The unique identifier for the protect configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectConfigurationId(String protectConfigurationId);

        /**
         * <p>
         * The time when the protect configuration was created, in <a href="https://www.epochconverter.com/">UNIX epoch
         * time</a> format.
         * </p>
         * 
         * @param createdTimestamp
         *        The time when the protect configuration was created, in <a href="https://www.epochconverter.com/">UNIX
         *        epoch time</a> format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * This is true if the protect configuration is set as your account default protect configuration.
         * </p>
         * 
         * @param accountDefault
         *        This is true if the protect configuration is set as your account default protect configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountDefault(Boolean accountDefault);

        /**
         * <p>
         * The status of deletion protection for the protect configuration. When set to true deletion protection is
         * enabled. By default this is set to false.
         * </p>
         * 
         * @param deletionProtectionEnabled
         *        The status of deletion protection for the protect configuration. When set to true deletion protection
         *        is enabled. By default this is set to false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionProtectionEnabled(Boolean deletionProtectionEnabled);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Response.BuilderImpl implements Builder {
        private String protectConfigurationArn;

        private String protectConfigurationId;

        private Instant createdTimestamp;

        private Boolean accountDefault;

        private Boolean deletionProtectionEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProtectConfigurationResponse model) {
            super(model);
            protectConfigurationArn(model.protectConfigurationArn);
            protectConfigurationId(model.protectConfigurationId);
            createdTimestamp(model.createdTimestamp);
            accountDefault(model.accountDefault);
            deletionProtectionEnabled(model.deletionProtectionEnabled);
        }

        public final String getProtectConfigurationArn() {
            return protectConfigurationArn;
        }

        public final void setProtectConfigurationArn(String protectConfigurationArn) {
            this.protectConfigurationArn = protectConfigurationArn;
        }

        @Override
        public final Builder protectConfigurationArn(String protectConfigurationArn) {
            this.protectConfigurationArn = protectConfigurationArn;
            return this;
        }

        public final String getProtectConfigurationId() {
            return protectConfigurationId;
        }

        public final void setProtectConfigurationId(String protectConfigurationId) {
            this.protectConfigurationId = protectConfigurationId;
        }

        @Override
        public final Builder protectConfigurationId(String protectConfigurationId) {
            this.protectConfigurationId = protectConfigurationId;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Boolean getAccountDefault() {
            return accountDefault;
        }

        public final void setAccountDefault(Boolean accountDefault) {
            this.accountDefault = accountDefault;
        }

        @Override
        public final Builder accountDefault(Boolean accountDefault) {
            this.accountDefault = accountDefault;
            return this;
        }

        public final Boolean getDeletionProtectionEnabled() {
            return deletionProtectionEnabled;
        }

        public final void setDeletionProtectionEnabled(Boolean deletionProtectionEnabled) {
            this.deletionProtectionEnabled = deletionProtectionEnabled;
        }

        @Override
        public final Builder deletionProtectionEnabled(Boolean deletionProtectionEnabled) {
            this.deletionProtectionEnabled = deletionProtectionEnabled;
            return this;
        }

        @Override
        public UpdateProtectConfigurationResponse build() {
            return new UpdateProtectConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
