/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum VoiceId {
    AMY("AMY"),

    ASTRID("ASTRID"),

    BIANCA("BIANCA"),

    BRIAN("BRIAN"),

    CAMILA("CAMILA"),

    CARLA("CARLA"),

    CARMEN("CARMEN"),

    CELINE("CELINE"),

    CHANTAL("CHANTAL"),

    CONCHITA("CONCHITA"),

    CRISTIANO("CRISTIANO"),

    DORA("DORA"),

    EMMA("EMMA"),

    ENRIQUE("ENRIQUE"),

    EWA("EWA"),

    FILIZ("FILIZ"),

    GERAINT("GERAINT"),

    GIORGIO("GIORGIO"),

    GWYNETH("GWYNETH"),

    HANS("HANS"),

    INES("INES"),

    IVY("IVY"),

    JACEK("JACEK"),

    JAN("JAN"),

    JOANNA("JOANNA"),

    JOEY("JOEY"),

    JUSTIN("JUSTIN"),

    KARL("KARL"),

    KENDRA("KENDRA"),

    KIMBERLY("KIMBERLY"),

    LEA("LEA"),

    LIV("LIV"),

    LOTTE("LOTTE"),

    LUCIA("LUCIA"),

    LUPE("LUPE"),

    MADS("MADS"),

    MAJA("MAJA"),

    MARLENE("MARLENE"),

    MATHIEU("MATHIEU"),

    MATTHEW("MATTHEW"),

    MAXIM("MAXIM"),

    MIA("MIA"),

    MIGUEL("MIGUEL"),

    MIZUKI("MIZUKI"),

    NAJA("NAJA"),

    NICOLE("NICOLE"),

    PENELOPE("PENELOPE"),

    RAVEENA("RAVEENA"),

    RICARDO("RICARDO"),

    RUBEN("RUBEN"),

    RUSSELL("RUSSELL"),

    SALLI("SALLI"),

    SEOYEON("SEOYEON"),

    TAKUMI("TAKUMI"),

    TATYANA("TATYANA"),

    VICKI("VICKI"),

    VITORIA("VITORIA"),

    ZEINA("ZEINA"),

    ZHIYU("ZHIYU"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, VoiceId> VALUE_MAP = EnumUtils.uniqueIndex(VoiceId.class, VoiceId::toString);

    private final String value;

    private VoiceId(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return VoiceId corresponding to the value
     */
    public static VoiceId fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link VoiceId}s
     */
    public static Set<VoiceId> knownValues() {
        Set<VoiceId> knownValues = EnumSet.allOf(VoiceId.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
