/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PhoneNumberType;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PinpointSmsVoiceV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CarrierLookupResponse
extends PinpointSmsVoiceV2Response
implements ToCopyableBuilder<Builder, CarrierLookupResponse> {
    private static final SdkField<String> E164_PHONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("E164PhoneNumber").getter(CarrierLookupResponse.getter(CarrierLookupResponse::e164PhoneNumber)).setter(CarrierLookupResponse.setter(Builder::e164PhoneNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("E164PhoneNumber").build()}).build();
    private static final SdkField<String> DIALING_COUNTRY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DialingCountryCode").getter(CarrierLookupResponse.getter(CarrierLookupResponse::dialingCountryCode)).setter(CarrierLookupResponse.setter(Builder::dialingCountryCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DialingCountryCode").build()}).build();
    private static final SdkField<String> ISO_COUNTRY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IsoCountryCode").getter(CarrierLookupResponse.getter(CarrierLookupResponse::isoCountryCode)).setter(CarrierLookupResponse.setter(Builder::isoCountryCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsoCountryCode").build()}).build();
    private static final SdkField<String> COUNTRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Country").getter(CarrierLookupResponse.getter(CarrierLookupResponse::country)).setter(CarrierLookupResponse.setter(Builder::country)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Country").build()}).build();
    private static final SdkField<String> MCC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MCC").getter(CarrierLookupResponse.getter(CarrierLookupResponse::mcc)).setter(CarrierLookupResponse.setter(Builder::mcc)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MCC").build()}).build();
    private static final SdkField<String> MNC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MNC").getter(CarrierLookupResponse.getter(CarrierLookupResponse::mnc)).setter(CarrierLookupResponse.setter(Builder::mnc)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MNC").build()}).build();
    private static final SdkField<String> CARRIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Carrier").getter(CarrierLookupResponse.getter(CarrierLookupResponse::carrier)).setter(CarrierLookupResponse.setter(Builder::carrier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Carrier").build()}).build();
    private static final SdkField<String> PHONE_NUMBER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PhoneNumberType").getter(CarrierLookupResponse.getter(CarrierLookupResponse::phoneNumberTypeAsString)).setter(CarrierLookupResponse.setter(Builder::phoneNumberType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(E164_PHONE_NUMBER_FIELD, DIALING_COUNTRY_CODE_FIELD, ISO_COUNTRY_CODE_FIELD, COUNTRY_FIELD, MCC_FIELD, MNC_FIELD, CARRIER_FIELD, PHONE_NUMBER_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CarrierLookupResponse.memberNameToFieldInitializer();
    private final String e164PhoneNumber;
    private final String dialingCountryCode;
    private final String isoCountryCode;
    private final String country;
    private final String mcc;
    private final String mnc;
    private final String carrier;
    private final String phoneNumberType;

    private CarrierLookupResponse(BuilderImpl builder) {
        super(builder);
        this.e164PhoneNumber = builder.e164PhoneNumber;
        this.dialingCountryCode = builder.dialingCountryCode;
        this.isoCountryCode = builder.isoCountryCode;
        this.country = builder.country;
        this.mcc = builder.mcc;
        this.mnc = builder.mnc;
        this.carrier = builder.carrier;
        this.phoneNumberType = builder.phoneNumberType;
    }

    public final String e164PhoneNumber() {
        return this.e164PhoneNumber;
    }

    public final String dialingCountryCode() {
        return this.dialingCountryCode;
    }

    public final String isoCountryCode() {
        return this.isoCountryCode;
    }

    public final String country() {
        return this.country;
    }

    public final String mcc() {
        return this.mcc;
    }

    public final String mnc() {
        return this.mnc;
    }

    public final String carrier() {
        return this.carrier;
    }

    public final PhoneNumberType phoneNumberType() {
        return PhoneNumberType.fromValue(this.phoneNumberType);
    }

    public final String phoneNumberTypeAsString() {
        return this.phoneNumberType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.e164PhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.dialingCountryCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.isoCountryCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.country());
        hashCode = 31 * hashCode + Objects.hashCode(this.mcc());
        hashCode = 31 * hashCode + Objects.hashCode(this.mnc());
        hashCode = 31 * hashCode + Objects.hashCode(this.carrier());
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneNumberTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CarrierLookupResponse)) {
            return false;
        }
        CarrierLookupResponse other = (CarrierLookupResponse)((Object)obj);
        return Objects.equals(this.e164PhoneNumber(), other.e164PhoneNumber()) && Objects.equals(this.dialingCountryCode(), other.dialingCountryCode()) && Objects.equals(this.isoCountryCode(), other.isoCountryCode()) && Objects.equals(this.country(), other.country()) && Objects.equals(this.mcc(), other.mcc()) && Objects.equals(this.mnc(), other.mnc()) && Objects.equals(this.carrier(), other.carrier()) && Objects.equals(this.phoneNumberTypeAsString(), other.phoneNumberTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CarrierLookupResponse").add("E164PhoneNumber", (Object)this.e164PhoneNumber()).add("DialingCountryCode", (Object)this.dialingCountryCode()).add("IsoCountryCode", (Object)this.isoCountryCode()).add("Country", (Object)this.country()).add("MCC", (Object)this.mcc()).add("MNC", (Object)this.mnc()).add("Carrier", (Object)this.carrier()).add("PhoneNumberType", (Object)this.phoneNumberTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "E164PhoneNumber": {
                return Optional.ofNullable(clazz.cast(this.e164PhoneNumber()));
            }
            case "DialingCountryCode": {
                return Optional.ofNullable(clazz.cast(this.dialingCountryCode()));
            }
            case "IsoCountryCode": {
                return Optional.ofNullable(clazz.cast(this.isoCountryCode()));
            }
            case "Country": {
                return Optional.ofNullable(clazz.cast(this.country()));
            }
            case "MCC": {
                return Optional.ofNullable(clazz.cast(this.mcc()));
            }
            case "MNC": {
                return Optional.ofNullable(clazz.cast(this.mnc()));
            }
            case "Carrier": {
                return Optional.ofNullable(clazz.cast(this.carrier()));
            }
            case "PhoneNumberType": {
                return Optional.ofNullable(clazz.cast(this.phoneNumberTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("E164PhoneNumber", E164_PHONE_NUMBER_FIELD);
        map.put("DialingCountryCode", DIALING_COUNTRY_CODE_FIELD);
        map.put("IsoCountryCode", ISO_COUNTRY_CODE_FIELD);
        map.put("Country", COUNTRY_FIELD);
        map.put("MCC", MCC_FIELD);
        map.put("MNC", MNC_FIELD);
        map.put("Carrier", CARRIER_FIELD);
        map.put("PhoneNumberType", PHONE_NUMBER_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CarrierLookupResponse, T> g) {
        return obj -> g.apply((CarrierLookupResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointSmsVoiceV2Response.BuilderImpl
    implements Builder {
        private String e164PhoneNumber;
        private String dialingCountryCode;
        private String isoCountryCode;
        private String country;
        private String mcc;
        private String mnc;
        private String carrier;
        private String phoneNumberType;

        private BuilderImpl() {
        }

        private BuilderImpl(CarrierLookupResponse model) {
            super(model);
            this.e164PhoneNumber(model.e164PhoneNumber);
            this.dialingCountryCode(model.dialingCountryCode);
            this.isoCountryCode(model.isoCountryCode);
            this.country(model.country);
            this.mcc(model.mcc);
            this.mnc(model.mnc);
            this.carrier(model.carrier);
            this.phoneNumberType(model.phoneNumberType);
        }

        public final String getE164PhoneNumber() {
            return this.e164PhoneNumber;
        }

        public final void setE164PhoneNumber(String e164PhoneNumber) {
            this.e164PhoneNumber = e164PhoneNumber;
        }

        @Override
        public final Builder e164PhoneNumber(String e164PhoneNumber) {
            this.e164PhoneNumber = e164PhoneNumber;
            return this;
        }

        public final String getDialingCountryCode() {
            return this.dialingCountryCode;
        }

        public final void setDialingCountryCode(String dialingCountryCode) {
            this.dialingCountryCode = dialingCountryCode;
        }

        @Override
        public final Builder dialingCountryCode(String dialingCountryCode) {
            this.dialingCountryCode = dialingCountryCode;
            return this;
        }

        public final String getIsoCountryCode() {
            return this.isoCountryCode;
        }

        public final void setIsoCountryCode(String isoCountryCode) {
            this.isoCountryCode = isoCountryCode;
        }

        @Override
        public final Builder isoCountryCode(String isoCountryCode) {
            this.isoCountryCode = isoCountryCode;
            return this;
        }

        public final String getCountry() {
            return this.country;
        }

        public final void setCountry(String country) {
            this.country = country;
        }

        @Override
        public final Builder country(String country) {
            this.country = country;
            return this;
        }

        public final String getMcc() {
            return this.mcc;
        }

        public final void setMcc(String mcc) {
            this.mcc = mcc;
        }

        @Override
        public final Builder mcc(String mcc) {
            this.mcc = mcc;
            return this;
        }

        public final String getMnc() {
            return this.mnc;
        }

        public final void setMnc(String mnc) {
            this.mnc = mnc;
        }

        @Override
        public final Builder mnc(String mnc) {
            this.mnc = mnc;
            return this;
        }

        public final String getCarrier() {
            return this.carrier;
        }

        public final void setCarrier(String carrier) {
            this.carrier = carrier;
        }

        @Override
        public final Builder carrier(String carrier) {
            this.carrier = carrier;
            return this;
        }

        public final String getPhoneNumberType() {
            return this.phoneNumberType;
        }

        public final void setPhoneNumberType(String phoneNumberType) {
            this.phoneNumberType = phoneNumberType;
        }

        @Override
        public final Builder phoneNumberType(String phoneNumberType) {
            this.phoneNumberType = phoneNumberType;
            return this;
        }

        @Override
        public final Builder phoneNumberType(PhoneNumberType phoneNumberType) {
            this.phoneNumberType(phoneNumberType == null ? null : phoneNumberType.toString());
            return this;
        }

        @Override
        public CarrierLookupResponse build() {
            return new CarrierLookupResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PinpointSmsVoiceV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CarrierLookupResponse> {
        public Builder e164PhoneNumber(String var1);

        public Builder dialingCountryCode(String var1);

        public Builder isoCountryCode(String var1);

        public Builder country(String var1);

        public Builder mcc(String var1);

        public Builder mnc(String var1);

        public Builder carrier(String var1);

        public Builder phoneNumberType(String var1);

        public Builder phoneNumberType(PhoneNumberType var1);
    }
}

