/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pipes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Secrets Manager secret that stores your stream credentials.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SelfManagedKafkaAccessConfigurationCredentials implements SdkPojo, Serializable,
        ToCopyableBuilder<SelfManagedKafkaAccessConfigurationCredentials.Builder, SelfManagedKafkaAccessConfigurationCredentials> {
    private static final SdkField<String> BASIC_AUTH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BasicAuth").getter(getter(SelfManagedKafkaAccessConfigurationCredentials::basicAuth))
            .setter(setter(Builder::basicAuth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BasicAuth").build()).build();

    private static final SdkField<String> CLIENT_CERTIFICATE_TLS_AUTH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientCertificateTlsAuth")
            .getter(getter(SelfManagedKafkaAccessConfigurationCredentials::clientCertificateTlsAuth))
            .setter(setter(Builder::clientCertificateTlsAuth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientCertificateTlsAuth").build())
            .build();

    private static final SdkField<String> SASL_SCRAM256_AUTH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SaslScram256Auth").getter(getter(SelfManagedKafkaAccessConfigurationCredentials::saslScram256Auth))
            .setter(setter(Builder::saslScram256Auth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SaslScram256Auth").build()).build();

    private static final SdkField<String> SASL_SCRAM512_AUTH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SaslScram512Auth").getter(getter(SelfManagedKafkaAccessConfigurationCredentials::saslScram512Auth))
            .setter(setter(Builder::saslScram512Auth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SaslScram512Auth").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASIC_AUTH_FIELD,
            CLIENT_CERTIFICATE_TLS_AUTH_FIELD, SASL_SCRAM256_AUTH_FIELD, SASL_SCRAM512_AUTH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String basicAuth;

    private final String clientCertificateTlsAuth;

    private final String saslScram256Auth;

    private final String saslScram512Auth;

    private final Type type;

    private SelfManagedKafkaAccessConfigurationCredentials(BuilderImpl builder) {
        this.basicAuth = builder.basicAuth;
        this.clientCertificateTlsAuth = builder.clientCertificateTlsAuth;
        this.saslScram256Auth = builder.saslScram256Auth;
        this.saslScram512Auth = builder.saslScram512Auth;
        this.type = builder.type;
    }

    /**
     * <p>
     * The ARN of the Secrets Manager secret.
     * </p>
     * 
     * @return The ARN of the Secrets Manager secret.
     */
    public final String basicAuth() {
        return basicAuth;
    }

    /**
     * <p>
     * The ARN of the Secrets Manager secret.
     * </p>
     * 
     * @return The ARN of the Secrets Manager secret.
     */
    public final String clientCertificateTlsAuth() {
        return clientCertificateTlsAuth;
    }

    /**
     * <p>
     * The ARN of the Secrets Manager secret.
     * </p>
     * 
     * @return The ARN of the Secrets Manager secret.
     */
    public final String saslScram256Auth() {
        return saslScram256Auth;
    }

    /**
     * <p>
     * The ARN of the Secrets Manager secret.
     * </p>
     * 
     * @return The ARN of the Secrets Manager secret.
     */
    public final String saslScram512Auth() {
        return saslScram512Auth;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(basicAuth());
        hashCode = 31 * hashCode + Objects.hashCode(clientCertificateTlsAuth());
        hashCode = 31 * hashCode + Objects.hashCode(saslScram256Auth());
        hashCode = 31 * hashCode + Objects.hashCode(saslScram512Auth());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SelfManagedKafkaAccessConfigurationCredentials)) {
            return false;
        }
        SelfManagedKafkaAccessConfigurationCredentials other = (SelfManagedKafkaAccessConfigurationCredentials) obj;
        return Objects.equals(basicAuth(), other.basicAuth())
                && Objects.equals(clientCertificateTlsAuth(), other.clientCertificateTlsAuth())
                && Objects.equals(saslScram256Auth(), other.saslScram256Auth())
                && Objects.equals(saslScram512Auth(), other.saslScram512Auth());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SelfManagedKafkaAccessConfigurationCredentials").add("BasicAuth", basicAuth())
                .add("ClientCertificateTlsAuth", clientCertificateTlsAuth()).add("SaslScram256Auth", saslScram256Auth())
                .add("SaslScram512Auth", saslScram512Auth()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BasicAuth":
            return Optional.ofNullable(clazz.cast(basicAuth()));
        case "ClientCertificateTlsAuth":
            return Optional.ofNullable(clazz.cast(clientCertificateTlsAuth()));
        case "SaslScram256Auth":
            return Optional.ofNullable(clazz.cast(saslScram256Auth()));
        case "SaslScram512Auth":
            return Optional.ofNullable(clazz.cast(saslScram512Auth()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #basicAuth()} initialized to the given value.
     *
     * <p>
     * The ARN of the Secrets Manager secret.
     * </p>
     * 
     * @param basicAuth
     *        The ARN of the Secrets Manager secret.
     */
    public static SelfManagedKafkaAccessConfigurationCredentials fromBasicAuth(String basicAuth) {
        return builder().basicAuth(basicAuth).build();
    }

    /**
     * Create an instance of this class with {@link #clientCertificateTlsAuth()} initialized to the given value.
     *
     * <p>
     * The ARN of the Secrets Manager secret.
     * </p>
     * 
     * @param clientCertificateTlsAuth
     *        The ARN of the Secrets Manager secret.
     */
    public static SelfManagedKafkaAccessConfigurationCredentials fromClientCertificateTlsAuth(String clientCertificateTlsAuth) {
        return builder().clientCertificateTlsAuth(clientCertificateTlsAuth).build();
    }

    /**
     * Create an instance of this class with {@link #saslScram256Auth()} initialized to the given value.
     *
     * <p>
     * The ARN of the Secrets Manager secret.
     * </p>
     * 
     * @param saslScram256Auth
     *        The ARN of the Secrets Manager secret.
     */
    public static SelfManagedKafkaAccessConfigurationCredentials fromSaslScram256Auth(String saslScram256Auth) {
        return builder().saslScram256Auth(saslScram256Auth).build();
    }

    /**
     * Create an instance of this class with {@link #saslScram512Auth()} initialized to the given value.
     *
     * <p>
     * The ARN of the Secrets Manager secret.
     * </p>
     * 
     * @param saslScram512Auth
     *        The ARN of the Secrets Manager secret.
     */
    public static SelfManagedKafkaAccessConfigurationCredentials fromSaslScram512Auth(String saslScram512Auth) {
        return builder().saslScram512Auth(saslScram512Auth).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SelfManagedKafkaAccessConfigurationCredentials, T> g) {
        return obj -> g.apply((SelfManagedKafkaAccessConfigurationCredentials) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SelfManagedKafkaAccessConfigurationCredentials> {
        /**
         * <p>
         * The ARN of the Secrets Manager secret.
         * </p>
         * 
         * @param basicAuth
         *        The ARN of the Secrets Manager secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder basicAuth(String basicAuth);

        /**
         * <p>
         * The ARN of the Secrets Manager secret.
         * </p>
         * 
         * @param clientCertificateTlsAuth
         *        The ARN of the Secrets Manager secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientCertificateTlsAuth(String clientCertificateTlsAuth);

        /**
         * <p>
         * The ARN of the Secrets Manager secret.
         * </p>
         * 
         * @param saslScram256Auth
         *        The ARN of the Secrets Manager secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder saslScram256Auth(String saslScram256Auth);

        /**
         * <p>
         * The ARN of the Secrets Manager secret.
         * </p>
         * 
         * @param saslScram512Auth
         *        The ARN of the Secrets Manager secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder saslScram512Auth(String saslScram512Auth);
    }

    static final class BuilderImpl implements Builder {
        private String basicAuth;

        private String clientCertificateTlsAuth;

        private String saslScram256Auth;

        private String saslScram512Auth;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(SelfManagedKafkaAccessConfigurationCredentials model) {
            basicAuth(model.basicAuth);
            clientCertificateTlsAuth(model.clientCertificateTlsAuth);
            saslScram256Auth(model.saslScram256Auth);
            saslScram512Auth(model.saslScram512Auth);
        }

        public final String getBasicAuth() {
            return basicAuth;
        }

        public final void setBasicAuth(String basicAuth) {
            Object oldValue = this.basicAuth;
            this.basicAuth = basicAuth;
            handleUnionValueChange(Type.BASIC_AUTH, oldValue, this.basicAuth);
        }

        @Override
        public final Builder basicAuth(String basicAuth) {
            Object oldValue = this.basicAuth;
            this.basicAuth = basicAuth;
            handleUnionValueChange(Type.BASIC_AUTH, oldValue, this.basicAuth);
            return this;
        }

        public final String getClientCertificateTlsAuth() {
            return clientCertificateTlsAuth;
        }

        public final void setClientCertificateTlsAuth(String clientCertificateTlsAuth) {
            Object oldValue = this.clientCertificateTlsAuth;
            this.clientCertificateTlsAuth = clientCertificateTlsAuth;
            handleUnionValueChange(Type.CLIENT_CERTIFICATE_TLS_AUTH, oldValue, this.clientCertificateTlsAuth);
        }

        @Override
        public final Builder clientCertificateTlsAuth(String clientCertificateTlsAuth) {
            Object oldValue = this.clientCertificateTlsAuth;
            this.clientCertificateTlsAuth = clientCertificateTlsAuth;
            handleUnionValueChange(Type.CLIENT_CERTIFICATE_TLS_AUTH, oldValue, this.clientCertificateTlsAuth);
            return this;
        }

        public final String getSaslScram256Auth() {
            return saslScram256Auth;
        }

        public final void setSaslScram256Auth(String saslScram256Auth) {
            Object oldValue = this.saslScram256Auth;
            this.saslScram256Auth = saslScram256Auth;
            handleUnionValueChange(Type.SASL_SCRAM256_AUTH, oldValue, this.saslScram256Auth);
        }

        @Override
        public final Builder saslScram256Auth(String saslScram256Auth) {
            Object oldValue = this.saslScram256Auth;
            this.saslScram256Auth = saslScram256Auth;
            handleUnionValueChange(Type.SASL_SCRAM256_AUTH, oldValue, this.saslScram256Auth);
            return this;
        }

        public final String getSaslScram512Auth() {
            return saslScram512Auth;
        }

        public final void setSaslScram512Auth(String saslScram512Auth) {
            Object oldValue = this.saslScram512Auth;
            this.saslScram512Auth = saslScram512Auth;
            handleUnionValueChange(Type.SASL_SCRAM512_AUTH, oldValue, this.saslScram512Auth);
        }

        @Override
        public final Builder saslScram512Auth(String saslScram512Auth) {
            Object oldValue = this.saslScram512Auth;
            this.saslScram512Auth = saslScram512Auth;
            handleUnionValueChange(Type.SASL_SCRAM512_AUTH, oldValue, this.saslScram512Auth);
            return this;
        }

        @Override
        public SelfManagedKafkaAccessConfigurationCredentials build() {
            return new SelfManagedKafkaAccessConfigurationCredentials(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see SelfManagedKafkaAccessConfigurationCredentials#type()
     */
    public enum Type {
        BASIC_AUTH,

        CLIENT_CERTIFICATE_TLS_AUTH,

        SASL_SCRAM256_AUTH,

        SASL_SCRAM512_AUTH,

        UNKNOWN_TO_SDK_VERSION
    }
}
