/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pipes;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.pipes.DefaultPipesAsyncClient;
import software.amazon.awssdk.services.pipes.DefaultPipesBaseClientBuilder;
import software.amazon.awssdk.services.pipes.PipesAsyncClient;
import software.amazon.awssdk.services.pipes.PipesAsyncClientBuilder;
import software.amazon.awssdk.services.pipes.PipesServiceClientConfiguration;
import software.amazon.awssdk.services.pipes.endpoints.PipesEndpointProvider;

@SdkInternalApi
final class DefaultPipesAsyncClientBuilder
extends DefaultPipesBaseClientBuilder<PipesAsyncClientBuilder, PipesAsyncClient>
implements PipesAsyncClientBuilder {
    DefaultPipesAsyncClientBuilder() {
    }

    @Override
    public DefaultPipesAsyncClientBuilder endpointProvider(PipesEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final PipesAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultPipesAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        PipesServiceClientConfiguration serviceClientConfiguration = PipesServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultPipesAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

