/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pipes.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribePipeResponse extends PipesResponse implements
        ToCopyableBuilder<DescribePipeResponse.Builder, DescribePipeResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(DescribePipeResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribePipeResponse::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> CURRENT_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrentState").getter(getter(DescribePipeResponse::currentStateAsString))
            .setter(setter(Builder::currentState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentState").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DescribePipeResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> DESIRED_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DesiredState").getter(getter(DescribePipeResponse::desiredStateAsString))
            .setter(setter(Builder::desiredState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredState").build()).build();

    private static final SdkField<String> ENRICHMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Enrichment").getter(getter(DescribePipeResponse::enrichment)).setter(setter(Builder::enrichment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enrichment").build()).build();

    private static final SdkField<PipeEnrichmentParameters> ENRICHMENT_PARAMETERS_FIELD = SdkField
            .<PipeEnrichmentParameters> builder(MarshallingType.SDK_POJO).memberName("EnrichmentParameters")
            .getter(getter(DescribePipeResponse::enrichmentParameters)).setter(setter(Builder::enrichmentParameters))
            .constructor(PipeEnrichmentParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnrichmentParameters").build())
            .build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(DescribePipeResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<PipeLogConfiguration> LOG_CONFIGURATION_FIELD = SdkField
            .<PipeLogConfiguration> builder(MarshallingType.SDK_POJO).memberName("LogConfiguration")
            .getter(getter(DescribePipeResponse::logConfiguration)).setter(setter(Builder::logConfiguration))
            .constructor(PipeLogConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogConfiguration").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DescribePipeResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(DescribePipeResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Source")
            .getter(getter(DescribePipeResponse::source)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final SdkField<PipeSourceParameters> SOURCE_PARAMETERS_FIELD = SdkField
            .<PipeSourceParameters> builder(MarshallingType.SDK_POJO).memberName("SourceParameters")
            .getter(getter(DescribePipeResponse::sourceParameters)).setter(setter(Builder::sourceParameters))
            .constructor(PipeSourceParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceParameters").build()).build();

    private static final SdkField<String> STATE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StateReason").getter(getter(DescribePipeResponse::stateReason)).setter(setter(Builder::stateReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReason").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(DescribePipeResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Target")
            .getter(getter(DescribePipeResponse::target)).setter(setter(Builder::target))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()).build();

    private static final SdkField<PipeTargetParameters> TARGET_PARAMETERS_FIELD = SdkField
            .<PipeTargetParameters> builder(MarshallingType.SDK_POJO).memberName("TargetParameters")
            .getter(getter(DescribePipeResponse::targetParameters)).setter(setter(Builder::targetParameters))
            .constructor(PipeTargetParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetParameters").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            CREATION_TIME_FIELD, CURRENT_STATE_FIELD, DESCRIPTION_FIELD, DESIRED_STATE_FIELD, ENRICHMENT_FIELD,
            ENRICHMENT_PARAMETERS_FIELD, LAST_MODIFIED_TIME_FIELD, LOG_CONFIGURATION_FIELD, NAME_FIELD, ROLE_ARN_FIELD,
            SOURCE_FIELD, SOURCE_PARAMETERS_FIELD, STATE_REASON_FIELD, TAGS_FIELD, TARGET_FIELD, TARGET_PARAMETERS_FIELD));

    private final String arn;

    private final Instant creationTime;

    private final String currentState;

    private final String description;

    private final String desiredState;

    private final String enrichment;

    private final PipeEnrichmentParameters enrichmentParameters;

    private final Instant lastModifiedTime;

    private final PipeLogConfiguration logConfiguration;

    private final String name;

    private final String roleArn;

    private final String source;

    private final PipeSourceParameters sourceParameters;

    private final String stateReason;

    private final Map<String, String> tags;

    private final String target;

    private final PipeTargetParameters targetParameters;

    private DescribePipeResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.creationTime = builder.creationTime;
        this.currentState = builder.currentState;
        this.description = builder.description;
        this.desiredState = builder.desiredState;
        this.enrichment = builder.enrichment;
        this.enrichmentParameters = builder.enrichmentParameters;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.logConfiguration = builder.logConfiguration;
        this.name = builder.name;
        this.roleArn = builder.roleArn;
        this.source = builder.source;
        this.sourceParameters = builder.sourceParameters;
        this.stateReason = builder.stateReason;
        this.tags = builder.tags;
        this.target = builder.target;
        this.targetParameters = builder.targetParameters;
    }

    /**
     * <p>
     * The ARN of the pipe.
     * </p>
     * 
     * @return The ARN of the pipe.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The time the pipe was created.
     * </p>
     * 
     * @return The time the pipe was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The state the pipe is in.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currentState} will
     * return {@link PipeState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currentStateAsString}.
     * </p>
     * 
     * @return The state the pipe is in.
     * @see PipeState
     */
    public final PipeState currentState() {
        return PipeState.fromValue(currentState);
    }

    /**
     * <p>
     * The state the pipe is in.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currentState} will
     * return {@link PipeState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currentStateAsString}.
     * </p>
     * 
     * @return The state the pipe is in.
     * @see PipeState
     */
    public final String currentStateAsString() {
        return currentState;
    }

    /**
     * <p>
     * A description of the pipe.
     * </p>
     * 
     * @return A description of the pipe.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The state the pipe should be in.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #desiredState} will
     * return {@link RequestedPipeStateDescribeResponse#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #desiredStateAsString}.
     * </p>
     * 
     * @return The state the pipe should be in.
     * @see RequestedPipeStateDescribeResponse
     */
    public final RequestedPipeStateDescribeResponse desiredState() {
        return RequestedPipeStateDescribeResponse.fromValue(desiredState);
    }

    /**
     * <p>
     * The state the pipe should be in.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #desiredState} will
     * return {@link RequestedPipeStateDescribeResponse#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #desiredStateAsString}.
     * </p>
     * 
     * @return The state the pipe should be in.
     * @see RequestedPipeStateDescribeResponse
     */
    public final String desiredStateAsString() {
        return desiredState;
    }

    /**
     * <p>
     * The ARN of the enrichment resource.
     * </p>
     * 
     * @return The ARN of the enrichment resource.
     */
    public final String enrichment() {
        return enrichment;
    }

    /**
     * <p>
     * The parameters required to set up enrichment on your pipe.
     * </p>
     * 
     * @return The parameters required to set up enrichment on your pipe.
     */
    public final PipeEnrichmentParameters enrichmentParameters() {
        return enrichmentParameters;
    }

    /**
     * <p>
     * When the pipe was last updated, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a>
     * (YYYY-MM-DDThh:mm:ss.sTZD).
     * </p>
     * 
     * @return When the pipe was last updated, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a>
     *         (YYYY-MM-DDThh:mm:ss.sTZD).
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The logging configuration settings for the pipe.
     * </p>
     * 
     * @return The logging configuration settings for the pipe.
     */
    public final PipeLogConfiguration logConfiguration() {
        return logConfiguration;
    }

    /**
     * <p>
     * The name of the pipe.
     * </p>
     * 
     * @return The name of the pipe.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ARN of the role that allows the pipe to send data to the target.
     * </p>
     * 
     * @return The ARN of the role that allows the pipe to send data to the target.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The ARN of the source resource.
     * </p>
     * 
     * @return The ARN of the source resource.
     */
    public final String source() {
        return source;
    }

    /**
     * <p>
     * The parameters required to set up a source for your pipe.
     * </p>
     * 
     * @return The parameters required to set up a source for your pipe.
     */
    public final PipeSourceParameters sourceParameters() {
        return sourceParameters;
    }

    /**
     * <p>
     * The reason the pipe is in its current state.
     * </p>
     * 
     * @return The reason the pipe is in its current state.
     */
    public final String stateReason() {
        return stateReason;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The list of key-value pairs to associate with the pipe.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The list of key-value pairs to associate with the pipe.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The ARN of the target resource.
     * </p>
     * 
     * @return The ARN of the target resource.
     */
    public final String target() {
        return target;
    }

    /**
     * <p>
     * The parameters required to set up a target for your pipe.
     * </p>
     * <p>
     * For more information about pipe target parameters, including how to use dynamic path parameters, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-event-target.html">Target parameters</a>
     * in the <i>Amazon EventBridge User Guide</i>.
     * </p>
     * 
     * @return The parameters required to set up a target for your pipe.</p>
     *         <p>
     *         For more information about pipe target parameters, including how to use dynamic path parameters, see <a
     *         href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-event-target.html">Target
     *         parameters</a> in the <i>Amazon EventBridge User Guide</i>.
     */
    public final PipeTargetParameters targetParameters() {
        return targetParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(currentStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(desiredStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(enrichment());
        hashCode = 31 * hashCode + Objects.hashCode(enrichmentParameters());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(logConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(sourceParameters());
        hashCode = 31 * hashCode + Objects.hashCode(stateReason());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(target());
        hashCode = 31 * hashCode + Objects.hashCode(targetParameters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePipeResponse)) {
            return false;
        }
        DescribePipeResponse other = (DescribePipeResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(currentStateAsString(), other.currentStateAsString())
                && Objects.equals(description(), other.description())
                && Objects.equals(desiredStateAsString(), other.desiredStateAsString())
                && Objects.equals(enrichment(), other.enrichment())
                && Objects.equals(enrichmentParameters(), other.enrichmentParameters())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(logConfiguration(), other.logConfiguration()) && Objects.equals(name(), other.name())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(source(), other.source())
                && Objects.equals(sourceParameters(), other.sourceParameters())
                && Objects.equals(stateReason(), other.stateReason()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(target(), other.target())
                && Objects.equals(targetParameters(), other.targetParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribePipeResponse").add("Arn", arn()).add("CreationTime", creationTime())
                .add("CurrentState", currentStateAsString())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DesiredState", desiredStateAsString()).add("Enrichment", enrichment())
                .add("EnrichmentParameters", enrichmentParameters()).add("LastModifiedTime", lastModifiedTime())
                .add("LogConfiguration", logConfiguration()).add("Name", name()).add("RoleArn", roleArn())
                .add("Source", source()).add("SourceParameters", sourceParameters()).add("StateReason", stateReason())
                .add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***").add("Target", target())
                .add("TargetParameters", targetParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "CurrentState":
            return Optional.ofNullable(clazz.cast(currentStateAsString()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DesiredState":
            return Optional.ofNullable(clazz.cast(desiredStateAsString()));
        case "Enrichment":
            return Optional.ofNullable(clazz.cast(enrichment()));
        case "EnrichmentParameters":
            return Optional.ofNullable(clazz.cast(enrichmentParameters()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "LogConfiguration":
            return Optional.ofNullable(clazz.cast(logConfiguration()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "SourceParameters":
            return Optional.ofNullable(clazz.cast(sourceParameters()));
        case "StateReason":
            return Optional.ofNullable(clazz.cast(stateReason()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "Target":
            return Optional.ofNullable(clazz.cast(target()));
        case "TargetParameters":
            return Optional.ofNullable(clazz.cast(targetParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePipeResponse, T> g) {
        return obj -> g.apply((DescribePipeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PipesResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribePipeResponse> {
        /**
         * <p>
         * The ARN of the pipe.
         * </p>
         * 
         * @param arn
         *        The ARN of the pipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The time the pipe was created.
         * </p>
         * 
         * @param creationTime
         *        The time the pipe was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The state the pipe is in.
         * </p>
         * 
         * @param currentState
         *        The state the pipe is in.
         * @see PipeState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PipeState
         */
        Builder currentState(String currentState);

        /**
         * <p>
         * The state the pipe is in.
         * </p>
         * 
         * @param currentState
         *        The state the pipe is in.
         * @see PipeState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PipeState
         */
        Builder currentState(PipeState currentState);

        /**
         * <p>
         * A description of the pipe.
         * </p>
         * 
         * @param description
         *        A description of the pipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The state the pipe should be in.
         * </p>
         * 
         * @param desiredState
         *        The state the pipe should be in.
         * @see RequestedPipeStateDescribeResponse
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequestedPipeStateDescribeResponse
         */
        Builder desiredState(String desiredState);

        /**
         * <p>
         * The state the pipe should be in.
         * </p>
         * 
         * @param desiredState
         *        The state the pipe should be in.
         * @see RequestedPipeStateDescribeResponse
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequestedPipeStateDescribeResponse
         */
        Builder desiredState(RequestedPipeStateDescribeResponse desiredState);

        /**
         * <p>
         * The ARN of the enrichment resource.
         * </p>
         * 
         * @param enrichment
         *        The ARN of the enrichment resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enrichment(String enrichment);

        /**
         * <p>
         * The parameters required to set up enrichment on your pipe.
         * </p>
         * 
         * @param enrichmentParameters
         *        The parameters required to set up enrichment on your pipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enrichmentParameters(PipeEnrichmentParameters enrichmentParameters);

        /**
         * <p>
         * The parameters required to set up enrichment on your pipe.
         * </p>
         * This is a convenience method that creates an instance of the {@link PipeEnrichmentParameters.Builder}
         * avoiding the need to create one manually via {@link PipeEnrichmentParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PipeEnrichmentParameters.Builder#build()} is called immediately
         * and its result is passed to {@link #enrichmentParameters(PipeEnrichmentParameters)}.
         * 
         * @param enrichmentParameters
         *        a consumer that will call methods on {@link PipeEnrichmentParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #enrichmentParameters(PipeEnrichmentParameters)
         */
        default Builder enrichmentParameters(Consumer<PipeEnrichmentParameters.Builder> enrichmentParameters) {
            return enrichmentParameters(PipeEnrichmentParameters.builder().applyMutation(enrichmentParameters).build());
        }

        /**
         * <p>
         * When the pipe was last updated, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a>
         * (YYYY-MM-DDThh:mm:ss.sTZD).
         * </p>
         * 
         * @param lastModifiedTime
         *        When the pipe was last updated, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a>
         *        (YYYY-MM-DDThh:mm:ss.sTZD).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The logging configuration settings for the pipe.
         * </p>
         * 
         * @param logConfiguration
         *        The logging configuration settings for the pipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logConfiguration(PipeLogConfiguration logConfiguration);

        /**
         * <p>
         * The logging configuration settings for the pipe.
         * </p>
         * This is a convenience method that creates an instance of the {@link PipeLogConfiguration.Builder} avoiding
         * the need to create one manually via {@link PipeLogConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PipeLogConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #logConfiguration(PipeLogConfiguration)}.
         * 
         * @param logConfiguration
         *        a consumer that will call methods on {@link PipeLogConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logConfiguration(PipeLogConfiguration)
         */
        default Builder logConfiguration(Consumer<PipeLogConfiguration.Builder> logConfiguration) {
            return logConfiguration(PipeLogConfiguration.builder().applyMutation(logConfiguration).build());
        }

        /**
         * <p>
         * The name of the pipe.
         * </p>
         * 
         * @param name
         *        The name of the pipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ARN of the role that allows the pipe to send data to the target.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the role that allows the pipe to send data to the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The ARN of the source resource.
         * </p>
         * 
         * @param source
         *        The ARN of the source resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(String source);

        /**
         * <p>
         * The parameters required to set up a source for your pipe.
         * </p>
         * 
         * @param sourceParameters
         *        The parameters required to set up a source for your pipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceParameters(PipeSourceParameters sourceParameters);

        /**
         * <p>
         * The parameters required to set up a source for your pipe.
         * </p>
         * This is a convenience method that creates an instance of the {@link PipeSourceParameters.Builder} avoiding
         * the need to create one manually via {@link PipeSourceParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PipeSourceParameters.Builder#build()} is called immediately and
         * its result is passed to {@link #sourceParameters(PipeSourceParameters)}.
         * 
         * @param sourceParameters
         *        a consumer that will call methods on {@link PipeSourceParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceParameters(PipeSourceParameters)
         */
        default Builder sourceParameters(Consumer<PipeSourceParameters.Builder> sourceParameters) {
            return sourceParameters(PipeSourceParameters.builder().applyMutation(sourceParameters).build());
        }

        /**
         * <p>
         * The reason the pipe is in its current state.
         * </p>
         * 
         * @param stateReason
         *        The reason the pipe is in its current state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateReason(String stateReason);

        /**
         * <p>
         * The list of key-value pairs to associate with the pipe.
         * </p>
         * 
         * @param tags
         *        The list of key-value pairs to associate with the pipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The ARN of the target resource.
         * </p>
         * 
         * @param target
         *        The ARN of the target resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(String target);

        /**
         * <p>
         * The parameters required to set up a target for your pipe.
         * </p>
         * <p>
         * For more information about pipe target parameters, including how to use dynamic path parameters, see <a
         * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-event-target.html">Target
         * parameters</a> in the <i>Amazon EventBridge User Guide</i>.
         * </p>
         * 
         * @param targetParameters
         *        The parameters required to set up a target for your pipe.</p>
         *        <p>
         *        For more information about pipe target parameters, including how to use dynamic path parameters, see
         *        <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-event-target.html">Target
         *        parameters</a> in the <i>Amazon EventBridge User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetParameters(PipeTargetParameters targetParameters);

        /**
         * <p>
         * The parameters required to set up a target for your pipe.
         * </p>
         * <p>
         * For more information about pipe target parameters, including how to use dynamic path parameters, see <a
         * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-event-target.html">Target
         * parameters</a> in the <i>Amazon EventBridge User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link PipeTargetParameters.Builder} avoiding
         * the need to create one manually via {@link PipeTargetParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PipeTargetParameters.Builder#build()} is called immediately and
         * its result is passed to {@link #targetParameters(PipeTargetParameters)}.
         * 
         * @param targetParameters
         *        a consumer that will call methods on {@link PipeTargetParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetParameters(PipeTargetParameters)
         */
        default Builder targetParameters(Consumer<PipeTargetParameters.Builder> targetParameters) {
            return targetParameters(PipeTargetParameters.builder().applyMutation(targetParameters).build());
        }
    }

    static final class BuilderImpl extends PipesResponse.BuilderImpl implements Builder {
        private String arn;

        private Instant creationTime;

        private String currentState;

        private String description;

        private String desiredState;

        private String enrichment;

        private PipeEnrichmentParameters enrichmentParameters;

        private Instant lastModifiedTime;

        private PipeLogConfiguration logConfiguration;

        private String name;

        private String roleArn;

        private String source;

        private PipeSourceParameters sourceParameters;

        private String stateReason;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String target;

        private PipeTargetParameters targetParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePipeResponse model) {
            super(model);
            arn(model.arn);
            creationTime(model.creationTime);
            currentState(model.currentState);
            description(model.description);
            desiredState(model.desiredState);
            enrichment(model.enrichment);
            enrichmentParameters(model.enrichmentParameters);
            lastModifiedTime(model.lastModifiedTime);
            logConfiguration(model.logConfiguration);
            name(model.name);
            roleArn(model.roleArn);
            source(model.source);
            sourceParameters(model.sourceParameters);
            stateReason(model.stateReason);
            tags(model.tags);
            target(model.target);
            targetParameters(model.targetParameters);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getCurrentState() {
            return currentState;
        }

        public final void setCurrentState(String currentState) {
            this.currentState = currentState;
        }

        @Override
        public final Builder currentState(String currentState) {
            this.currentState = currentState;
            return this;
        }

        @Override
        public final Builder currentState(PipeState currentState) {
            this.currentState(currentState == null ? null : currentState.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDesiredState() {
            return desiredState;
        }

        public final void setDesiredState(String desiredState) {
            this.desiredState = desiredState;
        }

        @Override
        public final Builder desiredState(String desiredState) {
            this.desiredState = desiredState;
            return this;
        }

        @Override
        public final Builder desiredState(RequestedPipeStateDescribeResponse desiredState) {
            this.desiredState(desiredState == null ? null : desiredState.toString());
            return this;
        }

        public final String getEnrichment() {
            return enrichment;
        }

        public final void setEnrichment(String enrichment) {
            this.enrichment = enrichment;
        }

        @Override
        public final Builder enrichment(String enrichment) {
            this.enrichment = enrichment;
            return this;
        }

        public final PipeEnrichmentParameters.Builder getEnrichmentParameters() {
            return enrichmentParameters != null ? enrichmentParameters.toBuilder() : null;
        }

        public final void setEnrichmentParameters(PipeEnrichmentParameters.BuilderImpl enrichmentParameters) {
            this.enrichmentParameters = enrichmentParameters != null ? enrichmentParameters.build() : null;
        }

        @Override
        public final Builder enrichmentParameters(PipeEnrichmentParameters enrichmentParameters) {
            this.enrichmentParameters = enrichmentParameters;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final PipeLogConfiguration.Builder getLogConfiguration() {
            return logConfiguration != null ? logConfiguration.toBuilder() : null;
        }

        public final void setLogConfiguration(PipeLogConfiguration.BuilderImpl logConfiguration) {
            this.logConfiguration = logConfiguration != null ? logConfiguration.build() : null;
        }

        @Override
        public final Builder logConfiguration(PipeLogConfiguration logConfiguration) {
            this.logConfiguration = logConfiguration;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final PipeSourceParameters.Builder getSourceParameters() {
            return sourceParameters != null ? sourceParameters.toBuilder() : null;
        }

        public final void setSourceParameters(PipeSourceParameters.BuilderImpl sourceParameters) {
            this.sourceParameters = sourceParameters != null ? sourceParameters.build() : null;
        }

        @Override
        public final Builder sourceParameters(PipeSourceParameters sourceParameters) {
            this.sourceParameters = sourceParameters;
            return this;
        }

        public final String getStateReason() {
            return stateReason;
        }

        public final void setStateReason(String stateReason) {
            this.stateReason = stateReason;
        }

        @Override
        public final Builder stateReason(String stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getTarget() {
            return target;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final PipeTargetParameters.Builder getTargetParameters() {
            return targetParameters != null ? targetParameters.toBuilder() : null;
        }

        public final void setTargetParameters(PipeTargetParameters.BuilderImpl targetParameters) {
            this.targetParameters = targetParameters != null ? targetParameters.build() : null;
        }

        @Override
        public final Builder targetParameters(PipeTargetParameters targetParameters) {
            this.targetParameters = targetParameters;
            return this;
        }

        @Override
        public DescribePipeResponse build() {
            return new DescribePipeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
