/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pipes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pipes.model.PipeEnrichmentHttpParameters;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PipeEnrichmentParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PipeEnrichmentParameters> {
    private static final SdkField<String> INPUT_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InputTemplate").getter(PipeEnrichmentParameters.getter(PipeEnrichmentParameters::inputTemplate)).setter(PipeEnrichmentParameters.setter(Builder::inputTemplate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputTemplate").build()}).build();
    private static final SdkField<PipeEnrichmentHttpParameters> HTTP_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HttpParameters").getter(PipeEnrichmentParameters.getter(PipeEnrichmentParameters::httpParameters)).setter(PipeEnrichmentParameters.setter(Builder::httpParameters)).constructor(PipeEnrichmentHttpParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpParameters").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_TEMPLATE_FIELD, HTTP_PARAMETERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String inputTemplate;
    private final PipeEnrichmentHttpParameters httpParameters;

    private PipeEnrichmentParameters(BuilderImpl builder) {
        this.inputTemplate = builder.inputTemplate;
        this.httpParameters = builder.httpParameters;
    }

    public final String inputTemplate() {
        return this.inputTemplate;
    }

    public final PipeEnrichmentHttpParameters httpParameters() {
        return this.httpParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.inputTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpParameters());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipeEnrichmentParameters)) {
            return false;
        }
        PipeEnrichmentParameters other = (PipeEnrichmentParameters)obj;
        return Objects.equals(this.inputTemplate(), other.inputTemplate()) && Objects.equals(this.httpParameters(), other.httpParameters());
    }

    public final String toString() {
        return ToString.builder((String)"PipeEnrichmentParameters").add("InputTemplate", (Object)(this.inputTemplate() == null ? null : "*** Sensitive Data Redacted ***")).add("HttpParameters", (Object)this.httpParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InputTemplate": {
                return Optional.ofNullable(clazz.cast(this.inputTemplate()));
            }
            case "HttpParameters": {
                return Optional.ofNullable(clazz.cast(this.httpParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PipeEnrichmentParameters, T> g) {
        return obj -> g.apply((PipeEnrichmentParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String inputTemplate;
        private PipeEnrichmentHttpParameters httpParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(PipeEnrichmentParameters model) {
            this.inputTemplate(model.inputTemplate);
            this.httpParameters(model.httpParameters);
        }

        public final String getInputTemplate() {
            return this.inputTemplate;
        }

        public final void setInputTemplate(String inputTemplate) {
            this.inputTemplate = inputTemplate;
        }

        @Override
        public final Builder inputTemplate(String inputTemplate) {
            this.inputTemplate = inputTemplate;
            return this;
        }

        public final PipeEnrichmentHttpParameters.Builder getHttpParameters() {
            return this.httpParameters != null ? this.httpParameters.toBuilder() : null;
        }

        public final void setHttpParameters(PipeEnrichmentHttpParameters.BuilderImpl httpParameters) {
            this.httpParameters = httpParameters != null ? httpParameters.build() : null;
        }

        @Override
        public final Builder httpParameters(PipeEnrichmentHttpParameters httpParameters) {
            this.httpParameters = httpParameters;
            return this;
        }

        public PipeEnrichmentParameters build() {
            return new PipeEnrichmentParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PipeEnrichmentParameters> {
        public Builder inputTemplate(String var1);

        public Builder httpParameters(PipeEnrichmentHttpParameters var1);

        default public Builder httpParameters(Consumer<PipeEnrichmentHttpParameters.Builder> httpParameters) {
            return this.httpParameters((PipeEnrichmentHttpParameters)((PipeEnrichmentHttpParameters.Builder)PipeEnrichmentHttpParameters.builder().applyMutation(httpParameters)).build());
        }
    }
}

