/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pipes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pipes.model.CloudwatchLogsLogDestination;
import software.amazon.awssdk.services.pipes.model.FirehoseLogDestination;
import software.amazon.awssdk.services.pipes.model.IncludeExecutionDataCopier;
import software.amazon.awssdk.services.pipes.model.IncludeExecutionDataOption;
import software.amazon.awssdk.services.pipes.model.LogLevel;
import software.amazon.awssdk.services.pipes.model.S3LogDestination;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PipeLogConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PipeLogConfiguration> {
    private static final SdkField<S3LogDestination> S3_LOG_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3LogDestination").getter(PipeLogConfiguration.getter(PipeLogConfiguration::s3LogDestination)).setter(PipeLogConfiguration.setter(Builder::s3LogDestination)).constructor(S3LogDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3LogDestination").build()}).build();
    private static final SdkField<FirehoseLogDestination> FIREHOSE_LOG_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FirehoseLogDestination").getter(PipeLogConfiguration.getter(PipeLogConfiguration::firehoseLogDestination)).setter(PipeLogConfiguration.setter(Builder::firehoseLogDestination)).constructor(FirehoseLogDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirehoseLogDestination").build()}).build();
    private static final SdkField<CloudwatchLogsLogDestination> CLOUDWATCH_LOGS_LOG_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CloudwatchLogsLogDestination").getter(PipeLogConfiguration.getter(PipeLogConfiguration::cloudwatchLogsLogDestination)).setter(PipeLogConfiguration.setter(Builder::cloudwatchLogsLogDestination)).constructor(CloudwatchLogsLogDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudwatchLogsLogDestination").build()}).build();
    private static final SdkField<String> LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Level").getter(PipeLogConfiguration.getter(PipeLogConfiguration::levelAsString)).setter(PipeLogConfiguration.setter(Builder::level)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Level").build()}).build();
    private static final SdkField<List<String>> INCLUDE_EXECUTION_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IncludeExecutionData").getter(PipeLogConfiguration.getter(PipeLogConfiguration::includeExecutionDataAsStrings)).setter(PipeLogConfiguration.setter(Builder::includeExecutionDataWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeExecutionData").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_LOG_DESTINATION_FIELD, FIREHOSE_LOG_DESTINATION_FIELD, CLOUDWATCH_LOGS_LOG_DESTINATION_FIELD, LEVEL_FIELD, INCLUDE_EXECUTION_DATA_FIELD));
    private static final long serialVersionUID = 1L;
    private final S3LogDestination s3LogDestination;
    private final FirehoseLogDestination firehoseLogDestination;
    private final CloudwatchLogsLogDestination cloudwatchLogsLogDestination;
    private final String level;
    private final List<String> includeExecutionData;

    private PipeLogConfiguration(BuilderImpl builder) {
        this.s3LogDestination = builder.s3LogDestination;
        this.firehoseLogDestination = builder.firehoseLogDestination;
        this.cloudwatchLogsLogDestination = builder.cloudwatchLogsLogDestination;
        this.level = builder.level;
        this.includeExecutionData = builder.includeExecutionData;
    }

    public final S3LogDestination s3LogDestination() {
        return this.s3LogDestination;
    }

    public final FirehoseLogDestination firehoseLogDestination() {
        return this.firehoseLogDestination;
    }

    public final CloudwatchLogsLogDestination cloudwatchLogsLogDestination() {
        return this.cloudwatchLogsLogDestination;
    }

    public final LogLevel level() {
        return LogLevel.fromValue(this.level);
    }

    public final String levelAsString() {
        return this.level;
    }

    public final List<IncludeExecutionDataOption> includeExecutionData() {
        return IncludeExecutionDataCopier.copyStringToEnum(this.includeExecutionData);
    }

    public final boolean hasIncludeExecutionData() {
        return this.includeExecutionData != null && !(this.includeExecutionData instanceof SdkAutoConstructList);
    }

    public final List<String> includeExecutionDataAsStrings() {
        return this.includeExecutionData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3LogDestination());
        hashCode = 31 * hashCode + Objects.hashCode(this.firehoseLogDestination());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudwatchLogsLogDestination());
        hashCode = 31 * hashCode + Objects.hashCode(this.levelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIncludeExecutionData() ? this.includeExecutionDataAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipeLogConfiguration)) {
            return false;
        }
        PipeLogConfiguration other = (PipeLogConfiguration)obj;
        return Objects.equals(this.s3LogDestination(), other.s3LogDestination()) && Objects.equals(this.firehoseLogDestination(), other.firehoseLogDestination()) && Objects.equals(this.cloudwatchLogsLogDestination(), other.cloudwatchLogsLogDestination()) && Objects.equals(this.levelAsString(), other.levelAsString()) && this.hasIncludeExecutionData() == other.hasIncludeExecutionData() && Objects.equals(this.includeExecutionDataAsStrings(), other.includeExecutionDataAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"PipeLogConfiguration").add("S3LogDestination", (Object)this.s3LogDestination()).add("FirehoseLogDestination", (Object)this.firehoseLogDestination()).add("CloudwatchLogsLogDestination", (Object)this.cloudwatchLogsLogDestination()).add("Level", (Object)this.levelAsString()).add("IncludeExecutionData", this.hasIncludeExecutionData() ? this.includeExecutionDataAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3LogDestination": {
                return Optional.ofNullable(clazz.cast(this.s3LogDestination()));
            }
            case "FirehoseLogDestination": {
                return Optional.ofNullable(clazz.cast(this.firehoseLogDestination()));
            }
            case "CloudwatchLogsLogDestination": {
                return Optional.ofNullable(clazz.cast(this.cloudwatchLogsLogDestination()));
            }
            case "Level": {
                return Optional.ofNullable(clazz.cast(this.levelAsString()));
            }
            case "IncludeExecutionData": {
                return Optional.ofNullable(clazz.cast(this.includeExecutionDataAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PipeLogConfiguration, T> g) {
        return obj -> g.apply((PipeLogConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private S3LogDestination s3LogDestination;
        private FirehoseLogDestination firehoseLogDestination;
        private CloudwatchLogsLogDestination cloudwatchLogsLogDestination;
        private String level;
        private List<String> includeExecutionData = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PipeLogConfiguration model) {
            this.s3LogDestination(model.s3LogDestination);
            this.firehoseLogDestination(model.firehoseLogDestination);
            this.cloudwatchLogsLogDestination(model.cloudwatchLogsLogDestination);
            this.level(model.level);
            this.includeExecutionDataWithStrings(model.includeExecutionData);
        }

        public final S3LogDestination.Builder getS3LogDestination() {
            return this.s3LogDestination != null ? this.s3LogDestination.toBuilder() : null;
        }

        public final void setS3LogDestination(S3LogDestination.BuilderImpl s3LogDestination) {
            this.s3LogDestination = s3LogDestination != null ? s3LogDestination.build() : null;
        }

        @Override
        public final Builder s3LogDestination(S3LogDestination s3LogDestination) {
            this.s3LogDestination = s3LogDestination;
            return this;
        }

        public final FirehoseLogDestination.Builder getFirehoseLogDestination() {
            return this.firehoseLogDestination != null ? this.firehoseLogDestination.toBuilder() : null;
        }

        public final void setFirehoseLogDestination(FirehoseLogDestination.BuilderImpl firehoseLogDestination) {
            this.firehoseLogDestination = firehoseLogDestination != null ? firehoseLogDestination.build() : null;
        }

        @Override
        public final Builder firehoseLogDestination(FirehoseLogDestination firehoseLogDestination) {
            this.firehoseLogDestination = firehoseLogDestination;
            return this;
        }

        public final CloudwatchLogsLogDestination.Builder getCloudwatchLogsLogDestination() {
            return this.cloudwatchLogsLogDestination != null ? this.cloudwatchLogsLogDestination.toBuilder() : null;
        }

        public final void setCloudwatchLogsLogDestination(CloudwatchLogsLogDestination.BuilderImpl cloudwatchLogsLogDestination) {
            this.cloudwatchLogsLogDestination = cloudwatchLogsLogDestination != null ? cloudwatchLogsLogDestination.build() : null;
        }

        @Override
        public final Builder cloudwatchLogsLogDestination(CloudwatchLogsLogDestination cloudwatchLogsLogDestination) {
            this.cloudwatchLogsLogDestination = cloudwatchLogsLogDestination;
            return this;
        }

        public final String getLevel() {
            return this.level;
        }

        public final void setLevel(String level) {
            this.level = level;
        }

        @Override
        public final Builder level(String level) {
            this.level = level;
            return this;
        }

        @Override
        public final Builder level(LogLevel level) {
            this.level(level == null ? null : level.toString());
            return this;
        }

        public final Collection<String> getIncludeExecutionData() {
            if (this.includeExecutionData instanceof SdkAutoConstructList) {
                return null;
            }
            return this.includeExecutionData;
        }

        public final void setIncludeExecutionData(Collection<String> includeExecutionData) {
            this.includeExecutionData = IncludeExecutionDataCopier.copy(includeExecutionData);
        }

        @Override
        public final Builder includeExecutionDataWithStrings(Collection<String> includeExecutionData) {
            this.includeExecutionData = IncludeExecutionDataCopier.copy(includeExecutionData);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeExecutionDataWithStrings(String ... includeExecutionData) {
            this.includeExecutionDataWithStrings(Arrays.asList(includeExecutionData));
            return this;
        }

        @Override
        public final Builder includeExecutionData(Collection<IncludeExecutionDataOption> includeExecutionData) {
            this.includeExecutionData = IncludeExecutionDataCopier.copyEnumToString(includeExecutionData);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeExecutionData(IncludeExecutionDataOption ... includeExecutionData) {
            this.includeExecutionData(Arrays.asList(includeExecutionData));
            return this;
        }

        public PipeLogConfiguration build() {
            return new PipeLogConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PipeLogConfiguration> {
        public Builder s3LogDestination(S3LogDestination var1);

        default public Builder s3LogDestination(Consumer<S3LogDestination.Builder> s3LogDestination) {
            return this.s3LogDestination((S3LogDestination)((S3LogDestination.Builder)S3LogDestination.builder().applyMutation(s3LogDestination)).build());
        }

        public Builder firehoseLogDestination(FirehoseLogDestination var1);

        default public Builder firehoseLogDestination(Consumer<FirehoseLogDestination.Builder> firehoseLogDestination) {
            return this.firehoseLogDestination((FirehoseLogDestination)((FirehoseLogDestination.Builder)FirehoseLogDestination.builder().applyMutation(firehoseLogDestination)).build());
        }

        public Builder cloudwatchLogsLogDestination(CloudwatchLogsLogDestination var1);

        default public Builder cloudwatchLogsLogDestination(Consumer<CloudwatchLogsLogDestination.Builder> cloudwatchLogsLogDestination) {
            return this.cloudwatchLogsLogDestination((CloudwatchLogsLogDestination)((CloudwatchLogsLogDestination.Builder)CloudwatchLogsLogDestination.builder().applyMutation(cloudwatchLogsLogDestination)).build());
        }

        public Builder level(String var1);

        public Builder level(LogLevel var1);

        public Builder includeExecutionDataWithStrings(Collection<String> var1);

        public Builder includeExecutionDataWithStrings(String ... var1);

        public Builder includeExecutionData(Collection<IncludeExecutionDataOption> var1);

        public Builder includeExecutionData(IncludeExecutionDataOption ... var1);
    }
}

