/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pipes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pipes.model.DimensionMapping;
import software.amazon.awssdk.services.pipes.model.DimensionMappingsCopier;
import software.amazon.awssdk.services.pipes.model.EpochTimeUnit;
import software.amazon.awssdk.services.pipes.model.MultiMeasureMapping;
import software.amazon.awssdk.services.pipes.model.MultiMeasureMappingsCopier;
import software.amazon.awssdk.services.pipes.model.SingleMeasureMapping;
import software.amazon.awssdk.services.pipes.model.SingleMeasureMappingsCopier;
import software.amazon.awssdk.services.pipes.model.TimeFieldType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PipeTargetTimestreamParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PipeTargetTimestreamParameters> {
    private static final SdkField<String> TIME_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimeValue").getter(PipeTargetTimestreamParameters.getter(PipeTargetTimestreamParameters::timeValue)).setter(PipeTargetTimestreamParameters.setter(Builder::timeValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeValue").build()}).build();
    private static final SdkField<String> EPOCH_TIME_UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EpochTimeUnit").getter(PipeTargetTimestreamParameters.getter(PipeTargetTimestreamParameters::epochTimeUnitAsString)).setter(PipeTargetTimestreamParameters.setter(Builder::epochTimeUnit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EpochTimeUnit").build()}).build();
    private static final SdkField<String> TIME_FIELD_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimeFieldType").getter(PipeTargetTimestreamParameters.getter(PipeTargetTimestreamParameters::timeFieldTypeAsString)).setter(PipeTargetTimestreamParameters.setter(Builder::timeFieldType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeFieldType").build()}).build();
    private static final SdkField<String> TIMESTAMP_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimestampFormat").getter(PipeTargetTimestreamParameters.getter(PipeTargetTimestreamParameters::timestampFormat)).setter(PipeTargetTimestreamParameters.setter(Builder::timestampFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimestampFormat").build()}).build();
    private static final SdkField<String> VERSION_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VersionValue").getter(PipeTargetTimestreamParameters.getter(PipeTargetTimestreamParameters::versionValue)).setter(PipeTargetTimestreamParameters.setter(Builder::versionValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionValue").build()}).build();
    private static final SdkField<List<DimensionMapping>> DIMENSION_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DimensionMappings").getter(PipeTargetTimestreamParameters.getter(PipeTargetTimestreamParameters::dimensionMappings)).setter(PipeTargetTimestreamParameters.setter(Builder::dimensionMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DimensionMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SingleMeasureMapping>> SINGLE_MEASURE_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SingleMeasureMappings").getter(PipeTargetTimestreamParameters.getter(PipeTargetTimestreamParameters::singleMeasureMappings)).setter(PipeTargetTimestreamParameters.setter(Builder::singleMeasureMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SingleMeasureMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SingleMeasureMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<MultiMeasureMapping>> MULTI_MEASURE_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MultiMeasureMappings").getter(PipeTargetTimestreamParameters.getter(PipeTargetTimestreamParameters::multiMeasureMappings)).setter(PipeTargetTimestreamParameters.setter(Builder::multiMeasureMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiMeasureMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MultiMeasureMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_VALUE_FIELD, EPOCH_TIME_UNIT_FIELD, TIME_FIELD_TYPE_FIELD, TIMESTAMP_FORMAT_FIELD, VERSION_VALUE_FIELD, DIMENSION_MAPPINGS_FIELD, SINGLE_MEASURE_MAPPINGS_FIELD, MULTI_MEASURE_MAPPINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String timeValue;
    private final String epochTimeUnit;
    private final String timeFieldType;
    private final String timestampFormat;
    private final String versionValue;
    private final List<DimensionMapping> dimensionMappings;
    private final List<SingleMeasureMapping> singleMeasureMappings;
    private final List<MultiMeasureMapping> multiMeasureMappings;

    private PipeTargetTimestreamParameters(BuilderImpl builder) {
        this.timeValue = builder.timeValue;
        this.epochTimeUnit = builder.epochTimeUnit;
        this.timeFieldType = builder.timeFieldType;
        this.timestampFormat = builder.timestampFormat;
        this.versionValue = builder.versionValue;
        this.dimensionMappings = builder.dimensionMappings;
        this.singleMeasureMappings = builder.singleMeasureMappings;
        this.multiMeasureMappings = builder.multiMeasureMappings;
    }

    public final String timeValue() {
        return this.timeValue;
    }

    public final EpochTimeUnit epochTimeUnit() {
        return EpochTimeUnit.fromValue(this.epochTimeUnit);
    }

    public final String epochTimeUnitAsString() {
        return this.epochTimeUnit;
    }

    public final TimeFieldType timeFieldType() {
        return TimeFieldType.fromValue(this.timeFieldType);
    }

    public final String timeFieldTypeAsString() {
        return this.timeFieldType;
    }

    public final String timestampFormat() {
        return this.timestampFormat;
    }

    public final String versionValue() {
        return this.versionValue;
    }

    public final boolean hasDimensionMappings() {
        return this.dimensionMappings != null && !(this.dimensionMappings instanceof SdkAutoConstructList);
    }

    public final List<DimensionMapping> dimensionMappings() {
        return this.dimensionMappings;
    }

    public final boolean hasSingleMeasureMappings() {
        return this.singleMeasureMappings != null && !(this.singleMeasureMappings instanceof SdkAutoConstructList);
    }

    public final List<SingleMeasureMapping> singleMeasureMappings() {
        return this.singleMeasureMappings;
    }

    public final boolean hasMultiMeasureMappings() {
        return this.multiMeasureMappings != null && !(this.multiMeasureMappings instanceof SdkAutoConstructList);
    }

    public final List<MultiMeasureMapping> multiMeasureMappings() {
        return this.multiMeasureMappings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timeValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.epochTimeUnitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeFieldTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestampFormat());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDimensionMappings() ? this.dimensionMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSingleMeasureMappings() ? this.singleMeasureMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMultiMeasureMappings() ? this.multiMeasureMappings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipeTargetTimestreamParameters)) {
            return false;
        }
        PipeTargetTimestreamParameters other = (PipeTargetTimestreamParameters)obj;
        return Objects.equals(this.timeValue(), other.timeValue()) && Objects.equals(this.epochTimeUnitAsString(), other.epochTimeUnitAsString()) && Objects.equals(this.timeFieldTypeAsString(), other.timeFieldTypeAsString()) && Objects.equals(this.timestampFormat(), other.timestampFormat()) && Objects.equals(this.versionValue(), other.versionValue()) && this.hasDimensionMappings() == other.hasDimensionMappings() && Objects.equals(this.dimensionMappings(), other.dimensionMappings()) && this.hasSingleMeasureMappings() == other.hasSingleMeasureMappings() && Objects.equals(this.singleMeasureMappings(), other.singleMeasureMappings()) && this.hasMultiMeasureMappings() == other.hasMultiMeasureMappings() && Objects.equals(this.multiMeasureMappings(), other.multiMeasureMappings());
    }

    public final String toString() {
        return ToString.builder((String)"PipeTargetTimestreamParameters").add("TimeValue", (Object)this.timeValue()).add("EpochTimeUnit", (Object)this.epochTimeUnitAsString()).add("TimeFieldType", (Object)this.timeFieldTypeAsString()).add("TimestampFormat", (Object)this.timestampFormat()).add("VersionValue", (Object)this.versionValue()).add("DimensionMappings", this.hasDimensionMappings() ? this.dimensionMappings() : null).add("SingleMeasureMappings", this.hasSingleMeasureMappings() ? this.singleMeasureMappings() : null).add("MultiMeasureMappings", this.hasMultiMeasureMappings() ? this.multiMeasureMappings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TimeValue": {
                return Optional.ofNullable(clazz.cast(this.timeValue()));
            }
            case "EpochTimeUnit": {
                return Optional.ofNullable(clazz.cast(this.epochTimeUnitAsString()));
            }
            case "TimeFieldType": {
                return Optional.ofNullable(clazz.cast(this.timeFieldTypeAsString()));
            }
            case "TimestampFormat": {
                return Optional.ofNullable(clazz.cast(this.timestampFormat()));
            }
            case "VersionValue": {
                return Optional.ofNullable(clazz.cast(this.versionValue()));
            }
            case "DimensionMappings": {
                return Optional.ofNullable(clazz.cast(this.dimensionMappings()));
            }
            case "SingleMeasureMappings": {
                return Optional.ofNullable(clazz.cast(this.singleMeasureMappings()));
            }
            case "MultiMeasureMappings": {
                return Optional.ofNullable(clazz.cast(this.multiMeasureMappings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PipeTargetTimestreamParameters, T> g) {
        return obj -> g.apply((PipeTargetTimestreamParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String timeValue;
        private String epochTimeUnit;
        private String timeFieldType;
        private String timestampFormat;
        private String versionValue;
        private List<DimensionMapping> dimensionMappings = DefaultSdkAutoConstructList.getInstance();
        private List<SingleMeasureMapping> singleMeasureMappings = DefaultSdkAutoConstructList.getInstance();
        private List<MultiMeasureMapping> multiMeasureMappings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PipeTargetTimestreamParameters model) {
            this.timeValue(model.timeValue);
            this.epochTimeUnit(model.epochTimeUnit);
            this.timeFieldType(model.timeFieldType);
            this.timestampFormat(model.timestampFormat);
            this.versionValue(model.versionValue);
            this.dimensionMappings(model.dimensionMappings);
            this.singleMeasureMappings(model.singleMeasureMappings);
            this.multiMeasureMappings(model.multiMeasureMappings);
        }

        public final String getTimeValue() {
            return this.timeValue;
        }

        public final void setTimeValue(String timeValue) {
            this.timeValue = timeValue;
        }

        @Override
        public final Builder timeValue(String timeValue) {
            this.timeValue = timeValue;
            return this;
        }

        public final String getEpochTimeUnit() {
            return this.epochTimeUnit;
        }

        public final void setEpochTimeUnit(String epochTimeUnit) {
            this.epochTimeUnit = epochTimeUnit;
        }

        @Override
        public final Builder epochTimeUnit(String epochTimeUnit) {
            this.epochTimeUnit = epochTimeUnit;
            return this;
        }

        @Override
        public final Builder epochTimeUnit(EpochTimeUnit epochTimeUnit) {
            this.epochTimeUnit(epochTimeUnit == null ? null : epochTimeUnit.toString());
            return this;
        }

        public final String getTimeFieldType() {
            return this.timeFieldType;
        }

        public final void setTimeFieldType(String timeFieldType) {
            this.timeFieldType = timeFieldType;
        }

        @Override
        public final Builder timeFieldType(String timeFieldType) {
            this.timeFieldType = timeFieldType;
            return this;
        }

        @Override
        public final Builder timeFieldType(TimeFieldType timeFieldType) {
            this.timeFieldType(timeFieldType == null ? null : timeFieldType.toString());
            return this;
        }

        public final String getTimestampFormat() {
            return this.timestampFormat;
        }

        public final void setTimestampFormat(String timestampFormat) {
            this.timestampFormat = timestampFormat;
        }

        @Override
        public final Builder timestampFormat(String timestampFormat) {
            this.timestampFormat = timestampFormat;
            return this;
        }

        public final String getVersionValue() {
            return this.versionValue;
        }

        public final void setVersionValue(String versionValue) {
            this.versionValue = versionValue;
        }

        @Override
        public final Builder versionValue(String versionValue) {
            this.versionValue = versionValue;
            return this;
        }

        public final List<DimensionMapping.Builder> getDimensionMappings() {
            List<DimensionMapping.Builder> result = DimensionMappingsCopier.copyToBuilder(this.dimensionMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDimensionMappings(Collection<DimensionMapping.BuilderImpl> dimensionMappings) {
            this.dimensionMappings = DimensionMappingsCopier.copyFromBuilder(dimensionMappings);
        }

        @Override
        public final Builder dimensionMappings(Collection<DimensionMapping> dimensionMappings) {
            this.dimensionMappings = DimensionMappingsCopier.copy(dimensionMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensionMappings(DimensionMapping ... dimensionMappings) {
            this.dimensionMappings(Arrays.asList(dimensionMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensionMappings(Consumer<DimensionMapping.Builder> ... dimensionMappings) {
            this.dimensionMappings(Stream.of(dimensionMappings).map(c -> (DimensionMapping)((DimensionMapping.Builder)DimensionMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SingleMeasureMapping.Builder> getSingleMeasureMappings() {
            List<SingleMeasureMapping.Builder> result = SingleMeasureMappingsCopier.copyToBuilder(this.singleMeasureMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSingleMeasureMappings(Collection<SingleMeasureMapping.BuilderImpl> singleMeasureMappings) {
            this.singleMeasureMappings = SingleMeasureMappingsCopier.copyFromBuilder(singleMeasureMappings);
        }

        @Override
        public final Builder singleMeasureMappings(Collection<SingleMeasureMapping> singleMeasureMappings) {
            this.singleMeasureMappings = SingleMeasureMappingsCopier.copy(singleMeasureMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder singleMeasureMappings(SingleMeasureMapping ... singleMeasureMappings) {
            this.singleMeasureMappings(Arrays.asList(singleMeasureMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder singleMeasureMappings(Consumer<SingleMeasureMapping.Builder> ... singleMeasureMappings) {
            this.singleMeasureMappings(Stream.of(singleMeasureMappings).map(c -> (SingleMeasureMapping)((SingleMeasureMapping.Builder)SingleMeasureMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<MultiMeasureMapping.Builder> getMultiMeasureMappings() {
            List<MultiMeasureMapping.Builder> result = MultiMeasureMappingsCopier.copyToBuilder(this.multiMeasureMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMultiMeasureMappings(Collection<MultiMeasureMapping.BuilderImpl> multiMeasureMappings) {
            this.multiMeasureMappings = MultiMeasureMappingsCopier.copyFromBuilder(multiMeasureMappings);
        }

        @Override
        public final Builder multiMeasureMappings(Collection<MultiMeasureMapping> multiMeasureMappings) {
            this.multiMeasureMappings = MultiMeasureMappingsCopier.copy(multiMeasureMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder multiMeasureMappings(MultiMeasureMapping ... multiMeasureMappings) {
            this.multiMeasureMappings(Arrays.asList(multiMeasureMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder multiMeasureMappings(Consumer<MultiMeasureMapping.Builder> ... multiMeasureMappings) {
            this.multiMeasureMappings(Stream.of(multiMeasureMappings).map(c -> (MultiMeasureMapping)((MultiMeasureMapping.Builder)MultiMeasureMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public PipeTargetTimestreamParameters build() {
            return new PipeTargetTimestreamParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PipeTargetTimestreamParameters> {
        public Builder timeValue(String var1);

        public Builder epochTimeUnit(String var1);

        public Builder epochTimeUnit(EpochTimeUnit var1);

        public Builder timeFieldType(String var1);

        public Builder timeFieldType(TimeFieldType var1);

        public Builder timestampFormat(String var1);

        public Builder versionValue(String var1);

        public Builder dimensionMappings(Collection<DimensionMapping> var1);

        public Builder dimensionMappings(DimensionMapping ... var1);

        public Builder dimensionMappings(Consumer<DimensionMapping.Builder> ... var1);

        public Builder singleMeasureMappings(Collection<SingleMeasureMapping> var1);

        public Builder singleMeasureMappings(SingleMeasureMapping ... var1);

        public Builder singleMeasureMappings(Consumer<SingleMeasureMapping.Builder> ... var1);

        public Builder multiMeasureMappings(Collection<MultiMeasureMapping> var1);

        public Builder multiMeasureMappings(MultiMeasureMapping ... var1);

        public Builder multiMeasureMappings(Consumer<MultiMeasureMapping.Builder> ... var1);
    }
}

