/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pipes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A mapping of a source event data field to a measure in a Timestream for LiveAnalytics record.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MultiMeasureAttributeMapping implements SdkPojo, Serializable,
        ToCopyableBuilder<MultiMeasureAttributeMapping.Builder, MultiMeasureAttributeMapping> {
    private static final SdkField<String> MEASURE_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MeasureValue").getter(getter(MultiMeasureAttributeMapping::measureValue))
            .setter(setter(Builder::measureValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeasureValue").build()).build();

    private static final SdkField<String> MEASURE_VALUE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MeasureValueType").getter(getter(MultiMeasureAttributeMapping::measureValueTypeAsString))
            .setter(setter(Builder::measureValueType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeasureValueType").build()).build();

    private static final SdkField<String> MULTI_MEASURE_ATTRIBUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MultiMeasureAttributeName").getter(getter(MultiMeasureAttributeMapping::multiMeasureAttributeName))
            .setter(setter(Builder::multiMeasureAttributeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiMeasureAttributeName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEASURE_VALUE_FIELD,
            MEASURE_VALUE_TYPE_FIELD, MULTI_MEASURE_ATTRIBUTE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String measureValue;

    private final String measureValueType;

    private final String multiMeasureAttributeName;

    private MultiMeasureAttributeMapping(BuilderImpl builder) {
        this.measureValue = builder.measureValue;
        this.measureValueType = builder.measureValueType;
        this.multiMeasureAttributeName = builder.multiMeasureAttributeName;
    }

    /**
     * <p>
     * Dynamic path to the measurement attribute in the source event.
     * </p>
     * 
     * @return Dynamic path to the measurement attribute in the source event.
     */
    public final String measureValue() {
        return measureValue;
    }

    /**
     * <p>
     * Data type of the measurement attribute in the source event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #measureValueType}
     * will return {@link MeasureValueType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #measureValueTypeAsString}.
     * </p>
     * 
     * @return Data type of the measurement attribute in the source event.
     * @see MeasureValueType
     */
    public final MeasureValueType measureValueType() {
        return MeasureValueType.fromValue(measureValueType);
    }

    /**
     * <p>
     * Data type of the measurement attribute in the source event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #measureValueType}
     * will return {@link MeasureValueType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #measureValueTypeAsString}.
     * </p>
     * 
     * @return Data type of the measurement attribute in the source event.
     * @see MeasureValueType
     */
    public final String measureValueTypeAsString() {
        return measureValueType;
    }

    /**
     * <p>
     * Target measure name to be used.
     * </p>
     * 
     * @return Target measure name to be used.
     */
    public final String multiMeasureAttributeName() {
        return multiMeasureAttributeName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(measureValue());
        hashCode = 31 * hashCode + Objects.hashCode(measureValueTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(multiMeasureAttributeName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultiMeasureAttributeMapping)) {
            return false;
        }
        MultiMeasureAttributeMapping other = (MultiMeasureAttributeMapping) obj;
        return Objects.equals(measureValue(), other.measureValue())
                && Objects.equals(measureValueTypeAsString(), other.measureValueTypeAsString())
                && Objects.equals(multiMeasureAttributeName(), other.multiMeasureAttributeName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MultiMeasureAttributeMapping").add("MeasureValue", measureValue())
                .add("MeasureValueType", measureValueTypeAsString())
                .add("MultiMeasureAttributeName", multiMeasureAttributeName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MeasureValue":
            return Optional.ofNullable(clazz.cast(measureValue()));
        case "MeasureValueType":
            return Optional.ofNullable(clazz.cast(measureValueTypeAsString()));
        case "MultiMeasureAttributeName":
            return Optional.ofNullable(clazz.cast(multiMeasureAttributeName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MultiMeasureAttributeMapping, T> g) {
        return obj -> g.apply((MultiMeasureAttributeMapping) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MultiMeasureAttributeMapping> {
        /**
         * <p>
         * Dynamic path to the measurement attribute in the source event.
         * </p>
         * 
         * @param measureValue
         *        Dynamic path to the measurement attribute in the source event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder measureValue(String measureValue);

        /**
         * <p>
         * Data type of the measurement attribute in the source event.
         * </p>
         * 
         * @param measureValueType
         *        Data type of the measurement attribute in the source event.
         * @see MeasureValueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MeasureValueType
         */
        Builder measureValueType(String measureValueType);

        /**
         * <p>
         * Data type of the measurement attribute in the source event.
         * </p>
         * 
         * @param measureValueType
         *        Data type of the measurement attribute in the source event.
         * @see MeasureValueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MeasureValueType
         */
        Builder measureValueType(MeasureValueType measureValueType);

        /**
         * <p>
         * Target measure name to be used.
         * </p>
         * 
         * @param multiMeasureAttributeName
         *        Target measure name to be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiMeasureAttributeName(String multiMeasureAttributeName);
    }

    static final class BuilderImpl implements Builder {
        private String measureValue;

        private String measureValueType;

        private String multiMeasureAttributeName;

        private BuilderImpl() {
        }

        private BuilderImpl(MultiMeasureAttributeMapping model) {
            measureValue(model.measureValue);
            measureValueType(model.measureValueType);
            multiMeasureAttributeName(model.multiMeasureAttributeName);
        }

        public final String getMeasureValue() {
            return measureValue;
        }

        public final void setMeasureValue(String measureValue) {
            this.measureValue = measureValue;
        }

        @Override
        public final Builder measureValue(String measureValue) {
            this.measureValue = measureValue;
            return this;
        }

        public final String getMeasureValueType() {
            return measureValueType;
        }

        public final void setMeasureValueType(String measureValueType) {
            this.measureValueType = measureValueType;
        }

        @Override
        public final Builder measureValueType(String measureValueType) {
            this.measureValueType = measureValueType;
            return this;
        }

        @Override
        public final Builder measureValueType(MeasureValueType measureValueType) {
            this.measureValueType(measureValueType == null ? null : measureValueType.toString());
            return this;
        }

        public final String getMultiMeasureAttributeName() {
            return multiMeasureAttributeName;
        }

        public final void setMultiMeasureAttributeName(String multiMeasureAttributeName) {
            this.multiMeasureAttributeName = multiMeasureAttributeName;
        }

        @Override
        public final Builder multiMeasureAttributeName(String multiMeasureAttributeName) {
            this.multiMeasureAttributeName = multiMeasureAttributeName;
            return this;
        }

        @Override
        public MultiMeasureAttributeMapping build() {
            return new MultiMeasureAttributeMapping(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
