/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pipes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The parameters required to set up enrichment on your pipe.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PipeEnrichmentParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<PipeEnrichmentParameters.Builder, PipeEnrichmentParameters> {
    private static final SdkField<String> INPUT_TEMPLATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputTemplate").getter(getter(PipeEnrichmentParameters::inputTemplate))
            .setter(setter(Builder::inputTemplate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputTemplate").build()).build();

    private static final SdkField<PipeEnrichmentHttpParameters> HTTP_PARAMETERS_FIELD = SdkField
            .<PipeEnrichmentHttpParameters> builder(MarshallingType.SDK_POJO).memberName("HttpParameters")
            .getter(getter(PipeEnrichmentParameters::httpParameters)).setter(setter(Builder::httpParameters))
            .constructor(PipeEnrichmentHttpParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpParameters").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_TEMPLATE_FIELD,
            HTTP_PARAMETERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String inputTemplate;

    private final PipeEnrichmentHttpParameters httpParameters;

    private PipeEnrichmentParameters(BuilderImpl builder) {
        this.inputTemplate = builder.inputTemplate;
        this.httpParameters = builder.httpParameters;
    }

    /**
     * <p>
     * Valid JSON text passed to the enrichment. In this case, nothing from the event itself is passed to the
     * enrichment. For more information, see <a href="http://www.rfc-editor.org/rfc/rfc7159.txt">The JavaScript Object
     * Notation (JSON) Data Interchange Format</a>.
     * </p>
     * <p>
     * To remove an input template, specify an empty string.
     * </p>
     * 
     * @return Valid JSON text passed to the enrichment. In this case, nothing from the event itself is passed to the
     *         enrichment. For more information, see <a href="http://www.rfc-editor.org/rfc/rfc7159.txt">The JavaScript
     *         Object Notation (JSON) Data Interchange Format</a>.</p>
     *         <p>
     *         To remove an input template, specify an empty string.
     */
    public final String inputTemplate() {
        return inputTemplate;
    }

    /**
     * <p>
     * Contains the HTTP parameters to use when the target is a API Gateway REST endpoint or EventBridge ApiDestination.
     * </p>
     * <p>
     * If you specify an API Gateway REST API or EventBridge ApiDestination as a target, you can use this parameter to
     * specify headers, path parameters, and query string keys/values as part of your target invoking request. If you're
     * using ApiDestinations, the corresponding Connection can also have these values configured. In case of any
     * conflicting keys, values from the Connection take precedence.
     * </p>
     * 
     * @return Contains the HTTP parameters to use when the target is a API Gateway REST endpoint or EventBridge
     *         ApiDestination.</p>
     *         <p>
     *         If you specify an API Gateway REST API or EventBridge ApiDestination as a target, you can use this
     *         parameter to specify headers, path parameters, and query string keys/values as part of your target
     *         invoking request. If you're using ApiDestinations, the corresponding Connection can also have these
     *         values configured. In case of any conflicting keys, values from the Connection take precedence.
     */
    public final PipeEnrichmentHttpParameters httpParameters() {
        return httpParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inputTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(httpParameters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipeEnrichmentParameters)) {
            return false;
        }
        PipeEnrichmentParameters other = (PipeEnrichmentParameters) obj;
        return Objects.equals(inputTemplate(), other.inputTemplate()) && Objects.equals(httpParameters(), other.httpParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PipeEnrichmentParameters")
                .add("InputTemplate", inputTemplate() == null ? null : "*** Sensitive Data Redacted ***")
                .add("HttpParameters", httpParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InputTemplate":
            return Optional.ofNullable(clazz.cast(inputTemplate()));
        case "HttpParameters":
            return Optional.ofNullable(clazz.cast(httpParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PipeEnrichmentParameters, T> g) {
        return obj -> g.apply((PipeEnrichmentParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PipeEnrichmentParameters> {
        /**
         * <p>
         * Valid JSON text passed to the enrichment. In this case, nothing from the event itself is passed to the
         * enrichment. For more information, see <a href="http://www.rfc-editor.org/rfc/rfc7159.txt">The JavaScript
         * Object Notation (JSON) Data Interchange Format</a>.
         * </p>
         * <p>
         * To remove an input template, specify an empty string.
         * </p>
         * 
         * @param inputTemplate
         *        Valid JSON text passed to the enrichment. In this case, nothing from the event itself is passed to the
         *        enrichment. For more information, see <a href="http://www.rfc-editor.org/rfc/rfc7159.txt">The
         *        JavaScript Object Notation (JSON) Data Interchange Format</a>.</p>
         *        <p>
         *        To remove an input template, specify an empty string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputTemplate(String inputTemplate);

        /**
         * <p>
         * Contains the HTTP parameters to use when the target is a API Gateway REST endpoint or EventBridge
         * ApiDestination.
         * </p>
         * <p>
         * If you specify an API Gateway REST API or EventBridge ApiDestination as a target, you can use this parameter
         * to specify headers, path parameters, and query string keys/values as part of your target invoking request. If
         * you're using ApiDestinations, the corresponding Connection can also have these values configured. In case of
         * any conflicting keys, values from the Connection take precedence.
         * </p>
         * 
         * @param httpParameters
         *        Contains the HTTP parameters to use when the target is a API Gateway REST endpoint or EventBridge
         *        ApiDestination.</p>
         *        <p>
         *        If you specify an API Gateway REST API or EventBridge ApiDestination as a target, you can use this
         *        parameter to specify headers, path parameters, and query string keys/values as part of your target
         *        invoking request. If you're using ApiDestinations, the corresponding Connection can also have these
         *        values configured. In case of any conflicting keys, values from the Connection take precedence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpParameters(PipeEnrichmentHttpParameters httpParameters);

        /**
         * <p>
         * Contains the HTTP parameters to use when the target is a API Gateway REST endpoint or EventBridge
         * ApiDestination.
         * </p>
         * <p>
         * If you specify an API Gateway REST API or EventBridge ApiDestination as a target, you can use this parameter
         * to specify headers, path parameters, and query string keys/values as part of your target invoking request. If
         * you're using ApiDestinations, the corresponding Connection can also have these values configured. In case of
         * any conflicting keys, values from the Connection take precedence.
         * </p>
         * This is a convenience method that creates an instance of the {@link PipeEnrichmentHttpParameters.Builder}
         * avoiding the need to create one manually via {@link PipeEnrichmentHttpParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PipeEnrichmentHttpParameters.Builder#build()} is called
         * immediately and its result is passed to {@link #httpParameters(PipeEnrichmentHttpParameters)}.
         * 
         * @param httpParameters
         *        a consumer that will call methods on {@link PipeEnrichmentHttpParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #httpParameters(PipeEnrichmentHttpParameters)
         */
        default Builder httpParameters(Consumer<PipeEnrichmentHttpParameters.Builder> httpParameters) {
            return httpParameters(PipeEnrichmentHttpParameters.builder().applyMutation(httpParameters).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String inputTemplate;

        private PipeEnrichmentHttpParameters httpParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(PipeEnrichmentParameters model) {
            inputTemplate(model.inputTemplate);
            httpParameters(model.httpParameters);
        }

        public final String getInputTemplate() {
            return inputTemplate;
        }

        public final void setInputTemplate(String inputTemplate) {
            this.inputTemplate = inputTemplate;
        }

        @Override
        public final Builder inputTemplate(String inputTemplate) {
            this.inputTemplate = inputTemplate;
            return this;
        }

        public final PipeEnrichmentHttpParameters.Builder getHttpParameters() {
            return httpParameters != null ? httpParameters.toBuilder() : null;
        }

        public final void setHttpParameters(PipeEnrichmentHttpParameters.BuilderImpl httpParameters) {
            this.httpParameters = httpParameters != null ? httpParameters.build() : null;
        }

        @Override
        public final Builder httpParameters(PipeEnrichmentHttpParameters httpParameters) {
            this.httpParameters = httpParameters;
            return this;
        }

        @Override
        public PipeEnrichmentParameters build() {
            return new PipeEnrichmentParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
