/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pipes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The parameters required to set up a source for your pipe.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PipeSourceParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<PipeSourceParameters.Builder, PipeSourceParameters> {
    private static final SdkField<FilterCriteria> FILTER_CRITERIA_FIELD = SdkField
            .<FilterCriteria> builder(MarshallingType.SDK_POJO).memberName("FilterCriteria")
            .getter(getter(PipeSourceParameters::filterCriteria)).setter(setter(Builder::filterCriteria))
            .constructor(FilterCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterCriteria").build()).build();

    private static final SdkField<PipeSourceKinesisStreamParameters> KINESIS_STREAM_PARAMETERS_FIELD = SdkField
            .<PipeSourceKinesisStreamParameters> builder(MarshallingType.SDK_POJO).memberName("KinesisStreamParameters")
            .getter(getter(PipeSourceParameters::kinesisStreamParameters)).setter(setter(Builder::kinesisStreamParameters))
            .constructor(PipeSourceKinesisStreamParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisStreamParameters").build())
            .build();

    private static final SdkField<PipeSourceDynamoDBStreamParameters> DYNAMO_DB_STREAM_PARAMETERS_FIELD = SdkField
            .<PipeSourceDynamoDBStreamParameters> builder(MarshallingType.SDK_POJO).memberName("DynamoDBStreamParameters")
            .getter(getter(PipeSourceParameters::dynamoDBStreamParameters)).setter(setter(Builder::dynamoDBStreamParameters))
            .constructor(PipeSourceDynamoDBStreamParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DynamoDBStreamParameters").build())
            .build();

    private static final SdkField<PipeSourceSqsQueueParameters> SQS_QUEUE_PARAMETERS_FIELD = SdkField
            .<PipeSourceSqsQueueParameters> builder(MarshallingType.SDK_POJO).memberName("SqsQueueParameters")
            .getter(getter(PipeSourceParameters::sqsQueueParameters)).setter(setter(Builder::sqsQueueParameters))
            .constructor(PipeSourceSqsQueueParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SqsQueueParameters").build())
            .build();

    private static final SdkField<PipeSourceActiveMQBrokerParameters> ACTIVE_MQ_BROKER_PARAMETERS_FIELD = SdkField
            .<PipeSourceActiveMQBrokerParameters> builder(MarshallingType.SDK_POJO).memberName("ActiveMQBrokerParameters")
            .getter(getter(PipeSourceParameters::activeMQBrokerParameters)).setter(setter(Builder::activeMQBrokerParameters))
            .constructor(PipeSourceActiveMQBrokerParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveMQBrokerParameters").build())
            .build();

    private static final SdkField<PipeSourceRabbitMQBrokerParameters> RABBIT_MQ_BROKER_PARAMETERS_FIELD = SdkField
            .<PipeSourceRabbitMQBrokerParameters> builder(MarshallingType.SDK_POJO).memberName("RabbitMQBrokerParameters")
            .getter(getter(PipeSourceParameters::rabbitMQBrokerParameters)).setter(setter(Builder::rabbitMQBrokerParameters))
            .constructor(PipeSourceRabbitMQBrokerParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RabbitMQBrokerParameters").build())
            .build();

    private static final SdkField<PipeSourceManagedStreamingKafkaParameters> MANAGED_STREAMING_KAFKA_PARAMETERS_FIELD = SdkField
            .<PipeSourceManagedStreamingKafkaParameters> builder(MarshallingType.SDK_POJO)
            .memberName("ManagedStreamingKafkaParameters")
            .getter(getter(PipeSourceParameters::managedStreamingKafkaParameters))
            .setter(setter(Builder::managedStreamingKafkaParameters))
            .constructor(PipeSourceManagedStreamingKafkaParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedStreamingKafkaParameters")
                    .build()).build();

    private static final SdkField<PipeSourceSelfManagedKafkaParameters> SELF_MANAGED_KAFKA_PARAMETERS_FIELD = SdkField
            .<PipeSourceSelfManagedKafkaParameters> builder(MarshallingType.SDK_POJO)
            .memberName("SelfManagedKafkaParameters")
            .getter(getter(PipeSourceParameters::selfManagedKafkaParameters))
            .setter(setter(Builder::selfManagedKafkaParameters))
            .constructor(PipeSourceSelfManagedKafkaParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelfManagedKafkaParameters").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_CRITERIA_FIELD,
            KINESIS_STREAM_PARAMETERS_FIELD, DYNAMO_DB_STREAM_PARAMETERS_FIELD, SQS_QUEUE_PARAMETERS_FIELD,
            ACTIVE_MQ_BROKER_PARAMETERS_FIELD, RABBIT_MQ_BROKER_PARAMETERS_FIELD, MANAGED_STREAMING_KAFKA_PARAMETERS_FIELD,
            SELF_MANAGED_KAFKA_PARAMETERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final FilterCriteria filterCriteria;

    private final PipeSourceKinesisStreamParameters kinesisStreamParameters;

    private final PipeSourceDynamoDBStreamParameters dynamoDBStreamParameters;

    private final PipeSourceSqsQueueParameters sqsQueueParameters;

    private final PipeSourceActiveMQBrokerParameters activeMQBrokerParameters;

    private final PipeSourceRabbitMQBrokerParameters rabbitMQBrokerParameters;

    private final PipeSourceManagedStreamingKafkaParameters managedStreamingKafkaParameters;

    private final PipeSourceSelfManagedKafkaParameters selfManagedKafkaParameters;

    private PipeSourceParameters(BuilderImpl builder) {
        this.filterCriteria = builder.filterCriteria;
        this.kinesisStreamParameters = builder.kinesisStreamParameters;
        this.dynamoDBStreamParameters = builder.dynamoDBStreamParameters;
        this.sqsQueueParameters = builder.sqsQueueParameters;
        this.activeMQBrokerParameters = builder.activeMQBrokerParameters;
        this.rabbitMQBrokerParameters = builder.rabbitMQBrokerParameters;
        this.managedStreamingKafkaParameters = builder.managedStreamingKafkaParameters;
        this.selfManagedKafkaParameters = builder.selfManagedKafkaParameters;
    }

    /**
     * <p>
     * The collection of event patterns used to filter events.
     * </p>
     * <p>
     * To remove a filter, specify a <code>FilterCriteria</code> object with an empty array of <code>Filter</code>
     * objects.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html">Events and
     * Event Patterns</a> in the <i>Amazon EventBridge User Guide</i>.
     * </p>
     * 
     * @return The collection of event patterns used to filter events.</p>
     *         <p>
     *         To remove a filter, specify a <code>FilterCriteria</code> object with an empty array of
     *         <code>Filter</code> objects.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html"
     *         >Events and Event Patterns</a> in the <i>Amazon EventBridge User Guide</i>.
     */
    public final FilterCriteria filterCriteria() {
        return filterCriteria;
    }

    /**
     * <p>
     * The parameters for using a Kinesis stream as a source.
     * </p>
     * 
     * @return The parameters for using a Kinesis stream as a source.
     */
    public final PipeSourceKinesisStreamParameters kinesisStreamParameters() {
        return kinesisStreamParameters;
    }

    /**
     * <p>
     * The parameters for using a DynamoDB stream as a source.
     * </p>
     * 
     * @return The parameters for using a DynamoDB stream as a source.
     */
    public final PipeSourceDynamoDBStreamParameters dynamoDBStreamParameters() {
        return dynamoDBStreamParameters;
    }

    /**
     * <p>
     * The parameters for using a Amazon SQS stream as a source.
     * </p>
     * 
     * @return The parameters for using a Amazon SQS stream as a source.
     */
    public final PipeSourceSqsQueueParameters sqsQueueParameters() {
        return sqsQueueParameters;
    }

    /**
     * <p>
     * The parameters for using an Active MQ broker as a source.
     * </p>
     * 
     * @return The parameters for using an Active MQ broker as a source.
     */
    public final PipeSourceActiveMQBrokerParameters activeMQBrokerParameters() {
        return activeMQBrokerParameters;
    }

    /**
     * <p>
     * The parameters for using a Rabbit MQ broker as a source.
     * </p>
     * 
     * @return The parameters for using a Rabbit MQ broker as a source.
     */
    public final PipeSourceRabbitMQBrokerParameters rabbitMQBrokerParameters() {
        return rabbitMQBrokerParameters;
    }

    /**
     * <p>
     * The parameters for using an MSK stream as a source.
     * </p>
     * 
     * @return The parameters for using an MSK stream as a source.
     */
    public final PipeSourceManagedStreamingKafkaParameters managedStreamingKafkaParameters() {
        return managedStreamingKafkaParameters;
    }

    /**
     * <p>
     * The parameters for using a self-managed Apache Kafka stream as a source.
     * </p>
     * <p>
     * A <i>self managed</i> cluster refers to any Apache Kafka cluster not hosted by Amazon Web Services. This includes
     * both clusters you manage yourself, as well as those hosted by a third-party provider, such as <a
     * href="https://www.confluent.io/">Confluent Cloud</a>, <a href="https://www.cloudkarafka.com/">CloudKarafka</a>,
     * or <a href="https://redpanda.com/">Redpanda</a>. For more information, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-kafka.html">Apache Kafka streams as a
     * source</a> in the <i>Amazon EventBridge User Guide</i>.
     * </p>
     * 
     * @return The parameters for using a self-managed Apache Kafka stream as a source.</p>
     *         <p>
     *         A <i>self managed</i> cluster refers to any Apache Kafka cluster not hosted by Amazon Web Services. This
     *         includes both clusters you manage yourself, as well as those hosted by a third-party provider, such as <a
     *         href="https://www.confluent.io/">Confluent Cloud</a>, <a
     *         href="https://www.cloudkarafka.com/">CloudKarafka</a>, or <a href="https://redpanda.com/">Redpanda</a>.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-kafka.html">Apache Kafka streams
     *         as a source</a> in the <i>Amazon EventBridge User Guide</i>.
     */
    public final PipeSourceSelfManagedKafkaParameters selfManagedKafkaParameters() {
        return selfManagedKafkaParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filterCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(kinesisStreamParameters());
        hashCode = 31 * hashCode + Objects.hashCode(dynamoDBStreamParameters());
        hashCode = 31 * hashCode + Objects.hashCode(sqsQueueParameters());
        hashCode = 31 * hashCode + Objects.hashCode(activeMQBrokerParameters());
        hashCode = 31 * hashCode + Objects.hashCode(rabbitMQBrokerParameters());
        hashCode = 31 * hashCode + Objects.hashCode(managedStreamingKafkaParameters());
        hashCode = 31 * hashCode + Objects.hashCode(selfManagedKafkaParameters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipeSourceParameters)) {
            return false;
        }
        PipeSourceParameters other = (PipeSourceParameters) obj;
        return Objects.equals(filterCriteria(), other.filterCriteria())
                && Objects.equals(kinesisStreamParameters(), other.kinesisStreamParameters())
                && Objects.equals(dynamoDBStreamParameters(), other.dynamoDBStreamParameters())
                && Objects.equals(sqsQueueParameters(), other.sqsQueueParameters())
                && Objects.equals(activeMQBrokerParameters(), other.activeMQBrokerParameters())
                && Objects.equals(rabbitMQBrokerParameters(), other.rabbitMQBrokerParameters())
                && Objects.equals(managedStreamingKafkaParameters(), other.managedStreamingKafkaParameters())
                && Objects.equals(selfManagedKafkaParameters(), other.selfManagedKafkaParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PipeSourceParameters").add("FilterCriteria", filterCriteria())
                .add("KinesisStreamParameters", kinesisStreamParameters())
                .add("DynamoDBStreamParameters", dynamoDBStreamParameters()).add("SqsQueueParameters", sqsQueueParameters())
                .add("ActiveMQBrokerParameters", activeMQBrokerParameters())
                .add("RabbitMQBrokerParameters", rabbitMQBrokerParameters())
                .add("ManagedStreamingKafkaParameters", managedStreamingKafkaParameters())
                .add("SelfManagedKafkaParameters", selfManagedKafkaParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FilterCriteria":
            return Optional.ofNullable(clazz.cast(filterCriteria()));
        case "KinesisStreamParameters":
            return Optional.ofNullable(clazz.cast(kinesisStreamParameters()));
        case "DynamoDBStreamParameters":
            return Optional.ofNullable(clazz.cast(dynamoDBStreamParameters()));
        case "SqsQueueParameters":
            return Optional.ofNullable(clazz.cast(sqsQueueParameters()));
        case "ActiveMQBrokerParameters":
            return Optional.ofNullable(clazz.cast(activeMQBrokerParameters()));
        case "RabbitMQBrokerParameters":
            return Optional.ofNullable(clazz.cast(rabbitMQBrokerParameters()));
        case "ManagedStreamingKafkaParameters":
            return Optional.ofNullable(clazz.cast(managedStreamingKafkaParameters()));
        case "SelfManagedKafkaParameters":
            return Optional.ofNullable(clazz.cast(selfManagedKafkaParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PipeSourceParameters, T> g) {
        return obj -> g.apply((PipeSourceParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PipeSourceParameters> {
        /**
         * <p>
         * The collection of event patterns used to filter events.
         * </p>
         * <p>
         * To remove a filter, specify a <code>FilterCriteria</code> object with an empty array of <code>Filter</code>
         * objects.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html">Events
         * and Event Patterns</a> in the <i>Amazon EventBridge User Guide</i>.
         * </p>
         * 
         * @param filterCriteria
         *        The collection of event patterns used to filter events.</p>
         *        <p>
         *        To remove a filter, specify a <code>FilterCriteria</code> object with an empty array of
         *        <code>Filter</code> objects.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html"
         *        >Events and Event Patterns</a> in the <i>Amazon EventBridge User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterCriteria(FilterCriteria filterCriteria);

        /**
         * <p>
         * The collection of event patterns used to filter events.
         * </p>
         * <p>
         * To remove a filter, specify a <code>FilterCriteria</code> object with an empty array of <code>Filter</code>
         * objects.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html">Events
         * and Event Patterns</a> in the <i>Amazon EventBridge User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link FilterCriteria.Builder} avoiding the need
         * to create one manually via {@link FilterCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilterCriteria.Builder#build()} is called immediately and its
         * result is passed to {@link #filterCriteria(FilterCriteria)}.
         * 
         * @param filterCriteria
         *        a consumer that will call methods on {@link FilterCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filterCriteria(FilterCriteria)
         */
        default Builder filterCriteria(Consumer<FilterCriteria.Builder> filterCriteria) {
            return filterCriteria(FilterCriteria.builder().applyMutation(filterCriteria).build());
        }

        /**
         * <p>
         * The parameters for using a Kinesis stream as a source.
         * </p>
         * 
         * @param kinesisStreamParameters
         *        The parameters for using a Kinesis stream as a source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisStreamParameters(PipeSourceKinesisStreamParameters kinesisStreamParameters);

        /**
         * <p>
         * The parameters for using a Kinesis stream as a source.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link PipeSourceKinesisStreamParameters.Builder} avoiding the need to create one manually via
         * {@link PipeSourceKinesisStreamParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PipeSourceKinesisStreamParameters.Builder#build()} is called
         * immediately and its result is passed to {@link #kinesisStreamParameters(PipeSourceKinesisStreamParameters)}.
         * 
         * @param kinesisStreamParameters
         *        a consumer that will call methods on {@link PipeSourceKinesisStreamParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kinesisStreamParameters(PipeSourceKinesisStreamParameters)
         */
        default Builder kinesisStreamParameters(Consumer<PipeSourceKinesisStreamParameters.Builder> kinesisStreamParameters) {
            return kinesisStreamParameters(PipeSourceKinesisStreamParameters.builder().applyMutation(kinesisStreamParameters)
                    .build());
        }

        /**
         * <p>
         * The parameters for using a DynamoDB stream as a source.
         * </p>
         * 
         * @param dynamoDBStreamParameters
         *        The parameters for using a DynamoDB stream as a source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dynamoDBStreamParameters(PipeSourceDynamoDBStreamParameters dynamoDBStreamParameters);

        /**
         * <p>
         * The parameters for using a DynamoDB stream as a source.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link PipeSourceDynamoDBStreamParameters.Builder} avoiding the need to create one manually via
         * {@link PipeSourceDynamoDBStreamParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PipeSourceDynamoDBStreamParameters.Builder#build()} is called
         * immediately and its result is passed to {@link #dynamoDBStreamParameters(PipeSourceDynamoDBStreamParameters)}.
         * 
         * @param dynamoDBStreamParameters
         *        a consumer that will call methods on {@link PipeSourceDynamoDBStreamParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dynamoDBStreamParameters(PipeSourceDynamoDBStreamParameters)
         */
        default Builder dynamoDBStreamParameters(Consumer<PipeSourceDynamoDBStreamParameters.Builder> dynamoDBStreamParameters) {
            return dynamoDBStreamParameters(PipeSourceDynamoDBStreamParameters.builder().applyMutation(dynamoDBStreamParameters)
                    .build());
        }

        /**
         * <p>
         * The parameters for using a Amazon SQS stream as a source.
         * </p>
         * 
         * @param sqsQueueParameters
         *        The parameters for using a Amazon SQS stream as a source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sqsQueueParameters(PipeSourceSqsQueueParameters sqsQueueParameters);

        /**
         * <p>
         * The parameters for using a Amazon SQS stream as a source.
         * </p>
         * This is a convenience method that creates an instance of the {@link PipeSourceSqsQueueParameters.Builder}
         * avoiding the need to create one manually via {@link PipeSourceSqsQueueParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PipeSourceSqsQueueParameters.Builder#build()} is called
         * immediately and its result is passed to {@link #sqsQueueParameters(PipeSourceSqsQueueParameters)}.
         * 
         * @param sqsQueueParameters
         *        a consumer that will call methods on {@link PipeSourceSqsQueueParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sqsQueueParameters(PipeSourceSqsQueueParameters)
         */
        default Builder sqsQueueParameters(Consumer<PipeSourceSqsQueueParameters.Builder> sqsQueueParameters) {
            return sqsQueueParameters(PipeSourceSqsQueueParameters.builder().applyMutation(sqsQueueParameters).build());
        }

        /**
         * <p>
         * The parameters for using an Active MQ broker as a source.
         * </p>
         * 
         * @param activeMQBrokerParameters
         *        The parameters for using an Active MQ broker as a source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeMQBrokerParameters(PipeSourceActiveMQBrokerParameters activeMQBrokerParameters);

        /**
         * <p>
         * The parameters for using an Active MQ broker as a source.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link PipeSourceActiveMQBrokerParameters.Builder} avoiding the need to create one manually via
         * {@link PipeSourceActiveMQBrokerParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PipeSourceActiveMQBrokerParameters.Builder#build()} is called
         * immediately and its result is passed to {@link #activeMQBrokerParameters(PipeSourceActiveMQBrokerParameters)}.
         * 
         * @param activeMQBrokerParameters
         *        a consumer that will call methods on {@link PipeSourceActiveMQBrokerParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activeMQBrokerParameters(PipeSourceActiveMQBrokerParameters)
         */
        default Builder activeMQBrokerParameters(Consumer<PipeSourceActiveMQBrokerParameters.Builder> activeMQBrokerParameters) {
            return activeMQBrokerParameters(PipeSourceActiveMQBrokerParameters.builder().applyMutation(activeMQBrokerParameters)
                    .build());
        }

        /**
         * <p>
         * The parameters for using a Rabbit MQ broker as a source.
         * </p>
         * 
         * @param rabbitMQBrokerParameters
         *        The parameters for using a Rabbit MQ broker as a source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rabbitMQBrokerParameters(PipeSourceRabbitMQBrokerParameters rabbitMQBrokerParameters);

        /**
         * <p>
         * The parameters for using a Rabbit MQ broker as a source.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link PipeSourceRabbitMQBrokerParameters.Builder} avoiding the need to create one manually via
         * {@link PipeSourceRabbitMQBrokerParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PipeSourceRabbitMQBrokerParameters.Builder#build()} is called
         * immediately and its result is passed to {@link #rabbitMQBrokerParameters(PipeSourceRabbitMQBrokerParameters)}.
         * 
         * @param rabbitMQBrokerParameters
         *        a consumer that will call methods on {@link PipeSourceRabbitMQBrokerParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rabbitMQBrokerParameters(PipeSourceRabbitMQBrokerParameters)
         */
        default Builder rabbitMQBrokerParameters(Consumer<PipeSourceRabbitMQBrokerParameters.Builder> rabbitMQBrokerParameters) {
            return rabbitMQBrokerParameters(PipeSourceRabbitMQBrokerParameters.builder().applyMutation(rabbitMQBrokerParameters)
                    .build());
        }

        /**
         * <p>
         * The parameters for using an MSK stream as a source.
         * </p>
         * 
         * @param managedStreamingKafkaParameters
         *        The parameters for using an MSK stream as a source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedStreamingKafkaParameters(PipeSourceManagedStreamingKafkaParameters managedStreamingKafkaParameters);

        /**
         * <p>
         * The parameters for using an MSK stream as a source.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link PipeSourceManagedStreamingKafkaParameters.Builder} avoiding the need to create one manually via
         * {@link PipeSourceManagedStreamingKafkaParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PipeSourceManagedStreamingKafkaParameters.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #managedStreamingKafkaParameters(PipeSourceManagedStreamingKafkaParameters)}.
         * 
         * @param managedStreamingKafkaParameters
         *        a consumer that will call methods on {@link PipeSourceManagedStreamingKafkaParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #managedStreamingKafkaParameters(PipeSourceManagedStreamingKafkaParameters)
         */
        default Builder managedStreamingKafkaParameters(
                Consumer<PipeSourceManagedStreamingKafkaParameters.Builder> managedStreamingKafkaParameters) {
            return managedStreamingKafkaParameters(PipeSourceManagedStreamingKafkaParameters.builder()
                    .applyMutation(managedStreamingKafkaParameters).build());
        }

        /**
         * <p>
         * The parameters for using a self-managed Apache Kafka stream as a source.
         * </p>
         * <p>
         * A <i>self managed</i> cluster refers to any Apache Kafka cluster not hosted by Amazon Web Services. This
         * includes both clusters you manage yourself, as well as those hosted by a third-party provider, such as <a
         * href="https://www.confluent.io/">Confluent Cloud</a>, <a
         * href="https://www.cloudkarafka.com/">CloudKarafka</a>, or <a href="https://redpanda.com/">Redpanda</a>. For
         * more information, see <a
         * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-kafka.html">Apache Kafka streams as a
         * source</a> in the <i>Amazon EventBridge User Guide</i>.
         * </p>
         * 
         * @param selfManagedKafkaParameters
         *        The parameters for using a self-managed Apache Kafka stream as a source.</p>
         *        <p>
         *        A <i>self managed</i> cluster refers to any Apache Kafka cluster not hosted by Amazon Web Services.
         *        This includes both clusters you manage yourself, as well as those hosted by a third-party provider,
         *        such as <a href="https://www.confluent.io/">Confluent Cloud</a>, <a
         *        href="https://www.cloudkarafka.com/">CloudKarafka</a>, or <a
         *        href="https://redpanda.com/">Redpanda</a>. For more information, see <a
         *        href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-kafka.html">Apache Kafka
         *        streams as a source</a> in the <i>Amazon EventBridge User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selfManagedKafkaParameters(PipeSourceSelfManagedKafkaParameters selfManagedKafkaParameters);

        /**
         * <p>
         * The parameters for using a self-managed Apache Kafka stream as a source.
         * </p>
         * <p>
         * A <i>self managed</i> cluster refers to any Apache Kafka cluster not hosted by Amazon Web Services. This
         * includes both clusters you manage yourself, as well as those hosted by a third-party provider, such as <a
         * href="https://www.confluent.io/">Confluent Cloud</a>, <a
         * href="https://www.cloudkarafka.com/">CloudKarafka</a>, or <a href="https://redpanda.com/">Redpanda</a>. For
         * more information, see <a
         * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-kafka.html">Apache Kafka streams as a
         * source</a> in the <i>Amazon EventBridge User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link PipeSourceSelfManagedKafkaParameters.Builder} avoiding the need to create one manually via
         * {@link PipeSourceSelfManagedKafkaParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PipeSourceSelfManagedKafkaParameters.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #selfManagedKafkaParameters(PipeSourceSelfManagedKafkaParameters)}.
         * 
         * @param selfManagedKafkaParameters
         *        a consumer that will call methods on {@link PipeSourceSelfManagedKafkaParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #selfManagedKafkaParameters(PipeSourceSelfManagedKafkaParameters)
         */
        default Builder selfManagedKafkaParameters(
                Consumer<PipeSourceSelfManagedKafkaParameters.Builder> selfManagedKafkaParameters) {
            return selfManagedKafkaParameters(PipeSourceSelfManagedKafkaParameters.builder()
                    .applyMutation(selfManagedKafkaParameters).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private FilterCriteria filterCriteria;

        private PipeSourceKinesisStreamParameters kinesisStreamParameters;

        private PipeSourceDynamoDBStreamParameters dynamoDBStreamParameters;

        private PipeSourceSqsQueueParameters sqsQueueParameters;

        private PipeSourceActiveMQBrokerParameters activeMQBrokerParameters;

        private PipeSourceRabbitMQBrokerParameters rabbitMQBrokerParameters;

        private PipeSourceManagedStreamingKafkaParameters managedStreamingKafkaParameters;

        private PipeSourceSelfManagedKafkaParameters selfManagedKafkaParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(PipeSourceParameters model) {
            filterCriteria(model.filterCriteria);
            kinesisStreamParameters(model.kinesisStreamParameters);
            dynamoDBStreamParameters(model.dynamoDBStreamParameters);
            sqsQueueParameters(model.sqsQueueParameters);
            activeMQBrokerParameters(model.activeMQBrokerParameters);
            rabbitMQBrokerParameters(model.rabbitMQBrokerParameters);
            managedStreamingKafkaParameters(model.managedStreamingKafkaParameters);
            selfManagedKafkaParameters(model.selfManagedKafkaParameters);
        }

        public final FilterCriteria.Builder getFilterCriteria() {
            return filterCriteria != null ? filterCriteria.toBuilder() : null;
        }

        public final void setFilterCriteria(FilterCriteria.BuilderImpl filterCriteria) {
            this.filterCriteria = filterCriteria != null ? filterCriteria.build() : null;
        }

        @Override
        public final Builder filterCriteria(FilterCriteria filterCriteria) {
            this.filterCriteria = filterCriteria;
            return this;
        }

        public final PipeSourceKinesisStreamParameters.Builder getKinesisStreamParameters() {
            return kinesisStreamParameters != null ? kinesisStreamParameters.toBuilder() : null;
        }

        public final void setKinesisStreamParameters(PipeSourceKinesisStreamParameters.BuilderImpl kinesisStreamParameters) {
            this.kinesisStreamParameters = kinesisStreamParameters != null ? kinesisStreamParameters.build() : null;
        }

        @Override
        public final Builder kinesisStreamParameters(PipeSourceKinesisStreamParameters kinesisStreamParameters) {
            this.kinesisStreamParameters = kinesisStreamParameters;
            return this;
        }

        public final PipeSourceDynamoDBStreamParameters.Builder getDynamoDBStreamParameters() {
            return dynamoDBStreamParameters != null ? dynamoDBStreamParameters.toBuilder() : null;
        }

        public final void setDynamoDBStreamParameters(PipeSourceDynamoDBStreamParameters.BuilderImpl dynamoDBStreamParameters) {
            this.dynamoDBStreamParameters = dynamoDBStreamParameters != null ? dynamoDBStreamParameters.build() : null;
        }

        @Override
        public final Builder dynamoDBStreamParameters(PipeSourceDynamoDBStreamParameters dynamoDBStreamParameters) {
            this.dynamoDBStreamParameters = dynamoDBStreamParameters;
            return this;
        }

        public final PipeSourceSqsQueueParameters.Builder getSqsQueueParameters() {
            return sqsQueueParameters != null ? sqsQueueParameters.toBuilder() : null;
        }

        public final void setSqsQueueParameters(PipeSourceSqsQueueParameters.BuilderImpl sqsQueueParameters) {
            this.sqsQueueParameters = sqsQueueParameters != null ? sqsQueueParameters.build() : null;
        }

        @Override
        public final Builder sqsQueueParameters(PipeSourceSqsQueueParameters sqsQueueParameters) {
            this.sqsQueueParameters = sqsQueueParameters;
            return this;
        }

        public final PipeSourceActiveMQBrokerParameters.Builder getActiveMQBrokerParameters() {
            return activeMQBrokerParameters != null ? activeMQBrokerParameters.toBuilder() : null;
        }

        public final void setActiveMQBrokerParameters(PipeSourceActiveMQBrokerParameters.BuilderImpl activeMQBrokerParameters) {
            this.activeMQBrokerParameters = activeMQBrokerParameters != null ? activeMQBrokerParameters.build() : null;
        }

        @Override
        public final Builder activeMQBrokerParameters(PipeSourceActiveMQBrokerParameters activeMQBrokerParameters) {
            this.activeMQBrokerParameters = activeMQBrokerParameters;
            return this;
        }

        public final PipeSourceRabbitMQBrokerParameters.Builder getRabbitMQBrokerParameters() {
            return rabbitMQBrokerParameters != null ? rabbitMQBrokerParameters.toBuilder() : null;
        }

        public final void setRabbitMQBrokerParameters(PipeSourceRabbitMQBrokerParameters.BuilderImpl rabbitMQBrokerParameters) {
            this.rabbitMQBrokerParameters = rabbitMQBrokerParameters != null ? rabbitMQBrokerParameters.build() : null;
        }

        @Override
        public final Builder rabbitMQBrokerParameters(PipeSourceRabbitMQBrokerParameters rabbitMQBrokerParameters) {
            this.rabbitMQBrokerParameters = rabbitMQBrokerParameters;
            return this;
        }

        public final PipeSourceManagedStreamingKafkaParameters.Builder getManagedStreamingKafkaParameters() {
            return managedStreamingKafkaParameters != null ? managedStreamingKafkaParameters.toBuilder() : null;
        }

        public final void setManagedStreamingKafkaParameters(
                PipeSourceManagedStreamingKafkaParameters.BuilderImpl managedStreamingKafkaParameters) {
            this.managedStreamingKafkaParameters = managedStreamingKafkaParameters != null ? managedStreamingKafkaParameters
                    .build() : null;
        }

        @Override
        public final Builder managedStreamingKafkaParameters(
                PipeSourceManagedStreamingKafkaParameters managedStreamingKafkaParameters) {
            this.managedStreamingKafkaParameters = managedStreamingKafkaParameters;
            return this;
        }

        public final PipeSourceSelfManagedKafkaParameters.Builder getSelfManagedKafkaParameters() {
            return selfManagedKafkaParameters != null ? selfManagedKafkaParameters.toBuilder() : null;
        }

        public final void setSelfManagedKafkaParameters(
                PipeSourceSelfManagedKafkaParameters.BuilderImpl selfManagedKafkaParameters) {
            this.selfManagedKafkaParameters = selfManagedKafkaParameters != null ? selfManagedKafkaParameters.build() : null;
        }

        @Override
        public final Builder selfManagedKafkaParameters(PipeSourceSelfManagedKafkaParameters selfManagedKafkaParameters) {
            this.selfManagedKafkaParameters = selfManagedKafkaParameters;
            return this;
        }

        @Override
        public PipeSourceParameters build() {
            return new PipeSourceParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
