/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pipes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The parameters for using a Timestream for LiveAnalytics table as a target.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PipeTargetTimestreamParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<PipeTargetTimestreamParameters.Builder, PipeTargetTimestreamParameters> {
    private static final SdkField<String> TIME_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimeValue").getter(getter(PipeTargetTimestreamParameters::timeValue)).setter(setter(Builder::timeValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeValue").build()).build();

    private static final SdkField<String> EPOCH_TIME_UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EpochTimeUnit").getter(getter(PipeTargetTimestreamParameters::epochTimeUnitAsString))
            .setter(setter(Builder::epochTimeUnit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EpochTimeUnit").build()).build();

    private static final SdkField<String> TIME_FIELD_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimeFieldType").getter(getter(PipeTargetTimestreamParameters::timeFieldTypeAsString))
            .setter(setter(Builder::timeFieldType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeFieldType").build()).build();

    private static final SdkField<String> TIMESTAMP_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimestampFormat").getter(getter(PipeTargetTimestreamParameters::timestampFormat))
            .setter(setter(Builder::timestampFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimestampFormat").build()).build();

    private static final SdkField<String> VERSION_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VersionValue").getter(getter(PipeTargetTimestreamParameters::versionValue))
            .setter(setter(Builder::versionValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionValue").build()).build();

    private static final SdkField<List<DimensionMapping>> DIMENSION_MAPPINGS_FIELD = SdkField
            .<List<DimensionMapping>> builder(MarshallingType.LIST)
            .memberName("DimensionMappings")
            .getter(getter(PipeTargetTimestreamParameters::dimensionMappings))
            .setter(setter(Builder::dimensionMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DimensionMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(DimensionMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<SingleMeasureMapping>> SINGLE_MEASURE_MAPPINGS_FIELD = SdkField
            .<List<SingleMeasureMapping>> builder(MarshallingType.LIST)
            .memberName("SingleMeasureMappings")
            .getter(getter(PipeTargetTimestreamParameters::singleMeasureMappings))
            .setter(setter(Builder::singleMeasureMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SingleMeasureMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SingleMeasureMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(SingleMeasureMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<MultiMeasureMapping>> MULTI_MEASURE_MAPPINGS_FIELD = SdkField
            .<List<MultiMeasureMapping>> builder(MarshallingType.LIST)
            .memberName("MultiMeasureMappings")
            .getter(getter(PipeTargetTimestreamParameters::multiMeasureMappings))
            .setter(setter(Builder::multiMeasureMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiMeasureMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MultiMeasureMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(MultiMeasureMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_VALUE_FIELD,
            EPOCH_TIME_UNIT_FIELD, TIME_FIELD_TYPE_FIELD, TIMESTAMP_FORMAT_FIELD, VERSION_VALUE_FIELD, DIMENSION_MAPPINGS_FIELD,
            SINGLE_MEASURE_MAPPINGS_FIELD, MULTI_MEASURE_MAPPINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String timeValue;

    private final String epochTimeUnit;

    private final String timeFieldType;

    private final String timestampFormat;

    private final String versionValue;

    private final List<DimensionMapping> dimensionMappings;

    private final List<SingleMeasureMapping> singleMeasureMappings;

    private final List<MultiMeasureMapping> multiMeasureMappings;

    private PipeTargetTimestreamParameters(BuilderImpl builder) {
        this.timeValue = builder.timeValue;
        this.epochTimeUnit = builder.epochTimeUnit;
        this.timeFieldType = builder.timeFieldType;
        this.timestampFormat = builder.timestampFormat;
        this.versionValue = builder.versionValue;
        this.dimensionMappings = builder.dimensionMappings;
        this.singleMeasureMappings = builder.singleMeasureMappings;
        this.multiMeasureMappings = builder.multiMeasureMappings;
    }

    /**
     * <p>
     * Dynamic path to the source data field that represents the time value for your data.
     * </p>
     * 
     * @return Dynamic path to the source data field that represents the time value for your data.
     */
    public final String timeValue() {
        return timeValue;
    }

    /**
     * <p>
     * The granularity of the time units used. Default is <code>MILLISECONDS</code>.
     * </p>
     * <p>
     * Required if <code>TimeFieldType</code> is specified as <code>EPOCH</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #epochTimeUnit}
     * will return {@link EpochTimeUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #epochTimeUnitAsString}.
     * </p>
     * 
     * @return The granularity of the time units used. Default is <code>MILLISECONDS</code>.</p>
     *         <p>
     *         Required if <code>TimeFieldType</code> is specified as <code>EPOCH</code>.
     * @see EpochTimeUnit
     */
    public final EpochTimeUnit epochTimeUnit() {
        return EpochTimeUnit.fromValue(epochTimeUnit);
    }

    /**
     * <p>
     * The granularity of the time units used. Default is <code>MILLISECONDS</code>.
     * </p>
     * <p>
     * Required if <code>TimeFieldType</code> is specified as <code>EPOCH</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #epochTimeUnit}
     * will return {@link EpochTimeUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #epochTimeUnitAsString}.
     * </p>
     * 
     * @return The granularity of the time units used. Default is <code>MILLISECONDS</code>.</p>
     *         <p>
     *         Required if <code>TimeFieldType</code> is specified as <code>EPOCH</code>.
     * @see EpochTimeUnit
     */
    public final String epochTimeUnitAsString() {
        return epochTimeUnit;
    }

    /**
     * <p>
     * The type of time value used.
     * </p>
     * <p>
     * The default is <code>EPOCH</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeFieldType}
     * will return {@link TimeFieldType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #timeFieldTypeAsString}.
     * </p>
     * 
     * @return The type of time value used.</p>
     *         <p>
     *         The default is <code>EPOCH</code>.
     * @see TimeFieldType
     */
    public final TimeFieldType timeFieldType() {
        return TimeFieldType.fromValue(timeFieldType);
    }

    /**
     * <p>
     * The type of time value used.
     * </p>
     * <p>
     * The default is <code>EPOCH</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeFieldType}
     * will return {@link TimeFieldType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #timeFieldTypeAsString}.
     * </p>
     * 
     * @return The type of time value used.</p>
     *         <p>
     *         The default is <code>EPOCH</code>.
     * @see TimeFieldType
     */
    public final String timeFieldTypeAsString() {
        return timeFieldType;
    }

    /**
     * <p>
     * How to format the timestamps. For example, <code>YYYY-MM-DDThh:mm:ss.sssTZD</code>.
     * </p>
     * <p>
     * Required if <code>TimeFieldType</code> is specified as <code>TIMESTAMP_FORMAT</code>.
     * </p>
     * 
     * @return How to format the timestamps. For example, <code>YYYY-MM-DDThh:mm:ss.sssTZD</code>.</p>
     *         <p>
     *         Required if <code>TimeFieldType</code> is specified as <code>TIMESTAMP_FORMAT</code>.
     */
    public final String timestampFormat() {
        return timestampFormat;
    }

    /**
     * <p>
     * 64 bit version value or source data field that represents the version value for your data.
     * </p>
     * <p>
     * Write requests with a higher version number will update the existing measure values of the record and version. In
     * cases where the measure value is the same, the version will still be updated.
     * </p>
     * <p>
     * Default value is 1.
     * </p>
     * <p>
     * Timestream for LiveAnalytics does not support updating partial measure values in a record.
     * </p>
     * <p>
     * Write requests for duplicate data with a higher version number will update the existing measure value and
     * version. In cases where the measure value is the same, <code>Version</code> will still be updated. Default value
     * is <code>1</code>.
     * </p>
     * <note>
     * <p>
     * <code>Version</code> must be <code>1</code> or greater, or you will receive a <code>ValidationException</code>
     * error.
     * </p>
     * </note>
     * 
     * @return 64 bit version value or source data field that represents the version value for your data.</p>
     *         <p>
     *         Write requests with a higher version number will update the existing measure values of the record and
     *         version. In cases where the measure value is the same, the version will still be updated.
     *         </p>
     *         <p>
     *         Default value is 1.
     *         </p>
     *         <p>
     *         Timestream for LiveAnalytics does not support updating partial measure values in a record.
     *         </p>
     *         <p>
     *         Write requests for duplicate data with a higher version number will update the existing measure value and
     *         version. In cases where the measure value is the same, <code>Version</code> will still be updated.
     *         Default value is <code>1</code>.
     *         </p>
     *         <note>
     *         <p>
     *         <code>Version</code> must be <code>1</code> or greater, or you will receive a
     *         <code>ValidationException</code> error.
     *         </p>
     */
    public final String versionValue() {
        return versionValue;
    }

    /**
     * For responses, this returns true if the service returned a value for the DimensionMappings property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDimensionMappings() {
        return dimensionMappings != null && !(dimensionMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Map source data to dimensions in the target Timestream for LiveAnalytics table.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/timestream/latest/developerguide/concepts.html">Amazon Timestream for
     * LiveAnalytics concepts</a>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDimensionMappings} method.
     * </p>
     * 
     * @return Map source data to dimensions in the target Timestream for LiveAnalytics table.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/timestream/latest/developerguide/concepts.html">Amazon Timestream for
     *         LiveAnalytics concepts</a>
     */
    public final List<DimensionMapping> dimensionMappings() {
        return dimensionMappings;
    }

    /**
     * For responses, this returns true if the service returned a value for the SingleMeasureMappings property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSingleMeasureMappings() {
        return singleMeasureMappings != null && !(singleMeasureMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Mappings of single source data fields to individual records in the specified Timestream for LiveAnalytics table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSingleMeasureMappings} method.
     * </p>
     * 
     * @return Mappings of single source data fields to individual records in the specified Timestream for LiveAnalytics
     *         table.
     */
    public final List<SingleMeasureMapping> singleMeasureMappings() {
        return singleMeasureMappings;
    }

    /**
     * For responses, this returns true if the service returned a value for the MultiMeasureMappings property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMultiMeasureMappings() {
        return multiMeasureMappings != null && !(multiMeasureMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Maps multiple measures from the source event to the same record in the specified Timestream for LiveAnalytics
     * table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMultiMeasureMappings} method.
     * </p>
     * 
     * @return Maps multiple measures from the source event to the same record in the specified Timestream for
     *         LiveAnalytics table.
     */
    public final List<MultiMeasureMapping> multiMeasureMappings() {
        return multiMeasureMappings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timeValue());
        hashCode = 31 * hashCode + Objects.hashCode(epochTimeUnitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timeFieldTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timestampFormat());
        hashCode = 31 * hashCode + Objects.hashCode(versionValue());
        hashCode = 31 * hashCode + Objects.hashCode(hasDimensionMappings() ? dimensionMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSingleMeasureMappings() ? singleMeasureMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMultiMeasureMappings() ? multiMeasureMappings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipeTargetTimestreamParameters)) {
            return false;
        }
        PipeTargetTimestreamParameters other = (PipeTargetTimestreamParameters) obj;
        return Objects.equals(timeValue(), other.timeValue())
                && Objects.equals(epochTimeUnitAsString(), other.epochTimeUnitAsString())
                && Objects.equals(timeFieldTypeAsString(), other.timeFieldTypeAsString())
                && Objects.equals(timestampFormat(), other.timestampFormat())
                && Objects.equals(versionValue(), other.versionValue()) && hasDimensionMappings() == other.hasDimensionMappings()
                && Objects.equals(dimensionMappings(), other.dimensionMappings())
                && hasSingleMeasureMappings() == other.hasSingleMeasureMappings()
                && Objects.equals(singleMeasureMappings(), other.singleMeasureMappings())
                && hasMultiMeasureMappings() == other.hasMultiMeasureMappings()
                && Objects.equals(multiMeasureMappings(), other.multiMeasureMappings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PipeTargetTimestreamParameters").add("TimeValue", timeValue())
                .add("EpochTimeUnit", epochTimeUnitAsString()).add("TimeFieldType", timeFieldTypeAsString())
                .add("TimestampFormat", timestampFormat()).add("VersionValue", versionValue())
                .add("DimensionMappings", hasDimensionMappings() ? dimensionMappings() : null)
                .add("SingleMeasureMappings", hasSingleMeasureMappings() ? singleMeasureMappings() : null)
                .add("MultiMeasureMappings", hasMultiMeasureMappings() ? multiMeasureMappings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TimeValue":
            return Optional.ofNullable(clazz.cast(timeValue()));
        case "EpochTimeUnit":
            return Optional.ofNullable(clazz.cast(epochTimeUnitAsString()));
        case "TimeFieldType":
            return Optional.ofNullable(clazz.cast(timeFieldTypeAsString()));
        case "TimestampFormat":
            return Optional.ofNullable(clazz.cast(timestampFormat()));
        case "VersionValue":
            return Optional.ofNullable(clazz.cast(versionValue()));
        case "DimensionMappings":
            return Optional.ofNullable(clazz.cast(dimensionMappings()));
        case "SingleMeasureMappings":
            return Optional.ofNullable(clazz.cast(singleMeasureMappings()));
        case "MultiMeasureMappings":
            return Optional.ofNullable(clazz.cast(multiMeasureMappings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PipeTargetTimestreamParameters, T> g) {
        return obj -> g.apply((PipeTargetTimestreamParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PipeTargetTimestreamParameters> {
        /**
         * <p>
         * Dynamic path to the source data field that represents the time value for your data.
         * </p>
         * 
         * @param timeValue
         *        Dynamic path to the source data field that represents the time value for your data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeValue(String timeValue);

        /**
         * <p>
         * The granularity of the time units used. Default is <code>MILLISECONDS</code>.
         * </p>
         * <p>
         * Required if <code>TimeFieldType</code> is specified as <code>EPOCH</code>.
         * </p>
         * 
         * @param epochTimeUnit
         *        The granularity of the time units used. Default is <code>MILLISECONDS</code>.</p>
         *        <p>
         *        Required if <code>TimeFieldType</code> is specified as <code>EPOCH</code>.
         * @see EpochTimeUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EpochTimeUnit
         */
        Builder epochTimeUnit(String epochTimeUnit);

        /**
         * <p>
         * The granularity of the time units used. Default is <code>MILLISECONDS</code>.
         * </p>
         * <p>
         * Required if <code>TimeFieldType</code> is specified as <code>EPOCH</code>.
         * </p>
         * 
         * @param epochTimeUnit
         *        The granularity of the time units used. Default is <code>MILLISECONDS</code>.</p>
         *        <p>
         *        Required if <code>TimeFieldType</code> is specified as <code>EPOCH</code>.
         * @see EpochTimeUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EpochTimeUnit
         */
        Builder epochTimeUnit(EpochTimeUnit epochTimeUnit);

        /**
         * <p>
         * The type of time value used.
         * </p>
         * <p>
         * The default is <code>EPOCH</code>.
         * </p>
         * 
         * @param timeFieldType
         *        The type of time value used.</p>
         *        <p>
         *        The default is <code>EPOCH</code>.
         * @see TimeFieldType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeFieldType
         */
        Builder timeFieldType(String timeFieldType);

        /**
         * <p>
         * The type of time value used.
         * </p>
         * <p>
         * The default is <code>EPOCH</code>.
         * </p>
         * 
         * @param timeFieldType
         *        The type of time value used.</p>
         *        <p>
         *        The default is <code>EPOCH</code>.
         * @see TimeFieldType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeFieldType
         */
        Builder timeFieldType(TimeFieldType timeFieldType);

        /**
         * <p>
         * How to format the timestamps. For example, <code>YYYY-MM-DDThh:mm:ss.sssTZD</code>.
         * </p>
         * <p>
         * Required if <code>TimeFieldType</code> is specified as <code>TIMESTAMP_FORMAT</code>.
         * </p>
         * 
         * @param timestampFormat
         *        How to format the timestamps. For example, <code>YYYY-MM-DDThh:mm:ss.sssTZD</code>.</p>
         *        <p>
         *        Required if <code>TimeFieldType</code> is specified as <code>TIMESTAMP_FORMAT</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestampFormat(String timestampFormat);

        /**
         * <p>
         * 64 bit version value or source data field that represents the version value for your data.
         * </p>
         * <p>
         * Write requests with a higher version number will update the existing measure values of the record and
         * version. In cases where the measure value is the same, the version will still be updated.
         * </p>
         * <p>
         * Default value is 1.
         * </p>
         * <p>
         * Timestream for LiveAnalytics does not support updating partial measure values in a record.
         * </p>
         * <p>
         * Write requests for duplicate data with a higher version number will update the existing measure value and
         * version. In cases where the measure value is the same, <code>Version</code> will still be updated. Default
         * value is <code>1</code>.
         * </p>
         * <note>
         * <p>
         * <code>Version</code> must be <code>1</code> or greater, or you will receive a
         * <code>ValidationException</code> error.
         * </p>
         * </note>
         * 
         * @param versionValue
         *        64 bit version value or source data field that represents the version value for your data.</p>
         *        <p>
         *        Write requests with a higher version number will update the existing measure values of the record and
         *        version. In cases where the measure value is the same, the version will still be updated.
         *        </p>
         *        <p>
         *        Default value is 1.
         *        </p>
         *        <p>
         *        Timestream for LiveAnalytics does not support updating partial measure values in a record.
         *        </p>
         *        <p>
         *        Write requests for duplicate data with a higher version number will update the existing measure value
         *        and version. In cases where the measure value is the same, <code>Version</code> will still be updated.
         *        Default value is <code>1</code>.
         *        </p>
         *        <note>
         *        <p>
         *        <code>Version</code> must be <code>1</code> or greater, or you will receive a
         *        <code>ValidationException</code> error.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionValue(String versionValue);

        /**
         * <p>
         * Map source data to dimensions in the target Timestream for LiveAnalytics table.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/timestream/latest/developerguide/concepts.html">Amazon Timestream for
         * LiveAnalytics concepts</a>
         * </p>
         * 
         * @param dimensionMappings
         *        Map source data to dimensions in the target Timestream for LiveAnalytics table.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/timestream/latest/developerguide/concepts.html">Amazon Timestream
         *        for LiveAnalytics concepts</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensionMappings(Collection<DimensionMapping> dimensionMappings);

        /**
         * <p>
         * Map source data to dimensions in the target Timestream for LiveAnalytics table.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/timestream/latest/developerguide/concepts.html">Amazon Timestream for
         * LiveAnalytics concepts</a>
         * </p>
         * 
         * @param dimensionMappings
         *        Map source data to dimensions in the target Timestream for LiveAnalytics table.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/timestream/latest/developerguide/concepts.html">Amazon Timestream
         *        for LiveAnalytics concepts</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensionMappings(DimensionMapping... dimensionMappings);

        /**
         * <p>
         * Map source data to dimensions in the target Timestream for LiveAnalytics table.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/timestream/latest/developerguide/concepts.html">Amazon Timestream for
         * LiveAnalytics concepts</a>
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pipes.model.DimensionMapping.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.pipes.model.DimensionMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pipes.model.DimensionMapping.Builder#build()} is called immediately
         * and its result is passed to {@link #dimensionMappings(List<DimensionMapping>)}.
         * 
         * @param dimensionMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pipes.model.DimensionMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dimensionMappings(java.util.Collection<DimensionMapping>)
         */
        Builder dimensionMappings(Consumer<DimensionMapping.Builder>... dimensionMappings);

        /**
         * <p>
         * Mappings of single source data fields to individual records in the specified Timestream for LiveAnalytics
         * table.
         * </p>
         * 
         * @param singleMeasureMappings
         *        Mappings of single source data fields to individual records in the specified Timestream for
         *        LiveAnalytics table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder singleMeasureMappings(Collection<SingleMeasureMapping> singleMeasureMappings);

        /**
         * <p>
         * Mappings of single source data fields to individual records in the specified Timestream for LiveAnalytics
         * table.
         * </p>
         * 
         * @param singleMeasureMappings
         *        Mappings of single source data fields to individual records in the specified Timestream for
         *        LiveAnalytics table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder singleMeasureMappings(SingleMeasureMapping... singleMeasureMappings);

        /**
         * <p>
         * Mappings of single source data fields to individual records in the specified Timestream for LiveAnalytics
         * table.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pipes.model.SingleMeasureMapping.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.pipes.model.SingleMeasureMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pipes.model.SingleMeasureMapping.Builder#build()} is called
         * immediately and its result is passed to {@link #singleMeasureMappings(List<SingleMeasureMapping>)}.
         * 
         * @param singleMeasureMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pipes.model.SingleMeasureMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #singleMeasureMappings(java.util.Collection<SingleMeasureMapping>)
         */
        Builder singleMeasureMappings(Consumer<SingleMeasureMapping.Builder>... singleMeasureMappings);

        /**
         * <p>
         * Maps multiple measures from the source event to the same record in the specified Timestream for LiveAnalytics
         * table.
         * </p>
         * 
         * @param multiMeasureMappings
         *        Maps multiple measures from the source event to the same record in the specified Timestream for
         *        LiveAnalytics table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiMeasureMappings(Collection<MultiMeasureMapping> multiMeasureMappings);

        /**
         * <p>
         * Maps multiple measures from the source event to the same record in the specified Timestream for LiveAnalytics
         * table.
         * </p>
         * 
         * @param multiMeasureMappings
         *        Maps multiple measures from the source event to the same record in the specified Timestream for
         *        LiveAnalytics table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiMeasureMappings(MultiMeasureMapping... multiMeasureMappings);

        /**
         * <p>
         * Maps multiple measures from the source event to the same record in the specified Timestream for LiveAnalytics
         * table.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pipes.model.MultiMeasureMapping.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.pipes.model.MultiMeasureMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pipes.model.MultiMeasureMapping.Builder#build()} is called immediately
         * and its result is passed to {@link #multiMeasureMappings(List<MultiMeasureMapping>)}.
         * 
         * @param multiMeasureMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pipes.model.MultiMeasureMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #multiMeasureMappings(java.util.Collection<MultiMeasureMapping>)
         */
        Builder multiMeasureMappings(Consumer<MultiMeasureMapping.Builder>... multiMeasureMappings);
    }

    static final class BuilderImpl implements Builder {
        private String timeValue;

        private String epochTimeUnit;

        private String timeFieldType;

        private String timestampFormat;

        private String versionValue;

        private List<DimensionMapping> dimensionMappings = DefaultSdkAutoConstructList.getInstance();

        private List<SingleMeasureMapping> singleMeasureMappings = DefaultSdkAutoConstructList.getInstance();

        private List<MultiMeasureMapping> multiMeasureMappings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PipeTargetTimestreamParameters model) {
            timeValue(model.timeValue);
            epochTimeUnit(model.epochTimeUnit);
            timeFieldType(model.timeFieldType);
            timestampFormat(model.timestampFormat);
            versionValue(model.versionValue);
            dimensionMappings(model.dimensionMappings);
            singleMeasureMappings(model.singleMeasureMappings);
            multiMeasureMappings(model.multiMeasureMappings);
        }

        public final String getTimeValue() {
            return timeValue;
        }

        public final void setTimeValue(String timeValue) {
            this.timeValue = timeValue;
        }

        @Override
        public final Builder timeValue(String timeValue) {
            this.timeValue = timeValue;
            return this;
        }

        public final String getEpochTimeUnit() {
            return epochTimeUnit;
        }

        public final void setEpochTimeUnit(String epochTimeUnit) {
            this.epochTimeUnit = epochTimeUnit;
        }

        @Override
        public final Builder epochTimeUnit(String epochTimeUnit) {
            this.epochTimeUnit = epochTimeUnit;
            return this;
        }

        @Override
        public final Builder epochTimeUnit(EpochTimeUnit epochTimeUnit) {
            this.epochTimeUnit(epochTimeUnit == null ? null : epochTimeUnit.toString());
            return this;
        }

        public final String getTimeFieldType() {
            return timeFieldType;
        }

        public final void setTimeFieldType(String timeFieldType) {
            this.timeFieldType = timeFieldType;
        }

        @Override
        public final Builder timeFieldType(String timeFieldType) {
            this.timeFieldType = timeFieldType;
            return this;
        }

        @Override
        public final Builder timeFieldType(TimeFieldType timeFieldType) {
            this.timeFieldType(timeFieldType == null ? null : timeFieldType.toString());
            return this;
        }

        public final String getTimestampFormat() {
            return timestampFormat;
        }

        public final void setTimestampFormat(String timestampFormat) {
            this.timestampFormat = timestampFormat;
        }

        @Override
        public final Builder timestampFormat(String timestampFormat) {
            this.timestampFormat = timestampFormat;
            return this;
        }

        public final String getVersionValue() {
            return versionValue;
        }

        public final void setVersionValue(String versionValue) {
            this.versionValue = versionValue;
        }

        @Override
        public final Builder versionValue(String versionValue) {
            this.versionValue = versionValue;
            return this;
        }

        public final List<DimensionMapping.Builder> getDimensionMappings() {
            List<DimensionMapping.Builder> result = DimensionMappingsCopier.copyToBuilder(this.dimensionMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDimensionMappings(Collection<DimensionMapping.BuilderImpl> dimensionMappings) {
            this.dimensionMappings = DimensionMappingsCopier.copyFromBuilder(dimensionMappings);
        }

        @Override
        public final Builder dimensionMappings(Collection<DimensionMapping> dimensionMappings) {
            this.dimensionMappings = DimensionMappingsCopier.copy(dimensionMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensionMappings(DimensionMapping... dimensionMappings) {
            dimensionMappings(Arrays.asList(dimensionMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensionMappings(Consumer<DimensionMapping.Builder>... dimensionMappings) {
            dimensionMappings(Stream.of(dimensionMappings).map(c -> DimensionMapping.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<SingleMeasureMapping.Builder> getSingleMeasureMappings() {
            List<SingleMeasureMapping.Builder> result = SingleMeasureMappingsCopier.copyToBuilder(this.singleMeasureMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSingleMeasureMappings(Collection<SingleMeasureMapping.BuilderImpl> singleMeasureMappings) {
            this.singleMeasureMappings = SingleMeasureMappingsCopier.copyFromBuilder(singleMeasureMappings);
        }

        @Override
        public final Builder singleMeasureMappings(Collection<SingleMeasureMapping> singleMeasureMappings) {
            this.singleMeasureMappings = SingleMeasureMappingsCopier.copy(singleMeasureMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder singleMeasureMappings(SingleMeasureMapping... singleMeasureMappings) {
            singleMeasureMappings(Arrays.asList(singleMeasureMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder singleMeasureMappings(Consumer<SingleMeasureMapping.Builder>... singleMeasureMappings) {
            singleMeasureMappings(Stream.of(singleMeasureMappings)
                    .map(c -> SingleMeasureMapping.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<MultiMeasureMapping.Builder> getMultiMeasureMappings() {
            List<MultiMeasureMapping.Builder> result = MultiMeasureMappingsCopier.copyToBuilder(this.multiMeasureMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMultiMeasureMappings(Collection<MultiMeasureMapping.BuilderImpl> multiMeasureMappings) {
            this.multiMeasureMappings = MultiMeasureMappingsCopier.copyFromBuilder(multiMeasureMappings);
        }

        @Override
        public final Builder multiMeasureMappings(Collection<MultiMeasureMapping> multiMeasureMappings) {
            this.multiMeasureMappings = MultiMeasureMappingsCopier.copy(multiMeasureMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder multiMeasureMappings(MultiMeasureMapping... multiMeasureMappings) {
            multiMeasureMappings(Arrays.asList(multiMeasureMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder multiMeasureMappings(Consumer<MultiMeasureMapping.Builder>... multiMeasureMappings) {
            multiMeasureMappings(Stream.of(multiMeasureMappings).map(c -> MultiMeasureMapping.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public PipeTargetTimestreamParameters build() {
            return new PipeTargetTimestreamParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
