/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pipes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This structure specifies the VPC subnets and security groups for the stream, and whether a public IP address is to be
 * used.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SelfManagedKafkaAccessConfigurationVpc implements SdkPojo, Serializable,
        ToCopyableBuilder<SelfManagedKafkaAccessConfigurationVpc.Builder, SelfManagedKafkaAccessConfigurationVpc> {
    private static final SdkField<List<String>> SUBNETS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Subnets")
            .getter(getter(SelfManagedKafkaAccessConfigurationVpc::subnets))
            .setter(setter(Builder::subnets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subnets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroup")
            .getter(getter(SelfManagedKafkaAccessConfigurationVpc::securityGroup))
            .setter(setter(Builder::securityGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroup").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBNETS_FIELD,
            SECURITY_GROUP_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> subnets;

    private final List<String> securityGroup;

    private SelfManagedKafkaAccessConfigurationVpc(BuilderImpl builder) {
        this.subnets = builder.subnets;
        this.securityGroup = builder.securityGroup;
    }

    /**
     * For responses, this returns true if the service returned a value for the Subnets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnets() {
        return subnets != null && !(subnets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the subnets associated with the stream. These subnets must all be in the same VPC. You can specify as
     * many as 16 subnets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnets} method.
     * </p>
     * 
     * @return Specifies the subnets associated with the stream. These subnets must all be in the same VPC. You can
     *         specify as many as 16 subnets.
     */
    public final List<String> subnets() {
        return subnets;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroup property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroup() {
        return securityGroup != null && !(securityGroup instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the security groups associated with the stream. These security groups must all be in the same VPC. You
     * can specify as many as five security groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroup} method.
     * </p>
     * 
     * @return Specifies the security groups associated with the stream. These security groups must all be in the same
     *         VPC. You can specify as many as five security groups.
     */
    public final List<String> securityGroup() {
        return securityGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnets() ? subnets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroup() ? securityGroup() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SelfManagedKafkaAccessConfigurationVpc)) {
            return false;
        }
        SelfManagedKafkaAccessConfigurationVpc other = (SelfManagedKafkaAccessConfigurationVpc) obj;
        return hasSubnets() == other.hasSubnets() && Objects.equals(subnets(), other.subnets())
                && hasSecurityGroup() == other.hasSecurityGroup() && Objects.equals(securityGroup(), other.securityGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SelfManagedKafkaAccessConfigurationVpc")
                .add("Subnets", subnets() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SecurityGroup", securityGroup() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Subnets":
            return Optional.ofNullable(clazz.cast(subnets()));
        case "SecurityGroup":
            return Optional.ofNullable(clazz.cast(securityGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SelfManagedKafkaAccessConfigurationVpc, T> g) {
        return obj -> g.apply((SelfManagedKafkaAccessConfigurationVpc) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SelfManagedKafkaAccessConfigurationVpc> {
        /**
         * <p>
         * Specifies the subnets associated with the stream. These subnets must all be in the same VPC. You can specify
         * as many as 16 subnets.
         * </p>
         * 
         * @param subnets
         *        Specifies the subnets associated with the stream. These subnets must all be in the same VPC. You can
         *        specify as many as 16 subnets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnets(Collection<String> subnets);

        /**
         * <p>
         * Specifies the subnets associated with the stream. These subnets must all be in the same VPC. You can specify
         * as many as 16 subnets.
         * </p>
         * 
         * @param subnets
         *        Specifies the subnets associated with the stream. These subnets must all be in the same VPC. You can
         *        specify as many as 16 subnets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnets(String... subnets);

        /**
         * <p>
         * Specifies the security groups associated with the stream. These security groups must all be in the same VPC.
         * You can specify as many as five security groups.
         * </p>
         * 
         * @param securityGroup
         *        Specifies the security groups associated with the stream. These security groups must all be in the
         *        same VPC. You can specify as many as five security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroup(Collection<String> securityGroup);

        /**
         * <p>
         * Specifies the security groups associated with the stream. These security groups must all be in the same VPC.
         * You can specify as many as five security groups.
         * </p>
         * 
         * @param securityGroup
         *        Specifies the security groups associated with the stream. These security groups must all be in the
         *        same VPC. You can specify as many as five security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroup(String... securityGroup);
    }

    static final class BuilderImpl implements Builder {
        private List<String> subnets = DefaultSdkAutoConstructList.getInstance();

        private List<String> securityGroup = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SelfManagedKafkaAccessConfigurationVpc model) {
            subnets(model.subnets);
            securityGroup(model.securityGroup);
        }

        public final Collection<String> getSubnets() {
            if (subnets instanceof SdkAutoConstructList) {
                return null;
            }
            return subnets;
        }

        public final void setSubnets(Collection<String> subnets) {
            this.subnets = SubnetIdsCopier.copy(subnets);
        }

        @Override
        public final Builder subnets(Collection<String> subnets) {
            this.subnets = SubnetIdsCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(String... subnets) {
            subnets(Arrays.asList(subnets));
            return this;
        }

        public final Collection<String> getSecurityGroup() {
            if (securityGroup instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroup;
        }

        public final void setSecurityGroup(Collection<String> securityGroup) {
            this.securityGroup = SecurityGroupIdsCopier.copy(securityGroup);
        }

        @Override
        public final Builder securityGroup(Collection<String> securityGroup) {
            this.securityGroup = SecurityGroupIdsCopier.copy(securityGroup);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroup(String... securityGroup) {
            securityGroup(Arrays.asList(securityGroup));
            return this;
        }

        @Override
        public SelfManagedKafkaAccessConfigurationVpc build() {
            return new SelfManagedKafkaAccessConfigurationVpc(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
