/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pipes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Maps a single source data field to a single record in the specified Timestream for LiveAnalytics table.
 * </p>
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/concepts.html">Amazon
 * Timestream for LiveAnalytics concepts</a>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SingleMeasureMapping implements SdkPojo, Serializable,
        ToCopyableBuilder<SingleMeasureMapping.Builder, SingleMeasureMapping> {
    private static final SdkField<String> MEASURE_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MeasureValue").getter(getter(SingleMeasureMapping::measureValue)).setter(setter(Builder::measureValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeasureValue").build()).build();

    private static final SdkField<String> MEASURE_VALUE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MeasureValueType").getter(getter(SingleMeasureMapping::measureValueTypeAsString))
            .setter(setter(Builder::measureValueType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeasureValueType").build()).build();

    private static final SdkField<String> MEASURE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MeasureName").getter(getter(SingleMeasureMapping::measureName)).setter(setter(Builder::measureName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeasureName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEASURE_VALUE_FIELD,
            MEASURE_VALUE_TYPE_FIELD, MEASURE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String measureValue;

    private final String measureValueType;

    private final String measureName;

    private SingleMeasureMapping(BuilderImpl builder) {
        this.measureValue = builder.measureValue;
        this.measureValueType = builder.measureValueType;
        this.measureName = builder.measureName;
    }

    /**
     * <p>
     * Dynamic path of the source field to map to the measure in the record.
     * </p>
     * 
     * @return Dynamic path of the source field to map to the measure in the record.
     */
    public final String measureValue() {
        return measureValue;
    }

    /**
     * <p>
     * Data type of the source field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #measureValueType}
     * will return {@link MeasureValueType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #measureValueTypeAsString}.
     * </p>
     * 
     * @return Data type of the source field.
     * @see MeasureValueType
     */
    public final MeasureValueType measureValueType() {
        return MeasureValueType.fromValue(measureValueType);
    }

    /**
     * <p>
     * Data type of the source field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #measureValueType}
     * will return {@link MeasureValueType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #measureValueTypeAsString}.
     * </p>
     * 
     * @return Data type of the source field.
     * @see MeasureValueType
     */
    public final String measureValueTypeAsString() {
        return measureValueType;
    }

    /**
     * <p>
     * Target measure name for the measurement attribute in the Timestream table.
     * </p>
     * 
     * @return Target measure name for the measurement attribute in the Timestream table.
     */
    public final String measureName() {
        return measureName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(measureValue());
        hashCode = 31 * hashCode + Objects.hashCode(measureValueTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(measureName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SingleMeasureMapping)) {
            return false;
        }
        SingleMeasureMapping other = (SingleMeasureMapping) obj;
        return Objects.equals(measureValue(), other.measureValue())
                && Objects.equals(measureValueTypeAsString(), other.measureValueTypeAsString())
                && Objects.equals(measureName(), other.measureName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SingleMeasureMapping").add("MeasureValue", measureValue())
                .add("MeasureValueType", measureValueTypeAsString()).add("MeasureName", measureName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MeasureValue":
            return Optional.ofNullable(clazz.cast(measureValue()));
        case "MeasureValueType":
            return Optional.ofNullable(clazz.cast(measureValueTypeAsString()));
        case "MeasureName":
            return Optional.ofNullable(clazz.cast(measureName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SingleMeasureMapping, T> g) {
        return obj -> g.apply((SingleMeasureMapping) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SingleMeasureMapping> {
        /**
         * <p>
         * Dynamic path of the source field to map to the measure in the record.
         * </p>
         * 
         * @param measureValue
         *        Dynamic path of the source field to map to the measure in the record.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder measureValue(String measureValue);

        /**
         * <p>
         * Data type of the source field.
         * </p>
         * 
         * @param measureValueType
         *        Data type of the source field.
         * @see MeasureValueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MeasureValueType
         */
        Builder measureValueType(String measureValueType);

        /**
         * <p>
         * Data type of the source field.
         * </p>
         * 
         * @param measureValueType
         *        Data type of the source field.
         * @see MeasureValueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MeasureValueType
         */
        Builder measureValueType(MeasureValueType measureValueType);

        /**
         * <p>
         * Target measure name for the measurement attribute in the Timestream table.
         * </p>
         * 
         * @param measureName
         *        Target measure name for the measurement attribute in the Timestream table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder measureName(String measureName);
    }

    static final class BuilderImpl implements Builder {
        private String measureValue;

        private String measureValueType;

        private String measureName;

        private BuilderImpl() {
        }

        private BuilderImpl(SingleMeasureMapping model) {
            measureValue(model.measureValue);
            measureValueType(model.measureValueType);
            measureName(model.measureName);
        }

        public final String getMeasureValue() {
            return measureValue;
        }

        public final void setMeasureValue(String measureValue) {
            this.measureValue = measureValue;
        }

        @Override
        public final Builder measureValue(String measureValue) {
            this.measureValue = measureValue;
            return this;
        }

        public final String getMeasureValueType() {
            return measureValueType;
        }

        public final void setMeasureValueType(String measureValueType) {
            this.measureValueType = measureValueType;
        }

        @Override
        public final Builder measureValueType(String measureValueType) {
            this.measureValueType = measureValueType;
            return this;
        }

        @Override
        public final Builder measureValueType(MeasureValueType measureValueType) {
            this.measureValueType(measureValueType == null ? null : measureValueType.toString());
            return this;
        }

        public final String getMeasureName() {
            return measureName;
        }

        public final void setMeasureName(String measureName) {
            this.measureName = measureName;
        }

        @Override
        public final Builder measureName(String measureName) {
            this.measureName = measureName;
            return this;
        }

        @Override
        public SingleMeasureMapping build() {
            return new SingleMeasureMapping(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
