/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pipes.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pipes.model.PipeEnrichmentParameters;
import software.amazon.awssdk.services.pipes.model.PipeLogConfiguration;
import software.amazon.awssdk.services.pipes.model.PipeSourceParameters;
import software.amazon.awssdk.services.pipes.model.PipeState;
import software.amazon.awssdk.services.pipes.model.PipeTargetParameters;
import software.amazon.awssdk.services.pipes.model.PipesResponse;
import software.amazon.awssdk.services.pipes.model.RequestedPipeStateDescribeResponse;
import software.amazon.awssdk.services.pipes.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribePipeResponse
extends PipesResponse
implements ToCopyableBuilder<Builder, DescribePipeResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(DescribePipeResponse.getter(DescribePipeResponse::arn)).setter(DescribePipeResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DescribePipeResponse.getter(DescribePipeResponse::name)).setter(DescribePipeResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DescribePipeResponse.getter(DescribePipeResponse::description)).setter(DescribePipeResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> DESIRED_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DesiredState").getter(DescribePipeResponse.getter(DescribePipeResponse::desiredStateAsString)).setter(DescribePipeResponse.setter(Builder::desiredState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredState").build()}).build();
    private static final SdkField<String> CURRENT_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentState").getter(DescribePipeResponse.getter(DescribePipeResponse::currentStateAsString)).setter(DescribePipeResponse.setter(Builder::currentState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentState").build()}).build();
    private static final SdkField<String> STATE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StateReason").getter(DescribePipeResponse.getter(DescribePipeResponse::stateReason)).setter(DescribePipeResponse.setter(Builder::stateReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReason").build()}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Source").getter(DescribePipeResponse.getter(DescribePipeResponse::source)).setter(DescribePipeResponse.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final SdkField<PipeSourceParameters> SOURCE_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceParameters").getter(DescribePipeResponse.getter(DescribePipeResponse::sourceParameters)).setter(DescribePipeResponse.setter(Builder::sourceParameters)).constructor(PipeSourceParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceParameters").build()}).build();
    private static final SdkField<String> ENRICHMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Enrichment").getter(DescribePipeResponse.getter(DescribePipeResponse::enrichment)).setter(DescribePipeResponse.setter(Builder::enrichment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enrichment").build()}).build();
    private static final SdkField<PipeEnrichmentParameters> ENRICHMENT_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EnrichmentParameters").getter(DescribePipeResponse.getter(DescribePipeResponse::enrichmentParameters)).setter(DescribePipeResponse.setter(Builder::enrichmentParameters)).constructor(PipeEnrichmentParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnrichmentParameters").build()}).build();
    private static final SdkField<String> TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Target").getter(DescribePipeResponse.getter(DescribePipeResponse::target)).setter(DescribePipeResponse.setter(Builder::target)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()}).build();
    private static final SdkField<PipeTargetParameters> TARGET_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TargetParameters").getter(DescribePipeResponse.getter(DescribePipeResponse::targetParameters)).setter(DescribePipeResponse.setter(Builder::targetParameters)).constructor(PipeTargetParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetParameters").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(DescribePipeResponse.getter(DescribePipeResponse::roleArn)).setter(DescribePipeResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(DescribePipeResponse.getter(DescribePipeResponse::tags)).setter(DescribePipeResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribePipeResponse.getter(DescribePipeResponse::creationTime)).setter(DescribePipeResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(DescribePipeResponse.getter(DescribePipeResponse::lastModifiedTime)).setter(DescribePipeResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<PipeLogConfiguration> LOG_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LogConfiguration").getter(DescribePipeResponse.getter(DescribePipeResponse::logConfiguration)).setter(DescribePipeResponse.setter(Builder::logConfiguration)).constructor(PipeLogConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogConfiguration").build()}).build();
    private static final SdkField<String> KMS_KEY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyIdentifier").getter(DescribePipeResponse.getter(DescribePipeResponse::kmsKeyIdentifier)).setter(DescribePipeResponse.setter(Builder::kmsKeyIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, DESIRED_STATE_FIELD, CURRENT_STATE_FIELD, STATE_REASON_FIELD, SOURCE_FIELD, SOURCE_PARAMETERS_FIELD, ENRICHMENT_FIELD, ENRICHMENT_PARAMETERS_FIELD, TARGET_FIELD, TARGET_PARAMETERS_FIELD, ROLE_ARN_FIELD, TAGS_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, LOG_CONFIGURATION_FIELD, KMS_KEY_IDENTIFIER_FIELD));
    private final String arn;
    private final String name;
    private final String description;
    private final String desiredState;
    private final String currentState;
    private final String stateReason;
    private final String source;
    private final PipeSourceParameters sourceParameters;
    private final String enrichment;
    private final PipeEnrichmentParameters enrichmentParameters;
    private final String target;
    private final PipeTargetParameters targetParameters;
    private final String roleArn;
    private final Map<String, String> tags;
    private final Instant creationTime;
    private final Instant lastModifiedTime;
    private final PipeLogConfiguration logConfiguration;
    private final String kmsKeyIdentifier;

    private DescribePipeResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.desiredState = builder.desiredState;
        this.currentState = builder.currentState;
        this.stateReason = builder.stateReason;
        this.source = builder.source;
        this.sourceParameters = builder.sourceParameters;
        this.enrichment = builder.enrichment;
        this.enrichmentParameters = builder.enrichmentParameters;
        this.target = builder.target;
        this.targetParameters = builder.targetParameters;
        this.roleArn = builder.roleArn;
        this.tags = builder.tags;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.logConfiguration = builder.logConfiguration;
        this.kmsKeyIdentifier = builder.kmsKeyIdentifier;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final RequestedPipeStateDescribeResponse desiredState() {
        return RequestedPipeStateDescribeResponse.fromValue(this.desiredState);
    }

    public final String desiredStateAsString() {
        return this.desiredState;
    }

    public final PipeState currentState() {
        return PipeState.fromValue(this.currentState);
    }

    public final String currentStateAsString() {
        return this.currentState;
    }

    public final String stateReason() {
        return this.stateReason;
    }

    public final String source() {
        return this.source;
    }

    public final PipeSourceParameters sourceParameters() {
        return this.sourceParameters;
    }

    public final String enrichment() {
        return this.enrichment;
    }

    public final PipeEnrichmentParameters enrichmentParameters() {
        return this.enrichmentParameters;
    }

    public final String target() {
        return this.target;
    }

    public final PipeTargetParameters targetParameters() {
        return this.targetParameters;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final PipeLogConfiguration logConfiguration() {
        return this.logConfiguration;
    }

    public final String kmsKeyIdentifier() {
        return this.kmsKeyIdentifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.enrichment());
        hashCode = 31 * hashCode + Objects.hashCode(this.enrichmentParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.target());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.logConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePipeResponse)) {
            return false;
        }
        DescribePipeResponse other = (DescribePipeResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.desiredStateAsString(), other.desiredStateAsString()) && Objects.equals(this.currentStateAsString(), other.currentStateAsString()) && Objects.equals(this.stateReason(), other.stateReason()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.sourceParameters(), other.sourceParameters()) && Objects.equals(this.enrichment(), other.enrichment()) && Objects.equals(this.enrichmentParameters(), other.enrichmentParameters()) && Objects.equals(this.target(), other.target()) && Objects.equals(this.targetParameters(), other.targetParameters()) && Objects.equals(this.roleArn(), other.roleArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.logConfiguration(), other.logConfiguration()) && Objects.equals(this.kmsKeyIdentifier(), other.kmsKeyIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"DescribePipeResponse").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("DesiredState", (Object)this.desiredStateAsString()).add("CurrentState", (Object)this.currentStateAsString()).add("StateReason", (Object)this.stateReason()).add("Source", (Object)this.source()).add("SourceParameters", (Object)this.sourceParameters()).add("Enrichment", (Object)this.enrichment()).add("EnrichmentParameters", (Object)this.enrichmentParameters()).add("Target", (Object)this.target()).add("TargetParameters", (Object)this.targetParameters()).add("RoleArn", (Object)this.roleArn()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("LogConfiguration", (Object)this.logConfiguration()).add("KmsKeyIdentifier", (Object)this.kmsKeyIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DesiredState": {
                return Optional.ofNullable(clazz.cast(this.desiredStateAsString()));
            }
            case "CurrentState": {
                return Optional.ofNullable(clazz.cast(this.currentStateAsString()));
            }
            case "StateReason": {
                return Optional.ofNullable(clazz.cast(this.stateReason()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "SourceParameters": {
                return Optional.ofNullable(clazz.cast(this.sourceParameters()));
            }
            case "Enrichment": {
                return Optional.ofNullable(clazz.cast(this.enrichment()));
            }
            case "EnrichmentParameters": {
                return Optional.ofNullable(clazz.cast(this.enrichmentParameters()));
            }
            case "Target": {
                return Optional.ofNullable(clazz.cast(this.target()));
            }
            case "TargetParameters": {
                return Optional.ofNullable(clazz.cast(this.targetParameters()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "LogConfiguration": {
                return Optional.ofNullable(clazz.cast(this.logConfiguration()));
            }
            case "KmsKeyIdentifier": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePipeResponse, T> g) {
        return obj -> g.apply((DescribePipeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PipesResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String description;
        private String desiredState;
        private String currentState;
        private String stateReason;
        private String source;
        private PipeSourceParameters sourceParameters;
        private String enrichment;
        private PipeEnrichmentParameters enrichmentParameters;
        private String target;
        private PipeTargetParameters targetParameters;
        private String roleArn;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Instant creationTime;
        private Instant lastModifiedTime;
        private PipeLogConfiguration logConfiguration;
        private String kmsKeyIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePipeResponse model) {
            super(model);
            this.arn(model.arn);
            this.name(model.name);
            this.description(model.description);
            this.desiredState(model.desiredState);
            this.currentState(model.currentState);
            this.stateReason(model.stateReason);
            this.source(model.source);
            this.sourceParameters(model.sourceParameters);
            this.enrichment(model.enrichment);
            this.enrichmentParameters(model.enrichmentParameters);
            this.target(model.target);
            this.targetParameters(model.targetParameters);
            this.roleArn(model.roleArn);
            this.tags(model.tags);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.logConfiguration(model.logConfiguration);
            this.kmsKeyIdentifier(model.kmsKeyIdentifier);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDesiredState() {
            return this.desiredState;
        }

        public final void setDesiredState(String desiredState) {
            this.desiredState = desiredState;
        }

        @Override
        public final Builder desiredState(String desiredState) {
            this.desiredState = desiredState;
            return this;
        }

        @Override
        public final Builder desiredState(RequestedPipeStateDescribeResponse desiredState) {
            this.desiredState(desiredState == null ? null : desiredState.toString());
            return this;
        }

        public final String getCurrentState() {
            return this.currentState;
        }

        public final void setCurrentState(String currentState) {
            this.currentState = currentState;
        }

        @Override
        public final Builder currentState(String currentState) {
            this.currentState = currentState;
            return this;
        }

        @Override
        public final Builder currentState(PipeState currentState) {
            this.currentState(currentState == null ? null : currentState.toString());
            return this;
        }

        public final String getStateReason() {
            return this.stateReason;
        }

        public final void setStateReason(String stateReason) {
            this.stateReason = stateReason;
        }

        @Override
        public final Builder stateReason(String stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final PipeSourceParameters.Builder getSourceParameters() {
            return this.sourceParameters != null ? this.sourceParameters.toBuilder() : null;
        }

        public final void setSourceParameters(PipeSourceParameters.BuilderImpl sourceParameters) {
            this.sourceParameters = sourceParameters != null ? sourceParameters.build() : null;
        }

        @Override
        public final Builder sourceParameters(PipeSourceParameters sourceParameters) {
            this.sourceParameters = sourceParameters;
            return this;
        }

        public final String getEnrichment() {
            return this.enrichment;
        }

        public final void setEnrichment(String enrichment) {
            this.enrichment = enrichment;
        }

        @Override
        public final Builder enrichment(String enrichment) {
            this.enrichment = enrichment;
            return this;
        }

        public final PipeEnrichmentParameters.Builder getEnrichmentParameters() {
            return this.enrichmentParameters != null ? this.enrichmentParameters.toBuilder() : null;
        }

        public final void setEnrichmentParameters(PipeEnrichmentParameters.BuilderImpl enrichmentParameters) {
            this.enrichmentParameters = enrichmentParameters != null ? enrichmentParameters.build() : null;
        }

        @Override
        public final Builder enrichmentParameters(PipeEnrichmentParameters enrichmentParameters) {
            this.enrichmentParameters = enrichmentParameters;
            return this;
        }

        public final String getTarget() {
            return this.target;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final PipeTargetParameters.Builder getTargetParameters() {
            return this.targetParameters != null ? this.targetParameters.toBuilder() : null;
        }

        public final void setTargetParameters(PipeTargetParameters.BuilderImpl targetParameters) {
            this.targetParameters = targetParameters != null ? targetParameters.build() : null;
        }

        @Override
        public final Builder targetParameters(PipeTargetParameters targetParameters) {
            this.targetParameters = targetParameters;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final PipeLogConfiguration.Builder getLogConfiguration() {
            return this.logConfiguration != null ? this.logConfiguration.toBuilder() : null;
        }

        public final void setLogConfiguration(PipeLogConfiguration.BuilderImpl logConfiguration) {
            this.logConfiguration = logConfiguration != null ? logConfiguration.build() : null;
        }

        @Override
        public final Builder logConfiguration(PipeLogConfiguration logConfiguration) {
            this.logConfiguration = logConfiguration;
            return this;
        }

        public final String getKmsKeyIdentifier() {
            return this.kmsKeyIdentifier;
        }

        public final void setKmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
        }

        @Override
        public final Builder kmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
            return this;
        }

        @Override
        public DescribePipeResponse build() {
            return new DescribePipeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PipesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribePipeResponse> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder desiredState(String var1);

        public Builder desiredState(RequestedPipeStateDescribeResponse var1);

        public Builder currentState(String var1);

        public Builder currentState(PipeState var1);

        public Builder stateReason(String var1);

        public Builder source(String var1);

        public Builder sourceParameters(PipeSourceParameters var1);

        default public Builder sourceParameters(Consumer<PipeSourceParameters.Builder> sourceParameters) {
            return this.sourceParameters((PipeSourceParameters)((PipeSourceParameters.Builder)PipeSourceParameters.builder().applyMutation(sourceParameters)).build());
        }

        public Builder enrichment(String var1);

        public Builder enrichmentParameters(PipeEnrichmentParameters var1);

        default public Builder enrichmentParameters(Consumer<PipeEnrichmentParameters.Builder> enrichmentParameters) {
            return this.enrichmentParameters((PipeEnrichmentParameters)((PipeEnrichmentParameters.Builder)PipeEnrichmentParameters.builder().applyMutation(enrichmentParameters)).build());
        }

        public Builder target(String var1);

        public Builder targetParameters(PipeTargetParameters var1);

        default public Builder targetParameters(Consumer<PipeTargetParameters.Builder> targetParameters) {
            return this.targetParameters((PipeTargetParameters)((PipeTargetParameters.Builder)PipeTargetParameters.builder().applyMutation(targetParameters)).build());
        }

        public Builder roleArn(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder logConfiguration(PipeLogConfiguration var1);

        default public Builder logConfiguration(Consumer<PipeLogConfiguration.Builder> logConfiguration) {
            return this.logConfiguration((PipeLogConfiguration)((PipeLogConfiguration.Builder)PipeLogConfiguration.builder().applyMutation(logConfiguration)).build());
        }

        public Builder kmsKeyIdentifier(String var1);
    }
}

