/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pipes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pipes.model.MultiMeasureAttributeMapping;
import software.amazon.awssdk.services.pipes.model.MultiMeasureAttributeMappingsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MultiMeasureMapping
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MultiMeasureMapping> {
    private static final SdkField<String> MULTI_MEASURE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MultiMeasureName").getter(MultiMeasureMapping.getter(MultiMeasureMapping::multiMeasureName)).setter(MultiMeasureMapping.setter(Builder::multiMeasureName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiMeasureName").build()}).build();
    private static final SdkField<List<MultiMeasureAttributeMapping>> MULTI_MEASURE_ATTRIBUTE_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MultiMeasureAttributeMappings").getter(MultiMeasureMapping.getter(MultiMeasureMapping::multiMeasureAttributeMappings)).setter(MultiMeasureMapping.setter(Builder::multiMeasureAttributeMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiMeasureAttributeMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MultiMeasureAttributeMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MULTI_MEASURE_NAME_FIELD, MULTI_MEASURE_ATTRIBUTE_MAPPINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String multiMeasureName;
    private final List<MultiMeasureAttributeMapping> multiMeasureAttributeMappings;

    private MultiMeasureMapping(BuilderImpl builder) {
        this.multiMeasureName = builder.multiMeasureName;
        this.multiMeasureAttributeMappings = builder.multiMeasureAttributeMappings;
    }

    public final String multiMeasureName() {
        return this.multiMeasureName;
    }

    public final boolean hasMultiMeasureAttributeMappings() {
        return this.multiMeasureAttributeMappings != null && !(this.multiMeasureAttributeMappings instanceof SdkAutoConstructList);
    }

    public final List<MultiMeasureAttributeMapping> multiMeasureAttributeMappings() {
        return this.multiMeasureAttributeMappings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.multiMeasureName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMultiMeasureAttributeMappings() ? this.multiMeasureAttributeMappings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultiMeasureMapping)) {
            return false;
        }
        MultiMeasureMapping other = (MultiMeasureMapping)obj;
        return Objects.equals(this.multiMeasureName(), other.multiMeasureName()) && this.hasMultiMeasureAttributeMappings() == other.hasMultiMeasureAttributeMappings() && Objects.equals(this.multiMeasureAttributeMappings(), other.multiMeasureAttributeMappings());
    }

    public final String toString() {
        return ToString.builder((String)"MultiMeasureMapping").add("MultiMeasureName", (Object)this.multiMeasureName()).add("MultiMeasureAttributeMappings", this.hasMultiMeasureAttributeMappings() ? this.multiMeasureAttributeMappings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MultiMeasureName": {
                return Optional.ofNullable(clazz.cast(this.multiMeasureName()));
            }
            case "MultiMeasureAttributeMappings": {
                return Optional.ofNullable(clazz.cast(this.multiMeasureAttributeMappings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MultiMeasureMapping, T> g) {
        return obj -> g.apply((MultiMeasureMapping)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String multiMeasureName;
        private List<MultiMeasureAttributeMapping> multiMeasureAttributeMappings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MultiMeasureMapping model) {
            this.multiMeasureName(model.multiMeasureName);
            this.multiMeasureAttributeMappings(model.multiMeasureAttributeMappings);
        }

        public final String getMultiMeasureName() {
            return this.multiMeasureName;
        }

        public final void setMultiMeasureName(String multiMeasureName) {
            this.multiMeasureName = multiMeasureName;
        }

        @Override
        public final Builder multiMeasureName(String multiMeasureName) {
            this.multiMeasureName = multiMeasureName;
            return this;
        }

        public final List<MultiMeasureAttributeMapping.Builder> getMultiMeasureAttributeMappings() {
            List<MultiMeasureAttributeMapping.Builder> result = MultiMeasureAttributeMappingsCopier.copyToBuilder(this.multiMeasureAttributeMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMultiMeasureAttributeMappings(Collection<MultiMeasureAttributeMapping.BuilderImpl> multiMeasureAttributeMappings) {
            this.multiMeasureAttributeMappings = MultiMeasureAttributeMappingsCopier.copyFromBuilder(multiMeasureAttributeMappings);
        }

        @Override
        public final Builder multiMeasureAttributeMappings(Collection<MultiMeasureAttributeMapping> multiMeasureAttributeMappings) {
            this.multiMeasureAttributeMappings = MultiMeasureAttributeMappingsCopier.copy(multiMeasureAttributeMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder multiMeasureAttributeMappings(MultiMeasureAttributeMapping ... multiMeasureAttributeMappings) {
            this.multiMeasureAttributeMappings(Arrays.asList(multiMeasureAttributeMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder multiMeasureAttributeMappings(Consumer<MultiMeasureAttributeMapping.Builder> ... multiMeasureAttributeMappings) {
            this.multiMeasureAttributeMappings(Stream.of(multiMeasureAttributeMappings).map(c -> (MultiMeasureAttributeMapping)((MultiMeasureAttributeMapping.Builder)MultiMeasureAttributeMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public MultiMeasureMapping build() {
            return new MultiMeasureMapping(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MultiMeasureMapping> {
        public Builder multiMeasureName(String var1);

        public Builder multiMeasureAttributeMappings(Collection<MultiMeasureAttributeMapping> var1);

        public Builder multiMeasureAttributeMappings(MultiMeasureAttributeMapping ... var1);

        public Builder multiMeasureAttributeMappings(Consumer<MultiMeasureAttributeMapping.Builder> ... var1);
    }
}

