/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pipes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pipes.model.MeasureValueType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MultiMeasureAttributeMapping
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MultiMeasureAttributeMapping> {
    private static final SdkField<String> MEASURE_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MeasureValue").getter(MultiMeasureAttributeMapping.getter(MultiMeasureAttributeMapping::measureValue)).setter(MultiMeasureAttributeMapping.setter(Builder::measureValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeasureValue").build()}).build();
    private static final SdkField<String> MEASURE_VALUE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MeasureValueType").getter(MultiMeasureAttributeMapping.getter(MultiMeasureAttributeMapping::measureValueTypeAsString)).setter(MultiMeasureAttributeMapping.setter(Builder::measureValueType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeasureValueType").build()}).build();
    private static final SdkField<String> MULTI_MEASURE_ATTRIBUTE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MultiMeasureAttributeName").getter(MultiMeasureAttributeMapping.getter(MultiMeasureAttributeMapping::multiMeasureAttributeName)).setter(MultiMeasureAttributeMapping.setter(Builder::multiMeasureAttributeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiMeasureAttributeName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEASURE_VALUE_FIELD, MEASURE_VALUE_TYPE_FIELD, MULTI_MEASURE_ATTRIBUTE_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("MeasureValue", MEASURE_VALUE_FIELD);
            this.put("MeasureValueType", MEASURE_VALUE_TYPE_FIELD);
            this.put("MultiMeasureAttributeName", MULTI_MEASURE_ATTRIBUTE_NAME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String measureValue;
    private final String measureValueType;
    private final String multiMeasureAttributeName;

    private MultiMeasureAttributeMapping(BuilderImpl builder) {
        this.measureValue = builder.measureValue;
        this.measureValueType = builder.measureValueType;
        this.multiMeasureAttributeName = builder.multiMeasureAttributeName;
    }

    public final String measureValue() {
        return this.measureValue;
    }

    public final MeasureValueType measureValueType() {
        return MeasureValueType.fromValue(this.measureValueType);
    }

    public final String measureValueTypeAsString() {
        return this.measureValueType;
    }

    public final String multiMeasureAttributeName() {
        return this.multiMeasureAttributeName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.measureValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.measureValueTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.multiMeasureAttributeName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultiMeasureAttributeMapping)) {
            return false;
        }
        MultiMeasureAttributeMapping other = (MultiMeasureAttributeMapping)obj;
        return Objects.equals(this.measureValue(), other.measureValue()) && Objects.equals(this.measureValueTypeAsString(), other.measureValueTypeAsString()) && Objects.equals(this.multiMeasureAttributeName(), other.multiMeasureAttributeName());
    }

    public final String toString() {
        return ToString.builder((String)"MultiMeasureAttributeMapping").add("MeasureValue", (Object)this.measureValue()).add("MeasureValueType", (Object)this.measureValueTypeAsString()).add("MultiMeasureAttributeName", (Object)this.multiMeasureAttributeName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MeasureValue": {
                return Optional.ofNullable(clazz.cast(this.measureValue()));
            }
            case "MeasureValueType": {
                return Optional.ofNullable(clazz.cast(this.measureValueTypeAsString()));
            }
            case "MultiMeasureAttributeName": {
                return Optional.ofNullable(clazz.cast(this.multiMeasureAttributeName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MultiMeasureAttributeMapping, T> g) {
        return obj -> g.apply((MultiMeasureAttributeMapping)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String measureValue;
        private String measureValueType;
        private String multiMeasureAttributeName;

        private BuilderImpl() {
        }

        private BuilderImpl(MultiMeasureAttributeMapping model) {
            this.measureValue(model.measureValue);
            this.measureValueType(model.measureValueType);
            this.multiMeasureAttributeName(model.multiMeasureAttributeName);
        }

        public final String getMeasureValue() {
            return this.measureValue;
        }

        public final void setMeasureValue(String measureValue) {
            this.measureValue = measureValue;
        }

        @Override
        public final Builder measureValue(String measureValue) {
            this.measureValue = measureValue;
            return this;
        }

        public final String getMeasureValueType() {
            return this.measureValueType;
        }

        public final void setMeasureValueType(String measureValueType) {
            this.measureValueType = measureValueType;
        }

        @Override
        public final Builder measureValueType(String measureValueType) {
            this.measureValueType = measureValueType;
            return this;
        }

        @Override
        public final Builder measureValueType(MeasureValueType measureValueType) {
            this.measureValueType(measureValueType == null ? null : measureValueType.toString());
            return this;
        }

        public final String getMultiMeasureAttributeName() {
            return this.multiMeasureAttributeName;
        }

        public final void setMultiMeasureAttributeName(String multiMeasureAttributeName) {
            this.multiMeasureAttributeName = multiMeasureAttributeName;
        }

        @Override
        public final Builder multiMeasureAttributeName(String multiMeasureAttributeName) {
            this.multiMeasureAttributeName = multiMeasureAttributeName;
            return this;
        }

        public MultiMeasureAttributeMapping build() {
            return new MultiMeasureAttributeMapping(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MultiMeasureAttributeMapping> {
        public Builder measureValue(String var1);

        public Builder measureValueType(String var1);

        public Builder measureValueType(MeasureValueType var1);

        public Builder multiMeasureAttributeName(String var1);
    }
}

