/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pipes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Maps source data to a dimension in the target Timestream for LiveAnalytics table.
 * </p>
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/concepts.html">Amazon
 * Timestream for LiveAnalytics concepts</a>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DimensionMapping implements SdkPojo, Serializable,
        ToCopyableBuilder<DimensionMapping.Builder, DimensionMapping> {
    private static final SdkField<String> DIMENSION_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DimensionValue").getter(getter(DimensionMapping::dimensionValue))
            .setter(setter(Builder::dimensionValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionValue").build()).build();

    private static final SdkField<String> DIMENSION_VALUE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DimensionValueType").getter(getter(DimensionMapping::dimensionValueTypeAsString))
            .setter(setter(Builder::dimensionValueType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionValueType").build())
            .build();

    private static final SdkField<String> DIMENSION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DimensionName").getter(getter(DimensionMapping::dimensionName)).setter(setter(Builder::dimensionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSION_VALUE_FIELD,
            DIMENSION_VALUE_TYPE_FIELD, DIMENSION_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dimensionValue;

    private final String dimensionValueType;

    private final String dimensionName;

    private DimensionMapping(BuilderImpl builder) {
        this.dimensionValue = builder.dimensionValue;
        this.dimensionValueType = builder.dimensionValueType;
        this.dimensionName = builder.dimensionName;
    }

    /**
     * <p>
     * Dynamic path to the dimension value in the source event.
     * </p>
     * 
     * @return Dynamic path to the dimension value in the source event.
     */
    public final String dimensionValue() {
        return dimensionValue;
    }

    /**
     * <p>
     * The data type of the dimension for the time-series data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dimensionValueType} will return {@link DimensionValueType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #dimensionValueTypeAsString}.
     * </p>
     * 
     * @return The data type of the dimension for the time-series data.
     * @see DimensionValueType
     */
    public final DimensionValueType dimensionValueType() {
        return DimensionValueType.fromValue(dimensionValueType);
    }

    /**
     * <p>
     * The data type of the dimension for the time-series data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dimensionValueType} will return {@link DimensionValueType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #dimensionValueTypeAsString}.
     * </p>
     * 
     * @return The data type of the dimension for the time-series data.
     * @see DimensionValueType
     */
    public final String dimensionValueTypeAsString() {
        return dimensionValueType;
    }

    /**
     * <p>
     * The metadata attributes of the time series. For example, the name and Availability Zone of an Amazon EC2 instance
     * or the name of the manufacturer of a wind turbine are dimensions.
     * </p>
     * 
     * @return The metadata attributes of the time series. For example, the name and Availability Zone of an Amazon EC2
     *         instance or the name of the manufacturer of a wind turbine are dimensions.
     */
    public final String dimensionName() {
        return dimensionName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dimensionValue());
        hashCode = 31 * hashCode + Objects.hashCode(dimensionValueTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dimensionName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DimensionMapping)) {
            return false;
        }
        DimensionMapping other = (DimensionMapping) obj;
        return Objects.equals(dimensionValue(), other.dimensionValue())
                && Objects.equals(dimensionValueTypeAsString(), other.dimensionValueTypeAsString())
                && Objects.equals(dimensionName(), other.dimensionName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DimensionMapping").add("DimensionValue", dimensionValue())
                .add("DimensionValueType", dimensionValueTypeAsString()).add("DimensionName", dimensionName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DimensionValue":
            return Optional.ofNullable(clazz.cast(dimensionValue()));
        case "DimensionValueType":
            return Optional.ofNullable(clazz.cast(dimensionValueTypeAsString()));
        case "DimensionName":
            return Optional.ofNullable(clazz.cast(dimensionName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DimensionValue", DIMENSION_VALUE_FIELD);
        map.put("DimensionValueType", DIMENSION_VALUE_TYPE_FIELD);
        map.put("DimensionName", DIMENSION_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DimensionMapping, T> g) {
        return obj -> g.apply((DimensionMapping) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DimensionMapping> {
        /**
         * <p>
         * Dynamic path to the dimension value in the source event.
         * </p>
         * 
         * @param dimensionValue
         *        Dynamic path to the dimension value in the source event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensionValue(String dimensionValue);

        /**
         * <p>
         * The data type of the dimension for the time-series data.
         * </p>
         * 
         * @param dimensionValueType
         *        The data type of the dimension for the time-series data.
         * @see DimensionValueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DimensionValueType
         */
        Builder dimensionValueType(String dimensionValueType);

        /**
         * <p>
         * The data type of the dimension for the time-series data.
         * </p>
         * 
         * @param dimensionValueType
         *        The data type of the dimension for the time-series data.
         * @see DimensionValueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DimensionValueType
         */
        Builder dimensionValueType(DimensionValueType dimensionValueType);

        /**
         * <p>
         * The metadata attributes of the time series. For example, the name and Availability Zone of an Amazon EC2
         * instance or the name of the manufacturer of a wind turbine are dimensions.
         * </p>
         * 
         * @param dimensionName
         *        The metadata attributes of the time series. For example, the name and Availability Zone of an Amazon
         *        EC2 instance or the name of the manufacturer of a wind turbine are dimensions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensionName(String dimensionName);
    }

    static final class BuilderImpl implements Builder {
        private String dimensionValue;

        private String dimensionValueType;

        private String dimensionName;

        private BuilderImpl() {
        }

        private BuilderImpl(DimensionMapping model) {
            dimensionValue(model.dimensionValue);
            dimensionValueType(model.dimensionValueType);
            dimensionName(model.dimensionName);
        }

        public final String getDimensionValue() {
            return dimensionValue;
        }

        public final void setDimensionValue(String dimensionValue) {
            this.dimensionValue = dimensionValue;
        }

        @Override
        public final Builder dimensionValue(String dimensionValue) {
            this.dimensionValue = dimensionValue;
            return this;
        }

        public final String getDimensionValueType() {
            return dimensionValueType;
        }

        public final void setDimensionValueType(String dimensionValueType) {
            this.dimensionValueType = dimensionValueType;
        }

        @Override
        public final Builder dimensionValueType(String dimensionValueType) {
            this.dimensionValueType = dimensionValueType;
            return this;
        }

        @Override
        public final Builder dimensionValueType(DimensionValueType dimensionValueType) {
            this.dimensionValueType(dimensionValueType == null ? null : dimensionValueType.toString());
            return this;
        }

        public final String getDimensionName() {
            return dimensionName;
        }

        public final void setDimensionName(String dimensionName) {
            this.dimensionName = dimensionName;
        }

        @Override
        public final Builder dimensionName(String dimensionName) {
            this.dimensionName = dimensionName;
            return this;
        }

        @Override
        public DimensionMapping build() {
            return new DimensionMapping(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
